/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AbstractDesignator;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.MissingAttributeDetail;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.StatusDetail;

public class AttributeDesignator
extends AbstractDesignator {
    public static final int SUBJECT_TARGET = 0;
    public static final int RESOURCE_TARGET = 1;
    public static final int ACTION_TARGET = 2;
    public static final int ENVIRONMENT_TARGET = 3;
    public static final String SUBJECT_CATEGORY_DEFAULT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private static final String[] targetTypes = new String[]{"Subject", "Resource", "Action", "Environment"};
    private int target;
    private URI type;
    private URI id;
    private String issuer;
    private boolean mustBePresent;
    private URI category;
    private static final Log logger = LogFactory.getLog(AttributeDesignator.class);

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent) {
        this(target, type, id, mustBePresent, null, null);
    }

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent, String issuer) throws IllegalArgumentException {
        this(target, type, id, mustBePresent, null, null);
    }

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent, String issuer, URI category) throws IllegalArgumentException {
        if (target != 0 && target != 1 && target != 2 && target != 3) {
            throw new IllegalArgumentException("Input target is not a validvalue");
        }
        this.target = target;
        this.type = type;
        this.id = id;
        this.mustBePresent = mustBePresent;
        this.issuer = issuer;
        this.category = category;
    }

    public static AttributeDesignator getInstance(Node root) throws ParsingException {
        int target;
        URI type = null;
        URI id = null;
        String issuer = null;
        boolean mustBePresent = false;
        URI category = null;
        String tagName = DOMHelper.getLocalName(root);
        if (tagName.equals("SubjectAttributeDesignator")) {
            target = 0;
        } else if (tagName.equals("ResourceAttributeDesignator")) {
            target = 1;
        } else if (tagName.equals("ActionAttributeDesignator")) {
            target = 2;
        } else if (tagName.equals("EnvironmentAttributeDesignator")) {
            target = 3;
        } else {
            throw new ParsingException("AttributeDesignator cannot be constructed using type: " + DOMHelper.getLocalName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required AttributeId missing in AttributeDesignator", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required DataType missing in AttributeDesignator", e);
        }
        try {
            Node node = attrs.getNamedItem("Issuer");
            if (node != null) {
                issuer = node.getNodeValue();
            }
            if (target == 0) {
                Node scnode = attrs.getNamedItem("SubjectCategory");
                category = scnode != null ? new URI(scnode.getNodeValue()) : new URI(SUBJECT_CATEGORY_DEFAULT);
            } else if (target == 1) {
                category = new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:resource");
            } else if (target == 2) {
                category = new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:action");
            } else if (target == 3) {
                category = new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
            }
            node = attrs.getNamedItem("MustBePresent");
            if (node != null && node.getNodeValue().equals("true")) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing AttributeDesignator optional attributes", e);
        }
        return new AttributeDesignator(target, type, id, mustBePresent, issuer, category);
    }

    public int getDesignatorType() {
        return this.target;
    }

    @Override
    public URI getType() {
        return this.type;
    }

    @Override
    public URI getId() {
        return this.id;
    }

    public URI getCategory() {
        return this.category;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    @Override
    public boolean evaluatesToBag() {
        return true;
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx evaluationCtx) {
        EvaluationResult result = null;
        switch (this.target) {
            case 0: {
                result = evaluationCtx.getAttribute(this.type, this.id, this.issuer, this.category);
                break;
            }
            case 1: {
                result = evaluationCtx.getAttribute(this.type, this.id, this.issuer, this.category);
                break;
            }
            case 2: {
                result = evaluationCtx.getAttribute(this.type, this.id, this.issuer, this.category);
                break;
            }
            case 3: {
                result = evaluationCtx.getAttribute(this.type, this.id, this.issuer, this.category);
            }
        }
        if (result != null) {
            if (result.indeterminate()) {
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty() && this.mustBePresent) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AttributeDesignator failed to resolve a value for a required attribute: " + this.id.toString()));
                }
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                ArrayList<MissingAttributeDetail> missingAttributes = new ArrayList<MissingAttributeDetail>();
                MissingAttributeDetail missingAttribute = new MissingAttributeDetail(this.id, this.type, this.category, this.issuer, null, 3);
                missingAttributes.add(missingAttribute);
                StatusDetail detail = new StatusDetail(missingAttributes);
                String message = "Couldn't find " + targetTypes[this.target] + "AttributeDesignator attribute";
                return new EvaluationResult(new Status(code, message, detail));
            }
        } else {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            ArrayList<MissingAttributeDetail> missingAttributes = new ArrayList<MissingAttributeDetail>();
            MissingAttributeDetail missingAttribute = new MissingAttributeDetail(this.id, this.type, this.category, this.issuer, null, 3);
            missingAttributes.add(missingAttribute);
            StatusDetail detail = new StatusDetail(missingAttributes);
            String message = "Couldn't find " + targetTypes[this.target] + "AttributeDesignator attribute";
            return new EvaluationResult(new Status(code, message, detail));
        }
        return result;
    }

    @Override
    public void encode(StringBuilder builder) {
        builder.append("<").append(targetTypes[this.target]).append("AttributeDesignator");
        if (this.target == 0 && this.category != null) {
            builder.append(" SubjectCategory=\"").append(this.category.toString()).append("\"");
        }
        builder.append(" AttributeId=\"").append(this.id.toString()).append("\"");
        builder.append(" DataType=\"").append(this.type.toString()).append("\"");
        if (this.issuer != null) {
            builder.append(" Issuer=\"").append(this.issuer).append("\"");
        }
        if (this.mustBePresent) {
            builder.append(" MustBePresent=\"true\"");
        }
        builder.append("/>\n");
    }
}

