/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.ParsingException;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.combine.CombinerElement;
import org.wso2.balana.combine.CombinerParameter;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.finder.PolicyFinder;

public class PolicySet
extends AbstractPolicy {
    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, AbstractTarget target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, AbstractTarget target, List policies) {
        this(id, null, combiningAlg, null, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, AbstractTarget target, List policies) {
        this(id, version, combiningAlg, description, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, AbstractTarget target, List policies, String defaultVersion) {
        this(id, version, combiningAlg, description, target, policies, defaultVersion, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, AbstractTarget target, List<AbstractPolicy> policies, String defaultVersion, Set<AbstractObligation> obligations) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null, null);
        ArrayList<PolicyCombinerElement> list = null;
        if (policies != null) {
            list = new ArrayList<PolicyCombinerElement>();
            for (AbstractPolicy o : policies) {
                if (!(o instanceof AbstractPolicy)) {
                    throw new IllegalArgumentException("non-AbstractPolicy in policies");
                }
                list.add(new PolicyCombinerElement(o));
            }
        }
        this.setChildren(list);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, AbstractTarget target, List policyElements, String defaultVersion, Set<AbstractObligation> obligations, List<CombinerParameter> parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null, parameters);
        if (policyElements != null) {
            for (Object o : policyElements) {
                if (o instanceof PolicyCombinerElement) continue;
                throw new IllegalArgumentException("non-AbstractPolicy in policies");
            }
        }
        this.setChildren(policyElements);
    }

    private PolicySet(Node root, PolicyFinder finder) throws ParsingException {
        super(root, "PolicySet", "PolicyCombiningAlgId");
        ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
        HashMap<String, List<CombinerParameter>> policyParameters = new HashMap<String, List<CombinerParameter>>();
        HashMap<String, List<CombinerParameter>> policySetParameters = new HashMap<String, List<CombinerParameter>>();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = DOMHelper.getLocalName(child);
            if (name.equals("PolicySet")) {
                policies.add(PolicySet.getInstance(child, finder));
                continue;
            }
            if (name.equals("Policy")) {
                policies.add(Policy.getInstance(child));
                continue;
            }
            if (name.equals("PolicySetIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
                continue;
            }
            if (name.equals("PolicyIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
                continue;
            }
            if (name.equals("PolicyCombinerParameters")) {
                this.parameterHelper(policyParameters, child, "Policy");
                continue;
            }
            if (!name.equals("PolicySetCombinerParameters")) continue;
            this.parameterHelper(policySetParameters, child, "PolicySet");
        }
        ArrayList<CombinerElement> elements = new ArrayList<CombinerElement>();
        for (AbstractPolicy policy : policies) {
            List<CombinerParameter> list = null;
            if (policy instanceof Policy) {
                list = (List<CombinerParameter>)policyParameters.remove(policy.getId().toString());
            } else if (policy instanceof PolicySet) {
                list = (List)policySetParameters.remove(policy.getId().toString());
            } else {
                PolicyReference ref = (PolicyReference)policy;
                String id = ref.getReference().toString();
                list = ref.getReferenceType() == 0 ? policyParameters.remove(id) : policySetParameters.remove(id);
            }
            elements.add(new PolicyCombinerElement(policy, (List)list));
        }
        if (!policyParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Policy");
        }
        if (!policySetParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in PolicySet");
        }
        this.setChildren(elements);
    }

    private void parameterHelper(HashMap<String, List<CombinerParameter>> parameters, Node root, String prefix) throws ParsingException {
        String ref = root.getAttributes().getNamedItem(prefix + "IdRef").getNodeValue();
        if (parameters.containsKey(ref)) {
            List<CombinerParameter> list = parameters.get(ref);
            this.parseParameters(list, root);
        } else {
            ArrayList<CombinerParameter> list = new ArrayList<CombinerParameter>();
            this.parseParameters(list, root);
            parameters.put(ref, list);
        }
    }

    private void parseParameters(List<CombinerParameter> parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("CombinerParameter")) continue;
            parameters.add(CombinerParameter.getInstance(node));
        }
    }

    public static PolicySet getInstance(Node root) throws ParsingException {
        return PolicySet.getInstance(root, null);
    }

    public static PolicySet getInstance(Node root, PolicyFinder finder) throws ParsingException {
        if (!DOMHelper.getLocalName(root).equals("PolicySet")) {
            throw new ParsingException("Cannot create PolicySet from root of type " + DOMHelper.getLocalName(root));
        }
        return new PolicySet(root, finder);
    }

    @Override
    public String encode() {
        StringBuilder builder = new StringBuilder();
        this.encode(builder);
        return builder.toString();
    }

    @Override
    public void encode(StringBuilder builder) {
        String xPathVersion;
        String xacmlVersionId = this.metaData.getXACMLIdentifier();
        String version = this.getVersion();
        builder.append("<PolicySet xmlns=\"").append(xacmlVersionId).append("\" PolicySetId=\"").append(this.getId().toString()).append("\" PolicyCombiningAlgId=\"").append(this.getCombiningAlg().getIdentifier().toString()).append("\">\n");
        String description = this.getDescription();
        if (description != null) {
            builder.append("<Description>").append(description).append("</Description>\n");
        }
        if ((xPathVersion = this.metaData.getXPathIdentifier()) != null) {
            builder.append("<PolicySetDefaults><XPathVersion>").append(xPathVersion).append("</XPathVersion></PolicySetDefaults>\n");
        }
        this.getTarget().encode(builder);
        this.encodeCommonElements(builder);
        builder.append("</PolicySet>\n");
    }
}

