/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.ConfigurationStore;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.combine.CombiningAlgFactory;
import org.wso2.balana.cond.FunctionFactory;
import org.wso2.balana.finder.AttributeFinder;
import org.wso2.balana.finder.AttributeFinderModule;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.impl.CurrentEnvModule;
import org.wso2.balana.finder.impl.FileBasedPolicyFinderModule;
import org.wso2.balana.finder.impl.SelectorModule;
import org.wso2.balana.utils.Utils;

public class Balana {
    private PDPConfig pdpConfig;
    private AttributeFactory attributeFactory;
    private FunctionFactory functionTargetFactory;
    private FunctionFactory functionConditionFactory;
    private FunctionFactory functionGeneralFactory;
    private CombiningAlgFactory combiningAlgFactory;
    private DocumentBuilderFactory builder;
    private static final Object lock = new Object();
    private static Balana balana;
    private static final Log logger;

    private Balana(String pdpConfigName, String attributeFactoryName, String functionFactoryName, String combiningAlgFactoryName) {
        ConfigurationStore store = null;
        try {
            if (System.getProperty("org.wso2.balana.PDPConfigFile") != null) {
                store = new ConfigurationStore();
            } else {
                String configFile = new File(".").getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "config.xml";
                File file = new File(configFile);
                if (file.exists()) {
                    store = new ConfigurationStore(new File(configFile));
                }
            }
            if (store != null) {
                this.pdpConfig = pdpConfigName != null ? store.getPDPConfig(pdpConfigName) : store.getDefaultPDPConfig();
                this.attributeFactory = attributeFactoryName != null ? store.getAttributeFactory(attributeFactoryName) : store.getDefaultAttributeFactoryProxy().getFactory();
                this.functionTargetFactory = functionFactoryName != null ? store.getFunctionFactoryProxy(functionFactoryName).getTargetFactory() : store.getDefaultFunctionFactoryProxy().getTargetFactory();
                this.functionConditionFactory = functionFactoryName != null ? store.getFunctionFactoryProxy(functionFactoryName).getConditionFactory() : store.getDefaultFunctionFactoryProxy().getConditionFactory();
                this.functionGeneralFactory = functionFactoryName != null ? store.getFunctionFactoryProxy(functionFactoryName).getGeneralFactory() : store.getDefaultFunctionFactoryProxy().getGeneralFactory();
                this.combiningAlgFactory = functionFactoryName != null ? store.getCombiningAlgFactory(functionFactoryName) : store.getDefaultCombiningFactoryProxy().getFactory();
            }
        }
        catch (Exception configFile) {
            // empty catch block
        }
        if (this.pdpConfig == null) {
            PolicyFinder policyFinder = new PolicyFinder();
            HashSet<FileBasedPolicyFinderModule> policyFinderModules = new HashSet<FileBasedPolicyFinderModule>();
            FileBasedPolicyFinderModule fileBasedPolicyFinderModule = new FileBasedPolicyFinderModule();
            policyFinderModules.add(fileBasedPolicyFinderModule);
            policyFinder.setModules(policyFinderModules);
            AttributeFinder attributeFinder = new AttributeFinder();
            ArrayList<AttributeFinderModule> attributeFinderModules = new ArrayList<AttributeFinderModule>();
            SelectorModule selectorModule = new SelectorModule();
            CurrentEnvModule currentEnvModule = new CurrentEnvModule();
            attributeFinderModules.add(selectorModule);
            attributeFinderModules.add(currentEnvModule);
            attributeFinder.setModules(attributeFinderModules);
            this.pdpConfig = new PDPConfig(attributeFinder, policyFinder, null, false);
        }
        if (this.attributeFactory == null) {
            this.attributeFactory = AttributeFactory.getInstance();
        }
        if (this.functionTargetFactory == null) {
            this.functionTargetFactory = FunctionFactory.getInstance().getTargetFactory();
        }
        if (this.functionConditionFactory == null) {
            this.functionConditionFactory = FunctionFactory.getInstance().getConditionFactory();
        }
        if (this.functionGeneralFactory == null) {
            this.functionGeneralFactory = FunctionFactory.getInstance().getGeneralFactory();
        }
        if (this.combiningAlgFactory == null) {
            this.combiningAlgFactory = CombiningAlgFactory.getInstance();
        }
        this.builder = Utils.getSecuredDocumentBuilderFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Balana getInstance() {
        if (balana == null) {
            Object object = lock;
            synchronized (object) {
                if (balana == null) {
                    balana = new Balana(null, null, null, null);
                }
            }
        }
        return balana;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Balana getInstance(String identifier) {
        if (balana == null) {
            Object object = lock;
            synchronized (object) {
                if (balana == null) {
                    balana = new Balana(identifier, identifier, identifier, identifier);
                }
            }
        }
        return balana;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Balana getInstance(String pdpConfigName, String attributeFactoryName, String functionFactoryName, String combiningAlgFactoryName) {
        if (balana == null) {
            Object object = lock;
            synchronized (object) {
                if (balana == null) {
                    balana = new Balana(pdpConfigName, attributeFactoryName, functionFactoryName, combiningAlgFactoryName);
                }
            }
        }
        return balana;
    }

    public PDPConfig getPdpConfig() {
        return this.pdpConfig;
    }

    public void setPdpConfig(PDPConfig pdpConfig) {
        this.pdpConfig = pdpConfig;
    }

    public AttributeFactory getAttributeFactory() {
        return this.attributeFactory;
    }

    public void setAttributeFactory(AttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    public FunctionFactory getFunctionTargetFactory() {
        return this.functionTargetFactory;
    }

    public void setFunctionTargetFactory(FunctionFactory functionTargetFactory) {
        this.functionTargetFactory = functionTargetFactory;
    }

    public FunctionFactory getFunctionConditionFactory() {
        return this.functionConditionFactory;
    }

    public void setFunctionConditionFactory(FunctionFactory functionConditionFactory) {
        this.functionConditionFactory = functionConditionFactory;
    }

    public FunctionFactory getFunctionGeneralFactory() {
        return this.functionGeneralFactory;
    }

    public void setFunctionGeneralFactory(FunctionFactory functionGeneralFactory) {
        this.functionGeneralFactory = functionGeneralFactory;
    }

    public CombiningAlgFactory getCombiningAlgFactory() {
        return this.combiningAlgFactory;
    }

    public void setCombiningAlgFactory(CombiningAlgFactory combiningAlgFactory) {
        this.combiningAlgFactory = combiningAlgFactory;
    }

    public DocumentBuilderFactory getBuilder() {
        return this.builder;
    }

    static {
        logger = LogFactory.getLog(Balana.class);
    }
}

