/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.Balana;
import org.wso2.balana.DOMHelper;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ObligationFactory;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicyTreeElement;
import org.wso2.balana.TargetFactory;
import org.wso2.balana.combine.CombinerElement;
import org.wso2.balana.combine.CombinerParameter;
import org.wso2.balana.combine.CombiningAlgFactory;
import org.wso2.balana.combine.CombiningAlgorithm;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.RuleCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml2.Target;
import org.wso2.balana.xacml3.Advice;
import org.wso2.balana.xacml3.AdviceExpression;

public abstract class AbstractPolicy
implements PolicyTreeElement {
    private URI idAttr;
    private String version;
    private CombiningAlgorithm combiningAlg;
    private String description;
    private AbstractTarget target;
    private String defaultVersion;
    protected PolicyMetaData metaData;
    private List<PolicyTreeElement> children;
    private List<CombinerElement> childElements;
    private Set<AbstractObligation> obligationExpressions;
    private Set<AdviceExpression> adviceExpressions;
    private List<CombinerParameter> parameters;
    private String subjectPolicyValue;
    private String resourcePolicyValue;
    private String actionPolicyValue;
    private String envPolicyValue;
    private static final Log logger = LogFactory.getLog(AbstractPolicy.class);

    protected AbstractPolicy() {
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, AbstractTarget target) {
        this(id, version, combiningAlg, description, target, null);
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion) {
        this(id, version, combiningAlg, description, target, defaultVersion, null, null, null);
    }

    protected AbstractPolicy(URI id, String version, CombiningAlgorithm combiningAlg, String description, AbstractTarget target, String defaultVersion, Set<AbstractObligation> obligationExpressions, Set<AdviceExpression> adviceExpressions, List<CombinerParameter> parameters) {
        this.idAttr = id;
        this.combiningAlg = combiningAlg;
        this.description = description;
        this.target = target;
        this.defaultVersion = defaultVersion;
        this.version = version == null ? "1.0" : version;
        String namespaceUri = "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17";
        if (target != null && target instanceof Target) {
            namespaceUri = "urn:oasis:names:tc:xacml:2.0:policy:schema:os";
        }
        this.metaData = new PolicyMetaData(namespaceUri, defaultVersion);
        this.obligationExpressions = obligationExpressions == null ? new HashSet<AbstractObligation>() : Collections.unmodifiableSet(new HashSet<AbstractObligation>(obligationExpressions));
        this.adviceExpressions = adviceExpressions == null ? new HashSet<AdviceExpression>() : Collections.unmodifiableSet(new HashSet<AdviceExpression>(adviceExpressions));
        this.parameters = parameters == null ? new ArrayList<CombinerParameter>() : Collections.unmodifiableList(new ArrayList<CombinerParameter>(parameters));
    }

    protected AbstractPolicy(Node root, String policyPrefix, String combiningName) throws ParsingException {
        Node child;
        int i;
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.idAttr = new URI(attrs.getNamedItem(policyPrefix + "Id").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute " + policyPrefix + "Id", e);
        }
        Node versionNode = attrs.getNamedItem("Version");
        this.version = versionNode != null ? versionNode.getNodeValue() : "1.0";
        try {
            URI algId = new URI(attrs.getNamedItem(combiningName).getNodeValue());
            CombiningAlgFactory factory = Balana.getInstance().getCombiningAlgFactory();
            this.combiningAlg = factory.createAlgorithm(algId);
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing combining algorithm in " + policyPrefix, e);
        }
        if (policyPrefix.equals("Policy")) {
            if (!(this.combiningAlg instanceof RuleCombiningAlgorithm)) {
                throw new ParsingException("Policy must use a Rule Combining Algorithm");
            }
        } else if (!(this.combiningAlg instanceof PolicyCombiningAlgorithm)) {
            throw new ParsingException("PolicySet must use a Policy Combining Algorithm");
        }
        NodeList children = root.getChildNodes();
        Object xpathVersion = null;
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!DOMHelper.getLocalName(child).equals(policyPrefix + "Defaults")) continue;
            this.handleDefaults(child);
        }
        this.metaData = new PolicyMetaData(root.getNamespaceURI(), this.defaultVersion);
        this.obligationExpressions = new HashSet<AbstractObligation>();
        this.adviceExpressions = new HashSet<AdviceExpression>();
        this.parameters = new ArrayList<CombinerParameter>();
        children = root.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            String cname = DOMHelper.getLocalName(child);
            if (cname.equals("Description")) {
                if (!child.hasChildNodes()) continue;
                this.description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                this.target = TargetFactory.getFactory().getTarget(child, this.metaData);
                continue;
            }
            if (cname.equals("ObligationExpressions") || cname.equals("Obligations")) {
                this.parseObligationExpressions(child);
                continue;
            }
            if (cname.equals("AdviceExpressions")) {
                this.parseAdviceExpressions(child);
                continue;
            }
            if (!cname.equals("CombinerParameters")) continue;
            this.handleParameters(child);
        }
        this.obligationExpressions = Collections.unmodifiableSet(this.obligationExpressions);
        this.adviceExpressions = Collections.unmodifiableSet(this.adviceExpressions);
        this.parameters = Collections.unmodifiableList(this.parameters);
    }

    public String getSubjectPolicyValue() {
        return this.subjectPolicyValue;
    }

    public void setSubjectPolicyValue(String subjectPolicyValue) {
        this.subjectPolicyValue = subjectPolicyValue;
    }

    public String getResourcePolicyValue() {
        return this.resourcePolicyValue;
    }

    public void setResourcePolicyValue(String resourcePolicyValue) {
        this.resourcePolicyValue = resourcePolicyValue;
    }

    public String getActionPolicyValue() {
        return this.actionPolicyValue;
    }

    public void setActionPolicyValue(String actionPolicyValue) {
        this.actionPolicyValue = actionPolicyValue;
    }

    public String getEnvPolicyValue() {
        return this.envPolicyValue;
    }

    public void setEnvPolicyValue(String envPolicyValue) {
        this.envPolicyValue = envPolicyValue;
    }

    private void parseObligationExpressions(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("ObligationExpression") && !DOMHelper.getLocalName(node).equals("Obligation")) continue;
            AbstractObligation obligation = ObligationFactory.getFactory().getObligation(node, this.metaData);
            this.obligationExpressions.add(obligation);
        }
    }

    private void parseAdviceExpressions(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("AdviceExpression")) continue;
            this.adviceExpressions.add(AdviceExpression.getInstance(node, this.metaData));
        }
    }

    private void handleDefaults(Node root) throws ParsingException {
        this.defaultVersion = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("XPathVersion")) continue;
            this.defaultVersion = node.getFirstChild().getNodeValue();
        }
    }

    private void handleParameters(Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!DOMHelper.getLocalName(node).equals("CombinerParameter")) continue;
            this.parameters.add(CombinerParameter.getInstance(node));
        }
    }

    @Override
    public URI getId() {
        return this.idAttr;
    }

    public String getVersion() {
        return this.version;
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.combiningAlg;
    }

    public List getCombiningParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public AbstractTarget getTarget() {
        return this.target;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public List<PolicyTreeElement> getChildren() {
        return this.children;
    }

    public List<CombinerElement> getChildElements() {
        return this.childElements;
    }

    public Set getObligationExpressions() {
        return this.obligationExpressions;
    }

    public Set getAdviceExpressions() {
        return this.adviceExpressions;
    }

    public PolicyMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public MatchResult match(EvaluationCtx context) {
        return this.target.match(context);
    }

    protected void setChildren(List<CombinerElement> children) {
        if (children == null) {
            this.children = new ArrayList<PolicyTreeElement>();
        } else {
            ArrayList<PolicyTreeElement> list = new ArrayList<PolicyTreeElement>();
            for (CombinerElement aChildren : children) {
                list.add(aChildren.getElement());
            }
            this.children = Collections.unmodifiableList(list);
            this.childElements = Collections.unmodifiableList(children);
        }
    }

    @Override
    public AbstractResult evaluate(EvaluationCtx context) {
        AbstractResult result = this.combiningAlg.combine(context, this.parameters, this.childElements);
        if (this.obligationExpressions.size() < 1 && this.adviceExpressions.size() < 1) {
            return result;
        }
        int effect = result.getDecision();
        if (effect == 2 || effect == 3) {
            return result;
        }
        this.processObligationAndAdvices(context, effect, result);
        return result;
    }

    private void processObligationAndAdvices(EvaluationCtx evaluationCtx, int effect, AbstractResult result) {
        if (this.obligationExpressions != null && this.obligationExpressions.size() > 0) {
            HashSet<ObligationResult> results = new HashSet<ObligationResult>();
            for (AbstractObligation obligationExpression : this.obligationExpressions) {
                if (obligationExpression.getFulfillOn() != effect) continue;
                results.add(obligationExpression.evaluate(evaluationCtx));
            }
            result.getObligations().addAll(results);
        }
        if (this.adviceExpressions != null && this.adviceExpressions.size() > 0) {
            HashSet<Advice> advices = new HashSet<Advice>();
            for (AdviceExpression adviceExpression : this.adviceExpressions) {
                if (adviceExpression.getAppliesTo() != effect) continue;
                advices.add(adviceExpression.evaluate(evaluationCtx));
            }
            result.getAdvices().addAll(advices);
        }
    }

    protected void encodeCommonElements(StringBuilder builder) {
        for (CombinerElement childElement : this.childElements) {
            childElement.encode(builder);
        }
        if (this.obligationExpressions != null && this.obligationExpressions.size() != 0) {
            if (this.metaData.getXACMLVersion() == 3) {
                builder.append("<Obligations>\n");
            } else {
                builder.append("<ObligationExpressions>\n");
            }
            for (AbstractObligation obligationExpression : this.obligationExpressions) {
                obligationExpression.encode(builder);
            }
            if (this.metaData.getXACMLVersion() == 3) {
                builder.append("</Obligations>\n");
            } else {
                builder.append("</ObligationExpressions>\n");
            }
        }
        if (this.adviceExpressions != null && this.adviceExpressions.size() != 0) {
            builder.append("<AdviceExpressions>\n");
            for (AdviceExpression adviceExpression : this.adviceExpressions) {
                adviceExpression.encode(builder);
            }
            builder.append("</AdviceExpressions>\n");
        }
    }
}

