/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.priority.executors.services;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class PriorityMediationAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(PriorityMediationAdmin.class);

    public void add(String name, OMElement executor) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            PriorityExecutor ex = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)executor, (boolean)true, (Properties)new Properties());
            ex.setFileName(ServiceBusUtils.generateFileName((String)ex.getName()));
            ex.init();
            config.addPriorityExecutor(name, ex);
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.saveItem(name, 8);
            }
            log.info((Object)("Adding priority-executor with name: " + name));
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error occurred while building a priority executor from the configuration element" + axisFault.getMessage()));
            throw axisFault;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getExecutor(String name) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            Map exs = config.getPriorityExecutors();
            if (exs != null) {
                PriorityExecutor ex = (PriorityExecutor)exs.get(name);
                if (ex != null) {
                    OMElement oMElement = PriorityExecutorSerializer.serialize(null, (PriorityExecutor)ex, (String)"http://ws.apache.org/ns/synapse");
                    return oMElement;
                }
                String msg = "Cannot find an Priority Executor with the name:" + name;
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExecutorList() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            Map exs = config.getPriorityExecutors();
            if (exs != null && !exs.isEmpty()) {
                String[] stringArray = exs.keySet().toArray(new String[exs.keySet().size()]);
                return stringArray;
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String name, OMElement executor) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            PriorityExecutor oldExecutor = config.removeExecutor(name);
            if (oldExecutor != null) {
                oldExecutor.destroy();
                log.info((Object)("Removed priority executor with name: " + name));
                String oldFileName = oldExecutor.getFileName();
                PriorityExecutor ex = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)executor, (boolean)true, (Properties)new Properties());
                ex.setFileName(oldFileName);
                ex.init();
                config.addPriorityExecutor(name, ex);
                log.info((Object)("Updated and restored priority executor with name: " + name));
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    pm.deleteItem(name, oldFileName, 8);
                    pm.saveItem(name, 8);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            PriorityExecutor executor = config.removeExecutor(name);
            if (executor != null) {
                executor.destroy();
                log.info((Object)("Removed priority executor with name: " + name));
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    pm.deleteItem(name, executor.getFileName(), 8);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }
}

