/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.priority.executors;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.priority.executors.ExecutorDeployer;
import org.wso2.carbon.priority.executors.services.PriorityExeDeployerService;
import org.wso2.carbon.priority.executors.services.PriorityExeDeployerServiceImpl;
import org.wso2.carbon.priority.executors.util.ConfigHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.priority", immediate=true)
public class PriorityServiceComponent
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(PriorityServiceComponent.class);
    private boolean activated = false;
    private Map<Integer, SynapseEnvironmentService> synapseEnvironmentServices = new HashMap<Integer, SynapseEnvironmentService>();

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bndCtx = ctxt.getBundleContext();
            bndCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)this, null);
            bndCtx.registerService(PriorityExeDeployerService.class.getName(), (Object)new PriorityExeDeployerServiceImpl(), null);
            SynapseEnvironmentService synEnvService = this.synapseEnvironmentServices.get(-1234);
            this.registerDeployer(ConfigHolder.getInstance().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Endpoint Admin bundle is activated ");
            }
            this.activated = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sequence Admin bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Sequence Admin bundle ", e);
        }
    }

    private void unRegisterDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
            String endpointDirPath = synapseConfigPath + File.separator + "priority-executors";
            deploymentEngine.removeDeployer(endpointDirPath, "xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        SynapseConfiguration synCfg = synapseEnvironment.getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synCfg.getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String endpointDirPath = synapseConfigPath + File.separator + "priority-executors";
        for (PriorityExecutor ep : synCfg.getPriorityExecutors().values()) {
            if (ep.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(endpointDirPath + File.separator + ep.getFileName());
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            deploymentEngine.addDeployer((Deployer)new ExecutorDeployer(), endpointDirPath, "xml");
        }
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    @Reference(name="synapse.config.service", service=SynapseConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseConfigurationService")
    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    @Reference(name="synapse.env.service", service=SynapseEnvironmentService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseEnvironmentService")
    protected void setSynapseEnvironmentService(SynapseEnvironmentService synEnvSvc) {
        boolean alreadyCreated = this.synapseEnvironmentServices.containsKey(synEnvSvc.getTenantId());
        this.synapseEnvironmentServices.put(synEnvSvc.getTenantId(), synEnvSvc);
        if (this.activated && !alreadyCreated) {
            try {
                this.registerDeployer(synEnvSvc.getConfigurationContext().getAxisConfiguration(), synEnvSvc.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Endpoint Admin bundle is activated ");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Failed to activate Endpoint Admin bundle ", e);
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synEnvSvc) {
        this.synapseEnvironmentServices.remove(synEnvSvc.getTenantId());
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            ConfigHolder.getInstance().setRegistry(regService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }

    @Reference(name="synapse.registrations.service", service=SynapseRegistrationsService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseRegistrationsService")
    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (this.synapseEnvironmentServices.containsKey(tenantId)) {
            SynapseEnvironment env = this.synapseEnvironmentServices.get(tenantId).getSynapseEnvironment();
            this.synapseEnvironmentServices.remove(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unRegisterDeployer(axisConfig, env);
            }
        }
    }

    public void createdConfigurationContext(ConfigurationContext configContext) {
        SynapseEnvironmentService synEnvService;
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (axisConfig != null && (synEnvService = this.synapseEnvironmentServices.get(tenantId)) != null) {
            try {
                this.registerDeployer(axisConfig, synEnvService.getSynapseEnvironment());
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing PriorityExecutor Admin", (Throwable)e);
            }
        }
    }
}

