/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.rest.api.util.exception.InternalServerErrorException;
import org.wso2.carbon.apimgt.rest.api.util.validation.constraints.ValidateParamEquality;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class ParameterEqualityValidator
implements ConstraintValidator<ValidateParamEquality, Object[]> {
    private static final Log log = LogFactory.getLog(ParameterEqualityValidator.class);
    private int firstParamIndex;
    private int secondParamIndex;
    private String firstField;
    private String secondField;
    private String errorMessage;

    public void initialize(ValidateParamEquality validateEquality) {
        this.firstParamIndex = validateEquality.index0();
        this.secondParamIndex = validateEquality.index1();
        this.firstField = validateEquality.index0Field();
        this.secondField = validateEquality.index1Field();
        this.errorMessage = validateEquality.message();
    }

    public boolean isValid(Object[] object, ConstraintValidatorContext constraintValidatorContext) {
        Object firstObj = object[this.firstParamIndex];
        Object secondObj = object[this.secondParamIndex];
        try {
            if (!StringUtils.isEmpty((CharSequence)this.firstField)) {
                firstObj = BeanUtils.getProperty((Object)firstObj, (String)this.firstField);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.handleException("Error while accessing first field " + this.firstField + " for validation", e);
            return false;
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)this.secondField)) {
                secondObj = BeanUtils.getProperty((Object)secondObj, (String)this.secondField);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.handleException("Error while accessing second field " + this.secondField + " for validation", e);
            return false;
        }
        if (firstObj == null || secondObj == null) {
            return true;
        }
        boolean isValid = firstObj.equals(secondObj);
        if (!isValid && "Specified objects are not equal.".equals(this.errorMessage)) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("Values \\{" + firstObj + "," + secondObj + "\\} must be equal").addConstraintViolation();
        }
        return isValid;
    }

    private void handleException(String errorMessage, Throwable throwable) {
        log.error((Object)errorMessage, throwable);
        throw new InternalServerErrorException(errorMessage, throwable);
    }
}

