/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtAuthorizationFailedException;
import org.wso2.carbon.apimgt.api.APIMgtResourceAlreadyExistsException;
import org.wso2.carbon.apimgt.api.APIMgtResourceNotFoundException;
import org.wso2.carbon.apimgt.api.ApplicationNameWhiteSpaceValidationException;
import org.wso2.carbon.apimgt.api.ApplicationNameWithInvalidCharactersException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.DuplicateAPIException;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.impl.AMDefaultKeyManagerImpl;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.definitions.OASParserUtil;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.common.dto.ErrorDTO;
import org.wso2.carbon.apimgt.rest.api.common.dto.ErrorListItemDTO;
import org.wso2.carbon.apimgt.rest.api.util.exception.BadRequestException;
import org.wso2.carbon.apimgt.rest.api.util.exception.ConflictException;
import org.wso2.carbon.apimgt.rest.api.util.exception.ForbiddenException;
import org.wso2.carbon.apimgt.rest.api.util.exception.InternalServerErrorException;
import org.wso2.carbon.apimgt.rest.api.util.exception.MethodNotAllowedException;
import org.wso2.carbon.apimgt.rest.api.util.exception.NotFoundException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.uri.template.URITemplate;
import org.wso2.uri.template.URITemplateException;

public class RestApiUtil {
    public static final Log log = LogFactory.getLog(RestApiUtil.class);
    private static Set<org.wso2.carbon.apimgt.api.model.URITemplate> storeResourceMappings;
    private static Set<org.wso2.carbon.apimgt.api.model.URITemplate> publisherResourceMappings;
    private static Set<org.wso2.carbon.apimgt.api.model.URITemplate> adminAPIResourceMappings;
    private static Set<org.wso2.carbon.apimgt.api.model.URITemplate> serviceCatalogAPIResourceMappings;
    private static Dictionary<URITemplate, List<String>> uriToHttpMethodsMap;
    private static Dictionary<URITemplate, List<String>> ETagSkipListURIToHttpMethodsMap;

    public static <T> ErrorDTO getConstraintViolationErrorDTO(Set<ConstraintViolation<T>> violations) {
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setDescription("Validation Error");
        errorDTO.setMessage("Bad Request");
        errorDTO.setCode(Long.valueOf(400L));
        errorDTO.setMoreInfo("");
        ArrayList<ErrorListItemDTO> errorListItemDTOs = new ArrayList<ErrorListItemDTO>();
        for (ConstraintViolation<T> violation : violations) {
            ErrorListItemDTO errorListItemDTO = new ErrorListItemDTO();
            errorListItemDTO.setCode("400_" + violation.getPropertyPath());
            errorListItemDTO.setMessage(violation.getPropertyPath() + ": " + violation.getMessage());
            errorListItemDTOs.add(errorListItemDTO);
        }
        errorDTO.setError(errorListItemDTOs);
        return errorDTO;
    }

    public static ErrorDTO getErrorDTO(String message, Long code, String description) {
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setCode(code);
        errorDTO.setMoreInfo("");
        errorDTO.setMessage(message);
        errorDTO.setDescription(description);
        return errorDTO;
    }

    public static ErrorDTO getErrorDTO(ErrorHandler errorHandler) {
        ErrorDTO errorDTO = new ErrorDTO();
        errorDTO.setCode(Long.valueOf(errorHandler.getErrorCode()));
        errorDTO.setMoreInfo("");
        errorDTO.setMessage(errorHandler.getErrorMessage());
        errorDTO.setDescription(errorHandler.getErrorDescription());
        return errorDTO;
    }

    public static ErrorDTO getErrorDTO(List<ErrorHandler> errorHandlers) {
        ErrorDTO errorDTO = new ErrorDTO();
        for (int i = 0; i < errorHandlers.size(); ++i) {
            if (i == 0) {
                ErrorHandler elementAt0 = errorHandlers.get(0);
                errorDTO.setCode(Long.valueOf(elementAt0.getErrorCode()));
                errorDTO.setMoreInfo("");
                errorDTO.setMessage(elementAt0.getErrorMessage());
                errorDTO.setDescription(elementAt0.getErrorDescription());
                continue;
            }
            ErrorListItemDTO errorListItemDTO = new ErrorListItemDTO();
            errorListItemDTO.setCode(errorHandlers.get(i).getErrorCode() + "");
            errorListItemDTO.setMessage(errorHandlers.get(i).getErrorMessage());
            errorListItemDTO.setDescription(errorHandlers.get(i).getErrorDescription());
            errorDTO.getError().add(errorListItemDTO);
        }
        return errorDTO;
    }

    public static Response getResponseFromResourceFile(String fileNameWithoutExtension, ResourceFile resourceFile) {
        String extension;
        String contentType;
        if (resourceFile.getContentType().contains("application/zip")) {
            contentType = "application/zip";
            extension = ".zip";
        } else {
            contentType = "application/wsdl";
            extension = ".wsdl";
        }
        String filename = fileNameWithoutExtension + extension;
        return Response.ok((Object)resourceFile.getContent(), (String)contentType).header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
    }

    public static String getLoggedInUserGroupId() {
        String username = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        JSONObject loginInfoJsonObj = new JSONObject();
        try {
            loginInfoJsonObj.put((Object)"user", (Object)username);
            loginInfoJsonObj.put((Object)"isSuperTenant", (Object)tenantDomain.equals("carbon.super"));
            String loginInfoString = loginInfoJsonObj.toJSONString();
            String[] groupIdArr = RestApiUtil.getGroupIds(loginInfoString);
            String groupId = "";
            if (groupIdArr != null) {
                for (int i = 0; i < groupIdArr.length; ++i) {
                    if (groupIdArr[i] == null) continue;
                    groupId = i == groupIdArr.length - 1 ? groupId + groupIdArr[i] : groupId + groupIdArr[i] + ",";
                }
            }
            return groupId;
        }
        catch (APIManagementException e) {
            String errorMsg = "Unable to get groupIds of user " + username;
            RestApiUtil.handleInternalServerError(errorMsg, e, log);
            return null;
        }
    }

    private static String[] getGroupIds(String loginInfoString) throws APIManagementException {
        String groupingExtractorClass = APIUtil.getRESTApiGroupingExtractorImplementation();
        return APIUtil.getGroupIdsFromExtractor((String)loginInfoString, (String)groupingExtractorClass);
    }

    public static String getRequestedTenantDomain(String xTenantHeader) {
        if (StringUtils.isEmpty((CharSequence)xTenantHeader)) {
            return RestApiCommonUtil.getLoggedInUserTenantDomain();
        }
        return xTenantHeader;
    }

    public static void transferFile(InputStream uploadedInputStream, String newFileName, String storageLocation) throws APIManagementException {
        FileOutputStream outFileStream = null;
        try {
            int read;
            outFileStream = new FileOutputStream(new File(storageLocation, newFileName));
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                outFileStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            try {
                String errorMessage = "Error in transferring files.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIManagementException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outFileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outFileStream);
    }

    public static InternalServerErrorException buildInternalServerErrorException() {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Internal server error", 500L, "The server encountered an internal error. Please contact administrator.");
        return new InternalServerErrorException(errorDTO);
    }

    public static InternalServerErrorException buildInternalServerErrorException(String errorDescription) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Internal server error", 500L, errorDescription);
        return new InternalServerErrorException(errorDTO);
    }

    public static NotFoundException buildNotFoundException(String resource, String id) {
        String description = !StringUtils.isEmpty((CharSequence)id) ? "Requested " + resource + " with Id '" + id + "' not found" : "Requested " + resource + " not found";
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Not Found", 404L, description);
        return new NotFoundException(errorDTO);
    }

    public static NotFoundException buildNotFoundException(String resource, String id, String tenant) {
        String description = !StringUtils.isEmpty((CharSequence)id) ? "Requested " + resource + " with Id '" + id + "' not found in tenant " + tenant : "Requested " + resource + " not found in tenant " + tenant;
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Not Found", 404L, description);
        return new NotFoundException(errorDTO);
    }

    public static NotFoundException buildNotFoundException(String description) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Not Found", 404L, description);
        return new NotFoundException(errorDTO);
    }

    public static ForbiddenException buildForbiddenException(String resource, String id) {
        String description = !StringUtils.isEmpty((CharSequence)id) ? "You don't have permission to access the " + resource + " with Id " + id : "You don't have permission to access the " + resource;
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Forbidden", 403L, description);
        return new ForbiddenException(errorDTO);
    }

    public static ForbiddenException buildForbiddenException(String description) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Forbidden", 403L, description);
        return new ForbiddenException(errorDTO);
    }

    public static BadRequestException buildBadRequestException(String description) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Bad Request", 400L, description);
        return new BadRequestException(errorDTO);
    }

    public static BadRequestException buildBadRequestException(String description, Long code) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Bad Request", code, description);
        return new BadRequestException(errorDTO);
    }

    public static BadRequestException buildBadRequestException(String description, Throwable e) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Bad Request", 400L, description);
        return new BadRequestException(description, e, errorDTO);
    }

    public static BadRequestException buildBadRequestException(ErrorDTO errorDTO) {
        return new BadRequestException(errorDTO);
    }

    public static BadRequestException buildBadRequestException(ErrorHandler errorHandler) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO(errorHandler.getErrorMessage(), errorHandler.getErrorCode(), errorHandler.getErrorDescription());
        return new BadRequestException(errorDTO);
    }

    public static BadRequestException buildBadRequestException(List<ErrorHandler> errorHandlers) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO(errorHandlers);
        return new BadRequestException(errorDTO);
    }

    public static MethodNotAllowedException buildMethodNotAllowedException(String method, String resource) {
        String description = "Method " + method + " is not supported for " + resource;
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Method Not Allowed", 405L, description);
        return new MethodNotAllowedException(errorDTO);
    }

    public static ConflictException buildConflictException(String message, String description) {
        ErrorDTO errorDTO = RestApiUtil.getErrorDTO(message, 409L, description);
        return new ConflictException(errorDTO);
    }

    public static boolean isDueToAuthorizationFailure(Throwable e) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause instanceof AuthorizationFailedException || rootCause instanceof APIMgtAuthorizationFailedException;
    }

    public static boolean isDueToResourceNotFound(Throwable e) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause instanceof APIMgtResourceNotFoundException || rootCause instanceof ResourceNotFoundException;
    }

    public static boolean isDueToMetaInfoIsCorrupted(Throwable e) {
        return RestApiUtil.detailedMessageMatches(e, "Error while reading API meta information from path");
    }

    public static boolean isDueToProvidedThrottlingPolicyMissing(Throwable e) {
        return RestApiUtil.detailedMessageMatches(e, "Invalid x-throttling tier") || RestApiUtil.detailedMessageMatches(e, "Invalid API level throttling tier") || RestApiUtil.detailedMessageMatches(e, "Invalid Product level throttling tier") || RestApiUtil.detailedMessageMatches(e, "Invalid Subscription level throttling tier") || RestApiUtil.detailedMessageMatches(e, "Invalid Application level throttling tier");
    }

    public static boolean isDueToResourceAlreadyExists(Throwable e) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause instanceof APIMgtResourceAlreadyExistsException || rootCause instanceof DuplicateAPIException;
    }

    public static boolean isDueToApplicationNameWhiteSpaceValidation(Throwable e) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause instanceof ApplicationNameWhiteSpaceValidationException;
    }

    public static boolean isDueToApplicationNameWithInvalidCharacters(Throwable e) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause instanceof ApplicationNameWithInvalidCharactersException;
    }

    public static boolean rootCauseMessageMatches(Throwable e, String message) {
        Throwable rootCause = RestApiUtil.getPossibleErrorCause(e);
        return rootCause.getMessage().contains(message);
    }

    public static boolean detailedMessageMatches(Throwable e, String message) {
        return e.getMessage().contains(message);
    }

    private static Throwable getPossibleErrorCause(Throwable e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        rootCause = rootCause == null ? e : rootCause;
        return rootCause;
    }

    public static void handleBadRequest(String msg, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(msg);
        log.error((Object)msg);
        throw badRequestException;
    }

    public static void handleBadRequest(String msg, Long code, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(msg, code);
        log.error((Object)msg);
        throw badRequestException;
    }

    public static void handleBadRequest(String msg, Throwable e, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(msg);
        log.error((Object)msg, e);
        throw badRequestException;
    }

    public static void handleBadRequest(ErrorHandler errorHandler, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(errorHandler);
        log.error((Object)errorHandler.getErrorMessage());
        throw badRequestException;
    }

    public static void handleBadRequest(List<ErrorHandler> errorHandlers, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(errorHandlers);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < errorHandlers.size(); ++i) {
            ErrorHandler handler = errorHandlers.get(i);
            builder.append(handler.getErrorMessage());
            if (StringUtils.isNotBlank((CharSequence)handler.getErrorDescription())) {
                builder.append(":");
                builder.append(handler.getErrorDescription());
            }
            if (i >= errorHandlers.size() - 1) continue;
            builder.append(", ");
        }
        log.error((Object)builder.toString());
        throw badRequestException;
    }

    public static void handleAuthorizationFailure(String resource, String id, Throwable t, Log log) throws ForbiddenException {
        ForbiddenException forbiddenException = RestApiUtil.buildForbiddenException(resource, id);
        log.error((Object)forbiddenException.getMessage(), t);
        throw forbiddenException;
    }

    public static void handleAuthorizationFailure(String resource, String id, Log log) throws ForbiddenException {
        ForbiddenException forbiddenException = RestApiUtil.buildForbiddenException(resource, id);
        log.error((Object)forbiddenException.getMessage());
        throw forbiddenException;
    }

    public static void handleAuthorizationFailure(String description, Throwable t, Log log) throws ForbiddenException {
        ForbiddenException forbiddenException = RestApiUtil.buildForbiddenException(description);
        log.error((Object)description, t);
        throw forbiddenException;
    }

    public static void handleAuthorizationFailure(String description, Log log) throws ForbiddenException {
        ForbiddenException forbiddenException = RestApiUtil.buildForbiddenException(description);
        log.error((Object)description);
        throw forbiddenException;
    }

    public static void handleResourceNotFoundInTenantError(String resource, String id, Log log, String tenant) throws NotFoundException {
        NotFoundException notFoundException = RestApiUtil.buildNotFoundException(resource, id, tenant);
        log.error((Object)notFoundException.getMessage());
        throw notFoundException;
    }

    public static void handleResourceNotFoundError(String resource, String id, Throwable t, Log log) throws NotFoundException {
        NotFoundException notFoundException = RestApiUtil.buildNotFoundException(resource, id);
        log.error((Object)notFoundException.getMessage(), t);
        throw notFoundException;
    }

    public static void handleResourceNotFoundError(String resource, String id, Log log) throws NotFoundException {
        NotFoundException notFoundException = RestApiUtil.buildNotFoundException(resource, id);
        log.error((Object)notFoundException.getMessage());
        throw notFoundException;
    }

    public static void handleResourceNotFoundError(String description, Throwable t, Log log) throws NotFoundException {
        NotFoundException notFoundException = RestApiUtil.buildNotFoundException(description);
        log.error((Object)description, t);
        throw notFoundException;
    }

    public static void handleMetaInformationFailureError(String description, Throwable t, Log log) throws BadRequestException {
        BadRequestException badRequestException = RestApiUtil.buildBadRequestException(description);
        log.error((Object)description, t);
        throw badRequestException;
    }

    public static void handleResourceNotFoundError(String description, Log log) throws NotFoundException {
        NotFoundException notFoundException = RestApiUtil.buildNotFoundException(description);
        log.error((Object)description);
        throw notFoundException;
    }

    public static void handleResourceAlreadyExistsError(String description, Log log) throws ConflictException {
        ConflictException conflictException = RestApiUtil.buildConflictException("Resource Already Exists", description);
        log.error((Object)description);
        throw conflictException;
    }

    public static void handleConflict(String description, Log log) throws ConflictException {
        ConflictException conflictException = RestApiUtil.buildConflictException("Conflict", description);
        log.error((Object)description);
        throw conflictException;
    }

    public static void handleResourceAlreadyExistsError(String description, Throwable t, Log log) throws ConflictException {
        ConflictException conflictException = RestApiUtil.buildConflictException("Resource Already Exists", description);
        log.error((Object)description, t);
        throw conflictException;
    }

    public static void handleMethodNotAllowedError(String method, String resource, Log log) throws MethodNotAllowedException {
        MethodNotAllowedException methodNotAllowedException = RestApiUtil.buildMethodNotAllowedException(method, resource);
        log.error((Object)methodNotAllowedException.getMessage());
        throw methodNotAllowedException;
    }

    public static void handleInternalServerError(String msg, Throwable t, Log log) throws InternalServerErrorException {
        InternalServerErrorException internalServerErrorException = RestApiUtil.buildInternalServerErrorException(msg);
        log.error((Object)msg, t);
        throw internalServerErrorException;
    }

    public static void handleInternalServerError(String msg, Log log) throws InternalServerErrorException {
        InternalServerErrorException internalServerErrorException = RestApiUtil.buildInternalServerErrorException();
        log.error((Object)msg);
        throw internalServerErrorException;
    }

    public static void checkAllowedMethodForResource(String method, String resource) throws MethodNotAllowedException {
        if (("/throttling-policies/application".equals(resource) || "/throttling-policies/resource".equals(resource)) && !"GET".equals(method)) {
            RestApiUtil.handleMethodNotAllowedError(method, resource, log);
        }
    }

    public static Tier findTier(Collection<Tier> tiers, String tierName) {
        for (Tier tier : tiers) {
            if (tier.getName() == null || tierName == null || !tier.getName().equals(tierName)) continue;
            return tier;
        }
        return null;
    }

    public static OAuthApplicationInfo registerOAuthApplication(OAuthAppRequest appRequest) {
        AMDefaultKeyManagerImpl impl = new AMDefaultKeyManagerImpl();
        OAuthApplicationInfo returnedAPP = null;
        try {
            returnedAPP = impl.createApplication(appRequest);
        }
        catch (APIManagementException e) {
            log.error((Object)("Cannot create OAuth application from provided information, for APP name: " + appRequest.getOAuthApplicationInfo().getClientName()), (Throwable)e);
        }
        return returnedAPP;
    }

    public static Set<org.wso2.carbon.apimgt.api.model.URITemplate> getStoreAppResourceMapping(String version) {
        API api = new API(new APIIdentifier("admin", "/api/am/store/", "v0.16"));
        if (storeResourceMappings != null) {
            return storeResourceMappings;
        }
        try {
            String definition = "v0.16".equals(version) ? IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/store-api.json"), (String)"UTF-8") : IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/devportal-api.yaml"), (String)"UTF-8");
            APIDefinition oasParser = OASParserUtil.getOASParser((String)definition);
            storeResourceMappings = oasParser.getURITemplates(definition);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while reading resource mappings for API: " + api.getId().getApiName()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading the swagger definition for API: " + api.getId().getApiName()), (Throwable)e);
        }
        return storeResourceMappings;
    }

    public static Set<org.wso2.carbon.apimgt.api.model.URITemplate> getPublisherAppResourceMapping(String version) {
        API api = new API(new APIIdentifier("admin", "/api/am/store/", "v0.16"));
        if (publisherResourceMappings != null) {
            return publisherResourceMappings;
        }
        try {
            String definition = "v0.16".equals(version) ? IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/publisher-api.json"), (String)"UTF-8") : IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/publisher-api.yaml"), (String)"UTF-8");
            APIDefinition oasParser = OASParserUtil.getOASParser((String)definition);
            publisherResourceMappings = oasParser.getURITemplates(definition);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while reading resource mappings for API: " + api.getId().getApiName()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading the swagger definition for API: " + api.getId().getApiName()), (Throwable)e);
        }
        return publisherResourceMappings;
    }

    public static Set<org.wso2.carbon.apimgt.api.model.URITemplate> getServiceCatalogAPIResourceMapping() {
        API api = new API(new APIIdentifier("admin", "/api/am/service-catalog", "v0"));
        if (serviceCatalogAPIResourceMappings != null) {
            return serviceCatalogAPIResourceMappings;
        }
        try {
            String definition = IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/service-catalog-api.yaml"), (String)"UTF-8");
            APIDefinition oasParser = OASParserUtil.getOASParser((String)definition);
            serviceCatalogAPIResourceMappings = oasParser.getURITemplates(definition);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while reading resource mappings for API: " + api.getId().getApiName()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading the swagger definition for API: " + api.getId().getApiName()), (Throwable)e);
        }
        return serviceCatalogAPIResourceMappings;
    }

    public static Set<org.wso2.carbon.apimgt.api.model.URITemplate> getAdminAPIAppResourceMapping(String version) {
        API api = new API(new APIIdentifier("admin", "/api/am/admin/", "v0.16"));
        if (adminAPIResourceMappings != null) {
            return adminAPIResourceMappings;
        }
        try {
            String definition = "v0.16".equals(version) ? IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/admin-api.json"), (String)"UTF-8") : IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream("/admin-api.yaml"), (String)"UTF-8");
            APIDefinition oasParser = OASParserUtil.getOASParser((String)definition);
            adminAPIResourceMappings = oasParser.getURITemplates(definition);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while reading resource mappings for API: " + api.getId().getApiName()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading the swagger definition for API: " + api.getId().getApiName()), (Throwable)e);
        }
        return adminAPIResourceMappings;
    }

    private static Dictionary<URITemplate, List<String>> getAllowedURIsToMethodsMapFromConfig() throws APIManagementException {
        Hashtable<URITemplate, List<String>> uriToMethodsMap = new Hashtable<URITemplate, List<String>>();
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        List uriList = apiManagerConfiguration.getProperty("RESTAPI.AllowedURIs.AllowedURI.URI");
        List methodsList = apiManagerConfiguration.getProperty("RESTAPI.AllowedURIs.AllowedURI.HTTPMethods");
        if (uriList != null && methodsList != null) {
            if (uriList.size() != methodsList.size()) {
                String errorMsg = "Provided White-listed URIs for REST API are invalid. Every 'allowedURI' should include 'URI' and 'HTTPMethods' elements";
                log.error((Object)errorMsg);
                return new Hashtable<URITemplate, List<String>>();
            }
            for (int i = 0; i < uriList.size(); ++i) {
                String uri = (String)uriList.get(i);
                uri = uri.replace("/{version}", "");
                try {
                    URITemplate uriTemplate = new URITemplate(uri);
                    String methodsForUri = (String)methodsList.get(i);
                    List<String> methodListForUri = Arrays.asList(methodsForUri.split(","));
                    uriToMethodsMap.put(uriTemplate, methodListForUri);
                    continue;
                }
                catch (URITemplateException e) {
                    String msg = "Error in parsing uri " + uri + " when retrieving white-listed URIs for REST API";
                    log.error((Object)msg, (Throwable)e);
                    throw new APIManagementException(msg, (Throwable)e);
                }
            }
        }
        return uriToMethodsMap;
    }

    public static Dictionary<URITemplate, List<String>> getAllowedURIsToMethodsMap() throws APIManagementException {
        if (uriToHttpMethodsMap == null) {
            uriToHttpMethodsMap = RestApiUtil.getAllowedURIsToMethodsMapFromConfig();
        }
        return uriToHttpMethodsMap;
    }

    public static String extractOAuthAccessTokenFromMessage(Message message, Pattern pattern, String authHeaderName) {
        String authHeader = null;
        ArrayList authHeaders = (ArrayList)((TreeMap)message.get((Object)Message.PROTOCOL_HEADERS)).get(authHeaderName);
        if (authHeaders == null) {
            return null;
        }
        String headerString = authHeaders.get(0).toString();
        Matcher matcher = pattern.matcher(headerString);
        if (matcher.find()) {
            authHeader = headerString.substring(matcher.end());
        }
        return authHeader;
    }

    private static String removeLeadingAndTrailing(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    private static Dictionary<URITemplate, List<String>> getETagSkipListToMethodsMapFromConfig() throws APIManagementException {
        Hashtable<URITemplate, List<String>> uriToMethodsMap = new Hashtable<URITemplate, List<String>>();
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        List uriList = apiManagerConfiguration.getProperty("RESTAPI.ETagSkipList.ETagSkipURI.URI");
        List methodsList = apiManagerConfiguration.getProperty("RESTAPI.ETagSkipList.ETagSkipURI.HTTPMethods");
        if (uriList != null && methodsList != null) {
            if (uriList.size() != methodsList.size()) {
                String errorMsg = "Provided ETag skip list URIs for Store REST API are invalid.";
                log.error((Object)errorMsg);
                return new Hashtable<URITemplate, List<String>>();
            }
            for (int i = 0; i < uriList.size(); ++i) {
                String uri = (String)uriList.get(i);
                try {
                    URITemplate uriTemplate = new URITemplate(uri);
                    String methodsForUri = (String)methodsList.get(i);
                    List<String> methodListForUri = Arrays.asList(methodsForUri.split(","));
                    uriToMethodsMap.put(uriTemplate, methodListForUri);
                    continue;
                }
                catch (URITemplateException e) {
                    String msg = "Error in parsing uri " + uri + " when retrieving ETag skip URIs for REST API";
                    log.error((Object)msg, (Throwable)e);
                    throw new APIManagementException(msg, (Throwable)e);
                }
            }
        }
        return uriToMethodsMap;
    }

    public static Dictionary<URITemplate, List<String>> getETagSkipListToMethodsMap() throws APIManagementException {
        if (ETagSkipListURIToHttpMethodsMap == null) {
            ETagSkipListURIToHttpMethodsMap = RestApiUtil.getETagSkipListToMethodsMapFromConfig();
        }
        return ETagSkipListURIToHttpMethodsMap;
    }

    public static Boolean checkETagSkipList(String path, String httpMethod) {
        try {
            Dictionary<URITemplate, List<String>> eTagSkipListToMethodsMap = RestApiUtil.getETagSkipListToMethodsMap();
            Enumeration<URITemplate> uriTemplateSet = eTagSkipListToMethodsMap.keys();
            while (uriTemplateSet.hasMoreElements()) {
                URITemplate uriTemplate = uriTemplateSet.nextElement();
                if (!uriTemplate.matches(path, new HashMap())) continue;
                List<String> ETagDisableHttpVerbs = eTagSkipListToMethodsMap.get(uriTemplate);
                return ETagDisableHttpVerbs.contains(httpMethod);
            }
        }
        catch (APIManagementException e) {
            RestApiUtil.handleInternalServerError("Unable to resolve ETag skip list in api-manager.xml", e, log);
        }
        return false;
    }

    public static void handleMigrationSpecificPermissionViolations(String targetTenantDomain, String username) throws ForbiddenException {
        boolean isCrossTenantAccess;
        boolean bl = isCrossTenantAccess = !targetTenantDomain.equals(MultitenantUtils.getTenantDomain((String)username));
        if (!isCrossTenantAccess) {
            return;
        }
        String superAdminRole = null;
        try {
            superAdminRole = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(-1234).getRealmConfiguration().getAdminRoleName();
        }
        catch (UserStoreException e) {
            RestApiUtil.handleInternalServerError("Error in getting super admin role name", e, log);
        }
        String superTenantDomain = null;
        try {
            superTenantDomain = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getSuperTenantDomain();
        }
        catch (UserStoreException e) {
            RestApiUtil.handleInternalServerError("Error in getting the super tenant domain", e, log);
        }
        boolean isSuperTenantUser = RestApiCommonUtil.getLoggedInUserTenantDomain().equals(superTenantDomain);
        if (!isSuperTenantUser) {
            String errorMsg = "Cross Tenant resource access is not allowed for this request. User " + username + " is not allowed to access resources in " + targetTenantDomain + " as the requester is not a super tenant user";
            log.error((Object)errorMsg);
            ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Forbidden", 403L, errorMsg);
            throw new ForbiddenException(errorDTO);
        }
        boolean isSuperAdminRoleNameExist = false;
        try {
            isSuperAdminRoleNameExist = APIUtil.isUserInRole((String)username, (String)superAdminRole);
        }
        catch (APIManagementException | UserStoreException e) {
            RestApiUtil.handleInternalServerError("Error in checking whether the user has admin role", e, log);
        }
        if (!isSuperAdminRoleNameExist) {
            String errorMsg = "Cross Tenant resource access is not allowed for this request. User " + username + " is not allowed to access resources in " + targetTenantDomain + " as the requester is not a super tenant admin";
            log.error((Object)errorMsg);
            ErrorDTO errorDTO = RestApiUtil.getErrorDTO("Forbidden", 403L, errorMsg);
            throw new ForbiddenException(errorDTO);
        }
    }

    public static boolean checkIfAnonymousAPI(Message inMessage) {
        return inMessage.get((Object)"authentication_required") != null && (Boolean)inMessage.get((Object)"authentication_required") == false;
    }

    public static Set<org.wso2.carbon.apimgt.api.model.URITemplate> getURITemplatesForBasePath(String basePath) {
        Set<Object> uriTemplates = new HashSet();
        if (basePath.contains("/api/am/publisher/v0.16")) {
            uriTemplates = RestApiUtil.getPublisherAppResourceMapping("v0.16");
        } else if (basePath.contains("/api/am/publisher/v2")) {
            uriTemplates = RestApiUtil.getPublisherAppResourceMapping("v2");
        } else if (basePath.contains("/api/am/store/v0.16")) {
            uriTemplates = RestApiUtil.getStoreAppResourceMapping("v0.16");
        } else if (basePath.contains("api/am/devportalv2")) {
            uriTemplates = RestApiUtil.getStoreAppResourceMapping("v2");
        } else if (basePath.contains("/api/am/admin/v0.16")) {
            uriTemplates = RestApiUtil.getAdminAPIAppResourceMapping("v0.16");
        } else if (basePath.contains("/api/am/admin/v2")) {
            uriTemplates = RestApiUtil.getAdminAPIAppResourceMapping("v2");
        } else if (basePath.contains("/api/am/service-catalog")) {
            uriTemplates = RestApiUtil.getServiceCatalogAPIResourceMapping();
        }
        return uriTemplates;
    }

    public static Map<String, List<String>> getScopesInfoFromAPIYamlDefinitions() throws APIManagementException {
        String[] fileNameArray;
        HashMap<String, List<String>> portalScopeList = new HashMap<String, List<String>>();
        for (String fileName : fileNameArray = new String[]{"/admin-api.yaml", "/publisher-api.yaml", "/devportal-api.yaml"}) {
            String definition = null;
            try {
                definition = IOUtils.toString((InputStream)RestApiUtil.class.getResourceAsStream(fileName), (String)"UTF-8");
            }
            catch (IOException e) {
                throw new APIManagementException("Error while reading the swagger definition ,", (ErrorHandler)ExceptionCodes.DEFINITION_EXCEPTION);
            }
            APIDefinition oasParser = OASParserUtil.getOASParser((String)definition);
            Set scopeSet = oasParser.getScopes(definition);
            for (Scope entry : scopeSet) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getDescription());
                list.add(fileName.replaceAll("-api.yaml", "").replace("/", ""));
                portalScopeList.put(entry.getName(), list);
            }
        }
        return portalScopeList;
    }

    public static boolean isDevPortalAnonymousEnabled(String tenantDomain) {
        try {
            JSONObject tenantConfig = APIUtil.getTenantConfig((String)tenantDomain);
            Object value = tenantConfig.get((Object)"EnableAnonymous");
            if (value != null) {
                return Boolean.parseBoolean(value.toString());
            }
            return APIUtil.isDevPortalAnonymous();
        }
        catch (APIManagementException e) {
            log.error((Object)"Error while retrieving Anonymous config from registry", (Throwable)e);
            return true;
        }
    }
}

