/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtAuthorizationFailedException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.ApiTypeWrapper;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RestAPIStoreUtils {
    private static final Log log = LogFactory.getLog(RestAPIStoreUtils.class);
    private static boolean isStoreCacheEnabled;

    public static boolean isUserAccessAllowedForApplication(Application application) {
        if (application != null) {
            String userGroupId;
            String groupId = application.getGroupId();
            if (application.getSubscriber() != null && RestAPIStoreUtils.isUserOwnerOfApplication(application)) {
                return true;
            }
            if (!StringUtils.isEmpty((CharSequence)groupId) && (userGroupId = RestApiUtil.getLoggedInUserGroupId()) != null) {
                ArrayList<String> groupIdList = new ArrayList<String>(Arrays.asList(groupId.split(",")));
                for (String id : userGroupId.split(",")) {
                    if (!groupIdList.contains(id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isUserOwnerOfApplication(Application application) {
        String username = RestApiCommonUtil.getLoggedInUsername();
        if (application.getSubscriber().getName().equals(username)) {
            return true;
        }
        if (application.getSubscriber().getName().toLowerCase().equals(username.toLowerCase())) {
            APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String comparisonConfig = configuration.getFirstProperty("APIStore.CompareCaseInsensitively");
            return StringUtils.isNotEmpty((CharSequence)comparisonConfig) && Boolean.valueOf(comparisonConfig) != false;
        }
        return false;
    }

    public static boolean isUserAccessAllowedForSubscription(SubscribedAPI subscribedAPI) throws APIManagementException {
        String username = RestApiCommonUtil.getLoggedInUsername();
        Application application = subscribedAPI.getApplication();
        APIIdentifier apiIdentifier = subscribedAPI.getApiId();
        APIProductIdentifier productIdentifier = subscribedAPI.getProductId();
        if (apiIdentifier != null && application != null) {
            try {
                if (!RestAPIStoreUtils.isUserAccessAllowedForAPI(apiIdentifier)) {
                    return false;
                }
            }
            catch (APIManagementException e) {
                String message = "Failed to retrieve the API " + apiIdentifier.toString() + " to check user " + username + " has access to the subscription " + subscribedAPI.getUUID();
                throw new APIManagementException(message, (Throwable)e);
            }
            if (RestAPIStoreUtils.isUserAccessAllowedForApplication(application)) {
                return true;
            }
        }
        if (productIdentifier != null && application != null) {
            APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
            APIProduct product = apiConsumer.getAPIProduct(productIdentifier);
            if (!RestAPIStoreUtils.isUserAllowedForSubscription(product, username) || !RestAPIStoreUtils.isUserAccessAllowedForAPIProduct(product)) {
                return false;
            }
            if (RestAPIStoreUtils.isUserAccessAllowedForApplication(application)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUserAccessAllowedForAPIByUUID(String apiId, String tenantDomain) throws APIManagementException {
        String username = RestApiCommonUtil.getLoggedInUsername();
        APIConsumer consumer = RestApiCommonUtil.getLoggedInUserConsumer();
        try {
            consumer.getLightweightAPIByUUID(apiId, tenantDomain);
        }
        catch (APIManagementException e) {
            if (RestApiUtil.isDueToAuthorizationFailure(e)) {
                String message = "user " + username + " failed to access the API " + apiId + " due to an authorization failure";
                log.info((Object)message);
                return false;
            }
            String message = "Failed to retrieve the API " + apiId + " to check user " + username + " has access to the API";
            throw new APIManagementException(message, (Throwable)e);
        }
        return true;
    }

    public static boolean isUserAccessAllowedForAPI(APIIdentifier apiId) throws APIManagementException {
        String username = RestApiCommonUtil.getLoggedInUsername();
        try {
            APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)apiId.getProviderName()));
            apiConsumer.getLightweightAPIByUUID(apiId.getUUID(), tenantDomain);
        }
        catch (APIManagementException e) {
            if (RestApiUtil.isDueToAuthorizationFailure(e)) {
                String message = "user " + username + " failed to access the API " + apiId + " due to an authorization failure";
                log.info((Object)message);
                return false;
            }
            String message = "Failed to retrieve the API " + apiId + " to check user " + username + " has access to the API";
            throw new APIManagementException(message, (Throwable)e);
        }
        return true;
    }

    public static void checkSubscriptionAllowed(ApiTypeWrapper apiTypeWrapper, String tier) throws APIManagementException {
        String subscriptionAllowedTenants;
        String subscriptionAvailability;
        Set tiers;
        String providerName;
        String username = RestApiCommonUtil.getLoggedInUsername();
        String userTenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        APIConsumer apiConsumer = APIManagerFactory.getInstance().getAPIConsumer(username);
        if (apiTypeWrapper.isAPIProduct()) {
            APIProduct product = apiTypeWrapper.getApiProduct();
            providerName = product.getId().getProviderName();
            tiers = product.getAvailableTiers();
            subscriptionAvailability = product.getSubscriptionAvailability();
            subscriptionAllowedTenants = product.getSubscriptionAvailableTenants();
        } else {
            API api = apiTypeWrapper.getApi();
            providerName = api.getId().getProviderName();
            String apiSecurity = api.getApiSecurity();
            if (apiSecurity != null && !apiSecurity.contains("oauth2") && !apiSecurity.contains("api_key")) {
                String msg = "Subscription is not allowed for API " + apiTypeWrapper.toString() + ". To access the API, please use the client certificate";
                throw new APIMgtAuthorizationFailedException(msg);
            }
            tiers = api.getAvailableTiers();
            subscriptionAvailability = api.getSubscriptionAvailability();
            subscriptionAllowedTenants = api.getSubscriptionAvailableTenants();
        }
        String apiTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)providerName));
        boolean subscriptionAllowed = false;
        if (!userTenantDomain.equals(apiTenantDomain)) {
            if ("all_tenants".equals(subscriptionAvailability)) {
                subscriptionAllowed = true;
            } else if ("specific_tenants".equals(subscriptionAvailability) && subscriptionAllowedTenants != null) {
                String[] allowedTenants;
                for (String tenant : allowedTenants = subscriptionAllowedTenants.split(",")) {
                    if (tenant == null || !userTenantDomain.equals(tenant.trim())) continue;
                    subscriptionAllowed = true;
                    break;
                }
            }
        } else {
            subscriptionAllowed = true;
        }
        if (!subscriptionAllowed) {
            throw new APIMgtAuthorizationFailedException("Subscription is not allowed for " + userTenantDomain);
        }
        Iterator iterator = tiers.iterator();
        boolean isTierAllowed = false;
        ArrayList<String> allowedTierList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Tier t = (Tier)iterator.next();
            if (t.getName() != null && t.getName().equals(tier)) {
                isTierAllowed = true;
            }
            allowedTierList.add(t.getName());
        }
        if (!isTierAllowed) {
            String msg = "Tier " + tier + " is not allowed for API/API Product " + apiTypeWrapper.toString() + ". Only " + Arrays.toString(allowedTierList.toArray()) + " Tiers are allowed.";
            throw new APIMgtAuthorizationFailedException(msg);
        }
        if (apiConsumer.isTierDeneid(tier)) {
            throw new APIMgtAuthorizationFailedException("Tier " + tier + " is not allowed for user " + username);
        }
    }

    public static APIIdentifier getAPIIdentifierFromUUID(String apiId, String requestedTenantDomain) throws APIManagementException {
        APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
        API api = apiConsumer.getLightweightAPIByUUID(apiId, requestedTenantDomain);
        return api.getId();
    }

    public static Map<String, String> validateApplicationAttributes(Map<String, String> applicationAttributes, Set keys) {
        Iterator<String> iterator = applicationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (keys.contains(key)) continue;
            iterator.remove();
            applicationAttributes.remove(key);
        }
        return applicationAttributes;
    }

    public static Set<String> getApplicationAttributeKeys() throws APIManagementException {
        HashSet<String> keySet = new HashSet<String>();
        String username = RestApiCommonUtil.getLoggedInUsername();
        APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
        JSONArray attributeKeysFromConfig = apiConsumer.getAppAttributesFromConfig(username);
        for (Object object : attributeKeysFromConfig) {
            JSONObject jsonObject = (JSONObject)object;
            String key = (String)jsonObject.get((Object)"Attribute");
            keySet.add(key);
        }
        return keySet;
    }

    public static Set<String> getValidApplicationAttributeKeys(Map<String, String> applicationAttributes) throws APIManagementException {
        String username = RestApiCommonUtil.getLoggedInUsername();
        APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
        JSONArray attributeKeysFromConfig = apiConsumer.getAppAttributesFromConfig(username);
        HashSet<String> keySet = new HashSet<String>();
        Set<String> attributeKeysFromUSer = applicationAttributes.keySet();
        for (Object object : attributeKeysFromConfig) {
            JSONObject jsonObject = (JSONObject)object;
            Boolean isRequired = false;
            if (jsonObject.get((Object)"Required") != null) {
                isRequired = (Boolean)jsonObject.get((Object)"Required");
            }
            String key = (String)jsonObject.get((Object)"Attribute");
            if (isRequired.booleanValue() && !attributeKeysFromUSer.contains(key)) {
                RestApiUtil.handleBadRequest(key + " should be specified", log);
            }
            keySet.add(key);
        }
        return keySet;
    }

    public static boolean isUserAccessAllowedForAPIProduct(APIProduct product) throws APIManagementException {
        String username = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (log.isDebugEnabled()) {
            log.debug((Object)("isUserAccessAllowedForAPIProduct():- productId: " + product.getUuid() + ", visibility: " + product.getVisibility() + " username:" + username + " tenantDomain:" + tenantDomain));
        }
        if ("public".equals(product.getVisibility())) {
            return true;
        }
        return "restricted".equals(product.getVisibility()) ? APIUtil.isRoleExistForUser((String)username, (String)product.getVisibleRoles()) && tenantDomain.equals(product.getTenantDomain()) : "private".equals(product.getVisibility()) && tenantDomain.equals(product.getTenantDomain()) && !"wso2.anonymous.user".equals(username);
    }

    public static boolean isUserAllowedForSubscription(APIProduct product, String user) {
        String subscriptionAvailability = product.getSubscriptionAvailability();
        String subscriptionAllowedTenants = product.getSubscriptionAvailableTenants();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (log.isDebugEnabled()) {
            log.debug((Object)("isUserAllowedForSubscription():- productId: " + product.getUuid() + ", subscriptionAvailability: " + subscriptionAvailability + " subscriptionAllowedTenants: " + subscriptionAllowedTenants + " username:" + user + " tenantDomain:" + tenantDomain));
        }
        boolean subscriptionAllowed = false;
        if (!tenantDomain.equals(product.getTenantDomain())) {
            if ("all_tenants".equals(subscriptionAvailability)) {
                subscriptionAllowed = true;
            } else if ("specific_tenants".equals(subscriptionAvailability) && subscriptionAllowedTenants != null) {
                String[] allowedTenants;
                for (String tenant : allowedTenants = subscriptionAllowedTenants.split(",")) {
                    if (tenant == null || !tenantDomain.equals(tenant.trim())) continue;
                    subscriptionAllowed = true;
                    break;
                }
            }
        } else {
            subscriptionAllowed = true;
        }
        return subscriptionAllowed;
    }

    static {
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String isStoreCacheEnabledConfiguration = apiManagerConfiguration.getFirstProperty("CacheConfigurations.EnableScopeCache");
        isStoreCacheEnabled = isStoreCacheEnabledConfiguration != null && Boolean.parseBoolean(isStoreCacheEnabledConfiguration);
    }
}

