/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.utils;

import java.io.File;
import java.rmi.RemoteException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.rest.api.util.utils.EntitlementClientUtils;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceException;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;
import org.wso2.carbon.utils.CarbonUtils;

public class EntitlementServiceClient {
    EntitlementServiceStub entitlementServiceStub;
    private static final Log logger = LogFactory.getLog(EntitlementServiceClient.class);

    public EntitlementServiceClient() throws Exception {
        try {
            String repositoryBasePath = CarbonUtils.getCarbonHome() + File.separator + "repository";
            String clientRepo = repositoryBasePath + File.separator + "deployment" + File.separator + "client";
            String clientAxisConf = repositoryBasePath + File.separator + "conf" + File.separator + "axis2" + File.separator + "axis2_client.xml";
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)clientRepo, (String)clientAxisConf);
            String serviceEndPoint = EntitlementClientUtils.getServerUrl() + "EntitlementService";
            this.entitlementServiceStub = new EntitlementServiceStub(configContext, serviceEndPoint);
            ServiceClient client = this.entitlementServiceStub._getServiceClient();
            Options option = client.getOptions();
            option.setProperty("Cookie", null);
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            auth.setUsername(EntitlementClientUtils.getServerUsername());
            auth.setPassword(EntitlementClientUtils.getServerPassword());
            auth.setPreemptiveAuthentication(true);
            option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
            option.setManageSession(true);
        }
        catch (Exception e) {
            logger.error((Object)"Error while initiating entitlement service client ", (Throwable)e);
        }
    }

    public String validateAction(String subject, String resource, String action, String[] environment) {
        String decision = "DENY";
        try {
            decision = this.entitlementServiceStub.getDecisionByAttributes(subject, resource, action, environment);
            System.out.println("\nXACML Decision is received : " + decision);
            String authCookie = (String)this.entitlementServiceStub._getServiceClient().getServiceContext().getProperty("Cookie");
            System.out.println("\nCookie is received for subsequent communication :  " + authCookie);
        }
        catch (RemoteException e) {
            logger.error((Object)"Error while connecting PDP ", (Throwable)e);
        }
        catch (EntitlementServiceException e) {
            logger.error((Object)"Error while validating XACML policy for given request ", (Throwable)e);
        }
        return decision;
    }
}

