/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;

public class EntitlementClientUtils {
    private static Properties configProperties;
    private static final Log logger;

    public static String getServerUrl() {
        return configProperties != null && configProperties.getProperty("server_url") != null ? configProperties.getProperty("server_url") : "https://localhost:9444/services/";
    }

    public static String getServerUsername() {
        return configProperties != null && configProperties.getProperty("username") != null ? configProperties.getProperty("username") : "admin";
    }

    public static String getServerPassword() {
        String ret;
        if (configProperties != null && (ret = configProperties.getProperty("password")) != null) {
            return ret;
        }
        return "admin";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadConfigProperties() throws APIManagementException {
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            File file = new File(new File(".").getCanonicalPath() + File.separator + "resources" + File.separator + "config.properties");
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else {
                String msg = "File does not exist : config.properties";
                logger.error((Object)msg);
            }
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                    configProperties = properties;
                }
            }
            catch (IOException e) {
                String msg = "Error loading properties from config.properties file";
                logger.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            try {
                String msg = "File can not be found : config.properties";
                logger.error((Object)msg, (Throwable)e);
                throw new APIManagementException(msg, (Throwable)e);
                catch (IOException e2) {
                    msg = "Can not create the canonical file path for given file : config.properties";
                    logger.error((Object)msg, (Throwable)e2);
                    throw new APIManagementException(msg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    static {
        logger = LogFactory.getLog(EntitlementClientUtils.class);
    }
}

