/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ETagGenerator {
    private static final Log log = LogFactory.getLog(ETagGenerator.class);

    private static String getETag(long updatedTimeInMillis) {
        String eTagValue = null;
        try {
            eTagValue = ETagGenerator.getHash(updatedTimeInMillis);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Failed to generate E-Tag due to " + e.getMessage()), (Throwable)e);
        }
        return eTagValue;
    }

    private static String getHash(long updatedTimeInMillis, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(String.valueOf(updatedTimeInMillis).getBytes());
        byte[] digest = messageDigest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aDigest : digest) {
            sb.append(Integer.toString((aDigest & 0xFF) + 256, 16).substring(1));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ETag generated in HEX :: " + sb.toString()));
        }
        return sb.toString();
    }

    private static String getHash(long updatedTimeInMillis) throws NoSuchAlgorithmException {
        return ETagGenerator.getHash(updatedTimeInMillis, "MD5");
    }

    public static String getETag(String lastUpdatedTimeInMillis) {
        try {
            return ETagGenerator.getETag(Long.parseLong(lastUpdatedTimeInMillis));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error in ETagGenerator due to " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

