/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.validation;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.util.exception.ConstraintViolationException;

public class ValidationInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Validator validator = null;

    public ValidationInInterceptor() {
        super("pre-invoke");
        ValidatorFactory defaultFactory = Validation.buildDefaultValidatorFactory();
        this.validator = defaultFactory.getValidator();
        if (this.validator == null) {
            this.log.warn((Object)"Bean Validation provider could not be found, no validation will be performed");
        } else {
            this.log.debug((Object)"Validation In-Interceptor initialized successfully");
        }
    }

    public void handleMessage(Message message) {
        OperationResourceInfo operationResource = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
        if (operationResource == null) {
            this.log.info((Object)"OperationResourceInfo is not available, skipping validation");
            return;
        }
        ClassResourceInfo classResource = operationResource.getClassResourceInfo();
        if (classResource == null) {
            this.log.info((Object)"ClassResourceInfo is not available, skipping validation");
            return;
        }
        ResourceProvider resourceProvider = classResource.getResourceProvider();
        if (resourceProvider == null) {
            this.log.info((Object)"ResourceProvider is not available, skipping validation");
            return;
        }
        MessageContentsList arguments = MessageContentsList.getContentsList((Message)message);
        Method method = operationResource.getAnnotatedMethod();
        Object instance = resourceProvider.getInstance(message);
        if (method != null && arguments != null) {
            this.validate(method, arguments.toArray(), instance);
            for (Object arg : arguments) {
                if (arg == null) continue;
                this.validate(arg);
            }
        }
    }

    public <T> void validate(Method method, Object[] arguments, T instance) {
        if (this.validator == null) {
            this.log.warn((Object)"Bean Validation provider could not be found, no validation will be performed");
            return;
        }
        ExecutableValidator methodValidator = this.validator.forExecutables();
        Set violations = methodValidator.validateParameters(instance, method, arguments, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public <T> void validate(T object) {
        if (this.validator == null) {
            this.log.warn((Object)"Bean Validation provider could be found, no validation will be performed");
            return;
        }
        Set violations = this.validator.validate(object, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public void handleFault(Message messageParam) {
    }
}

