/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.eTag;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class ETagOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Log log = LogFactory.getLog(ETagOutInterceptor.class);
    private static final String ETAG = "ETag";

    public ETagOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        if (RestApiUtil.checkETagSkipList(message.getExchange().getInMessage().get((Object)Message.PATH_INFO).toString(), message.getExchange().getInMessage().get((Object)"org.apache.cxf.request.method").toString()).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping ETagOutInterceptor for URI : " + message.getExchange().getInMessage().get((Object)Message.PATH_INFO).toString()));
            }
            return;
        }
        MetadataMap headers = (MetadataMap)message.get((Object)Message.PROTOCOL_HEADERS);
        if (headers == null) {
            headers = new MetadataMap();
        }
        if (message.getExchange().containsKey((Object)ETAG)) {
            String eTag = (String)message.getExchange().get((Object)ETAG);
            this.setOutBoundHeaders(message, (MultivaluedMap<String, Object>)headers, eTag);
        }
    }

    private void setOutBoundHeaders(Message message, MultivaluedMap<String, Object> headers, String eTag) {
        headers.add((Object)ETAG, (Object)("\"" + eTag + "\""));
        message.put((Object)Message.PROTOCOL_HEADERS, headers);
    }
}

