/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.eTag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.util.utils.ETagGenerator;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class ETagInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Log log = LogFactory.getLog(ETagInInterceptor.class);

    public ETagInInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        block8: {
            if (RestApiUtil.checkETagSkipList(message.get((Object)Message.PATH_INFO).toString(), message.get((Object)"org.apache.cxf.request.method").toString()).booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping ETagInInterceptor for URI : " + message.get((Object)Message.PATH_INFO).toString()));
                }
                return;
            }
            OperationResourceInfo operationResource = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
            Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
            MessageContentsList arguments = MessageContentsList.getContentsList((Message)message);
            try {
                Class<?> aClass = Class.forName(operationResource.getMethodToInvoke().getDeclaringClass().getName());
                Method aClassMethod = aClass.getMethod(operationResource.getMethodToInvoke().getName() + "GetLastUpdatedTime", operationResource.getMethodToInvoke().getParameterTypes());
                Object o = aClass.newInstance();
                String lastUpdatedTime = String.valueOf(aClassMethod.invoke(o, arguments.toArray()));
                if (message.get((Object)"org.apache.cxf.request.method").equals("GET") && !Objects.equals(lastUpdatedTime, "null")) {
                    String headerValue;
                    String eTag = ETagGenerator.getETag(lastUpdatedTime);
                    if (headers.containsKey("If-None-Match") && Objects.equals(eTag, headerValue = (String)((List)headers.get("If-None-Match")).get(0))) {
                        Response response = Response.notModified((String)eTag).build();
                        message.getExchange().put(Response.class, (Object)response);
                        return;
                    }
                    message.getExchange().put((Object)"ETag", (Object)eTag);
                }
                if (("PUT".equals(message.get((Object)"org.apache.cxf.request.method")) || "DELETE".equals(message.get((Object)"org.apache.cxf.request.method"))) && headers.containsKey("If-Match")) {
                    String eTag;
                    String ifMatchHeaderValue = String.valueOf(((List)headers.get("If-Match")).get(0));
                    if (!Objects.equals(lastUpdatedTime, "null") && !Objects.equals(ifMatchHeaderValue, eTag = ETagGenerator.getETag(lastUpdatedTime))) {
                        Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                        message.getExchange().put(Response.class, (Object)response);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)(" Error while retrieving the ETag Resource timestamps due to " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

