/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.auth;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.util.utils.EntitlementServiceClient;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

@Deprecated
public class XACMLAuthenticationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log logger = LogFactory.getLog(XACMLAuthenticationInterceptor.class);

    public XACMLAuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message inMessage) {
        if (RestApiUtil.checkIfAnonymousAPI(inMessage)) {
            return;
        }
        this.handleRequest(inMessage, null);
    }

    public boolean handleRequest(Message message, ClassResourceInfo resourceInfo) {
        AuthorizationPolicy policy;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Authenticating request: " + message.getId(), new Object[0]));
        }
        if ((policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class)) == null) {
            logger.error((Object)"Authentication failed: Basic authentication header is missing");
            return false;
        }
        Object certObject = null;
        String username = StringUtils.trim((String)policy.getUserName());
        if (StringUtils.isEmpty((CharSequence)username)) {
            logger.error((Object)"Username cannot be null/empty.");
            return false;
        }
        return this.isUserPermitted(username, (String)message.get((Object)"org.apache.cxf.request.uri"), (String)message.get((Object)"org.apache.cxf.request.method"), null);
    }

    private boolean isUserPermitted(String userName, String resource, String httpMethod, String[] arr) {
        try {
            EntitlementServiceClient client = new EntitlementServiceClient();
            String status = client.validateAction(userName, resource, httpMethod, arr);
            if (status.equalsIgnoreCase("Permit")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while validating XACML request" + e));
        }
        return false;
    }
}

