/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.common.RestApiConstants;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class TokenMergeInterceptor
extends AbstractPhaseInterceptor {
    private static final Log logger = LogFactory.getLog(TokenMergeInterceptor.class);

    public TokenMergeInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        String accessToken = RestApiUtil.extractOAuthAccessTokenFromMessage(message, RestApiConstants.REGEX_BEARER_PATTERN, "Authorization");
        if (accessToken == null) {
            return;
        }
        ArrayList tokenCookie = (ArrayList)((TreeMap)message.get((Object)Message.PROTOCOL_HEADERS)).get("cookie");
        if (tokenCookie == null) {
            return;
        }
        String cookie = tokenCookie.get(0).toString();
        if (cookie == null) {
            return;
        }
        String[] cookies = (cookie = cookie.trim()).split(";");
        String tokenFromCookie = Arrays.stream(cookies).filter(name -> name.contains("AM_ACC_TOKEN_DEFAULT_P2")).findFirst().orElse("");
        String[] tokenParts = tokenFromCookie.split("=");
        if (tokenParts.length == 2) {
            accessToken = accessToken + tokenParts[1];
        }
        TreeMap headers = (TreeMap)message.get((Object)Message.PROTOCOL_HEADERS);
        ArrayList<String> authorizationHeader = new ArrayList<String>();
        authorizationHeader.add(0, String.format("Bearer %s", accessToken));
        headers.put("Authorization", authorizationHeader);
        message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
    }
}

