/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.auth;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.rest.api.common.RestApiConstants;
import org.wso2.carbon.apimgt.rest.api.util.authenticators.WebAppAuthenticator;
import org.wso2.carbon.apimgt.rest.api.util.impl.WebAppAuthenticatorImpl;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class OAuthAuthenticationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log logger = LogFactory.getLog(OAuthAuthenticationInterceptor.class);
    private static final String OAUTH_AUTHENTICATOR = "OAuth";
    private static final String REGEX_BEARER_PATTERN = "Bearer\\s";
    private static final Pattern PATTERN = Pattern.compile("Bearer\\s");
    private volatile WebAppAuthenticator authenticator;

    public OAuthAuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message inMessage) {
        if (RestApiUtil.checkIfAnonymousAPI(inMessage)) {
            return;
        }
        if (RestApiUtil.extractOAuthAccessTokenFromMessage(inMessage, RestApiConstants.REGEX_BEARER_PATTERN, "Authorization") == null) {
            return;
        }
        inMessage.put((Object)"request_authentication_scheme", (Object)"oauth2");
        if (this.handleRequest(inMessage, null)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"User logged into Web app using OAuth Authentication");
            }
        } else {
            throw new AuthenticationException("Unauthenticated request");
        }
    }

    public void initializeAuthenticator() throws APIManagementException {
        try {
            this.authenticator = new WebAppAuthenticatorImpl();
        }
        catch (Exception e) {
            throw new APIManagementException("Error while initializing authenticator of type: ", (Throwable)e);
        }
    }

    public boolean handleRequest(Message message, ClassResourceInfo resourceInfo) {
        if (this.authenticator == null) {
            try {
                this.initializeAuthenticator();
            }
            catch (APIManagementException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)" Initializing the authenticator resulted in an exception", (Throwable)e);
                } else {
                    logger.error((Object)e.getMessage());
                }
                return false;
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Authenticating request: " + message.getId(), new Object[0]));
            }
            if (this.authenticator.authenticate(message)) {
                return true;
            }
        }
        catch (APIManagementException e) {
            logger.error((Object)"Error while authenticating incoming request to API Manager REST API", (Throwable)e);
        }
        return false;
    }
}

