/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.RealmUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.uri.template.URITemplateException;

public class BasicAuthenticationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log log = LogFactory.getLog(BasicAuthenticationInterceptor.class);

    public BasicAuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message inMessage) {
        if (RestApiUtil.checkIfAnonymousAPI(inMessage)) {
            return;
        }
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        inMessage.put((Object)"LoggedInUserTenantDomain", (Object)tenantDomain);
        AuthorizationPolicy policy = (AuthorizationPolicy)inMessage.get(AuthorizationPolicy.class);
        if (policy != null) {
            inMessage.put((Object)"request_authentication_scheme", (Object)"basic_auth");
            String username = StringUtils.trim((String)policy.getUserName());
            String password = StringUtils.trim((String)policy.getPassword());
            if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                String errorMessage = StringUtils.isEmpty((CharSequence)username) ? "username cannot be null/empty." : "password cannot be null/empty.";
                log.error((Object)("Basic Authentication failed: " + errorMessage));
                throw new AuthenticationException("Unauthenticated request");
            }
            if (!this.authenticate(inMessage, username, password)) {
                throw new AuthenticationException("Unauthenticated request");
            }
            log.debug((Object)"User logged into web app using Basic Authentication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(Message inMessage, String username, String password) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            UserRealm userRealm = RealmUtil.getTenantUserRealm((int)tenantId);
            if (userRealm == null) {
                log.error((Object)"Authentication failed: invalid domain or unactivated tenant login");
                boolean bl = false;
                return bl;
            }
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            boolean isAuthenticated = userStoreManager.authenticate(MultitenantUtils.getTenantAwareUsername((String)username), (Object)password);
            if (isAuthenticated) {
                String domain = UserCoreUtil.getDomainFromThreadLocal();
                String domainAwareUserName = UserCoreUtil.addDomainToName((String)username, (String)domain);
                RestApiCommonUtil.setThreadLocalRequestedTenant((String)MultitenantUtils.getTenantAwareUsername((String)username));
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setTenantId(tenantId);
                carbonContext.setUsername(domainAwareUserName);
                if (!tenantDomain.equals("carbon.super")) {
                    APIUtil.loadTenantConfigBlockingMode((String)tenantDomain);
                }
                boolean bl = this.validateRoles(inMessage, userRealm, tenantDomain, username);
                return bl;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Error occurred while authenticating user: " + username), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return false;
    }

    private boolean validateRoles(Message inMessage, UserRealm userRealm, String tenantDomain, String username) {
        String basePath = (String)inMessage.get((Object)Message.BASE_PATH);
        String path = (String)inMessage.get((Object)"org.apache.cxf.request.uri");
        String verb = (String)inMessage.get((Object)"org.apache.cxf.request.method");
        String resource = path.substring(basePath.length() - 1);
        String version = (String)inMessage.get((Object)"API_VERSION");
        Set<URITemplate> uriTemplates = RestApiUtil.getURITemplatesForBasePath(basePath + version);
        if (uriTemplates.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No matching scopes found for request with path: " + basePath + version + ". Skipping role validation."));
            }
            return true;
        }
        for (Object template : uriTemplates.toArray()) {
            HashMap var = new HashMap();
            String templateString = ((URITemplate)template).getUriTemplate();
            try {
                org.wso2.uri.template.URITemplate templateToValidate = new org.wso2.uri.template.URITemplate(templateString);
                if (!templateToValidate.matches(resource, var) || verb == null || !verb.equalsIgnoreCase(((URITemplate)template).getHTTPVerb())) continue;
                List resourceScopeList = ((URITemplate)template).retrieveAllScopes();
                if (!resourceScopeList.isEmpty()) {
                    Map restAPIScopes = APIUtil.getRESTAPIScopesForTenant((String)tenantDomain);
                    if (restAPIScopes != null) {
                        String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(MultitenantUtils.getTenantAwareUsername((String)username));
                        if (userRoles != null) {
                            return this.validateUserRolesWithRESTAPIScopes(resourceScopeList, restAPIScopes, userRoles, username, path, verb, inMessage);
                        }
                        log.error((Object)("Error while validating roles. Invalid user roles found for user: " + username));
                        return false;
                    }
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scope not defined in swagger for matching resource " + resource + " and verb " + verb + ". So consider as anonymous permission and let request to continue."));
                }
                return true;
            }
            catch (URITemplateException e) {
                log.error((Object)("Error while creating URI Template object to validate request. Template pattern: " + templateString), (Throwable)e);
            }
            catch (UserStoreException e) {
                log.error((Object)("Error while getting role list of user: " + username), (Throwable)e);
            }
        }
        log.error((Object)("Error while validating roles. No matching resource URI template found in swagger for resource " + resource + " and verb " + verb));
        return false;
    }

    private boolean validateUserRolesWithRESTAPIScopes(List<Scope> resourceScopeList, Map<String, String> restAPIScopes, String[] userRoles, String username, String path, String verb, Message inMessage) {
        ArrayList<Scope> validatedUserScopes = new ArrayList<Scope>();
        block0: for (Scope scope2 : resourceScopeList) {
            String resourceRolesString = restAPIScopes.get(scope2.getKey());
            if (StringUtils.isNotBlank((CharSequence)resourceRolesString)) {
                List<String> resourceRoleList = Arrays.asList(resourceRolesString.split("\\s*,\\s*"));
                for (String role : userRoles) {
                    if (!resourceRoleList.contains(role)) continue;
                    validatedUserScopes.add(scope2);
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)("Basic Authentication: role validation successful for user: " + username + " with scope: " + scope2.getKey() + " for resource path: " + path + " and verb " + verb));
                    log.debug((Object)("Added scope: " + scope2.getKey() + " to validated user scope list"));
                    continue block0;
                }
                continue;
            }
            validatedUserScopes.add(scope2);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Role validation skipped. No REST API scope to role mapping defined for resource scope: " + scope2.getKey() + " Treated as anonymous scope."));
        }
        ArrayList scopes = new ArrayList();
        validatedUserScopes.forEach(scope -> scopes.add(scope.getKey()));
        inMessage.getExchange().put((Object)"user_rest_api_scopes", (Object)scopes.toArray(new String[0]));
        if (!validatedUserScopes.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully validated REST API Scopes for the user " + username));
            }
            return true;
        }
        log.error((Object)("Insufficient privileges. Role validation failed for user: " + username + " to access resource path: " + path + " and verb " + verb));
        return false;
    }
}

