/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors;

import java.util.Arrays;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class SubscriberRegistrationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log logger = LogFactory.getLog(SubscriberRegistrationInterceptor.class);
    private static final String LOCK_POSTFIX = "_SubscriberRegistration";

    public SubscriberRegistrationInterceptor() {
        super("pre-invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        block13: {
            String username = RestApiCommonUtil.getLoggedInUsername();
            if (username.equalsIgnoreCase("wso2.anonymous.user")) {
                return;
            }
            Cache subscriberCache = Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache("subscriberCache");
            if (subscriberCache.get((Object)username) != null) {
                return;
            }
            String groupId = RestApiUtil.getLoggedInUserGroupId();
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            try {
                APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
                Subscriber subscriber = apiConsumer.getSubscriber(username);
                if (subscriber == null) {
                    String string = (username + LOCK_POSTFIX).intern();
                    synchronized (string) {
                        subscriber = apiConsumer.getSubscriber(username);
                        if (subscriber == null) {
                            message.getExchange().get((Object)"user_rest_api_scopes");
                            if (!this.hasSubscribeScope(message)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("User " + username + " does not have subscribe scope (" + "apim:subscribe" + ")"));
                                }
                                return;
                            }
                            if (!"carbon.super".equalsIgnoreCase(tenantDomain)) {
                                this.loadTenantRegistry();
                            }
                            apiConsumer.addSubscriber(username, groupId);
                            subscriberCache.put((Object)username, (Object)new Subscriber(username));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Subscriber " + username + " added to AM_SUBSCRIBER database"));
                            }
                        }
                        break block13;
                    }
                }
                subscriberCache.put((Object)username, (Object)subscriber);
            }
            catch (APIManagementException e) {
                RestApiUtil.handleInternalServerError("Unable to add the subscriber " + username, e, logger);
            }
        }
    }

    private void loadTenantRegistry() throws APIManagementException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            APIUtil.loadTenantRegistry((int)tenantId);
            APIUtil.loadTenantAPIPolicy((String)tenantDomain, (int)tenantId);
            APIUtil.loadTenantExternalStoreConfig((int)tenantId);
            APIUtil.loadTenantWorkFlowExtensions((int)tenantId);
            APIUtil.loadTenantSelfSignUpConfigurations((int)tenantId);
            APIUtil.loadTenantConf((int)tenantId);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error occured while loading registry for tenant '" + tenantDomain + "'");
        }
    }

    private boolean hasSubscribeScope(Message message) {
        String[] scopes = (String[])message.getExchange().get((Object)"user_rest_api_scopes");
        if (scopes != null && scopes.length > 0) {
            return Arrays.asList(scopes).contains("apim:subscribe");
        }
        return false;
    }
}

