/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.uri.template.URITemplate;

public class PreAuthenticationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log logger = LogFactory.getLog(PreAuthenticationInterceptor.class);

    public PreAuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        String path = (String)message.get((Object)Message.PATH_INFO);
        if (path.contains("v0.17")) {
            path = path.replace("/v0.17", "");
        }
        String httpMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        ArrayList authHeaders = (ArrayList)((TreeMap)message.get((Object)Message.PROTOCOL_HEADERS)).get("Authorization");
        if (authHeaders != null) {
            return;
        }
        try {
            Dictionary<URITemplate, List<String>> allowedResourcePathsMap = RestApiUtil.getAllowedURIsToMethodsMap();
            Enumeration<URITemplate> uriTemplateSet = allowedResourcePathsMap.keys();
            ArrayList requestedTenantDomain = (ArrayList)((TreeMap)message.get((Object)Message.PROTOCOL_HEADERS)).get("x-wso2-tenant");
            String tenantDomain = null;
            if (requestedTenantDomain != null) {
                tenantDomain = RestApiUtil.getRequestedTenantDomain(requestedTenantDomain.get(0).toString());
            }
            if (StringUtils.isEmpty(tenantDomain)) {
                tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            }
            while (uriTemplateSet.hasMoreElements()) {
                List<String> allowedVerbs;
                URITemplate uriTemplate = uriTemplateSet.nextElement();
                if (!uriTemplate.matches(path, new HashMap()) || !(allowedVerbs = allowedResourcePathsMap.get(uriTemplate)).contains(httpMethod)) continue;
                if (StringUtils.startsWith((CharSequence)((String)message.get((Object)Message.BASE_PATH)), (CharSequence)"/api/am/devportal")) {
                    boolean doSkipAuthentication;
                    boolean bl = doSkipAuthentication = StringUtils.equals((CharSequence)path, (CharSequence)"/api/am/devportal/swagger.yaml") || StringUtils.equals((CharSequence)path, (CharSequence)"/api/am/devportal/settings") || StringUtils.equals((CharSequence)path, (CharSequence)"/api/am/devportal/tenants");
                    if (!doSkipAuthentication) {
                        message.put((Object)"authentication_required", (Object)(!RestApiUtil.isDevPortalAnonymousEnabled(tenantDomain) ? 1 : 0));
                    } else {
                        message.put((Object)"authentication_required", (Object)false);
                    }
                } else {
                    message.put((Object)"authentication_required", (Object)false);
                }
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setUsername("wso2.anonymous.user");
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                return;
            }
        }
        catch (APIManagementException e) {
            RestApiUtil.handleInternalServerError("Unable to retrieve/process allowed URIs for REST API", e, logger);
        }
    }
}

