/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.interceptors;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class PostAuthenticationInterceptor
extends AbstractPhaseInterceptor {
    private static final Log log = LogFactory.getLog(PostAuthenticationInterceptor.class);

    public PostAuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message inMessage) {
        if (RestApiUtil.checkIfAnonymousAPI(inMessage)) {
            return;
        }
        String authScheme = (String)inMessage.get((Object)"request_authentication_scheme");
        if (!StringUtils.equals((String)authScheme, (String)"oauth2") && !StringUtils.equals((String)authScheme, (String)"basic_auth")) {
            log.error((Object)"Authentication failed: Bearer/Basic authentication header is missing");
            throw new AuthenticationException("Unauthenticated request");
        }
    }
}

