/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.RESTAPICacheConfiguration;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiConstants;
import org.wso2.carbon.apimgt.rest.api.util.authenticators.WebAppAuthenticator;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.oauth2.OAuth2TokenValidationService;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientApplicationDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.uri.template.URITemplateException;

public class WebAppAuthenticatorImpl
implements WebAppAuthenticator {
    private static final Log log = LogFactory.getLog(WebAppAuthenticatorImpl.class);
    private static final String SUPER_TENANT_SUFFIX = "@carbon.super";

    @Override
    public boolean authenticate(Message message) throws APIManagementException {
        boolean retrievedFromInvalidTokenCache = false;
        boolean retrievedFromTokenCache = false;
        String accessToken = RestApiUtil.extractOAuthAccessTokenFromMessage(message, RestApiConstants.REGEX_BEARER_PATTERN, "Authorization");
        AccessTokenInfo tokenInfo = null;
        RESTAPICacheConfiguration cacheConfiguration = APIUtil.getRESTAPICacheConfig();
        if (cacheConfiguration.isTokenCacheEnabled()) {
            tokenInfo = (AccessTokenInfo)this.getRESTAPITokenCache().get((Object)accessToken);
            if (tokenInfo != null) {
                if (this.isAccessTokenExpired(tokenInfo)) {
                    tokenInfo.setTokenValid(false);
                    this.getRESTAPIInvalidTokenCache().put((Object)accessToken, (Object)tokenInfo);
                    this.getRESTAPITokenCache().remove((Object)accessToken);
                    log.error((Object)"Access token is expired");
                    return false;
                }
                retrievedFromTokenCache = true;
            } else {
                tokenInfo = (AccessTokenInfo)this.getRESTAPIInvalidTokenCache().get((Object)accessToken);
                if (tokenInfo != null) {
                    retrievedFromInvalidTokenCache = true;
                }
            }
        }
        try {
            if (tokenInfo == null) {
                tokenInfo = this.getTokenMetaData(accessToken);
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while retrieving token information for token: " + accessToken), (Throwable)e);
        }
        if (tokenInfo != null && tokenInfo.isTokenValid()) {
            if (cacheConfiguration.isTokenCacheEnabled() && !retrievedFromTokenCache) {
                this.getRESTAPITokenCache().put((Object)accessToken, (Object)tokenInfo);
            }
            if (this.validateScopes(message, tokenInfo)) {
                message.getExchange().put((Object)"user_rest_api_scopes", (Object)tokenInfo.getScopes());
                String tenantDomain = MultitenantUtils.getTenantDomain((String)tokenInfo.getEndUserName());
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                RealmService realmService = (RealmService)carbonContext.getOSGiService(RealmService.class, null);
                try {
                    String username = tokenInfo.getEndUserName();
                    if ("carbon.super".equals(tenantDomain)) {
                        long count = username.chars().filter(ch -> ch == 64).count();
                        boolean isEmailUsernameEnabled = Boolean.parseBoolean(CarbonUtils.getServerConfiguration().getFirstProperty("EnableEmailUserName"));
                        if (isEmailUsernameEnabled || username.endsWith(SUPER_TENANT_SUFFIX) && count <= 1L) {
                            username = MultitenantUtils.getTenantAwareUsername((String)username);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("username = " + username));
                    }
                    int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                    carbonContext.setTenantDomain(tenantDomain);
                    carbonContext.setTenantId(tenantId);
                    carbonContext.setUsername(username);
                    if (!tenantDomain.equals("carbon.super")) {
                        APIUtil.loadTenantConfigBlockingMode((String)tenantDomain);
                    }
                    return true;
                }
                catch (UserStoreException e) {
                    log.error((Object)("Error while retrieving tenant id for tenant domain: " + tenantDomain), (Throwable)e);
                }
            } else {
                log.error((Object)"You cannot access API as scope validation failed");
            }
        } else {
            log.error((Object)"Provided access token is invalid");
            if (cacheConfiguration.isTokenCacheEnabled() && !retrievedFromInvalidTokenCache) {
                this.getRESTAPIInvalidTokenCache().put((Object)accessToken, (Object)tokenInfo);
            }
        }
        return false;
    }

    private boolean validateScopes(Message message, AccessTokenInfo tokenInfo) {
        String basePath = (String)message.get((Object)Message.BASE_PATH);
        String path = (String)message.get((Object)"org.apache.cxf.request.uri");
        String verb = (String)message.get((Object)"org.apache.cxf.request.method");
        String resource = path.substring(basePath.length() - 1);
        String[] scopes = tokenInfo.getScopes();
        String version = (String)message.get((Object)"API_VERSION");
        Set<URITemplate> uriTemplates = RestApiUtil.getURITemplatesForBasePath(basePath + version);
        if (uriTemplates.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No matching scopes found for request with path: " + basePath + ". Skipping scope validation."));
            }
            return true;
        }
        for (Object template : uriTemplates.toArray()) {
            org.wso2.uri.template.URITemplate templateToValidate = null;
            HashMap var = new HashMap();
            String templateString = ((URITemplate)template).getUriTemplate();
            try {
                templateToValidate = new org.wso2.uri.template.URITemplate(templateString);
            }
            catch (URITemplateException e) {
                log.error((Object)("Error while creating URI Template object to validate request. Template pattern: " + templateString), (Throwable)e);
            }
            if (templateToValidate == null || !templateToValidate.matches(resource, var) || scopes == null || verb == null || !verb.equalsIgnoreCase(((URITemplate)template).getHTTPVerb())) continue;
            for (String scope : scopes) {
                Scope scp = ((URITemplate)template).getScope();
                if (scp != null) {
                    if (!scope.equalsIgnoreCase(scp.getKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scope validation successful for access token: " + tokenInfo.getAccessToken() + " with scope: " + scp.getKey() + " for resource path: " + path + " and verb " + verb));
                    }
                    return true;
                }
                if (!((URITemplate)template).retrieveAllScopes().isEmpty()) {
                    List scopesList = ((URITemplate)template).retrieveAllScopes();
                    for (Scope scpObj : scopesList) {
                        if (!scope.equalsIgnoreCase(scpObj.getKey())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Scope validation successful for access token: " + tokenInfo.getAccessToken() + " with scope: " + scpObj.getKey() + " for resource path: " + path + " and verb " + verb));
                        }
                        return true;
                    }
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scope not defined in swagger for matching resource " + resource + " and verb " + verb + " . So consider as anonymous permission and let request to continue."));
                }
                return true;
            }
        }
        return false;
    }

    private Cache getRESTAPITokenCache() {
        return CacheProvider.getRESTAPITokenCache();
    }

    private Cache getRESTAPIInvalidTokenCache() {
        return CacheProvider.getRESTAPIInvalidTokenCache();
    }

    private boolean isAccessTokenExpired(AccessTokenInfo accessTokenInfo) {
        APIKeyValidationInfoDTO infoDTO = new APIKeyValidationInfoDTO();
        infoDTO.setValidityPeriod(accessTokenInfo.getValidityPeriod());
        infoDTO.setIssuedTime(accessTokenInfo.getIssuedTime());
        return APIUtil.isAccessTokenExpired((APIKeyValidationInfoDTO)infoDTO);
    }

    public AccessTokenInfo getTokenMetaData(String accessToken) throws APIManagementException {
        AccessTokenInfo tokenInfo = new AccessTokenInfo();
        OAuth2TokenValidationRequestDTO requestDTO = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO.OAuth2AccessToken token = new OAuth2TokenValidationRequestDTO.OAuth2AccessToken(requestDTO);
        token.setIdentifier(accessToken);
        token.setTokenType("bearer");
        requestDTO.setAccessToken(token);
        OAuth2TokenValidationRequestDTO.TokenValidationContextParam[] contextParams = new OAuth2TokenValidationRequestDTO.TokenValidationContextParam[1];
        requestDTO.setContext(contextParams);
        OAuth2ClientApplicationDTO clientApplicationDTO = this.findOAuthConsumerIfTokenIsValid(requestDTO);
        OAuth2TokenValidationResponseDTO responseDTO = clientApplicationDTO.getAccessTokenValidationResponse();
        if (!responseDTO.isValid()) {
            tokenInfo.setTokenValid(responseDTO.isValid());
            log.error((Object)("Invalid OAuth Token : " + responseDTO.getErrorMsg()));
            tokenInfo.setErrorcode(900901);
            return tokenInfo;
        }
        tokenInfo.setTokenValid(responseDTO.isValid());
        tokenInfo.setEndUserName(responseDTO.getAuthorizedUser());
        tokenInfo.setConsumerKey(clientApplicationDTO.getConsumerKey());
        if (responseDTO.getExpiryTime() == Long.MAX_VALUE) {
            tokenInfo.setValidityPeriod(Long.MAX_VALUE);
        } else {
            tokenInfo.setValidityPeriod(responseDTO.getExpiryTime() * 1000L);
        }
        tokenInfo.setIssuedTime(System.currentTimeMillis());
        tokenInfo.setScope(responseDTO.getScope());
        String[] scopes = responseDTO.getScope();
        String applicationTokenScope = this.getConfigurationElementValue("OAuthConfigurations.ApplicationTokenScope");
        if (scopes != null && applicationTokenScope != null && !applicationTokenScope.isEmpty() && Arrays.asList(scopes).contains(applicationTokenScope)) {
            tokenInfo.setApplicationToken(true);
        }
        return tokenInfo;
    }

    protected OAuth2ClientApplicationDTO findOAuthConsumerIfTokenIsValid(OAuth2TokenValidationRequestDTO requestDTO) {
        OAuth2TokenValidationService oAuth2TokenValidationService = new OAuth2TokenValidationService();
        return oAuth2TokenValidationService.findOAuthConsumerIfTokenIsValid(requestDTO);
    }

    protected String getConfigurationElementValue(String property) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty(property);
    }
}

