/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.exception;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.EOFException;
import java.util.List;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.rest.api.common.dto.ErrorDTO;
import org.wso2.carbon.apimgt.rest.api.util.exception.BadRequestException;
import org.wso2.carbon.apimgt.rest.api.util.exception.ConflictException;
import org.wso2.carbon.apimgt.rest.api.util.exception.ConstraintViolationException;
import org.wso2.carbon.apimgt.rest.api.util.exception.ForbiddenException;
import org.wso2.carbon.apimgt.rest.api.util.exception.InternalServerErrorException;
import org.wso2.carbon.apimgt.rest.api.util.exception.MethodNotAllowedException;
import org.wso2.carbon.apimgt.rest.api.util.exception.NotFoundException;
import org.wso2.carbon.apimgt.rest.api.util.exception.PreconditionFailedException;
import org.wso2.carbon.apimgt.rest.api.util.utils.RestApiUtil;

public class GlobalThrowableMapper
implements ExceptionMapper<Throwable> {
    private static final Log log = LogFactory.getLog(GlobalThrowableMapper.class);
    private ErrorDTO e500 = new ErrorDTO();

    GlobalThrowableMapper() {
        this.e500.setCode(Long.valueOf(500L));
        this.e500.setMessage("Internal server error");
        this.e500.setMoreInfo("");
        this.e500.setDescription("The server encountered an internal error. Please contact administrator.");
    }

    public Response toResponse(Throwable e) {
        if (e instanceof ClientErrorException) {
            log.error((Object)"Client error", e);
            return ((ClientErrorException)e).getResponse();
        }
        if (e instanceof NotFoundException) {
            log.error((Object)"Resource not found", e);
            return ((NotFoundException)((Object)e)).getResponse();
        }
        if (e instanceof PreconditionFailedException) {
            log.error((Object)"Precondition failed", e);
            return ((PreconditionFailedException)((Object)e)).getResponse();
        }
        if (e instanceof BadRequestException) {
            log.error((Object)"Bad request", e);
            return ((BadRequestException)((Object)e)).getResponse();
        }
        if (e instanceof ConstraintViolationException) {
            log.error((Object)"Constraint violation", e);
            return ((ConstraintViolationException)((Object)e)).getResponse();
        }
        if (e instanceof ForbiddenException) {
            log.error((Object)"Resource forbidden", e);
            return ((ForbiddenException)((Object)e)).getResponse();
        }
        if (e instanceof ConflictException) {
            log.error((Object)"Conflict", e);
            return ((ConflictException)((Object)e)).getResponse();
        }
        if (e instanceof MethodNotAllowedException) {
            log.error((Object)"Method not allowed", e);
            return ((MethodNotAllowedException)((Object)e)).getResponse();
        }
        if (e instanceof InternalServerErrorException) {
            String errorMessage = "The server encountered an internal error : " + e.getMessage();
            log.error((Object)errorMessage, e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Content-Type", (Object)"application/json").entity((Object)this.e500).build();
        }
        if (e instanceof JsonParseException) {
            String errorMessage = "Malformed request body.";
            log.error((Object)errorMessage, e);
            return RestApiUtil.buildBadRequestException(errorMessage).getResponse();
        }
        if (e instanceof JsonMappingException) {
            if (e instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException unrecognizedPropertyException = (UnrecognizedPropertyException)e;
                String unrecognizedProperty = unrecognizedPropertyException.getPropertyName();
                String errorMessage = "Unrecognized property '" + unrecognizedProperty + "'";
                log.error((Object)errorMessage, e);
                return RestApiUtil.buildBadRequestException(errorMessage).getResponse();
            }
            String errorMessage = "One or more request body parameters contain disallowed values.";
            log.error((Object)errorMessage, e);
            return RestApiUtil.buildBadRequestException(errorMessage).getResponse();
        }
        if (e instanceof AuthenticationException) {
            ErrorDTO errorDetail = new ErrorDTO();
            errorDetail.setCode(Long.valueOf(401L));
            errorDetail.setMoreInfo("");
            errorDetail.setMessage("");
            errorDetail.setDescription(e.getMessage());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errorDetail).build();
        }
        if (e instanceof EOFException) {
            String errorMessage = "Request payload cannot be empty.";
            log.error((Object)errorMessage, e);
            return RestApiUtil.buildBadRequestException(errorMessage).getResponse();
        }
        if (e instanceof APIManagementException) {
            ErrorHandler selectedErrorHandler = null;
            List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
            for (Throwable t : throwableList) {
                APIManagementException apimException;
                ErrorHandler errorHandler;
                if (!(t instanceof APIManagementException) || (errorHandler = (apimException = (APIManagementException)t).getErrorHandler()) == null) continue;
                if (selectedErrorHandler == null) {
                    selectedErrorHandler = errorHandler;
                    continue;
                }
                selectedErrorHandler = errorHandler.getHttpStatusCode() < selectedErrorHandler.getHttpStatusCode() && errorHandler.getHttpStatusCode() > 0 ? errorHandler : selectedErrorHandler;
            }
            if (selectedErrorHandler != null) {
                if (selectedErrorHandler.printStackTrace()) {
                    log.error((Object)"A defined exception has been captured and mapped to an HTTP response by the global exception mapper ", e);
                } else {
                    log.error((Object)e.getMessage());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"A defined exception has been captured and mapped to an HTTP response by the global exception mapper ", e);
                    }
                }
                ErrorDTO errorDTO = RestApiUtil.getErrorDTO(selectedErrorHandler);
                return Response.status((Response.Status)Response.Status.fromStatusCode((int)selectedErrorHandler.getHttpStatusCode())).entity((Object)errorDTO).build();
            }
        }
        log.error((Object)"An unknown exception has been captured by the global exception mapper.", e);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("Content-Type", (Object)"application/json").entity((Object)this.e500).build();
    }
}

