/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.util.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.languages.StaticDocCodegen;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.util.DeserializationUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class DynamicHtmlGen
extends StaticDocCodegen {
    private Map<String, String> tagToSanitizedMap = new HashMap<String, String>();

    public String toApiName(String name) {
        if (this.tagToSanitizedMap.containsKey(name)) {
            return this.tagToSanitizedMap.get(name);
        }
        return name;
    }

    public String sanitizeTag(String tag) {
        String sanitizedTag = super.sanitizeTag(tag);
        this.tagToSanitizedMap.put(sanitizedTag, tag);
        return sanitizedTag;
    }

    public String toApiFilename(String name) {
        return this.sanitizeTag(name);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        op.summary = operation.getSummary();
        op.notes = operation.getDescription();
        String resourcesPath = new File(this.inputSpec).getParent();
        try {
            List scopes;
            List security;
            LinkedHashMap xExamples = (LinkedHashMap)operation.getVendorExtensions().get("x-examples");
            if (xExamples != null) {
                JsonNode exampleNode;
                String content;
                File exampleFile;
                ObjectMapper mapper = new ObjectMapper();
                String ref = (String)xExamples.get("$ref");
                String[] segments = ref.split("#/");
                if (segments.length >= 2) {
                    exampleFile = new File(resourcesPath + File.separator + segments[0]);
                    content = FileUtils.readFileToString((File)exampleFile);
                    JsonNode rootNode = DeserializationUtils.readYamlTree((String)content);
                    exampleNode = rootNode.get(segments[1]);
                    if (exampleNode == null) {
                        throw new RuntimeException("Could not find element '" + segments[1] + "' in " + exampleFile);
                    }
                } else {
                    exampleFile = new File(resourcesPath + File.separator + ref);
                    content = FileUtils.readFileToString((File)exampleFile);
                    exampleNode = DeserializationUtils.readYamlTree((String)content);
                }
                ArrayList result = (ArrayList)mapper.convertValue((Object)exampleNode, ArrayList.class);
                for (Object o : result) {
                    LinkedHashMap body;
                    StringBuilder builder;
                    LinkedHashMap example = (LinkedHashMap)o;
                    LinkedHashMap request = (LinkedHashMap)example.get("request");
                    LinkedHashMap response = (LinkedHashMap)example.get("response");
                    if (request != null) {
                        LinkedHashMap body2;
                        String headers;
                        builder = new StringBuilder();
                        String method = (String)request.get("method");
                        String url = (String)request.get("url");
                        builder.append(method);
                        builder.append(" ");
                        builder.append(url);
                        builder.append(" HTTP 1/1\n");
                        StringBuilder curlBuilder = new StringBuilder();
                        boolean hasNoCurl = false;
                        if (example.get("curl") == null) {
                            hasNoCurl = true;
                            curlBuilder.append("curl -k -v -X ");
                            curlBuilder.append(method);
                            curlBuilder.append(" '");
                            curlBuilder.append(url);
                            curlBuilder.append("' ");
                        }
                        if ((headers = (String)request.get("headers")) != null) {
                            builder.append(headers);
                            String[] headerArray = headers.split("\n");
                            if (hasNoCurl) {
                                for (String header : headerArray) {
                                    curlBuilder.append("-H '");
                                    curlBuilder.append(header);
                                    curlBuilder.append("' ");
                                }
                            }
                        }
                        if ((body2 = (LinkedHashMap)request.get("body")) != null) {
                            String jsonBody = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)body2);
                            builder.append("\n");
                            builder.append(jsonBody);
                            if (hasNoCurl) {
                                curlBuilder.append("-d @payload.json");
                            }
                        }
                        if (hasNoCurl) {
                            example.put("curl", curlBuilder.toString());
                        }
                        example.put("rawRequest", builder.toString());
                    }
                    if (response == null) continue;
                    builder = new StringBuilder();
                    builder.append("HTTP 1/1 ");
                    LinkedHashMap status = (LinkedHashMap)response.get("status");
                    builder.append(status.get("code"));
                    builder.append(" ");
                    builder.append(status.get("msg"));
                    builder.append("\n");
                    String headers = (String)response.get("headers");
                    if (headers != null) {
                        builder.append(headers);
                    }
                    if ((body = (LinkedHashMap)response.get("body")) != null) {
                        String jsonBody = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)body);
                        builder.append("\n");
                        builder.append(jsonBody);
                    }
                    example.put("rawResponse", builder.toString());
                }
                operation.getVendorExtensions().put("x-examples", result);
            }
            if ((security = operation.getSecurity()) != null && (scopes = (List)((Map)security.get(0)).get("OAuth2Security")).size() > 0) {
                operation.getVendorExtensions().put("x-scopes", scopes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading example file", e);
        }
        return op;
    }

    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(param, imports);
        parameter.description = param.getDescription();
        return parameter;
    }
}

