/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ganalytics.publisher;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.ganalytics.publisher.GoogleAnalyticsConstants;

public class GoogleAnalyticsDataPublisher {
    private static final Log log = LogFactory.getLog((String)GoogleAnalyticsDataPublisher.class.getName());

    public static boolean publishPOST(List<NameValuePair> payload, String userAgent, boolean useSSL) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(GoogleAnalyticsDataPublisher.getURI(useSSL));
        post.setHeader("User-Agent", userAgent);
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(payload));
            HttpResponse response = client.execute((HttpUriRequest)post);
            return response.getStatusLine().getStatusCode() == 200 && response.getFirstHeader("Content-Type").getValue().equals("image/gif");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean publishGET(String payload, String userAgent, boolean useSSL) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(GoogleAnalyticsDataPublisher.getURI(useSSL) + "?" + payload);
        get.setHeader("User-Agent", userAgent);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            return response.getStatusLine().getStatusCode() == 200 && response.getFirstHeader("Content-Type").getValue().equals("image/gif");
        }
        catch (ClientProtocolException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String buildPayloadString(Object o) {
        String queryString = "";
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            String fieldValue = GoogleAnalyticsDataPublisher.getFieldValue(fields[i], o);
            fields[i].setAccessible(false);
            if (fieldValue == null) continue;
            queryString = queryString + GoogleAnalyticsDataPublisher.encodeString(GoogleAnalyticsConstants.METHOD_TO_PARAM_MAP.get(fields[i].getName())) + "=" + GoogleAnalyticsDataPublisher.encodeString(fieldValue) + "&";
        }
        queryString = queryString.substring(0, queryString.length() - 1);
        return queryString;
    }

    public static List<NameValuePair> buildPayload(Object o) {
        ArrayList<NameValuePair> payload = new ArrayList<NameValuePair>();
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            String fieldValue = GoogleAnalyticsDataPublisher.getFieldValue(fields[i], o);
            fields[i].setAccessible(false);
            if (fieldValue == null) continue;
            BasicNameValuePair nvp = new BasicNameValuePair(GoogleAnalyticsConstants.METHOD_TO_PARAM_MAP.get(fields[i].getName()), fieldValue);
            payload.add((NameValuePair)nvp);
        }
        return payload;
    }

    private static String getFieldValue(Field f, Object o) {
        try {
            Object value = f.get(o);
            if (value instanceof String) {
                return (String)value;
            }
            if (value == null) {
                return null;
            }
            return String.valueOf(value);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Error while obtaining field value. " + e.getMessage()));
            return null;
        }
    }

    private static String encodeString(String queryString) {
        try {
            return URLEncoder.encode(queryString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Error while percent encoding analytics payload string. Using unencoded string. " + e.getMessage()));
            return queryString;
        }
    }

    private static String getURI(boolean useSSL) {
        if (useSSL) {
            return "https://ssl.google-analytics.com/collect";
        }
        return "http://www.google-analytics.com/collect";
    }
}

