/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.data.service.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.data.common.MetricAttribute;
import org.wso2.carbon.metrics.data.common.MetricType;
import org.wso2.carbon.metrics.data.service.dao.MetricDataProcessor;

public class ReporterDAO {
    private static final Logger logger = LoggerFactory.getLogger(ReporterDAO.class);
    private final DataSource dataSource;
    private final Map<MetricType, Set<MetricAttribute>> validMetricAttributeMap;

    public ReporterDAO(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Data source is null");
        }
        this.dataSource = dataSource;
        this.validMetricAttributeMap = new HashMap<MetricType, Set<MetricAttribute>>();
        this.populateValidMetricAttributeMap();
    }

    private void populateValidMetricAttributeMap() {
        HashSet<MetricAttribute> attributes = new HashSet<MetricAttribute>();
        attributes.add(MetricAttribute.VALUE);
        this.validMetricAttributeMap.put(MetricType.GAUGE, attributes);
        attributes = new HashSet();
        attributes.add(MetricAttribute.COUNT);
        this.validMetricAttributeMap.put(MetricType.COUNTER, attributes);
        attributes = new HashSet();
        attributes.add(MetricAttribute.COUNT);
        attributes.add(MetricAttribute.MEAN_RATE);
        attributes.add(MetricAttribute.M1_RATE);
        attributes.add(MetricAttribute.M5_RATE);
        attributes.add(MetricAttribute.M15_RATE);
        this.validMetricAttributeMap.put(MetricType.METER, attributes);
        attributes = new HashSet();
        attributes.add(MetricAttribute.COUNT);
        attributes.add(MetricAttribute.MAX);
        attributes.add(MetricAttribute.MEAN);
        attributes.add(MetricAttribute.MIN);
        attributes.add(MetricAttribute.STDDEV);
        attributes.add(MetricAttribute.P50);
        attributes.add(MetricAttribute.P75);
        attributes.add(MetricAttribute.P95);
        attributes.add(MetricAttribute.P98);
        attributes.add(MetricAttribute.P99);
        attributes.add(MetricAttribute.P999);
        this.validMetricAttributeMap.put(MetricType.HISTOGRAM, attributes);
        attributes = new HashSet();
        attributes.add(MetricAttribute.COUNT);
        attributes.add(MetricAttribute.MAX);
        attributes.add(MetricAttribute.MEAN);
        attributes.add(MetricAttribute.MIN);
        attributes.add(MetricAttribute.STDDEV);
        attributes.add(MetricAttribute.P50);
        attributes.add(MetricAttribute.P75);
        attributes.add(MetricAttribute.P95);
        attributes.add(MetricAttribute.P98);
        attributes.add(MetricAttribute.P99);
        attributes.add(MetricAttribute.P999);
        attributes.add(MetricAttribute.MEAN_RATE);
        attributes.add(MetricAttribute.M1_RATE);
        attributes.add(MetricAttribute.M5_RATE);
        attributes.add(MetricAttribute.M15_RATE);
        this.validMetricAttributeMap.put(MetricType.TIMER, attributes);
    }

    private void validateMetricAttributes(MetricType metricType, List<MetricAttribute> metricAttributes) {
        Set<MetricAttribute> attributes = this.validMetricAttributeMap.get(metricType);
        if (attributes == null) {
            return;
        }
        for (MetricAttribute metricAttribute : metricAttributes) {
            if (attributes.contains(metricAttribute)) continue;
            throw new IllegalArgumentException("Invalid Metric Attribute \"" + metricAttribute.name() + "\" for the Metric Type \"" + metricType.name() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> queryAllSources() {
        TreeSet<String> results = new TreeSet<String>();
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            for (MetricType metricType : MetricType.values()) {
                List<String> list = this.querySources(connection, metricType);
                if (list.isEmpty()) continue;
                results.addAll(list);
            }
            connection.close();
            connection = null;
        }
        catch (SQLException e) {
            logger.error("Error when querying sources.", (Throwable)e);
        }
        finally {
            this.closeQuietly(connection);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> querySources(Connection connection, MetricType metricType) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder queryBuilder = new StringBuilder("SELECT DISTINCT SOURCE FROM ");
        queryBuilder.append(this.getTableName(metricType));
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(queryBuilder.toString());
            while (rs.next()) {
                String source = rs.getString("SOURCE");
                results.add(source);
            }
            rs.close();
            rs = null;
            statement.close();
            statement = null;
            this.closeQuietly(null, statement, rs);
        }
        catch (SQLException e) {
            try {
                logger.error("Error when querying sources. Metric Type: " + metricType, (Throwable)e);
                this.closeQuietly(null, statement, rs);
            }
            catch (Throwable throwable) {
                this.closeQuietly(null, statement, rs);
                throw throwable;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MetricType> queryHierarchicalMetrics(String source, String path) {
        HashMap<String, MetricType> results = new HashMap<String, MetricType>();
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            for (MetricType metricType : MetricType.values()) {
                List<String> names = this.getHierarchicalMetricNames(connection, source, path, metricType);
                if (names.isEmpty()) continue;
                for (String name : names) {
                    results.put(name, metricType);
                }
            }
            connection.close();
            connection = null;
        }
        catch (SQLException e) {
            logger.error("Error when querying sources.", (Throwable)e);
        }
        finally {
            this.closeQuietly(connection);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getHierarchicalMetricNames(Connection connection, String source, String path, MetricType metricType) {
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder queryBuilder = new StringBuilder("SELECT DISTINCT NAME FROM ");
        queryBuilder.append(this.getTableName(metricType));
        queryBuilder.append(" WHERE SOURCE = ?");
        if (path != null && !path.isEmpty()) {
            queryBuilder.append(" AND NAME LIKE ?");
        }
        String query = queryBuilder.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(query);
            ps.setString(1, source);
            if (path != null && !path.isEmpty()) {
                ps.setString(2, path + "%");
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                results.add(name);
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            this.closeQuietly(null, ps, rs);
        }
        catch (SQLException e) {
            try {
                logger.error(String.format("Error when querying metrics. SQL %s", query), (Throwable)e);
                this.closeQuietly(null, ps, rs);
            }
            catch (Throwable throwable) {
                this.closeQuietly(null, ps, rs);
                throw throwable;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void queryMetrics(MetricType metricType, List<String> names, List<MetricAttribute> attributes, String source, long startTime, long endTime, MetricDataProcessor<T> processor) {
        int i;
        this.validateMetricAttributes(metricType, attributes);
        StringBuilder queryBuilder = new StringBuilder("SELECT NAME, TIMESTAMP, ");
        for (i = 0; i < attributes.size(); ++i) {
            if (i > 0) {
                queryBuilder.append(", ");
            }
            queryBuilder.append(this.getColumnName(attributes.get(i)));
        }
        queryBuilder.append(" FROM ");
        queryBuilder.append(this.getTableName(metricType));
        queryBuilder.append(" WHERE");
        if (names.size() == 1) {
            queryBuilder.append(" NAME = ?");
        } else {
            queryBuilder.append(" NAME IN (");
            for (i = 0; i < names.size(); ++i) {
                if (i > 0) {
                    queryBuilder.append(", ");
                }
                queryBuilder.append("?");
            }
            queryBuilder.append(")");
        }
        queryBuilder.append(" AND TIMESTAMP >= ? AND TIMESTAMP <= ?");
        queryBuilder.append(" AND SOURCE = ?");
        queryBuilder.append(" ORDER BY TIMESTAMP");
        String query = queryBuilder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Metric Search Query: %s Parameters: Metric Type: %s, Names: %s, Attributes: %s, Source: %s, Start Time: %d, End Time: %d", query, metricType, names, attributes, source, startTime, endTime));
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int i2;
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(query);
            for (i2 = 0; i2 < names.size(); ++i2) {
                ps.setString(i2 + 1, names.get(i2));
            }
            ps.setLong(++i2, startTime);
            ps.setLong(++i2, endTime);
            ps.setString(++i2, source);
            rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                long timestamp = rs.getLong(2);
                for (int j = 0; j < attributes.size(); ++j) {
                    BigDecimal value;
                    try {
                        value = rs.getBigDecimal(3 + j);
                    }
                    catch (NumberFormatException e) {
                        value = BigDecimal.ZERO;
                    }
                    processor.process(source, timestamp, metricType, name, attributes.get(j), value);
                }
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps, rs);
        }
        catch (SQLException e) {
            try {
                logger.error(String.format("Error when querying metrics. SQL %s", queryBuilder.toString()), (Throwable)e);
                this.closeQuietly(connection, ps, rs);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps, rs);
                throw throwable;
            }
        }
    }

    private String getTableName(MetricType metricType) {
        switch (metricType) {
            case COUNTER: {
                return "METRIC_COUNTER";
            }
            case GAUGE: {
                return "METRIC_GAUGE";
            }
            case HISTOGRAM: {
                return "METRIC_HISTOGRAM";
            }
            case METER: {
                return "METRIC_METER";
            }
            case TIMER: {
                return "METRIC_TIMER";
            }
        }
        throw new IllegalStateException("Invalid Metric Type");
    }

    private String getColumnName(MetricAttribute metricAttribute) {
        return metricAttribute.name();
    }

    private void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Connection connection, Statement statement, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Connection connection, PreparedStatement ps, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

