/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.data.service;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.service.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.metrics.common.DefaultSourceValueProvider;
import org.wso2.carbon.metrics.common.MetricsConfigException;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.common.MetricsXMLConfiguration;
import org.wso2.carbon.metrics.data.common.Metric;
import org.wso2.carbon.metrics.data.common.MetricAttribute;
import org.wso2.carbon.metrics.data.common.MetricDataFormat;
import org.wso2.carbon.metrics.data.common.MetricList;
import org.wso2.carbon.metrics.data.common.MetricType;
import org.wso2.carbon.metrics.data.service.Metadata;
import org.wso2.carbon.metrics.data.service.MetricData;
import org.wso2.carbon.metrics.data.service.MetricHierarchyData;
import org.wso2.carbon.metrics.data.service.MetricMeta;
import org.wso2.carbon.metrics.data.service.dao.MetricDataProcessor;
import org.wso2.carbon.metrics.data.service.dao.ReporterDAO;
import org.wso2.carbon.metrics.data.service.dao.converter.DumbConverter;
import org.wso2.carbon.metrics.data.service.dao.converter.MemoryConverter;
import org.wso2.carbon.metrics.data.service.dao.converter.PercentageConverter;
import org.wso2.carbon.metrics.data.service.dao.converter.ValueConverter;
import org.wso2.carbon.utils.CarbonUtils;

public class MetricsDataService
extends AbstractAdmin
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MetricsDataService.class);
    private ReporterDAO reporterDAO;
    private final Pattern fromPattern = Pattern.compile("(\\-?\\d+)([hdm])");
    private String currentJDBCReportingSource;
    private static final ValueConverter MEMORY_VALUE_CONVERTER = new MemoryConverter();
    private static final ValueConverter PERCENTAGE_VALUE_CONVERTER = new PercentageConverter();
    private static final ValueConverter DUMB_VALUE_CONVERTER = new DumbConverter();

    public void init(ServiceContext serviceContext) throws AxisFault {
        MetricsXMLConfiguration configuration;
        block2: {
            configuration = new MetricsXMLConfiguration();
            String filePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "metrics.xml";
            try {
                configuration.load(filePath);
            }
            catch (MetricsConfigException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Error reading configuration from " + filePath, (Throwable)e);
            }
        }
        this.init((MetricsConfiguration)configuration);
    }

    public void destroy(ServiceContext serviceContext) {
    }

    void init(MetricsConfiguration configuration) {
        String JDBC_REPORTING_DATASOURCE_NAME = "Reporting.JDBC.DataSourceName";
        String JDBC_REPORTING_SOURCE = "Reporting.JDBC.Source";
        String dataSourceName = configuration.getProperty("Reporting.JDBC.DataSourceName");
        if (dataSourceName == null || dataSourceName.trim().length() == 0) {
            String msg = "Data Source Name is not specified for Metrics Data Service";
            if (logger.isWarnEnabled()) {
                logger.warn(msg);
            }
            throw new IllegalStateException(msg);
        }
        DataSource dataSource = null;
        try {
            InitialContext ctx = new InitialContext();
            dataSource = (DataSource)ctx.lookup(dataSourceName);
        }
        catch (NamingException e) {
            String msg = String.format("Error when looking up the Data Source: '%s'. Cannot instantiate the Metrics Data Service", dataSourceName);
            if (logger.isWarnEnabled()) {
                logger.warn(msg);
            }
            throw new IllegalStateException(msg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Creating Metrics Data Service with data source '%s'", dataSourceName));
        }
        this.reporterDAO = new ReporterDAO(dataSource);
        this.currentJDBCReportingSource = configuration.getProperty("Reporting.JDBC.Source", DefaultSourceValueProvider.getValue());
    }

    private long getStartTime(String from) {
        if (from == null || from.isEmpty()) {
            return -1L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Get Start Time. From Value: %s", from));
        }
        long currentTimeMillis = System.currentTimeMillis();
        Matcher matcher = this.fromPattern.matcher(from);
        long startTime = -1L;
        if (matcher.find()) {
            long count = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2);
            if ("m".equals(unit)) {
                startTime = currentTimeMillis + count * 1000L * 60L;
            } else if ("h".equals(unit)) {
                startTime = currentTimeMillis + count * 1000L * 60L * 60L;
            } else if ("d".equals(unit)) {
                startTime = currentTimeMillis + count * 1000L * 60L * 60L * 24L;
            }
        } else if (from.matches("\\d+")) {
            startTime = Long.parseLong(from);
        }
        return startTime;
    }

    public String[] getAllSources() {
        ArrayList<String> sourcesList;
        Set<String> sources = this.reporterDAO.queryAllSources();
        if (sources.isEmpty()) {
            sourcesList = new ArrayList<String>(1);
            sourcesList.add(this.currentJDBCReportingSource);
        } else {
            sources.remove(this.currentJDBCReportingSource);
            sourcesList = new ArrayList(sources.size());
            sourcesList.add(this.currentJDBCReportingSource);
            sourcesList.addAll(sources);
        }
        return sourcesList.toArray(new String[sourcesList.size()]);
    }

    public MetricHierarchyData getHierarchy(String source, String path) {
        Map<String, MetricType> hierarchicalMetrics = this.reporterDAO.queryHierarchicalMetrics(source, path);
        TreeSet<String> childrenNames = new TreeSet<String>();
        ArrayList<MetricMeta> metrics = new ArrayList<MetricMeta>();
        path = path != null && !path.isEmpty() ? path : "";
        for (Map.Entry<String, MetricType> entry : hierarchicalMetrics.entrySet()) {
            String metric = entry.getKey();
            MetricType type = entry.getValue();
            if (!metric.startsWith(path)) continue;
            String suffix = !"".equals(path) ? metric.replaceFirst(path + "\\.", "") : metric;
            int chunks = suffix.length() - suffix.replace(".", "").length();
            if (chunks == 0) {
                metrics.add(new MetricMeta(metric, type.name()));
                continue;
            }
            if (chunks == 1) {
                childrenNames.add(metric.substring(0, metric.lastIndexOf(46)));
                continue;
            }
            if (chunks <= 1) continue;
            if (!"".equals(path)) {
                childrenNames.add(path + "." + suffix.substring(0, suffix.indexOf(46)));
                continue;
            }
            childrenNames.add(suffix.substring(0, suffix.indexOf(46)));
        }
        return new MetricHierarchyData(path, childrenNames.toArray(new String[childrenNames.size()]), metrics.toArray(new MetricMeta[metrics.size()]));
    }

    public MetricData findLastMetrics(MetricList metrics, String source, String from) {
        long startTime = this.getStartTime(from);
        if (startTime == -1L) {
            return null;
        }
        long endTime = System.currentTimeMillis();
        return this.findMetricsByTimePeriod(metrics, source, startTime, endTime);
    }

    public MetricData findMetricsByTimePeriod(MetricList metrics, String source, long startTime, long endTime) {
        MetricType metricType;
        Metric[] list = null;
        if (metrics == null || (list = metrics.getMetric()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Metric List is not available. Returning null");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Find Metrics by time period. Metric List Count: %d, Source: %s, Start Time: %d, End Time: %d", list.length, source, startTime, endTime));
        }
        HashMap<MetricGroup, MetricGroup> metricGroupMap = new HashMap<MetricGroup, MetricGroup>();
        HashMap nameGroupMap = new HashMap();
        HashMap attributeGroupMap = new HashMap();
        int index = 0;
        for (int i = 0; i < list.length; ++i) {
            MetricGroup metricGroup;
            ValueConverter valueConverter;
            ArrayList<String> names;
            ArrayList<MetricAttribute> attributes;
            Metric metric = list[i];
            String metricName = metric.getName();
            String displayName = metric.getDisplayName();
            metricType = MetricType.valueOf((String)metric.getType());
            MetricAttribute metricAttribute = MetricAttribute.valueOf((String)metric.getAttr());
            MetricDataFormat metricDataFormat = null;
            if (metric.getFormat() != null) {
                metricDataFormat = MetricDataFormat.valueOf((String)metric.getFormat());
            }
            if ((attributes = (ArrayList<MetricAttribute>)nameGroupMap.get(metricName)) == null) {
                attributes = new ArrayList<MetricAttribute>();
                nameGroupMap.put(metricName, attributes);
            }
            if ((names = (ArrayList<String>)attributeGroupMap.get(metricAttribute)) == null) {
                names = new ArrayList<String>();
                attributeGroupMap.put(metricAttribute, names);
            }
            attributes.add(metricAttribute);
            names.add(metricName);
            if (metricDataFormat != null) {
                switch (metricDataFormat) {
                    case P: {
                        valueConverter = PERCENTAGE_VALUE_CONVERTER;
                        break;
                    }
                    case B: {
                        valueConverter = MEMORY_VALUE_CONVERTER;
                        break;
                    }
                    default: {
                        valueConverter = DUMB_VALUE_CONVERTER;
                        break;
                    }
                }
            } else {
                valueConverter = DUMB_VALUE_CONVERTER;
            }
            if (metricGroupMap.containsKey(metricGroup = new MetricGroup(metricType, metricName, metricAttribute))) continue;
            metricGroupMap.put(metricGroup, metricGroup);
            metricGroup.index = index++;
            metricGroup.displayName = displayName;
            metricGroup.valueConverter = valueConverter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Metric Group Map Size: %d", metricGroupMap.size()));
        }
        JVMMetricDataProcessor processor = new JVMMetricDataProcessor(metricGroupMap);
        HashSet<MetricGroup> processedMetricGroups = new HashSet<MetricGroup>();
        for (MetricGroup metricGroup : metricGroupMap.values()) {
            ArrayList<MetricAttribute> metricAttributes;
            ArrayList<String> metricNames;
            if (processedMetricGroups.contains(metricGroup)) continue;
            metricType = metricGroup.metricType;
            ArrayList<String> names = (ArrayList<String>)attributeGroupMap.get(metricGroup.metricAttribute);
            ArrayList<MetricAttribute> attributes = (ArrayList<MetricAttribute>)nameGroupMap.get(metricGroup.metricName);
            if (names.size() > attributes.size()) {
                metricNames = names;
                metricAttributes = new ArrayList<MetricAttribute>(1);
                metricAttributes.add(metricGroup.metricAttribute);
            } else {
                metricAttributes = attributes;
                metricNames = new ArrayList<String>(1);
                metricNames.add(metricGroup.metricName);
            }
            this.reporterDAO.queryMetrics(metricType, metricNames, metricAttributes, source, startTime, endTime, processor);
            for (String metricName : metricNames) {
                for (MetricAttribute metricAttribute : metricAttributes) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Processed. Metric Type: %s, Name: %s, Attribute: %s", metricType, metricName, metricAttribute));
                    }
                    processedMetricGroups.add(new MetricGroup(metricType, metricName, metricAttribute));
                }
            }
        }
        return processor.getResult();
    }

    private static class MetricGroup {
        private final MetricType metricType;
        private final String metricName;
        private final MetricAttribute metricAttribute;
        private int index;
        private String displayName;
        private ValueConverter valueConverter;

        public MetricGroup(MetricType metricType, String metricName, MetricAttribute metricAttribute) {
            this.metricType = metricType;
            this.metricName = metricName;
            this.metricAttribute = metricAttribute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.metricAttribute == null ? 0 : this.metricAttribute.hashCode());
            result = 31 * result + (this.metricType == null ? 0 : this.metricType.hashCode());
            result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MetricGroup)) {
                return false;
            }
            MetricGroup other = (MetricGroup)obj;
            if (this.metricAttribute != other.metricAttribute) {
                return false;
            }
            if (this.metricType != other.metricType) {
                return false;
            }
            return !(this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName));
        }
    }

    private static class JVMMetricDataProcessor
    implements MetricDataProcessor<MetricData> {
        private final Map<Long, BigDecimal[]> dataMap = new HashMap<Long, BigDecimal[]>();
        private final List<BigDecimal[]> orderedList = new ArrayList<BigDecimal[]>();
        private final Map<MetricGroup, MetricGroup> metricGroupMap;
        private final String[] dataTypes;
        private final String[] displayNames;

        private JVMMetricDataProcessor(Map<MetricGroup, MetricGroup> metricGroupMap) {
            this.metricGroupMap = metricGroupMap;
            this.dataTypes = new String[metricGroupMap.size() + 1];
            this.displayNames = new String[metricGroupMap.size() + 1];
            this.dataTypes[0] = "T";
            this.displayNames[0] = "Time";
            for (MetricGroup metricGroup : metricGroupMap.values()) {
                int index = metricGroup.index;
                this.dataTypes[index + 1] = "N";
                this.displayNames[index + 1] = metricGroup.displayName;
            }
        }

        @Override
        public void process(String source, long timestamp, MetricType metricType, String metricName, MetricAttribute metricAttribute, BigDecimal value) {
            BigDecimal[] data = this.dataMap.get(timestamp);
            if (data == null) {
                data = new BigDecimal[this.metricGroupMap.size() + 1];
                this.dataMap.put(timestamp, data);
                this.orderedList.add(data);
                data[0] = BigDecimal.valueOf(timestamp);
            }
            MetricGroup metricGroupKey = new MetricGroup(metricType, metricName, metricAttribute);
            MetricGroup metricGroup = this.metricGroupMap.get(metricGroupKey);
            int index = metricGroup.index;
            data[index + 1] = metricGroup.valueConverter.convert(value);
        }

        @Override
        public MetricData getResult() {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Metrics Search Results. Display Names: %s, Data Types: %s, Columns %d, Rows: %d, Total Data Points: %d", Arrays.asList(this.displayNames), Arrays.asList(this.dataTypes), this.displayNames.length, this.orderedList.size(), this.displayNames.length * this.orderedList.size()));
            }
            return new MetricData(new Metadata(this.displayNames, this.dataTypes), (BigDecimal[][])this.orderedList.toArray((T[])new BigDecimal[this.orderedList.size()][]));
        }
    }
}

