/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.properties.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.properties.stub.PropertiesAdminServiceStub;
import org.wso2.carbon.registry.properties.stub.beans.xsd.PropertiesBean;
import org.wso2.carbon.registry.properties.stub.beans.xsd.RetentionBean;
import org.wso2.carbon.registry.properties.stub.utils.xsd.Property;
import org.wso2.carbon.registry.properties.ui.Utils;
import org.wso2.carbon.ui.CarbonUIUtil;

public class PropertiesServiceClient {
    private static final Log log = LogFactory.getLog(PropertiesServiceClient.class);
    private PropertiesAdminServiceStub stub;
    private String epr;

    public PropertiesServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "PropertiesAdminService";
        try {
            this.stub = new PropertiesAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public PropertiesBean getProperties(HttpServletRequest request) {
        String path = (String)Utils.getParameter(request, "path");
        Boolean view = (Boolean)request.getSession().getAttribute("show.system-properties");
        String viewProps = view != null ? (view.booleanValue() ? "yes" : "no") : "no";
        PropertiesBean bean = null;
        try {
            bean = this.stub.getProperties(path, viewProps);
            if (bean == null) {
                return null;
            }
            if (bean.getLifecycleProperties() == null) {
                bean.setLifecycleProperties(new String[0]);
            }
            if (bean.getSysProperties() == null) {
                bean.setSysProperties(new String[0]);
            }
            if (bean.getValidationProperties() == null) {
                bean.setValidationProperties(new String[0]);
            }
            if (bean.getProperties() == null) {
                bean.setProperties(new Property[0]);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get properties. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            e.printStackTrace();
        }
        return bean;
    }

    public void setProperty(HttpServletRequest request) throws Exception {
        String path = (String)Utils.getParameter(request, "path");
        String name = (String)Utils.getParameter(request, "name");
        String value = (String)Utils.getParameter(request, "value");
        try {
            this.stub.setProperty(path, name, value);
        }
        catch (Exception e) {
            String msg = "Failed to add the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void updateProperty(HttpServletRequest request) throws Exception {
        String path = (String)Utils.getParameter(request, "path");
        String name = (String)Utils.getParameter(request, "name");
        String value = (String)Utils.getParameter(request, "value");
        String oldName = (String)Utils.getParameter(request, "oldName");
        try {
            this.stub.updateProperty(path, name, value, oldName);
        }
        catch (Exception e) {
            String msg = "Failed to update the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(e);
        }
    }

    public void removeProperty(HttpServletRequest request) throws Exception {
        String path = (String)Utils.getParameter(request, "path");
        String name = (String)Utils.getParameter(request, "name");
        try {
            this.stub.removeProperty(path, name);
        }
        catch (Exception e) {
            String msg = "Failed to remove the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(e);
        }
    }

    public boolean setRetentionProperties(HttpServletRequest request) throws Exception {
        try {
            RetentionBean bean;
            String path = request.getParameter("path");
            String fromDate = request.getParameter("fromDate");
            if (fromDate == null || "".equals(fromDate)) {
                bean = null;
            } else {
                bean = new RetentionBean();
                bean.setFromDate(fromDate);
                bean.setToDate(request.getParameter("toDate"));
                String lockedOperationsParam = request.getParameter("lockedOperations");
                bean.setWriteLocked(lockedOperationsParam.contains("write"));
                bean.setDeleteLocked(lockedOperationsParam.contains("delete"));
            }
            this.stub.setRetentionProperties(path, bean);
        }
        catch (Exception e) {
            log.error((Object)("Failed to add retention: " + e.getMessage()), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public RetentionBean getRetentionProperties(HttpServletRequest request) throws RegistryException {
        try {
            return this.stub.getRetentionProperties(request.getParameter("path"));
        }
        catch (Exception e) {
            String msg = "Could not retrieve retention details " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

