/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationMgtListenerServiceComponent;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationResourceManagementListener;

public class DefaultApplicationResourceMgtListener
implements ApplicationResourceManagementListener {
    private static final Log log = LogFactory.getLog(DefaultApplicationResourceMgtListener.class);

    @Override
    public int getDefaultOrderId() {
        return 10;
    }

    @Override
    public boolean doPreCreateApplication(ServiceProvider application, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
            if (!listener.isEnable() || listener.doPreCreateApplication(application, tenantDomain, userPerformingAction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doPostCreateApplication(String resourceId, ServiceProvider application, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        int applicationId = this.getApplicationId(resourceId, tenantDomain);
        application.setApplicationID(applicationId);
        for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
            if (!listener.isEnable() || listener.doPostCreateApplication(application, tenantDomain, userPerformingAction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doPreUpdateApplicationByResourceId(ServiceProvider application, String resourceId, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        int applicationId = this.getApplicationId(resourceId, tenantDomain);
        if (this.isApplicationExists(applicationId)) {
            application.setApplicationID(applicationId);
            for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
                if (!listener.isEnable() || listener.doPreUpdateApplication(application, tenantDomain, userPerformingAction)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isApplicationExists(int applicationId) {
        return applicationId != -1;
    }

    @Override
    public boolean doPostUpdateApplicationByResourceId(ServiceProvider application, String resourceId, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        int applicationId = this.getApplicationId(resourceId, tenantDomain);
        application.setApplicationID(applicationId);
        for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
            if (!listener.isEnable() || listener.doPostUpdateApplication(application, tenantDomain, userPerformingAction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doPreDeleteApplicationByResourceId(String resourceId, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        String applicationName = this.getApplicationName(resourceId, tenantDomain);
        if (this.isApplicationExists(applicationName)) {
            for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
                if (!listener.isEnable() || listener.doPreDeleteApplication(applicationName, tenantDomain, userPerformingAction)) continue;
                return false;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Application cannot be found for the resourceId: " + resourceId + " in tenantDomain: " + tenantDomain + ". Therefore not triggering the doPreDeleteApplication() of ApplicationMgtListeners."));
        }
        return true;
    }

    private boolean isApplicationExists(String applicationName) {
        return applicationName != null;
    }

    @Override
    public boolean doPostDeleteApplicationByResourceId(ServiceProvider deletedApplication, String applicationResourceId, String tenantDomain, String userPerformingAction) throws IdentityApplicationManagementException {
        for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
            if (!listener.isEnable() || listener.doPostDeleteApplication(deletedApplication, tenantDomain, userPerformingAction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doPreGetApplicationByResourceId(String applicationResourceId, String tenantDomain) throws IdentityApplicationManagementException {
        String applicationName = this.getApplicationName(applicationResourceId, tenantDomain);
        if (this.isApplicationExists(applicationName)) {
            for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
                if (!listener.isEnable() || listener.doPreGetServiceProvider(applicationName, tenantDomain)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doPostGetApplicationByResourceId(ServiceProvider serviceProvider, String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        String applicationName = this.getApplicationName(resourceId, tenantDomain);
        for (ApplicationMgtListener listener : ApplicationMgtListenerServiceComponent.getApplicationMgtListeners()) {
            if (!listener.isEnable() || listener.doPostGetServiceProvider(serviceProvider, applicationName, tenantDomain)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doPreGetApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        return true;
    }

    @Override
    public boolean doPostGetApplicationBasicInfoByResourceId(ApplicationBasicInfo appInfo, String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        return true;
    }

    private String getApplicationName(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationBasicInfo appInfo = this.getApplicationBasicInfoByResourceId(resourceId, tenantDomain);
        return appInfo != null ? appInfo.getApplicationName() : null;
    }

    private int getApplicationId(String applicationResourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationBasicInfo appInfo = this.getApplicationBasicInfoByResourceId(applicationResourceId, tenantDomain);
        return appInfo != null ? appInfo.getApplicationId() : -1;
    }

    private ApplicationBasicInfo getApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        return appDAO.getApplicationBasicInfoByResourceId(resourceId, tenantDomain);
    }
}

