/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.listener;

import org.apache.commons.logging.Log;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ApplicationMgtAuditLogger
extends AbstractApplicationMgtListener {
    private static final Log audit = CarbonConstants.AUDIT_LOG;
    private static final String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";
    private static final String SUCCESS = "Success";

    @Override
    public int getDefaultOrderId() {
        return 200;
    }

    @Override
    public boolean doPostCreateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        int appId = -1;
        String name = "Undefined";
        if (serviceProvider != null) {
            appId = serviceProvider.getApplicationID();
            name = serviceProvider.getApplicationName();
        }
        userName = UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain);
        audit.info((Object)String.format(AUDIT_MESSAGE, userName, "create", appId, name, SUCCESS));
        return true;
    }

    @Override
    public boolean doPostUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        int appId = -1;
        String name = "Undefined";
        if (serviceProvider != null) {
            appId = serviceProvider.getApplicationID();
            name = serviceProvider.getApplicationName();
        }
        userName = UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain);
        audit.info((Object)String.format(AUDIT_MESSAGE, userName, "update", appId, name, SUCCESS));
        return true;
    }

    @Override
    public boolean doPostDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        userName = UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain);
        audit.info((Object)String.format(AUDIT_MESSAGE, userName, "delete", applicationName, null, SUCCESS));
        return true;
    }
}

