/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.listener;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCache;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.listener.AbstractIdentityProviderMgtListener;
import org.wso2.carbon.idp.mgt.model.ConnectedAppsResult;

public class ApplicationIdentityProviderMgtListener
extends AbstractIdentityProviderMgtListener {
    private static final Log log = LogFactory.getLog(ApplicationIdentityProviderMgtListener.class);

    public boolean doPreUpdateIdP(String oldIdPName, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        try {
            ConnectedAppsResult connectedApplications;
            IdentityServiceProviderCache.getInstance().clear();
            IdentityProviderManager identityProviderManager = IdentityProviderManager.getInstance();
            String idpId = identityProviderManager.getIdPByName(oldIdPName, tenantDomain).getResourceId();
            int offset = 0;
            do {
                connectedApplications = identityProviderManager.getConnectedApplications(idpId, null, Integer.valueOf(offset), tenantDomain);
                ArrayList<ServiceProvider> serviceProvidersList = new ArrayList<ServiceProvider>();
                for (String appResourceId : connectedApplications.getApps()) {
                    ServiceProvider serviceProvider = ApplicationMgtSystemConfig.getInstance().getApplicationDAO().getApplicationByResourceId(appResourceId, tenantDomain);
                    serviceProvidersList.add(serviceProvider);
                }
                for (ServiceProvider serviceProvider : serviceProvidersList) {
                    LocalAndOutboundAuthenticationConfig localAndOutboundAuthConfig = serviceProvider.getLocalAndOutBoundAuthenticationConfig();
                    AuthenticationStep[] authSteps = localAndOutboundAuthConfig.getAuthenticationSteps();
                    OutboundProvisioningConfig outboundProvisioningConfig = serviceProvider.getOutboundProvisioningConfig();
                    IdentityProvider[] provisioningIdps = outboundProvisioningConfig.getProvisioningIdentityProviders();
                    this.validateIdpDisable(identityProvider, authSteps, provisioningIdps);
                    this.updateApplicationWithFederatedAuthenticators(identityProvider, tenantDomain, serviceProvider, localAndOutboundAuthConfig, authSteps);
                    this.updateApplicationWithProvisioningConnectors(identityProvider, provisioningIdps);
                }
                offset = connectedApplications.getOffSet() + connectedApplications.getLimit();
            } while (connectedApplications.getTotalAppCount() > offset);
        }
        catch (IdentityApplicationManagementException e) {
            throw new IdentityProviderManagementException("Error when updating default authenticator of service providers", (Throwable)e);
        }
        return true;
    }

    private void updateApplicationWithProvisioningConnectors(IdentityProvider identityProvider, IdentityProvider[] provisioningIdps) throws IdentityProviderManagementException {
        if (provisioningIdps != null && provisioningIdps.length != 0) {
            this.updateOutboundProvisioningConnectors(identityProvider, provisioningIdps);
        }
    }

    private void updateApplicationWithFederatedAuthenticators(IdentityProvider identityProvider, String tenantDomain, ServiceProvider serviceProvider, LocalAndOutboundAuthenticationConfig localAndOutboundAuthConfig, AuthenticationStep[] authSteps) throws IdentityApplicationManagementException, IdentityProviderManagementException {
        if (authSteps != null && authSteps.length != 0) {
            if ("federated".equalsIgnoreCase(localAndOutboundAuthConfig.getAuthenticationType())) {
                this.updateApplicationWithFederatedAuthenticator(identityProvider, tenantDomain, serviceProvider, authSteps[0]);
            } else {
                this.updateApplicationWithMultiStepFederatedAuthenticator(identityProvider, authSteps);
            }
        }
    }

    private void validateIdpDisable(IdentityProvider identityProvider, AuthenticationStep[] authSteps, IdentityProvider[] provisioningIdps) throws IdentityProviderManagementException {
        if (!identityProvider.isEnable()) {
            for (AuthenticationStep authenticationStep : authSteps) {
                for (IdentityProvider idpProvider : authenticationStep.getFederatedIdentityProviders()) {
                    if (!StringUtils.equals((String)identityProvider.getIdentityProviderName(), (String)idpProvider.getIdentityProviderName())) continue;
                    throw new IdentityProviderManagementException("Error in disabling identity provider as it is referred by service providers.");
                }
            }
            for (AuthenticationStep authenticationStep : provisioningIdps) {
                if (!StringUtils.equals((String)identityProvider.getIdentityProviderName(), (String)authenticationStep.getIdentityProviderName())) continue;
                throw new IdentityProviderManagementException("Error in disabling identity provider as it is referred by service providers.");
            }
        }
    }

    public boolean doPostDeleteIdP(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPostDeleteIdp executed for idp: " + idPName + " of tenantDomain: " + tenantDomain));
        }
        IdentityServiceProviderCache.getInstance().clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("IdentityServiceProvider Cache is cleared on post delete event of idp: " + idPName + " of tenantDomain: " + tenantDomain));
        }
        return super.doPostDeleteIdP(idPName, tenantDomain);
    }

    public boolean doPostDeleteIdPs(String tenantDomain) throws IdentityProviderManagementException {
        return super.doPostDeleteIdPs(tenantDomain);
    }

    public int getDefaultOrderId() {
        return 10;
    }

    private void updateApplicationWithMultiStepFederatedAuthenticator(IdentityProvider identityProvider, AuthenticationStep[] authSteps) throws IdentityProviderManagementException {
        FederatedAuthenticatorConfig[] idpFederatedConfig = identityProvider.getFederatedAuthenticatorConfigs();
        for (AuthenticationStep authStep : authSteps) {
            IdentityProvider[] federatedIdentityProviders;
            for (IdentityProvider federatedIdp : federatedIdentityProviders = authStep.getFederatedIdentityProviders()) {
                if (!StringUtils.equals((String)federatedIdp.getIdentityProviderName(), (String)identityProvider.getIdentityProviderName())) continue;
                FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = federatedIdp.getFederatedAuthenticatorConfigs();
                String federatedConfigOption = federatedAuthenticatorConfigs[0].getName();
                for (FederatedAuthenticatorConfig config : idpFederatedConfig) {
                    if (!StringUtils.equals((String)config.getName(), (String)federatedConfigOption) || config.isEnabled()) continue;
                    throw new IdentityProviderManagementException(config.getName() + " is referred by service providers.");
                }
            }
        }
    }

    private void updateApplicationWithFederatedAuthenticator(IdentityProvider identityProvider, String tenantDomain, ServiceProvider serviceProvider, AuthenticationStep authStep) throws IdentityApplicationManagementException, IdentityProviderManagementException {
        IdentityProvider fedIdp = authStep.getFederatedIdentityProviders()[0];
        if (StringUtils.equals((String)fedIdp.getIdentityProviderName(), (String)identityProvider.getIdentityProviderName())) {
            String defaultAuthName = fedIdp.getDefaultAuthenticatorConfig().getName();
            if (identityProvider.getDefaultAuthenticatorConfig() != null) {
                String currentDefaultAuthName = identityProvider.getDefaultAuthenticatorConfig().getName();
                boolean isCurrentDefaultAuthEnabled = identityProvider.getDefaultAuthenticatorConfig().isEnabled();
                if (!StringUtils.equals((String)currentDefaultAuthName, (String)defaultAuthName)) {
                    FederatedAuthenticatorConfig currentDefaultAuthenticatorConfig = identityProvider.getDefaultAuthenticatorConfig();
                    fedIdp.setDefaultAuthenticatorConfig(currentDefaultAuthenticatorConfig);
                    fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{currentDefaultAuthenticatorConfig});
                    ApplicationMgtSystemConfig.getInstance().getApplicationDAO().updateApplication(serviceProvider, tenantDomain);
                } else if (!isCurrentDefaultAuthEnabled && StringUtils.equals((String)currentDefaultAuthName, (String)defaultAuthName)) {
                    throw new IdentityProviderManagementException("Error in disabling default federated authenticator as it is referred by service providers.");
                }
            }
        }
    }

    private void updateOutboundProvisioningConnectors(IdentityProvider identityProvider, IdentityProvider[] provisioningIdps) throws IdentityProviderManagementException {
        ProvisioningConnectorConfig[] idpProvisioningConnectorConfigs = identityProvider.getProvisioningConnectorConfigs();
        for (IdentityProvider idpProvider : provisioningIdps) {
            if (!StringUtils.equals((String)idpProvider.getIdentityProviderName(), (String)identityProvider.getIdentityProviderName())) continue;
            ProvisioningConnectorConfig defaultProvisioningConnectorConfig = idpProvider.getDefaultProvisioningConnectorConfig();
            for (ProvisioningConnectorConfig config : idpProvisioningConnectorConfigs) {
                if (!StringUtils.equals((String)config.getName(), (String)defaultProvisioningConnectorConfig.getName()) || config.isEnabled()) continue;
                throw new IdentityProviderManagementException(config.getName() + " outbound provisioning connector is referred by service providers.");
            }
        }
    }
}

