/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationResourceManagementListener;

@Component(name="org.wso2.carbon.identity.application.mgt.listener", immediate=true)
public class ApplicationMgtListenerServiceComponent {
    private static List<ApplicationMgtListener> applicationMgtListeners = new ArrayList<ApplicationMgtListener>();
    private static List<ApplicationResourceManagementListener> applicationResourceMgtListeners = new ArrayList<ApplicationResourceManagementListener>();
    private static Comparator<ApplicationMgtListener> appMgtListenerComparator = Comparator.comparingInt(ApplicationMgtListener::getExecutionOrderId);
    private static Comparator<ApplicationResourceManagementListener> appResourceMgtListenerComparator = Comparator.comparingInt(ApplicationResourceManagementListener::getExecutionOrderId);

    @Reference(name="application.mgt.event.listener.service", service=ApplicationMgtListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationMgtListenerService")
    protected synchronized void setApplicationMgtListenerService(ApplicationMgtListener applicationMgtListenerService) {
        applicationMgtListeners.add(applicationMgtListenerService);
        applicationMgtListeners.sort(appMgtListenerComparator);
    }

    protected synchronized void unsetApplicationMgtListenerService(ApplicationMgtListener applicationMgtListenerService) {
        applicationMgtListeners.remove(applicationMgtListenerService);
    }

    public static synchronized Collection<ApplicationMgtListener> getApplicationMgtListeners() {
        return applicationMgtListeners;
    }

    @Reference(name="application.resource.mgt.event.listener.service", service=ApplicationResourceManagementListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationResourceMgtListener")
    protected synchronized void setApplicationResourceMgtListener(ApplicationResourceManagementListener listener) {
        applicationResourceMgtListeners.add(listener);
        applicationResourceMgtListeners.sort(appResourceMgtListenerComparator);
    }

    protected synchronized void unsetApplicationResourceMgtListener(ApplicationResourceManagementListener listener) {
        applicationResourceMgtListeners.remove(listener);
    }

    public static Collection<ApplicationResourceManagementListener> getApplicationResourceMgtListeners() {
        return applicationResourceMgtListeners;
    }
}

