/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.AbstractInboundAuthenticatorConfig;
import org.wso2.carbon.identity.application.mgt.ApplicationConstants;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementServiceImpl;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.DiscoverableApplicationManager;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtService;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtServiceImpl;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponentHolder;
import org.wso2.carbon.identity.application.mgt.internal.impl.DiscoverableApplicationManagerImpl;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationIdentityProviderMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtAuditLogger;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationResourceManagementListener;
import org.wso2.carbon.identity.application.mgt.listener.DefaultApplicationResourceMgtListener;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderMgtListener;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.application.management.component", immediate=true)
public class ApplicationManagementServiceComponent {
    private static Log log = LogFactory.getLog(ApplicationManagementServiceComponent.class);
    private static BundleContext bundleContext;
    private static Map<String, ServiceProvider> fileBasedSPs;

    public static Map<String, ServiceProvider> getFileBasedSPs() {
        return fileBasedSPs;
    }

    @Activate
    protected void activate(ComponentContext context) {
        try {
            bundleContext = context.getBundleContext();
            bundleContext.registerService(ApplicationManagementService.class.getName(), (Object)ApplicationManagementServiceImpl.getInstance(), null);
            bundleContext.registerService(IdentityProviderMgtListener.class.getName(), (Object)new ApplicationIdentityProviderMgtListener(), null);
            ApplicationMgtSystemConfig.getInstance();
            bundleContext.registerService(ApplicationMgtListener.class.getName(), (Object)new ApplicationMgtAuditLogger(), null);
            bundleContext.registerService(DefaultAuthSeqMgtService.class.getName(), (Object)DefaultAuthSeqMgtServiceImpl.getInstance(), null);
            context.getBundleContext().registerService(ApplicationResourceManagementListener.class, (Object)new DefaultApplicationResourceMgtListener(), null);
            bundleContext.registerService(DiscoverableApplicationManager.class.getName(), (Object)new DiscoverableApplicationManagerImpl(), null);
            this.buildFileBasedSPList();
            this.loadAuthenticationTemplates();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity ApplicationManagementComponent bundle is activated");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating ApplicationManagementComponent bundle", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity ApplicationManagementComponent bundle is deactivated");
        }
    }

    @Reference(name="registry.service", service=org.wso2.carbon.registry.core.service.RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(org.wso2.carbon.registry.core.service.RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity ApplicationManagementComponent bundle");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setRegistryService((RegistryService)registryService);
    }

    protected void unsetRegistryService(org.wso2.carbon.registry.core.service.RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity ApplicationManagementComponent bundle");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setRealmService(null);
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Configuration Context Service");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setConfigContextService(configContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Configuration Context Service");
        }
        ApplicationManagementServiceComponentHolder.getInstance().setConfigContextService(null);
    }

    @Reference(name="application.mgt.authenticator", service=AbstractInboundAuthenticatorConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetInboundAuthenticatorConfig")
    protected void setInboundAuthenticatorConfig(AbstractInboundAuthenticatorConfig authenticator) {
        ApplicationManagementServiceComponentHolder.addInboundAuthenticatorConfig(authenticator);
    }

    protected void unsetInboundAuthenticatorConfig(AbstractInboundAuthenticatorConfig authenticator) {
        ApplicationManagementServiceComponentHolder.removeInboundAuthenticatorConfig(authenticator.getName());
    }

    @Reference(name="consent.mgt.service", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentMgtService")
    protected void setConsentMgtService(ConsentManager consentManager) {
        ApplicationManagementServiceComponentHolder.getInstance().setConsentManager(consentManager);
    }

    protected void unsetConsentMgtService(ConsentManager consentManager) {
        ApplicationManagementServiceComponentHolder.getInstance().setConsentManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFileBasedSPList() {
        Object[] fileList;
        String spConfigDirPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "identity" + File.separator + "service-providers";
        FileInputStream fileInputStream = null;
        File spConfigDir = new File(spConfigDirPath);
        if (spConfigDir.exists() && ArrayUtils.isNotEmpty((Object[])(fileList = spConfigDir.listFiles()))) {
            for (Object fileEntry : fileList) {
                try {
                    OMElement documentElement;
                    ServiceProvider sp;
                    if (((File)fileEntry).isDirectory() || (sp = ServiceProvider.build((OMElement)(documentElement = new StAXOMBuilder((InputStream)(fileInputStream = new FileInputStream(new File(((File)fileEntry).getAbsolutePath())))).getDocumentElement()))) == null) continue;
                    fileBasedSPs.put(sp.getApplicationName(), sp);
                }
                catch (Exception e) {
                    log.error((Object)"Error while loading idp from file system.", (Throwable)e);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            log.error((Object)("Error occurred while closing file input stream for file " + spConfigDirPath), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void loadAuthenticationTemplates() {
        File templatesDir = new File(ApplicationConstants.TEMPLATES_DIR_PATH);
        if (!templatesDir.exists() || !templatesDir.isDirectory()) {
            log.warn((Object)("Templates directory not found at " + templatesDir.getPath()));
            ApplicationManagementServiceComponentHolder.getInstance().setAuthenticationTemplatesJson("{}");
            return;
        }
        File categoriesFile = new File(templatesDir, "categories.json");
        JSONObject categoriesObj = this.parseCategoryMetadata(categoriesFile);
        File[] jsonFiles = templatesDir.listFiles((d, name) -> name.endsWith(".json") && !"categories.json".equals(name));
        if (jsonFiles != null) {
            for (File jsonFile : jsonFiles) {
                if (!jsonFile.isFile()) continue;
                try {
                    String templateJsonString = FileUtils.readFileToString((File)jsonFile);
                    JSONObject templateObj = new JSONObject(templateJsonString);
                    if (templateObj.has("category")) {
                        JSONObject categoryObj;
                        String category = templateObj.getString("category");
                        if (!categoriesObj.has(category)) {
                            log.warn((Object)String.format("No category defined as %s for template at %s. Proceeding with uncategorized.", category, jsonFile.getName()));
                            category = "uncategorized";
                        }
                        if (!(categoryObj = categoriesObj.getJSONObject(category)).has("templates")) {
                            categoryObj.put("templates", Collections.emptyList());
                        }
                        JSONArray categoryTemplateArray = categoryObj.getJSONArray("templates");
                        categoryTemplateArray.put((Object)templateObj);
                    } else {
                        log.warn((Object)String.format("Script template in file %s is missing category information, or using an undefined category. Hence it will be ignored.", jsonFile.getName()));
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Authentication template file loaded from: " + jsonFile.getName()));
                }
                catch (JSONException e) {
                    log.error((Object)("Error when parsing json content from file " + jsonFile.getName()), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Error when reading authentication template file " + jsonFile.getName()), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)("Authentication template files could not be read from " + ApplicationConstants.TEMPLATES_DIR_PATH));
        }
        ApplicationManagementServiceComponentHolder.getInstance().setAuthenticationTemplatesJson(categoriesObj.toString());
    }

    private JSONObject parseCategoryMetadata(File categoryMetadataFile) {
        JSONObject categoriesObj = null;
        try {
            String categoryMetadataString = FileUtils.readFileToString((File)categoryMetadataFile);
            try {
                categoriesObj = new JSONObject(categoryMetadataString);
            }
            catch (JSONException e) {
                log.error((Object)("Invalid syntax for authentication template category metadata file: " + categoryMetadataFile.getName() + " . Hence ignoring and proceeding with defaults."), (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error when reading authentication template category metadata file: " + categoryMetadataFile.getName()), (Throwable)e);
        }
        if (categoriesObj == null) {
            categoriesObj = new JSONObject();
        }
        JSONObject objForUncategorized = new JSONObject();
        objForUncategorized.put("displayName", (Object)"Uncategorized");
        objForUncategorized.put("order", 10000);
        categoriesObj.put("uncategorized", (Object)objForUncategorized);
        return categoriesObj;
    }

    static {
        fileBasedSPs = new HashMap<String, ServiceProvider>();
    }
}

