/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.defaultsequence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.model.DefaultAuthenticationSequence;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtException;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtServerException;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtService;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtServiceImpl;

public class DefaultAuthSeqMgtAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DefaultAuthSeqMgtAdminService.class);
    private DefaultAuthSeqMgtService authenticationSeqMgtService;

    public void createDefaultAuthenticationSeq(DefaultAuthenticationSequence authenticationSequence) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            this.authenticationSeqMgtService.createDefaultAuthenticationSeq(authenticationSequence, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while creating default authentication sequence of tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public DefaultAuthenticationSequence getDefaultAuthenticationSeq(String sequenceName) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            return this.authenticationSeqMgtService.getDefaultAuthenticationSeq(sequenceName, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while retrieving default authentication sequence of tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public DefaultAuthenticationSequence getDefaultAuthenticationSeqInXML(String sequenceName) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            return this.authenticationSeqMgtService.getDefaultAuthenticationSeqInXML(sequenceName, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while retrieving default authentication sequence of tenant: " + this.getTenantDomain() + " in XML format"), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public boolean isExistingDefaultAuthenticationSequence(String sequenceName) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            return this.authenticationSeqMgtService.isExistingDefaultAuthenticationSequence(sequenceName, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while checking existence of default authentication sequence in tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public DefaultAuthenticationSequence getDefaultAuthenticationSeqInfo(String sequenceName) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            return this.authenticationSeqMgtService.getDefaultAuthenticationSeqInfo(sequenceName, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while retrieving default authentication sequence info of tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public void deleteDefaultAuthenticationSeq(String sequenceName) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            this.authenticationSeqMgtService.deleteDefaultAuthenticationSeq(sequenceName, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while deleting default authentication sequence of tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }

    public void updateDefaultAuthenticationSeq(String sequenceName, DefaultAuthenticationSequence sequence) throws DefaultAuthSeqMgtException {
        try {
            this.authenticationSeqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
            this.authenticationSeqMgtService.updateDefaultAuthenticationSeq(sequenceName, sequence, this.getTenantDomain());
        }
        catch (DefaultAuthSeqMgtServerException e) {
            log.error((Object)("Error while updating default authentication sequence of tenant: " + this.getTenantDomain()), (Throwable)e);
            throw new DefaultAuthSeqMgtException("Server error occurred.");
        }
    }
}

