/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.mgt.dao.OAuthApplicationDAO;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class OAuthApplicationDAOImpl
implements OAuthApplicationDAO {
    private static final Log log = LogFactory.getLog(OAuthApplicationDAOImpl.class);

    @Override
    public void removeOAuthApplication(String clientIdentifier) throws IdentityApplicationManagementException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, clientIdentifier);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            log.error((Object)"Error when executing the SQL : DELETE FROM IDN_OAUTH_CONSUMER_APPS WHERE CONSUMER_KEY=?");
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IdentityApplicationManagementException("Error removing the consumer application.");
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        }
    }
}

