/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.ApplicationAuthenticatorService;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.mgt.dao.IdentityProviderDAO;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class IdentityProviderDAOImpl
implements IdentityProviderDAO {
    public static final String BASIC = "basic";
    public static final String IWA = "iwa";
    public static final String OAUTH_BEARER = "oauth-bearer";
    public static final String BASIC_AUTH = "basic-auth";
    public static final String SAML_SSO = "samlsso";
    public static final String OPENID_CONNECT = "openidconnect";
    public static final String OPENID = "openid";
    public static final String PASSIVE_STS = "passive-sts";
    public static final String FACEBOOK_AUTH = "facebook";

    @Override
    public String getDefaultAuthenticator(String idpName) throws IdentityApplicationManagementException {
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        try {
            IdentityProvider idp = idpManager.getIdPByName(idpName, CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
            return idp.getDefaultAuthenticatorConfig() != null ? idp.getDefaultAuthenticatorConfig().getName() : null;
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityApplicationManagementException("Error when retrieving default authenticator of idp " + idpName, (Throwable)e);
        }
    }

    @Override
    public IdentityProvider getIdentityProvider(String idpName) throws IdentityApplicationManagementException {
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        try {
            IdentityProvider idp = idpManager.getIdPByName(idpName, CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
            IdentityProvider identityProvider = new IdentityProvider();
            identityProvider.setIdentityProviderName(idp.getIdentityProviderName());
            FederatedAuthenticatorConfig defaultAuthenticator = new FederatedAuthenticatorConfig();
            defaultAuthenticator.setName(this.getDefaultAuthenticator(idp.getIdentityProviderName()));
            ArrayList<FederatedAuthenticatorConfig> federatedAuthenticators = new ArrayList<FederatedAuthenticatorConfig>();
            FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = idp.getFederatedAuthenticatorConfigs();
            if (federatedAuthenticatorConfigs != null && federatedAuthenticatorConfigs.length > 0) {
                for (FederatedAuthenticatorConfig config : federatedAuthenticatorConfigs) {
                    if (!config.isEnabled()) continue;
                    federatedAuthenticators.add(config);
                }
            }
            if (CollectionUtils.isNotEmpty(federatedAuthenticators)) {
                identityProvider.setFederatedAuthenticatorConfigs(federatedAuthenticators.toArray(new FederatedAuthenticatorConfig[federatedAuthenticators.size()]));
            }
            ArrayList<ProvisioningConnectorConfig> provisioningConnectors = new ArrayList<ProvisioningConnectorConfig>();
            ProvisioningConnectorConfig[] provisioningConnectorConfigs = idp.getProvisioningConnectorConfigs();
            if (provisioningConnectorConfigs != null && provisioningConnectorConfigs.length > 0) {
                for (ProvisioningConnectorConfig config : provisioningConnectorConfigs) {
                    if (!config.isEnabled()) continue;
                    provisioningConnectors.add(config);
                }
            }
            if (CollectionUtils.isNotEmpty(provisioningConnectors)) {
                identityProvider.setProvisioningConnectorConfigs(provisioningConnectors.toArray(new ProvisioningConnectorConfig[provisioningConnectors.size()]));
            }
            identityProvider.setEnable(idp.isEnable());
            return identityProvider;
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityApplicationManagementException("Error when retrieving identity provider " + idpName, (Throwable)e);
        }
    }

    @Override
    public List<IdentityProvider> getAllIdentityProviders() throws IdentityApplicationManagementException {
        List idps;
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        try {
            idps = idpManager.getIdPs(CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityApplicationManagementException("Error when retrieving all identity providers in " + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() + " tenant domain.", (Throwable)e);
        }
        ArrayList<IdentityProvider> federatedIdentityProviders = new ArrayList<IdentityProvider>();
        if (idps != null && !idps.isEmpty()) {
            for (IdentityProvider idp : idps) {
                federatedIdentityProviders.add(this.getIdentityProvider(idp.getIdentityProviderName()));
            }
        }
        return federatedIdentityProviders;
    }

    @Override
    public List<LocalAuthenticatorConfig> getAllLocalAuthenticators() throws IdentityApplicationManagementException {
        return ApplicationAuthenticatorService.getInstance().getLocalAuthenticators();
    }

    @Override
    public List<RequestPathAuthenticatorConfig> getAllRequestPathAuthenticators() throws IdentityApplicationManagementException {
        return ApplicationAuthenticatorService.getInstance().getRequestPathAuthenticators();
    }
}

