/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.dao.impl.AbstractApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponent;

public class FileBasedApplicationDAO
extends AbstractApplicationDAOImpl {
    @Override
    public int createApplication(ServiceProvider applicationDTO, String tenantDomain) throws IdentityApplicationManagementException {
        throw new IdentityApplicationManagementException("Not supported in file based dao.");
    }

    @Override
    public ServiceProvider getApplication(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        return ApplicationManagementServiceComponent.getFileBasedSPs().get(applicationName);
    }

    @Override
    public ServiceProvider getApplication(int applicationId) throws IdentityApplicationManagementException {
        throw new IdentityApplicationManagementException("Not supported in file based dao.");
    }

    @Override
    public ApplicationBasicInfo[] getAllApplicationBasicInfo() throws IdentityApplicationManagementException {
        Map<String, ServiceProvider> spMap = ApplicationManagementServiceComponent.getFileBasedSPs();
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        for (Map.Entry<String, ServiceProvider> entry : spMap.entrySet()) {
            ApplicationBasicInfo basicInfo = new ApplicationBasicInfo();
            basicInfo.setApplicationName(entry.getValue().getApplicationName());
            basicInfo.setDescription(entry.getValue().getDescription());
            appInfo.add(basicInfo);
        }
        return appInfo.toArray(new ApplicationBasicInfo[appInfo.size()]);
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter) throws IdentityApplicationManagementException {
        Map<String, ServiceProvider> spMap = ApplicationManagementServiceComponent.getFileBasedSPs();
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        filter = filter != null && filter.trim().length() != 0 ? filter.replace("*", ".*") : ".*";
        Pattern pattern = Pattern.compile(filter, 2);
        for (Map.Entry<String, ServiceProvider> entry : spMap.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getValue().getApplicationName());
            if (!matcher.matches()) continue;
            ApplicationBasicInfo basicInfo = new ApplicationBasicInfo();
            basicInfo.setApplicationName(entry.getValue().getApplicationName());
            basicInfo.setDescription(entry.getValue().getDescription());
            appInfo.add(basicInfo);
        }
        return appInfo.toArray(new ApplicationBasicInfo[appInfo.size()]);
    }

    @Override
    public void updateApplication(ServiceProvider applicationDTO, String tenantDomain) throws IdentityApplicationManagementException {
        throw new IdentityApplicationManagementException("Not supported in file based dao.");
    }

    @Override
    public void deleteApplication(String applicationName) throws IdentityApplicationManagementException {
        throw new IdentityApplicationManagementException("Not supported in file based dao.");
    }

    @Override
    public String getApplicationName(int applicationID) throws IdentityApplicationManagementException {
        Map<String, ServiceProvider> spMap = ApplicationManagementServiceComponent.getFileBasedSPs();
        for (Map.Entry<String, ServiceProvider> entry : spMap.entrySet()) {
            if (entry.getValue().getApplicationID() != applicationID) continue;
            return entry.getValue().getApplicationName();
        }
        return null;
    }

    @Override
    public String getServiceProviderNameByClientId(String clientId, String clientType, String tenantDomain) throws IdentityApplicationManagementException {
        if (StringUtils.isEmpty((String)clientId)) {
            return null;
        }
        Map<String, ServiceProvider> spMap = ApplicationManagementServiceComponent.getFileBasedSPs();
        for (Map.Entry<String, ServiceProvider> entry : spMap.entrySet()) {
            InboundAuthenticationRequestConfig[] authRequestConfigs;
            if (entry.getValue().getInboundAuthenticationConfig() == null || (authRequestConfigs = entry.getValue().getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) == null || authRequestConfigs.length <= 0) continue;
            for (InboundAuthenticationRequestConfig config : authRequestConfigs) {
                if (!clientType.equals(config.getInboundAuthType()) || !clientId.equals(config.getInboundAuthKey())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getServiceProviderToLocalIdPClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = ApplicationManagementServiceComponent.getFileBasedSPs().get(serviceProviderName);
        HashMap<String, String> claimMap = new HashMap<String, String>();
        if (serviceProvider == null || serviceProvider.getClaimConfig() == null) {
            return claimMap;
        }
        ClaimMapping[] claimMappings = serviceProvider.getClaimConfig().getClaimMappings();
        if (claimMappings != null && claimMappings.length > 0) {
            for (ClaimMapping mapping : claimMappings) {
                if (mapping.getLocalClaim() == null || mapping.getLocalClaim().getClaimUri() == null || mapping.getRemoteClaim() == null || mapping.getRemoteClaim().getClaimUri() == null) continue;
                claimMap.put(mapping.getRemoteClaim().getClaimUri(), mapping.getLocalClaim().getClaimUri());
            }
        }
        return claimMap;
    }

    @Override
    public Map<String, String> getLocalIdPToServiceProviderClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = ApplicationManagementServiceComponent.getFileBasedSPs().get(serviceProviderName);
        HashMap<String, String> claimMap = new HashMap<String, String>();
        if (serviceProvider == null || serviceProvider.getClaimConfig() == null) {
            return claimMap;
        }
        ClaimMapping[] claimMappings = serviceProvider.getClaimConfig().getClaimMappings();
        if (claimMappings != null && claimMappings.length > 0) {
            for (ClaimMapping mapping : claimMappings) {
                if (mapping.getLocalClaim() == null || mapping.getLocalClaim().getClaimUri() == null || mapping.getRemoteClaim() == null || mapping.getRemoteClaim().getClaimUri() == null) continue;
                claimMap.put(mapping.getLocalClaim().getClaimUri(), mapping.getRemoteClaim().getClaimUri());
            }
        }
        return claimMap;
    }

    @Override
    public List<String> getAllRequestedClaimsByServiceProvider(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = ApplicationManagementServiceComponent.getFileBasedSPs().get(serviceProviderName);
        ArrayList<String> requestedClaimList = new ArrayList<String>();
        if (serviceProvider == null || serviceProvider.getClaimConfig() == null) {
            return requestedClaimList;
        }
        ClaimMapping[] claimMappings = serviceProvider.getClaimConfig().getClaimMappings();
        if (claimMappings != null && claimMappings.length > 0) {
            for (ClaimMapping mapping : claimMappings) {
                if (!mapping.isRequested()) continue;
                if (mapping.getRemoteClaim() != null && mapping.getRemoteClaim().getClaimUri() != null) {
                    requestedClaimList.add(mapping.getRemoteClaim().getClaimUri());
                    continue;
                }
                if (mapping.getLocalClaim() == null || mapping.getLocalClaim().getClaimUri() == null) continue;
                requestedClaimList.add(mapping.getLocalClaim().getClaimUri());
            }
        }
        return requestedClaimList;
    }

    @Override
    public boolean isApplicationExists(String serviceProviderName, String tenantName) {
        return ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName);
    }
}

