/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.common.model.DefaultAuthenticationSequence;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.mgt.dao.DefaultAuthSeqMgtDAO;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtServerException;
import org.wso2.carbon.identity.application.mgt.util.JdbcUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;

public class DefaultAuthSeqMgtDAOImpl
implements DefaultAuthSeqMgtDAO {
    @Override
    public void createDefaultAuthenticationSeq(DefaultAuthenticationSequence sequence, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            this.doCreateDefaultAuthSeq(sequence, tenantDomain, jdbcTemplate);
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Error while creating default authentication sequence in tenant: " + tenantDomain, e);
        }
    }

    @Override
    public DefaultAuthenticationSequence getDefaultAuthenticationSeq(String sequenceName, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return this.doGetDefaultAuthSeq(sequenceName, tenantDomain, jdbcTemplate);
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Error while retrieving default authentication sequence in tenant: " + tenantDomain, e);
        }
    }

    @Override
    public DefaultAuthenticationSequence getDefaultAuthenticationSeqInfo(String sequenceName, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return this.doGetDefaultAuthenticationSeqInfo(sequenceName, tenantDomain, jdbcTemplate);
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Error while retrieving default authentication sequence info in tenant: " + tenantDomain, e);
        }
    }

    @Override
    public boolean isDefaultAuthSeqExists(String sequenceName, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        try {
            int sequenceID = this.doGetSequenceID(sequenceName, tenantDomain, JdbcUtils.getNewTemplate());
            if (sequenceID != 0) {
                return true;
            }
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Could not check existence of default authentication sequence in tenant: " + tenantDomain, e);
        }
        return false;
    }

    @Override
    public void deleteDefaultAuthenticationSeq(String sequenceName, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            this.doDeleteDefaultAuthSeq(sequenceName, tenantDomain, jdbcTemplate);
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Error while deleting default authentication sequence in tenant: " + tenantDomain, e);
        }
    }

    @Override
    public void updateDefaultAuthenticationSeq(String sequenceName, DefaultAuthenticationSequence sequence, String tenantDomain) throws DefaultAuthSeqMgtServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            this.doUpdateDefaultAuthSeq(sequenceName, sequence, tenantDomain, jdbcTemplate);
        }
        catch (DataAccessException e) {
            throw new DefaultAuthSeqMgtServerException("Error while deleting default authentication sequence in tenant: " + tenantDomain, e);
        }
    }

    private void doCreateDefaultAuthSeq(DefaultAuthenticationSequence sequence, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        jdbcTemplate.executeInsert("INSERT INTO SP_DEFAULT_AUTH_SEQ(NAME, DESCRIPTION, SEQ_CONTENT, TENANT_ID) VALUES (?, ?, ?, ?)", preparedStatement -> {
            preparedStatement.setString(1, sequence.getName());
            preparedStatement.setString(2, sequence.getDescription());
            try {
                this.setBlobValue(sequence.getContent(), preparedStatement, 3);
            }
            catch (IOException e) {
                throw new SQLException("Could not set default authentication sequence as a Blob.", e);
            }
            preparedStatement.setInt(4, this.getTenantID(tenantDomain));
        }, null, false);
    }

    private DefaultAuthenticationSequence doGetDefaultAuthSeq(String sequenceName, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        return (DefaultAuthenticationSequence)jdbcTemplate.fetchSingleRecord("SELECT NAME, DESCRIPTION, SEQ_CONTENT FROM SP_DEFAULT_AUTH_SEQ WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> {
            DefaultAuthenticationSequence sequence = new DefaultAuthenticationSequence();
            sequence.setName(resultSet.getString(1));
            sequence.setDescription(resultSet.getString(2));
            try {
                byte[] requestBytes = resultSet.getBytes(3);
                ByteArrayInputStream bais = new ByteArrayInputStream(requestBytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object objectRead = ois.readObject();
                if (objectRead instanceof LocalAndOutboundAuthenticationConfig) {
                    sequence.setContent((LocalAndOutboundAuthenticationConfig)objectRead);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new SQLException("Could not get content of default authentication sequence as a Blob.", e);
            }
            return sequence;
        }, preparedStatement -> {
            preparedStatement.setString(1, sequenceName);
            preparedStatement.setInt(2, this.getTenantID(tenantDomain));
        });
    }

    private DefaultAuthenticationSequence doGetDefaultAuthenticationSeqInfo(String sequenceName, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        return (DefaultAuthenticationSequence)jdbcTemplate.fetchSingleRecord("SELECT NAME, DESCRIPTION FROM SP_DEFAULT_AUTH_SEQ WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> {
            DefaultAuthenticationSequence sequence = new DefaultAuthenticationSequence();
            sequence.setName(resultSet.getString(1));
            sequence.setDescription(resultSet.getString(2));
            return sequence;
        }, preparedStatement -> {
            preparedStatement.setString(1, sequenceName);
            preparedStatement.setInt(2, this.getTenantID(tenantDomain));
        });
    }

    private int doGetSequenceID(String sequenceName, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        int sequenceID = 0;
        String sequenceIDExists = (String)jdbcTemplate.fetchSingleRecord("SELECT ID FROM SP_DEFAULT_AUTH_SEQ WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> Integer.toString(resultSet.getInt(1)), preparedStatement -> {
            preparedStatement.setString(1, sequenceName);
            preparedStatement.setInt(2, this.getTenantID(tenantDomain));
        });
        if (sequenceIDExists != null) {
            sequenceID = Integer.parseInt(sequenceIDExists);
        }
        return sequenceID;
    }

    private void doUpdateDefaultAuthSeq(String sequenceName, DefaultAuthenticationSequence sequence, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        jdbcTemplate.executeUpdate("UPDATE SP_DEFAULT_AUTH_SEQ SET NAME = ?,DESCRIPTION = ?,SEQ_CONTENT = ? WHERE NAME = ? AND TENANT_ID = ?", preparedStatement -> {
            preparedStatement.setString(1, sequence.getName());
            preparedStatement.setString(2, sequence.getDescription());
            try {
                this.setBlobValue(sequence.getContent(), preparedStatement, 3);
            }
            catch (IOException e) {
                throw new SQLException("Could not set default authentication sequence as a Blob.", e);
            }
            preparedStatement.setString(4, sequenceName);
            preparedStatement.setInt(5, this.getTenantID(tenantDomain));
        });
    }

    private void doDeleteDefaultAuthSeq(String sequenceName, String tenantDomain, JdbcTemplate jdbcTemplate) throws DataAccessException {
        jdbcTemplate.executeUpdate("DELETE FROM SP_DEFAULT_AUTH_SEQ WHERE NAME = ? AND TENANT_ID = ?", preparedStatement -> {
            preparedStatement.setString(1, sequenceName);
            preparedStatement.setInt(2, this.getTenantID(tenantDomain));
        });
    }

    private void setBlobValue(Object value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            prepStmt.setBytes(index, baos.toByteArray());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }

    private int getTenantID(String tenantDomain) {
        int tenantID = -1;
        if (tenantDomain != null) {
            tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        return tenantID;
    }
}

