/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCache;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCacheEntry;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCacheKey;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.PaginatableFilterableApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.impl.ApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.internal.cache.ApplicationBasicInfoByResourceIdCache;
import org.wso2.carbon.identity.application.mgt.internal.cache.ApplicationBasicInfoResourceIdCacheEntry;
import org.wso2.carbon.identity.application.mgt.internal.cache.ApplicationBasicInfoResourceIdCacheKey;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderByIDCache;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderByInboundAuthCache;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderByResourceIdCache;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderCacheInboundAuthEntry;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderCacheInboundAuthKey;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderIDCacheEntry;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderIDCacheKey;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderResourceIdCacheEntry;
import org.wso2.carbon.identity.application.mgt.internal.cache.ServiceProviderResourceIdCacheKey;

public class CacheBackedApplicationDAO
extends ApplicationDAOImpl {
    private static final Log log = LogFactory.getLog(CacheBackedApplicationDAO.class);
    private ApplicationDAO appDAO;
    private static IdentityServiceProviderCache appCacheByName = null;
    private static ServiceProviderByInboundAuthCache appCacheByInboundAuth = null;
    private static ServiceProviderByIDCache appCacheByID = null;
    private static ServiceProviderByResourceIdCache appCacheByResourceId = null;
    private static ApplicationBasicInfoByResourceIdCache appBasicInfoCacheByResourceId = null;

    public CacheBackedApplicationDAO(ApplicationDAO appDAO) {
        this.appDAO = appDAO;
        appCacheByName = IdentityServiceProviderCache.getInstance();
        appCacheByInboundAuth = ServiceProviderByInboundAuthCache.getInstance();
        appCacheByID = ServiceProviderByIDCache.getInstance();
        appCacheByResourceId = ServiceProviderByResourceIdCache.getInstance();
        appBasicInfoCacheByResourceId = ApplicationBasicInfoByResourceIdCache.getInstance();
    }

    @Override
    public ServiceProvider getApplication(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = this.getApplicationFromCache(applicationName, tenantDomain);
        if (serviceProvider == null) {
            try {
                serviceProvider = this.appDAO.getApplication(applicationName, tenantDomain);
                if (serviceProvider != null) {
                    this.addToCache(serviceProvider, tenantDomain);
                }
            }
            catch (Exception e) {
                String error = "Error occurred while retrieving the application, " + applicationName;
                log.error((Object)error, (Throwable)e);
                throw new IdentityApplicationManagementException(error, (Throwable)e);
            }
        }
        return serviceProvider;
    }

    @Override
    public ServiceProvider getApplication(int appId) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = this.getApplicationFromCache(appId);
        if (serviceProvider == null) {
            serviceProvider = this.appDAO.getApplication(appId);
            if (serviceProvider == null) {
                throw new IdentityApplicationManagementException("Error while getting the service provider for appId: " + appId);
            }
            this.addToCache(serviceProvider, serviceProvider.getOwner().getTenantDomain());
        }
        return serviceProvider;
    }

    @Override
    public String getApplicationName(int applicationID) throws IdentityApplicationManagementException {
        ServiceProvider applicationFromCache = this.getApplicationFromCache(applicationID);
        if (applicationFromCache != null) {
            return applicationFromCache.getApplicationName();
        }
        return this.appDAO.getApplicationName(applicationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceProviderNameByClientId(String clientId, String type, String tenantDomain) throws IdentityApplicationManagementException {
        if (StringUtils.isEmpty((String)clientId)) {
            return null;
        }
        String appName = null;
        try {
            ServiceProviderCacheInboundAuthKey cacheKey;
            ServiceProviderCacheInboundAuthEntry entry;
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            if (tenantDomain != null && (entry = (ServiceProviderCacheInboundAuthEntry)((Object)appCacheByInboundAuth.getValueFromCache((Serializable)((Object)(cacheKey = new ServiceProviderCacheInboundAuthKey(clientId, type, tenantDomain)))))) != null) {
                appName = entry.getServiceProviderName();
            }
            if (appName == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inbound Auth Key Cache is missing for " + clientId));
                }
                appName = this.appDAO.getServiceProviderNameByClientId(clientId, type, tenantDomain);
                if (tenantDomain != null) {
                    ServiceProviderCacheInboundAuthKey clientKey = new ServiceProviderCacheInboundAuthKey(clientId, type, tenantDomain);
                    ServiceProviderCacheInboundAuthEntry clientEntry = new ServiceProviderCacheInboundAuthEntry(appName, tenantDomain);
                    appCacheByInboundAuth.addToCache((Serializable)((Object)clientKey), (Serializable)((Object)clientEntry));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Inbound Auth Key Cache is present for " + clientId));
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        return appName;
    }

    @Override
    public boolean isApplicationExists(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider applicationFromCache = this.getApplicationFromCache(applicationName, tenantDomain);
        if (applicationFromCache != null) {
            return true;
        }
        return this.appDAO.isApplicationExists(applicationName, tenantDomain);
    }

    @Override
    public int createApplication(ServiceProvider application, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.createApplication(application, tenantDomain);
    }

    @Override
    public void updateApplication(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider storedApp = this.getApplication(serviceProvider.getApplicationID());
        this.clearAllAppCache(storedApp, tenantDomain);
        this.appDAO.updateApplication(serviceProvider, tenantDomain);
    }

    @Override
    public void deleteApplication(String applicationName) throws IdentityApplicationManagementException {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ServiceProvider serviceProvider = this.getApplication(applicationName, tenantDomain);
        this.clearAllAppCache(serviceProvider, tenantDomain);
        this.appDAO.deleteApplication(applicationName);
    }

    @Override
    public ApplicationBasicInfo[] getAllApplicationBasicInfo() throws IdentityApplicationManagementException {
        return this.getApplicationBasicInfo("*");
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getApplicationBasicInfo(filter);
        }
        throw new UnsupportedOperationException("Get application basic info with filter not supported.");
    }

    @Override
    public ApplicationBasicInfo[] getAllPaginatedApplicationBasicInfo(int pageNumber) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getAllPaginatedApplicationBasicInfo(pageNumber);
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(int offset, int limit) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getApplicationBasicInfo(offset, limit);
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public ApplicationBasicInfo[] getPaginatedApplicationBasicInfo(int pageNumber, String filter) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getPaginatedApplicationBasicInfo(pageNumber, filter);
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter, int offset, int limit) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getApplicationBasicInfo(filter, offset, limit);
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public int getCountOfAllApplications() throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getCountOfAllApplications();
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public int getCountOfApplications(String filter) throws IdentityApplicationManagementException {
        if (this.appDAO instanceof PaginatableFilterableApplicationDAO) {
            return ((PaginatableFilterableApplicationDAO)this.appDAO).getCountOfApplications(filter);
        }
        throw new UnsupportedOperationException("This operation only supported in PaginatableFilterableApplicationDAO only.");
    }

    @Override
    public Map<String, String> getServiceProviderToLocalIdPClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider applicationFromCache = this.getApplicationFromCache(serviceProviderName, tenantDomain);
        if (applicationFromCache != null) {
            ClaimMapping[] claimMappings;
            HashMap<String, String> localIdPToSPClaimMapping = new HashMap<String, String>();
            ClaimConfig claimConfig = applicationFromCache.getClaimConfig();
            for (ClaimMapping claimMapping : claimMappings = claimConfig.getClaimMappings()) {
                localIdPToSPClaimMapping.put(claimMapping.getRemoteClaim().getClaimUri(), claimMapping.getLocalClaim().getClaimUri());
            }
            return localIdPToSPClaimMapping;
        }
        return this.appDAO.getServiceProviderToLocalIdPClaimMapping(serviceProviderName, tenantDomain);
    }

    @Override
    public Map<String, String> getLocalIdPToServiceProviderClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider applicationFromCache = this.getApplicationFromCache(serviceProviderName, tenantDomain);
        if (applicationFromCache != null) {
            ClaimMapping[] claimMappings;
            HashMap<String, String> localIdPToSPClaimMapping = new HashMap<String, String>();
            ClaimConfig claimConfig = applicationFromCache.getClaimConfig();
            for (ClaimMapping claimMapping : claimMappings = claimConfig.getClaimMappings()) {
                localIdPToSPClaimMapping.put(claimMapping.getLocalClaim().getClaimUri(), claimMapping.getRemoteClaim().getClaimUri());
            }
            return localIdPToSPClaimMapping;
        }
        return this.appDAO.getLocalIdPToServiceProviderClaimMapping(serviceProviderName, tenantDomain);
    }

    @Override
    public List<String> getAllRequestedClaimsByServiceProvider(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider applicationFromCache = this.getApplicationFromCache(serviceProviderName, tenantDomain);
        if (applicationFromCache != null) {
            ClaimMapping[] claimMappings;
            ArrayList<String> requestedLocalClaims = new ArrayList<String>();
            ClaimConfig claimConfig = applicationFromCache.getClaimConfig();
            for (ClaimMapping claimMapping : claimMappings = claimConfig.getClaimMappings()) {
                if (!claimMapping.isRequested()) continue;
                requestedLocalClaims.add(claimMapping.getLocalClaim().getClaimUri());
            }
            return requestedLocalClaims;
        }
        return this.appDAO.getAllRequestedClaimsByServiceProvider(serviceProviderName, tenantDomain);
    }

    @Override
    public ApplicationBasicInfo getApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationBasicInfo appBasicInfo = this.getApplicationBasicInfoFromCacheByResourceId(resourceId);
        if (appBasicInfo == null && (appBasicInfo = this.appDAO.getApplicationBasicInfoByResourceId(resourceId, tenantDomain)) != null) {
            this.addAppBasicInfoToCache(appBasicInfo, tenantDomain);
        }
        return appBasicInfo;
    }

    @Override
    public ServiceProvider getApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider application = this.getApplicationFromCacheByResourceId(resourceId);
        if (application == null && (application = this.appDAO.getApplicationByResourceId(resourceId, tenantDomain)) != null) {
            this.addToCache(application, tenantDomain);
        }
        return application;
    }

    @Override
    public String addApplication(ServiceProvider application, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.addApplication(application, tenantDomain);
    }

    @Override
    public void updateApplicationByResourceId(String resourceId, String tenantDomain, ServiceProvider updatedApp) throws IdentityApplicationManagementException {
        ServiceProvider storedApp = this.getApplicationByResourceId(resourceId, tenantDomain);
        this.clearAllAppCache(storedApp, tenantDomain);
        this.appDAO.updateApplicationByResourceId(resourceId, tenantDomain, updatedApp);
    }

    @Override
    public void deleteApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = this.getApplicationByResourceId(resourceId, tenantDomain);
        this.clearAllAppCache(serviceProvider, tenantDomain);
        this.appDAO.deleteApplicationByResourceId(resourceId, tenantDomain);
    }

    @Override
    public List<ApplicationBasicInfo> getDiscoverableApplicationBasicInfo(int limit, int offset, String filter, String sortOrder, String sortBy, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.getDiscoverableApplicationBasicInfo(limit, offset, filter, sortOrder, sortBy, tenantDomain);
    }

    @Override
    public int getCountOfDiscoverableApplications(String filter, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.getCountOfDiscoverableApplications(filter, tenantDomain);
    }

    @Override
    public ApplicationBasicInfo getDiscoverableApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.getDiscoverableApplicationBasicInfoByResourceId(resourceId, tenantDomain);
    }

    @Override
    public boolean isApplicationDiscoverable(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        return this.appDAO.isApplicationDiscoverable(resourceId, tenantDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add cache for the application " + serviceProvider.getApplicationName() + "@" + tenantDomain));
        }
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            IdentityServiceProviderCacheKey nameKey = new IdentityServiceProviderCacheKey(serviceProvider.getApplicationName(), tenantDomain);
            IdentityServiceProviderCacheEntry nameEntry = new IdentityServiceProviderCacheEntry(serviceProvider);
            appCacheByName.addToCache((Serializable)((Object)nameKey), (Serializable)((Object)nameEntry));
            ServiceProviderIDCacheKey idKey = new ServiceProviderIDCacheKey(serviceProvider.getApplicationID());
            ServiceProviderIDCacheEntry idEntry = new ServiceProviderIDCacheEntry(serviceProvider);
            appCacheByID.addToCache((Serializable)((Object)idKey), (Serializable)((Object)idEntry));
            ServiceProviderResourceIdCacheKey resourceIdCacheKey = new ServiceProviderResourceIdCacheKey(serviceProvider.getApplicationResourceId());
            ServiceProviderResourceIdCacheEntry entry = new ServiceProviderResourceIdCacheEntry(serviceProvider);
            appCacheByResourceId.addToCache((Serializable)((Object)resourceIdCacheKey), (Serializable)((Object)entry));
            if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
                InboundAuthenticationRequestConfig[] configs;
                for (InboundAuthenticationRequestConfig config : configs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                    if (config.getInboundAuthKey() == null) continue;
                    ServiceProviderCacheInboundAuthKey clientKey = new ServiceProviderCacheInboundAuthKey(config.getInboundAuthKey(), config.getInboundAuthType(), tenantDomain);
                    ServiceProviderCacheInboundAuthEntry clientEntry = new ServiceProviderCacheInboundAuthEntry(serviceProvider.getApplicationName(), tenantDomain);
                    appCacheByInboundAuth.addToCache((Serializable)((Object)clientKey), (Serializable)((Object)clientEntry));
                }
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppBasicInfoToCache(ApplicationBasicInfo appBasicInfo, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add cache for the application " + appBasicInfo.getApplicationName() + "@" + tenantDomain));
        }
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            ApplicationBasicInfoResourceIdCacheKey key = new ApplicationBasicInfoResourceIdCacheKey(appBasicInfo.getApplicationResourceId());
            ApplicationBasicInfoResourceIdCacheEntry entry = new ApplicationBasicInfoResourceIdCacheEntry(appBasicInfo);
            appBasicInfoCacheByResourceId.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProvider getApplicationFromCache(int appId) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = null;
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            ServiceProviderIDCacheKey cacheKey = new ServiceProviderIDCacheKey(appId);
            ServiceProviderIDCacheEntry entry = (ServiceProviderIDCacheEntry)((Object)appCacheByID.getValueFromCache((Serializable)((Object)cacheKey)));
            if (entry != null) {
                serviceProvider = entry.getServiceProvider();
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (serviceProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache missing for the application with id " + appId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache present for the application with id " + appId));
        }
        return serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProvider getApplicationFromCacheByResourceId(String resourceId) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = null;
        try {
            ServiceProviderResourceIdCacheKey cacheKey;
            ServiceProviderResourceIdCacheEntry entry;
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            if (resourceId != null && (entry = (ServiceProviderResourceIdCacheEntry)((Object)appCacheByResourceId.getValueFromCache((Serializable)((Object)(cacheKey = new ServiceProviderResourceIdCacheKey(resourceId)))))) != null) {
                serviceProvider = entry.getServiceProvider();
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (serviceProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for the application with resourceId: " + resourceId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache hit for the application with resourceId: " + resourceId));
        }
        return serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationBasicInfo getApplicationBasicInfoFromCacheByResourceId(String resourceId) throws IdentityApplicationManagementException {
        ApplicationBasicInfo applicationBasicInfo = null;
        try {
            ApplicationBasicInfoResourceIdCacheKey cacheKey;
            ApplicationBasicInfoResourceIdCacheEntry entry;
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            if (resourceId != null && (entry = (ApplicationBasicInfoResourceIdCacheEntry)((Object)appBasicInfoCacheByResourceId.getValueFromCache((Serializable)((Object)(cacheKey = new ApplicationBasicInfoResourceIdCacheKey(resourceId)))))) != null) {
                applicationBasicInfo = entry.getApplicationBasicInfo();
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (applicationBasicInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for the application with resourceId: " + resourceId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache hit for the application with resourceId: " + resourceId));
        }
        return applicationBasicInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProvider getApplicationFromCache(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = null;
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            if (StringUtils.isNotBlank((String)applicationName)) {
                IdentityServiceProviderCacheKey cacheKey = new IdentityServiceProviderCacheKey(applicationName, tenantDomain);
                IdentityServiceProviderCacheEntry entry = (IdentityServiceProviderCacheEntry)((Object)appCacheByName.getValueFromCache((Serializable)((Object)cacheKey)));
                if (entry != null) {
                    serviceProvider = entry.getServiceProvider();
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Provided application name is empty");
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (serviceProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache missing for the application " + applicationName + "@" + tenantDomain));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache is present for the application " + applicationName + "@" + tenantDomain));
        }
        return serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllAppCache(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing all the Service Provider Caches for " + serviceProvider.getApplicationName() + "@" + tenantDomain));
        }
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            IdentityServiceProviderCacheKey cacheKey = new IdentityServiceProviderCacheKey(serviceProvider.getApplicationName(), tenantDomain);
            appCacheByName.clearCacheEntry((Serializable)((Object)cacheKey));
            ServiceProviderIDCacheKey idKey = new ServiceProviderIDCacheKey(serviceProvider.getApplicationID());
            appCacheByID.clearCacheEntry((Serializable)((Object)idKey));
            ServiceProviderResourceIdCacheKey resourceIdKey = new ServiceProviderResourceIdCacheKey(serviceProvider.getApplicationResourceId());
            appCacheByResourceId.clearCacheEntry((Serializable)((Object)resourceIdKey));
            ApplicationBasicInfoResourceIdCacheKey basicInfoKey = new ApplicationBasicInfoResourceIdCacheKey(serviceProvider.getApplicationResourceId());
            appBasicInfoCacheByResourceId.clearCacheEntry((Serializable)((Object)basicInfoKey));
            this.clearAppCacheByInboundKey(serviceProvider, tenantDomain);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllAppCache(ServiceProvider serviceProvider, String updatedName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            IdentityServiceProviderCacheKey cacheKey = new IdentityServiceProviderCacheKey(updatedName, tenantDomain);
            appCacheByName.clearCacheEntry((Serializable)((Object)cacheKey));
            this.clearAllAppCache(serviceProvider, tenantDomain);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    private void clearAppCacheByInboundKey(ServiceProvider serviceProvider, String tenantDomain) {
        if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
            InboundAuthenticationRequestConfig[] configs;
            for (InboundAuthenticationRequestConfig config : configs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                if (config.getInboundAuthKey() == null) continue;
                ServiceProviderCacheInboundAuthKey clientKey = new ServiceProviderCacheInboundAuthKey(config.getInboundAuthKey(), config.getInboundAuthType(), tenantDomain);
                appCacheByInboundAuth.clearCacheEntry((Serializable)((Object)clientKey));
            }
        }
    }
}

