/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.SpTemplate;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationTemplateDAO;
import org.wso2.carbon.identity.application.mgt.util.JdbcUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;

public class ApplicationTemplateDAOImpl
implements ApplicationTemplateDAO {
    private static final Log log = LogFactory.getLog(ApplicationTemplateDAOImpl.class);

    @Override
    public void createApplicationTemplate(SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating application template: %s in tenant: %s", spTemplate.getName(), tenantDomain));
        }
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            jdbcTemplate.executeInsert("INSERT INTO SP_TEMPLATE (TENANT_ID, NAME, DESCRIPTION, CONTENT) VALUES (?, ?, ?, ?)", preparedStatement -> {
                preparedStatement.setInt(1, this.getTenantID(tenantDomain));
                preparedStatement.setString(2, spTemplate.getName());
                preparedStatement.setString(3, spTemplate.getDescription());
                try {
                    this.setBlobValue(spTemplate.getContent(), preparedStatement, 4);
                }
                catch (IOException e) {
                    throw new SQLException(String.format("Could not set application template: %s content as a Blob in tenant: %s.", spTemplate.getName(), tenantDomain), e);
                }
            }, null, true);
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException(String.format("Error while creating application template: %s in tenant: %s", spTemplate.getName(), tenantDomain), (Throwable)e);
        }
    }

    @Override
    public SpTemplate getApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        SpTemplate spTemplate;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Retrieving application template: %s in tenant: %s", templateName, tenantDomain));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            spTemplate = (SpTemplate)jdbcTemplate.fetchSingleRecord("SELECT DESCRIPTION, CONTENT FROM SP_TEMPLATE WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> {
                try {
                    return new SpTemplate(templateName, resultSet.getString(1), IOUtils.toString((InputStream)resultSet.getBinaryStream(2)));
                }
                catch (IOException e) {
                    throw new SQLException(String.format("Could not get application template: %s content as a Blob in tenant: %s.", templateName, tenantDomain), e);
                }
            }, preparedStatement -> {
                preparedStatement.setString(1, templateName);
                preparedStatement.setInt(2, this.getTenantID(tenantDomain));
            });
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException(String.format("Could not read the template information for template: %s in tenant: %s" + templateName, tenantDomain), (Throwable)e);
        }
        return spTemplate;
    }

    @Override
    public void deleteApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting application template: %s in tenant: %s", templateName, tenantDomain));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM SP_TEMPLATE WHERE NAME = ? AND TENANT_ID= ?", preparedStatement -> {
                preparedStatement.setString(1, templateName);
                preparedStatement.setInt(2, this.getTenantID(tenantDomain));
            });
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException(String.format("An error occurred while deleting the application template : %s in tenant: %s", templateName, tenantDomain), (Throwable)e);
        }
    }

    @Override
    public void updateApplicationTemplate(String templateName, SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Updating application template: %s in tenant: %s", spTemplate.getName(), tenantDomain));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("UPDATE SP_TEMPLATE SET NAME= ?,DESCRIPTION = ?,CONTENT = ? WHERE NAME = ? AND TENANT_ID = ?", preparedStatement -> {
                preparedStatement.setString(1, spTemplate.getName());
                preparedStatement.setString(2, spTemplate.getDescription());
                try {
                    this.setBlobValue(spTemplate.getContent(), preparedStatement, 3);
                }
                catch (IOException e) {
                    throw new SQLException(String.format("Could not set application template: %s content as a Blob in tenant: %s.", spTemplate.getName(), tenantDomain), e);
                }
                preparedStatement.setString(4, templateName);
                preparedStatement.setInt(5, this.getTenantID(tenantDomain));
            });
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException(String.format("An error occurred while updating the application template : %s in tenant: %s", spTemplate.getName(), tenantDomain), (Throwable)e);
        }
    }

    @Override
    public boolean isExistingTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Checking application template exists for name: %s in tenant: %s", templateName, tenantDomain));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            Integer count = (Integer)jdbcTemplate.fetchSingleRecord("SELECT COUNT(*) FROM SP_TEMPLATE WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> {
                preparedStatement.setString(1, templateName);
                preparedStatement.setInt(2, this.getTenantID(tenantDomain));
            });
            if (count == null) {
                return false;
            }
            return count > 0;
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException(String.format("Error while checking existence of application template: %s in tenant: %s", templateName, tenantDomain), (Throwable)e);
        }
    }

    @Override
    public List<SpTemplate> getAllApplicationTemplateInfo(String tenantDomain) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting all the application template basic info of tenant: " + tenantDomain));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            List spTemplateList = jdbcTemplate.executeQuery("SELECT NAME, DESCRIPTION FROM SP_TEMPLATE WHERE TENANT_ID = ?", (resultSet, i) -> new SpTemplate(resultSet.getString(1), resultSet.getString(2), null), preparedStatement -> preparedStatement.setInt(1, this.getTenantID(tenantDomain)));
            return spTemplateList;
        }
        catch (DataAccessException e) {
            throw new IdentityApplicationManagementException("Error while Loading all the application template basic info of tenant: " + tenantDomain, (Throwable)e);
        }
    }

    private void setBlobValue(String value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }

    private int getTenantID(String tenantDomain) {
        int tenantID = -1;
        if (tenantDomain != null) {
            tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        return tenantID;
    }
}

