/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.dao.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.database.utils.jdbc.NamedPreparedStatement;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementServerException;
import org.wso2.carbon.identity.application.common.IdentityApplicationRegistrationFailureException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.ApplicationPermission;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ConsentConfig;
import org.wso2.carbon.identity.application.common.model.ConsentPurpose;
import org.wso2.carbon.identity.application.common.model.ConsentPurposeConfigs;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.InboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.LocalRole;
import org.wso2.carbon.identity.application.common.model.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.ServiceProviderProperty;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.common.model.script.AuthenticationScriptConfig;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationConstants;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.AbstractInboundAuthenticatorConfig;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.application.mgt.dao.IdentityProviderDAO;
import org.wso2.carbon.identity.application.mgt.dao.PaginatableFilterableApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.impl.AbstractApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.OAuthApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.SAMLApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponent;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponentHolder;
import org.wso2.carbon.identity.core.CertificateRetrievingException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.DBUtils;

public class ApplicationDAOImpl
extends AbstractApplicationDAOImpl
implements PaginatableFilterableApplicationDAO {
    private static final String SP_PROPERTY_NAME_CERTIFICATE = "CERTIFICATE";
    private static final String APPLICATION_NAME_CONSTRAINT = "APPLICATION_NAME_CONSTRAINT";
    private Log log = LogFactory.getLog(ApplicationDAOImpl.class);
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static final String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Data : { %s } | Result :  %s ";
    private static final String AUDIT_SUCCESS = "Success";
    private static final String AUDIT_FAIL = "Fail";
    private List<String> standardInboundAuthTypes = new ArrayList<String>();
    public static final String USE_DOMAIN_IN_ROLES = "USE_DOMAIN_IN_ROLES";
    public static final String USE_DOMAIN_IN_ROLE_DISPLAY_NAME = "DOMAIN_IN_ROLES";

    public ApplicationDAOImpl() {
        this.standardInboundAuthTypes.add("oauth2");
        this.standardInboundAuthTypes.add("wstrust");
        this.standardInboundAuthTypes.add("samlsso");
        this.standardInboundAuthTypes.add("openid");
        this.standardInboundAuthTypes.add("passivests");
        this.standardInboundAuthTypes.add("kerberos");
    }

    private boolean isCustomInboundAuthType(String authType) {
        return !this.standardInboundAuthTypes.contains(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceProviderProperty> getServicePropertiesBySpId(Connection dbConnection, int spId) throws SQLException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<ServiceProviderProperty> idpProperties = new ArrayList<ServiceProviderProperty>();
        try {
            prepStmt = dbConnection.prepareStatement("SELECT ID, NAME, VALUE, DISPLAY_NAME FROM SP_METADATA WHERE SP_ID = ?");
            prepStmt.setInt(1, spId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                ServiceProviderProperty property = new ServiceProviderProperty();
                property.setName(rs.getString("NAME"));
                property.setValue(rs.getString("VALUE"));
                property.setDisplayName(rs.getString("DISPLAY_NAME"));
                idpProperties.add(property);
            }
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityApplicationManagementUtil.closeResultSet(rs);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
        return idpProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceProviderProperties(Connection dbConnection, int spId, List<ServiceProviderProperty> properties, int tenantId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("INSERT INTO SP_METADATA (SP_ID, NAME, VALUE, DISPLAY_NAME, TENANT_ID) VALUES (?, ?, ?, ?, ?)");
            for (ServiceProviderProperty property : properties) {
                if (StringUtils.isNotBlank((String)property.getValue())) {
                    prepStmt.setInt(1, spId);
                    prepStmt.setString(2, property.getName());
                    prepStmt.setString(3, property.getValue());
                    prepStmt.setString(4, property.getDisplayName());
                    prepStmt.setInt(5, tenantId);
                    prepStmt.addBatch();
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                String msg = "SP property '%s' of Sp with id: %d of tenantId: %d is empty or null. Not adding the property to 'SP_METADATA' table.";
                this.log.debug((Object)String.format(msg, property.getName(), spId, tenantId));
            }
            prepStmt.executeBatch();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceProviderProperties(Connection dbConnection, int spId, List<ServiceProviderProperty> properties, int tenantId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("DELETE FROM SP_METADATA WHERE SP_ID = ?");
            prepStmt.setInt(1, spId);
            prepStmt.executeUpdate();
            this.addServiceProviderProperties(dbConnection, spId, properties, tenantId);
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    @Override
    public int createApplication(ServiceProvider application, String tenantDomain) throws IdentityApplicationManagementException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        try {
            ApplicationCreateResult result = this.persistBasicApplicationInformation(connection, application, tenantDomain);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            int n = result.getApplicationId();
            return n;
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            if (this.isApplicationConflict(e)) {
                throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode(), "Application already exists with name: " + application.getApplicationName() + " in tenantDomain: " + tenantDomain);
            }
            throw new IdentityApplicationManagementException("Error while Creating Application", (Throwable)e);
        }
        finally {
            IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        }
    }

    private boolean isApplicationConflict(Exception e) {
        if (!(e instanceof SQLException)) {
            return false;
        }
        return e instanceof SQLIntegrityConstraintViolationException || StringUtils.containsIgnoreCase((String)e.getMessage(), (String)APPLICATION_NAME_CONSTRAINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationCreateResult persistBasicApplicationInformation(Connection connection, ServiceProvider application, String tenantDomain) throws SQLException {
        ApplicationCreateResult applicationCreateResult;
        int tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String qualifiedUsername = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if ("wso2carbon-local-sp".equals(application.getApplicationName())) {
            qualifiedUsername = "wso2.system.user";
        }
        String username = UserCoreUtil.removeDomainFromName((String)qualifiedUsername);
        String userStoreDomain = IdentityUtil.extractDomainFromName((String)qualifiedUsername);
        String applicationName = application.getApplicationName();
        String description = application.getDescription();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating Application " + applicationName + " for user " + qualifiedUsername));
        }
        PreparedStatement storeAppPrepStmt = null;
        ResultSet results = null;
        try {
            ServiceProviderProperty[] spProperties;
            String resourceId = this.generateApplicationResourceId(application);
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            storeAppPrepStmt = connection.prepareStatement("INSERT INTO SP_APP (TENANT_ID, APP_NAME, USER_STORE, USERNAME, DESCRIPTION, AUTH_TYPE, IS_USE_TENANT_DOMAIN_SUBJECT, ENABLE_AUTHORIZATION,IS_USE_USER_DOMAIN_SUBJECT, UUID, IMAGE_URL, ACCESS_URL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            storeAppPrepStmt.setInt(1, tenantID);
            storeAppPrepStmt.setString(2, applicationName);
            storeAppPrepStmt.setString(3, userStoreDomain);
            storeAppPrepStmt.setString(4, username);
            storeAppPrepStmt.setString(5, description);
            storeAppPrepStmt.setString(6, "default");
            storeAppPrepStmt.setString(7, "0");
            storeAppPrepStmt.setString(8, "0");
            storeAppPrepStmt.setString(9, "0");
            storeAppPrepStmt.setString(10, resourceId);
            storeAppPrepStmt.setString(11, application.getImageUrl());
            storeAppPrepStmt.setString(12, application.getAccessUrl());
            storeAppPrepStmt.execute();
            results = storeAppPrepStmt.getGeneratedKeys();
            int applicationId = 0;
            if (results.next()) {
                applicationId = results.getInt(1);
            }
            if (applicationId == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"JDBC Driver did not return the application id, executing Select operation");
                }
                applicationId = this.getApplicationIDByName(applicationName, tenantID, connection);
            }
            if ((spProperties = application.getSpProperties()) != null) {
                this.addServiceProviderProperties(connection, applicationId, Arrays.asList(spProperties), tenantID);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Application Stored successfully with applicationId: " + applicationId + " and applicationResourceId: " + resourceId));
            }
            applicationCreateResult = new ApplicationCreateResult(resourceId, applicationId);
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeResultSet(results);
            IdentityApplicationManagementUtil.closeStatement(storeAppPrepStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)results);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeAppPrepStmt);
        return applicationCreateResult;
    }

    @Override
    public void updateApplication(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        int applicationId = serviceProvider.getApplicationID();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        try {
            this.deleteApplicationConfigurations(connection, serviceProvider, applicationId);
            this.addApplicationConfigurations(connection, serviceProvider, tenantDomain);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException | UserStoreException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new IdentityApplicationManagementException("Failed to update application id: " + applicationId, e);
        }
        finally {
            IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        }
    }

    private void addApplicationConfigurations(Connection connection, ServiceProvider serviceProvider, String tenantDomain) throws SQLException, UserStoreException, IdentityApplicationManagementException {
        int applicationId = serviceProvider.getApplicationID();
        int tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProvider.getApplicationName())) {
            throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode(), "Application with name: " + serviceProvider.getApplicationName() + "loaded from the file system.");
        }
        this.updateBasicApplicationData(serviceProvider, connection);
        this.updateApplicationCertificate(serviceProvider, tenantID, connection);
        this.updateInboundProvisioningConfiguration(applicationId, serviceProvider.getInboundProvisioningConfig(), connection);
        this.updateInboundAuthRequestConfiguration(serviceProvider.getApplicationID(), serviceProvider.getInboundAuthenticationConfig(), connection);
        this.updateLocalAndOutboundAuthenticationConfiguration(serviceProvider.getApplicationID(), serviceProvider.getLocalAndOutBoundAuthenticationConfig(), connection);
        this.updateRequestPathAuthenticators(applicationId, serviceProvider.getRequestPathAuthenticatorConfigs(), connection);
        this.updateClaimConfiguration(serviceProvider.getApplicationID(), serviceProvider.getClaimConfig(), applicationId, connection);
        this.updateOutboundProvisioningConfiguration(applicationId, serviceProvider.getOutboundProvisioningConfig(), connection);
        if (serviceProvider.getPermissionAndRoleConfig() != null) {
            this.updatePermissionAndRoleConfiguration(serviceProvider.getApplicationID(), serviceProvider.getPermissionAndRoleConfig(), connection);
            this.deleteAssignedPermissions(connection, serviceProvider.getApplicationName(), serviceProvider.getPermissionAndRoleConfig().getPermissions());
        }
        this.updateConfigurationsAsServiceProperties(serviceProvider);
        if (ArrayUtils.isNotEmpty((Object[])serviceProvider.getSpProperties())) {
            ServiceProviderProperty[] spProperties = serviceProvider.getSpProperties();
            this.updateServiceProviderProperties(connection, applicationId, Arrays.asList(spProperties), tenantID);
        }
    }

    private void deleteApplicationConfigurations(Connection connection, ServiceProvider serviceProvider, int applicationId) throws SQLException {
        this.deleteInboundAuthRequestConfiguration(serviceProvider.getApplicationID(), connection);
        this.deleteLocalAndOutboundAuthenticationConfiguration(applicationId, connection);
        this.deleteRequestPathAuthenticators(applicationId, connection);
        this.deleteClaimConfiguration(applicationId, connection);
        this.deleteOutboundProvisioningConfiguration(applicationId, connection);
        this.deletePermissionAndRoleConfiguration(applicationId, connection);
    }

    private void deleteConsentPurposeConfiguration(Connection connection, int applicationId, int tenantId) throws IdentityApplicationManagementException {
        try (PreparedStatement ps = connection.prepareStatement("DELETE FROM SP_CONSENT_PURPOSE_ASSOC WHERE APP_ID = ? AND TENANT_ID = ?");){
            ps.setInt(1, applicationId);
            ps.setInt(2, tenantId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while removing existing consent purposes for ApplicationId: " + applicationId + " and TenantId: " + tenantId, (Throwable)e);
        }
    }

    private void updateConsentPurposeConfiguration(Connection connection, int applicationId, ConsentConfig consentConfig, int tenantID) throws IdentityApplicationManagementException {
        try (PreparedStatement pst = connection.prepareStatement("UPDATE SP_APP SET IS_CONSENT_MGT_ENABLED = ? WHERE TENANT_ID= ? AND ID = ?");){
            pst.setString(1, consentConfig.isEnabled() ? "1" : "0");
            pst.setInt(2, tenantID);
            pst.setInt(3, applicationId);
            pst.executeUpdate();
        }
        catch (SQLException e) {
            String error = String.format("Error while setting consentEnabled: %s for applicationId: %s in tenantId: %s", Boolean.toString(consentConfig.isEnabled()), applicationId, tenantID);
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        ConsentPurposeConfigs consentPurposeConfigs = consentConfig.getConsentPurposeConfigs();
        if (Objects.isNull(consentPurposeConfigs)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ConsentPurposeConfigs entry is null for application ID: " + applicationId));
            }
            return;
        }
        ConsentPurpose[] consentPurposes = consentPurposeConfigs.getConsentPurpose();
        if (Objects.isNull(consentPurposes)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ConsentPurpose entry is null for application ID: " + applicationId));
            }
            return;
        }
        for (ConsentPurpose consentPurpose : consentPurposes) {
            try (PreparedStatement ps = connection.prepareStatement("INSERT INTO SP_CONSENT_PURPOSE_ASSOC (APP_ID, PURPOSE_ID, DISPLAY_ORDER, TENANT_ID) VALUES (?, ?, ?, ?)");){
                ps.setInt(1, applicationId);
                ps.setInt(2, consentPurpose.getPurposeId());
                ps.setInt(3, consentPurpose.getDisplayOrder());
                ps.setInt(4, tenantID);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String error = String.format("Error while persisting consent purposeId: %s for applicationId: %s in tenantId: %s", consentPurpose.getPurposeId(), applicationId, tenantID);
                throw new IdentityApplicationManagementException(error, (Throwable)e);
            }
        }
    }

    private void updateApplicationCertificate(ServiceProvider serviceProvider, int tenantID, Connection connection) throws SQLException, IdentityApplicationManagementException {
        if (StringUtils.isBlank((String)serviceProvider.getCertificateContent())) {
            ServiceProviderProperty[] serviceProviderProperties = serviceProvider.getSpProperties();
            if (serviceProviderProperties != null) {
                int certificateReferenceIdIndex = -1;
                String certificateReferenceId = null;
                for (int i = 0; i < serviceProviderProperties.length; ++i) {
                    if (!SP_PROPERTY_NAME_CERTIFICATE.equals(serviceProviderProperties[i].getName())) continue;
                    certificateReferenceIdIndex = i;
                    certificateReferenceId = serviceProviderProperties[i].getValue();
                    break;
                }
                if (certificateReferenceIdIndex > -1) {
                    ServiceProviderProperty[] propertiesWithoutCertificateReference = new ServiceProviderProperty[serviceProviderProperties.length - 1];
                    System.arraycopy(serviceProviderProperties, 0, propertiesWithoutCertificateReference, 0, certificateReferenceIdIndex);
                    System.arraycopy(serviceProviderProperties, certificateReferenceIdIndex + 1, propertiesWithoutCertificateReference, certificateReferenceIdIndex, propertiesWithoutCertificateReference.length - certificateReferenceIdIndex);
                    serviceProvider.setSpProperties(propertiesWithoutCertificateReference);
                    this.deleteCertificate(connection, Integer.parseInt(certificateReferenceId));
                }
            }
        } else {
            ServiceProviderProperty[] serviceProviderProperties = serviceProvider.getSpProperties();
            String certificateReferenceIdString = this.getCertificateReferenceID(serviceProviderProperties);
            if (certificateReferenceIdString != null) {
                PreparedStatement statementToUpdateCertificate = null;
                try {
                    statementToUpdateCertificate = connection.prepareStatement("UPDATE IDN_CERTIFICATE SET CERTIFICATE_IN_PEM = ? WHERE ID = ?");
                    this.setBlobValue(serviceProvider.getCertificateContent(), statementToUpdateCertificate, 1);
                    statementToUpdateCertificate.setInt(2, Integer.parseInt(certificateReferenceIdString));
                    statementToUpdateCertificate.executeUpdate();
                }
                catch (IOException e) {
                    throw new IdentityApplicationManagementException("An error occurred while processing content stream of certificate.", (Throwable)e);
                }
                finally {
                    IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementToUpdateCertificate);
                }
            } else {
                this.persistApplicationCertificate(serviceProvider, tenantID, connection);
            }
        }
    }

    private String getCertificateReferenceID(ServiceProviderProperty[] serviceProviderProperties) {
        String certificateReferenceId = null;
        if (serviceProviderProperties != null) {
            for (ServiceProviderProperty property : serviceProviderProperties) {
                if (!SP_PROPERTY_NAME_CERTIFICATE.equals(property.getName())) continue;
                certificateReferenceId = property.getValue();
            }
        }
        return certificateReferenceId;
    }

    private void persistApplicationCertificate(ServiceProvider serviceProvider, int tenantID, Connection connection) throws SQLException, IdentityApplicationManagementException {
        PreparedStatement statementToAddCertificate = null;
        ResultSet results = null;
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            statementToAddCertificate = connection.prepareStatement("INSERT INTO IDN_CERTIFICATE(NAME, CERTIFICATE_IN_PEM, TENANT_ID) VALUES(?, ?, ?)", new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            statementToAddCertificate.setString(1, serviceProvider.getApplicationName());
            this.setBlobValue(serviceProvider.getCertificateContent(), statementToAddCertificate, 2);
            statementToAddCertificate.setInt(3, tenantID);
            statementToAddCertificate.execute();
            results = statementToAddCertificate.getGeneratedKeys();
            int newlyAddedCertificateID = 0;
            if (results.next()) {
                newlyAddedCertificateID = results.getInt(1);
            }
            if (newlyAddedCertificateID == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"JDBC Driver did not return the application id, executing Select operation");
                }
                newlyAddedCertificateID = this.getCertificateIDByName(serviceProvider.getApplicationName(), tenantID, connection);
            }
            this.addApplicationCertificateReferenceAsServiceProviderProperty(serviceProvider, newlyAddedCertificateID);
        }
        catch (IOException e) {
            try {
                throw new IdentityApplicationManagementException("An error occurred while processing content stream of certificate.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(results);
                IdentityApplicationManagementUtil.closeStatement(statementToAddCertificate);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)results);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementToAddCertificate);
    }

    private void addApplicationCertificateReferenceAsServiceProviderProperty(ServiceProvider serviceProvider, int newlyAddedCertificateID) {
        ServiceProviderProperty[] newServiceProviderProperties;
        ServiceProviderProperty[] serviceProviderProperties = serviceProvider.getSpProperties();
        if (serviceProviderProperties != null) {
            newServiceProviderProperties = new ServiceProviderProperty[serviceProviderProperties.length + 1];
            for (int i = 0; i < serviceProviderProperties.length; ++i) {
                newServiceProviderProperties[i] = serviceProviderProperties[i];
            }
        } else {
            newServiceProviderProperties = new ServiceProviderProperty[1];
        }
        ServiceProviderProperty propertyForCertificate = new ServiceProviderProperty();
        propertyForCertificate.setDisplayName(SP_PROPERTY_NAME_CERTIFICATE);
        propertyForCertificate.setName(SP_PROPERTY_NAME_CERTIFICATE);
        propertyForCertificate.setValue(String.valueOf(newlyAddedCertificateID));
        newServiceProviderProperties[newServiceProviderProperties.length - 1] = propertyForCertificate;
        serviceProvider.setSpProperties(newServiceProviderProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCertificateIDByName(String applicationName, int tenantID, Connection connection) throws SQLException {
        int n;
        PreparedStatement statementToGetCertificateId = null;
        ResultSet results = null;
        try {
            statementToGetCertificateId = connection.prepareStatement("SELECT ID FROM IDN_CERTIFICATE WHERE NAME = ? AND TENANT_ID = ?");
            statementToGetCertificateId.setString(1, applicationName);
            statementToGetCertificateId.setInt(2, tenantID);
            results = statementToGetCertificateId.executeQuery();
            int applicationId = -1;
            while (results.next()) {
                applicationId = results.getInt(1);
            }
            n = applicationId;
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeResultSet(results);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementToGetCertificateId);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)results);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementToGetCertificateId);
        return n;
    }

    private void updateBasicApplicationData(ServiceProvider serviceProvider, Connection connection) throws SQLException, UserStoreException, IdentityApplicationManagementException {
        boolean isValidUserForOwnerUpdate;
        int applicationId = serviceProvider.getApplicationID();
        String applicationName = serviceProvider.getApplicationName();
        String description = serviceProvider.getDescription();
        boolean isSaasApp = serviceProvider.isSaasApp();
        boolean isDiscoverable = serviceProvider.isDiscoverable();
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String storedAppName = null;
        if (applicationName == null) {
            throw new IdentityApplicationManagementException("Application Name is required.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating Application with id: " + applicationId));
        }
        storedAppName = this.getApplicationName(applicationId, connection);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stored application name for id: " + applicationId + " is " + storedAppName));
        }
        if (!StringUtils.equals((String)applicationName, (String)storedAppName)) {
            String applicationNameforRole = IdentityUtil.addDomainToName((String)applicationName, (String)"Application");
            String storedAppNameforRole = IdentityUtil.addDomainToName((String)storedAppName, (String)"Application");
            ApplicationMgtUtil.renameRole(storedAppNameforRole, applicationNameforRole);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Renaming application role from " + storedAppName + " to " + applicationName));
            }
            Map<String, String> applicationPermissions = this.readApplicationPermissions(storedAppName);
            for (Map.Entry entry : applicationPermissions.entrySet()) {
                this.updatePermissionPath((String)entry.getKey(), ((String)entry.getValue()).replace(storedAppName.toLowerCase(), applicationName.toLowerCase()));
            }
        }
        String sql = (isValidUserForOwnerUpdate = ApplicationMgtUtil.isValidApplicationOwner(serviceProvider)) ? "UPDATE SP_APP SET APP_NAME=:APP_NAME;, DESCRIPTION=:DESCRIPTION;, IS_SAAS_APP=:IS_SAAS_APP;, IS_DISCOVERABLE=:IS_DISCOVERABLE;, USERNAME=:USERNAME;, USER_STORE=:USER_STORE;, IMAGE_URL=:IMAGE_URL;, ACCESS_URL=:ACCESS_URL; WHERE TENANT_ID=:TENANT_ID; AND ID=:ID;" : "UPDATE SP_APP SET APP_NAME=:APP_NAME;, DESCRIPTION=:DESCRIPTION;, IS_SAAS_APP=:IS_SAAS_APP;, IS_DISCOVERABLE=:IS_DISCOVERABLE;, IMAGE_URL=:IMAGE_URL;, ACCESS_URL=:ACCESS_URL; WHERE TENANT_ID=:TENANT_ID; AND ID=:ID;";
        NamedPreparedStatement statement = new NamedPreparedStatement(connection, sql);
        Object object = null;
        try {
            statement.setString("APP_NAME", applicationName);
            statement.setString("DESCRIPTION", description);
            statement.setString("IS_SAAS_APP", isSaasApp ? "1" : "0");
            statement.setString("IS_DISCOVERABLE", isDiscoverable ? "1" : "0");
            statement.setString("IMAGE_URL", serviceProvider.getImageUrl());
            statement.setString("ACCESS_URL", serviceProvider.getAccessUrl());
            if (isValidUserForOwnerUpdate) {
                User throwable = serviceProvider.getOwner();
                statement.setString("USERNAME", throwable.getUserName());
                statement.setString("USER_STORE", throwable.getUserStoreDomain());
            }
            statement.setInt("TENANT_ID", tenantID);
            statement.setInt("ID", applicationId);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (statement != null) {
                if (object != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    statement.close();
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantID);
            this.log.debug((Object)("Application with name: " + applicationName + " , id: " + applicationId + " in tenantDomain: " + tenantDomain + " updated successfully."));
        }
    }

    private List<Property> filterEmptyProperties(Property[] propertiesArray) {
        ArrayList<Property> propertyArrayList = new ArrayList<Property>();
        if (ArrayUtils.isNotEmpty((Object[])propertiesArray)) {
            for (Property property : propertiesArray) {
                if (property == null || !StringUtils.isNotBlank((String)property.getValue())) continue;
                propertyArrayList.add(property);
            }
        }
        return propertyArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInboundAuthRequestConfiguration(int applicationId, InboundAuthenticationConfig inBoundAuthenticationConfig, Connection connection) throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement inboundAuthReqConfigPrepStmt = null;
        try {
            InboundAuthenticationRequestConfig[] authRequests;
            if (inBoundAuthenticationConfig == null || inBoundAuthenticationConfig.getInboundAuthenticationRequestConfigs() == null || inBoundAuthenticationConfig.getInboundAuthenticationRequestConfigs().length == 0) {
                return;
            }
            inboundAuthReqConfigPrepStmt = connection.prepareStatement("INSERT INTO SP_INBOUND_AUTH (TENANT_ID, INBOUND_AUTH_KEY,INBOUND_AUTH_TYPE,PROP_NAME, PROP_VALUE, APP_ID,INBOUND_CONFIG_TYPE) VALUES (?,?,?,?,?,?,?)");
            for (InboundAuthenticationRequestConfig authRequest : authRequests = inBoundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) {
                String applicationName;
                if (authRequest == null || authRequest.getInboundAuthType() == null) {
                    this.log.warn((Object)"Invalid in-bound authentication request");
                    continue;
                }
                Property[] propertiesArray = authRequest.getProperties();
                List<Object> propertyArrayList = new ArrayList();
                String authKey = null;
                String inboundConfigType = "standardAPP";
                if (this.standardInboundAuthTypes.contains(authRequest.getInboundAuthType())) {
                    authKey = authRequest.getInboundAuthKey();
                    propertyArrayList = this.filterEmptyProperties(propertiesArray);
                } else {
                    AbstractInboundAuthenticatorConfig inboundAuthenticatorConfig = ApplicationManagementServiceComponentHolder.getInboundAuthenticatorConfig(authRequest.getInboundAuthType() + ":" + authRequest.getInboundConfigType());
                    if (inboundAuthenticatorConfig != null && StringUtils.isNotBlank((String)inboundAuthenticatorConfig.getRelyingPartyKey())) {
                        if (propertiesArray != null && propertiesArray.length > 0) {
                            for (Property prop : propertiesArray) {
                                if (inboundAuthenticatorConfig.getRelyingPartyKey().equals(prop.getName())) {
                                    if (!StringUtils.isNotBlank((String)prop.getValue())) continue;
                                    authKey = prop.getValue();
                                    continue;
                                }
                                if (!StringUtils.isNotBlank((String)prop.getValue())) continue;
                                propertyArrayList.add(prop);
                            }
                        }
                    } else {
                        propertyArrayList = this.filterEmptyProperties(propertiesArray);
                    }
                }
                if (StringUtils.isBlank((String)authKey) && StringUtils.isNotBlank((String)(applicationName = this.getApplicationName(applicationId, connection)))) {
                    authKey = applicationName;
                }
                if (StringUtils.isNotBlank((String)authRequest.getInboundConfigType())) {
                    inboundConfigType = authRequest.getInboundConfigType();
                }
                if (!propertyArrayList.isEmpty()) {
                    for (Property property : propertyArrayList) {
                        inboundAuthReqConfigPrepStmt.setInt(1, tenantID);
                        inboundAuthReqConfigPrepStmt.setString(2, authKey);
                        inboundAuthReqConfigPrepStmt.setString(3, authRequest.getInboundAuthType());
                        inboundAuthReqConfigPrepStmt.setString(4, property.getName());
                        inboundAuthReqConfigPrepStmt.setString(5, property.getValue());
                        inboundAuthReqConfigPrepStmt.setInt(6, applicationId);
                        inboundAuthReqConfigPrepStmt.setString(7, inboundConfigType);
                        inboundAuthReqConfigPrepStmt.addBatch();
                    }
                } else {
                    inboundAuthReqConfigPrepStmt.setInt(1, tenantID);
                    inboundAuthReqConfigPrepStmt.setString(2, authKey);
                    inboundAuthReqConfigPrepStmt.setString(3, authRequest.getInboundAuthType());
                    inboundAuthReqConfigPrepStmt.setString(4, null);
                    inboundAuthReqConfigPrepStmt.setString(5, null);
                    inboundAuthReqConfigPrepStmt.setInt(6, applicationId);
                    inboundAuthReqConfigPrepStmt.setString(7, inboundConfigType);
                    inboundAuthReqConfigPrepStmt.addBatch();
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Updating inbound authentication request configuration of the application " + applicationId + "inbound auth key: " + authRequest.getInboundAuthKey() + " inbound auth type: " + authRequest.getInboundAuthType()));
            }
            inboundAuthReqConfigPrepStmt.executeBatch();
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)inboundAuthReqConfigPrepStmt);
        }
        catch (SQLException e) {
            this.log.error((Object)"Error occurred while updating the Inbound Authentication Request Configuration.", (Throwable)e);
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement(inboundAuthReqConfigPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInboundProvisioningConfiguration(int applicationId, InboundProvisioningConfig inBoundProvisioningConfig, Connection connection) throws SQLException {
        if (inBoundProvisioningConfig == null) {
            return;
        }
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement inboundProConfigPrepStmt = null;
        try {
            inboundProConfigPrepStmt = connection.prepareStatement("UPDATE SP_APP SET PROVISIONING_USERSTORE_DOMAIN=?, IS_DUMB_MODE=? WHERE TENANT_ID= ? AND ID = ?");
            inboundProConfigPrepStmt.setString(1, inBoundProvisioningConfig.getProvisioningUserStore());
            inboundProConfigPrepStmt.setString(2, inBoundProvisioningConfig.isDumbMode() ? "1" : "0");
            inboundProConfigPrepStmt.setInt(3, tenantID);
            inboundProConfigPrepStmt.setInt(4, applicationId);
            inboundProConfigPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)inboundProConfigPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutboundProvisioningConfiguration(int applicationId, OutboundProvisioningConfig outBoundProvisioningConfig, Connection connection) throws SQLException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement outboundProConfigPrepStmt = null;
        if (outBoundProvisioningConfig != null) {
            Object[] proProviders;
            block8: {
                proProviders = outBoundProvisioningConfig.getProvisioningIdentityProviders();
                if (!ArrayUtils.isEmpty((Object[])proProviders)) break block8;
                IdentityApplicationManagementUtil.closeStatement(outboundProConfigPrepStmt);
                return;
            }
            try {
                outboundProConfigPrepStmt = connection.prepareStatement("INSERT INTO SP_PROVISIONING_CONNECTOR (TENANT_ID, IDP_NAME, CONNECTOR_NAME, APP_ID,IS_JIT_ENABLED, BLOCKING, RULE_ENABLED) VALUES (?,?,?,?,?,?,?)");
                for (Object proProvider : proProviders) {
                    ProvisioningConnectorConfig proConnector;
                    if (proProvider == null || (proConnector = proProvider.getDefaultProvisioningConnectorConfig()) == null) continue;
                    String jitEnabled = "0";
                    if (proProvider.getJustInTimeProvisioningConfig() != null && proProvider.getJustInTimeProvisioningConfig().isProvisioningEnabled()) {
                        jitEnabled = "1";
                    }
                    String blocking = "0";
                    if (proProvider.getDefaultProvisioningConnectorConfig() != null && proProvider.getDefaultProvisioningConnectorConfig().isBlocking()) {
                        blocking = "1";
                    }
                    String ruleEnabled = "0";
                    if (proProvider.getDefaultProvisioningConnectorConfig() != null && proProvider.getDefaultProvisioningConnectorConfig().isRulesEnabled()) {
                        ruleEnabled = "1";
                    }
                    outboundProConfigPrepStmt.setInt(1, tenantID);
                    outboundProConfigPrepStmt.setString(2, proProvider.getIdentityProviderName());
                    outboundProConfigPrepStmt.setString(3, proConnector.getName());
                    outboundProConfigPrepStmt.setInt(4, applicationId);
                    outboundProConfigPrepStmt.setString(5, jitEnabled);
                    outboundProConfigPrepStmt.setString(6, blocking);
                    outboundProConfigPrepStmt.setString(7, ruleEnabled);
                    outboundProConfigPrepStmt.addBatch();
                }
                outboundProConfigPrepStmt.executeBatch();
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(outboundProConfigPrepStmt);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)outboundProConfigPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InboundProvisioningConfig getInboundProvisioningConfiguration(int applicationId, Connection connection, int tenantID) throws SQLException {
        PreparedStatement inboundProConfigPrepStmt = null;
        InboundProvisioningConfig inBoundProvisioningConfig = new InboundProvisioningConfig();
        ResultSet resultSet = null;
        try {
            inboundProConfigPrepStmt = connection.prepareStatement("SELECT PROVISIONING_USERSTORE_DOMAIN, IS_DUMB_MODE FROM SP_APP WHERE TENANT_ID= ? AND ID = ?");
            inboundProConfigPrepStmt.setInt(1, tenantID);
            inboundProConfigPrepStmt.setInt(2, applicationId);
            resultSet = inboundProConfigPrepStmt.executeQuery();
            while (resultSet.next()) {
                inBoundProvisioningConfig.setProvisioningUserStore(resultSet.getString(1));
                inBoundProvisioningConfig.setDumbMode("1".equals(resultSet.getString(2)));
            }
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)inboundProConfigPrepStmt);
        }
        return inBoundProvisioningConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundProvisioningConfig getOutboundProvisioningConfiguration(int applicationId, Connection connection, int tenantID) throws SQLException {
        PreparedStatement outboundProConfigPrepStmt = null;
        OutboundProvisioningConfig outBoundProvisioningConfig = new OutboundProvisioningConfig();
        ResultSet resultSet = null;
        ArrayList<IdentityProvider> idpProConnectors = new ArrayList<IdentityProvider>();
        try {
            outboundProConfigPrepStmt = connection.prepareStatement("SELECT IDP_NAME, CONNECTOR_NAME, IS_JIT_ENABLED, BLOCKING, RULE_ENABLED FROM SP_PROVISIONING_CONNECTOR WHERE APP_ID = ? AND TENANT_ID = ?");
            outboundProConfigPrepStmt.setInt(1, applicationId);
            outboundProConfigPrepStmt.setInt(2, tenantID);
            resultSet = outboundProConfigPrepStmt.executeQuery();
            while (resultSet.next()) {
                ProvisioningConnectorConfig proConnector = null;
                IdentityProvider fedIdp = null;
                fedIdp = new IdentityProvider();
                fedIdp.setIdentityProviderName(resultSet.getString(1));
                proConnector = new ProvisioningConnectorConfig();
                proConnector.setName(resultSet.getString(2));
                if ("1".equals(resultSet.getString(3))) {
                    JustInTimeProvisioningConfig jitConfig = new JustInTimeProvisioningConfig();
                    jitConfig.setProvisioningEnabled(true);
                    fedIdp.setJustInTimeProvisioningConfig(jitConfig);
                }
                if ("1".equals(resultSet.getString(4))) {
                    proConnector.setBlocking(true);
                } else {
                    proConnector.setBlocking(false);
                }
                if ("1".equals(resultSet.getString(5))) {
                    proConnector.setRulesEnabled(true);
                } else {
                    proConnector.setRulesEnabled(false);
                }
                fedIdp.setDefaultProvisioningConnectorConfig(proConnector);
                idpProConnectors.add(fedIdp);
            }
            outBoundProvisioningConfig.setProvisioningIdentityProviders(idpProConnectors.toArray(new IdentityProvider[idpProConnectors.size()]));
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)outboundProConfigPrepStmt);
        }
        return outBoundProvisioningConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalAndOutboundAuthenticationConfiguration(int applicationId, LocalAndOutboundAuthenticationConfig localAndOutboundAuthConfig, Connection connection) throws SQLException, IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (localAndOutboundAuthConfig == null) {
            return;
        }
        this.updateAuthenticationScriptConfiguration(applicationId, localAndOutboundAuthConfig, connection, tenantID);
        PreparedStatement updateAuthTypePrepStmt = null;
        PreparedStatement storeSendAuthListOfIdPsPrepStmt = null;
        try {
            storeSendAuthListOfIdPsPrepStmt = connection.prepareStatement("UPDATE SP_APP SET IS_SEND_AUTH_LIST_OF_IDPS=? WHERE TENANT_ID= ? AND ID = ?");
            storeSendAuthListOfIdPsPrepStmt.setString(1, localAndOutboundAuthConfig.isAlwaysSendBackAuthenticatedListOfIdPs() ? "1" : "0");
            storeSendAuthListOfIdPsPrepStmt.setInt(2, tenantID);
            storeSendAuthListOfIdPsPrepStmt.setInt(3, applicationId);
            storeSendAuthListOfIdPsPrepStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeSendAuthListOfIdPsPrepStmt);
        }
        PreparedStatement storeUseTenantDomainInLocalSubjectIdStmt = null;
        try {
            storeUseTenantDomainInLocalSubjectIdStmt = connection.prepareStatement("UPDATE SP_APP SET IS_USE_TENANT_DOMAIN_SUBJECT=? WHERE TENANT_ID= ? AND ID = ?");
            storeUseTenantDomainInLocalSubjectIdStmt.setString(1, localAndOutboundAuthConfig.isUseTenantDomainInLocalSubjectIdentifier() ? "1" : "0");
            storeUseTenantDomainInLocalSubjectIdStmt.setInt(2, tenantID);
            storeUseTenantDomainInLocalSubjectIdStmt.setInt(3, applicationId);
            storeUseTenantDomainInLocalSubjectIdStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeUseTenantDomainInLocalSubjectIdStmt);
        }
        PreparedStatement storeUseUserstoreDomainInLocalSubjectIdStmt = null;
        try {
            storeUseUserstoreDomainInLocalSubjectIdStmt = connection.prepareStatement("UPDATE SP_APP SET IS_USE_USER_DOMAIN_SUBJECT=? WHERE TENANT_ID= ? AND ID = ?");
            storeUseUserstoreDomainInLocalSubjectIdStmt.setString(1, localAndOutboundAuthConfig.isUseUserstoreDomainInLocalSubjectIdentifier() ? "1" : "0");
            storeUseUserstoreDomainInLocalSubjectIdStmt.setInt(2, tenantID);
            storeUseUserstoreDomainInLocalSubjectIdStmt.setInt(3, applicationId);
            storeUseUserstoreDomainInLocalSubjectIdStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeUseUserstoreDomainInLocalSubjectIdStmt);
        }
        PreparedStatement enableAuthzStmt = null;
        try {
            enableAuthzStmt = connection.prepareStatement("UPDATE SP_APP SET ENABLE_AUTHORIZATION=? WHERE TENANT_ID= ? AND ID = ?");
            enableAuthzStmt.setString(1, localAndOutboundAuthConfig.isEnableAuthorization() ? "1" : "0");
            enableAuthzStmt.setInt(2, tenantID);
            enableAuthzStmt.setInt(3, applicationId);
            enableAuthzStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)enableAuthzStmt);
        }
        PreparedStatement storeSubjectClaimUri = null;
        try {
            storeSubjectClaimUri = connection.prepareStatement("UPDATE SP_APP SET SUBJECT_CLAIM_URI=? WHERE TENANT_ID= ? AND ID = ?");
            storeSubjectClaimUri.setString(1, localAndOutboundAuthConfig.getSubjectClaimUri());
            storeSubjectClaimUri.setInt(2, tenantID);
            storeSubjectClaimUri.setInt(3, applicationId);
            storeSubjectClaimUri.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeSubjectClaimUri);
        }
        AuthenticationStep[] authSteps = localAndOutboundAuthConfig.getAuthenticationSteps();
        if (authSteps == null || authSteps.length == 0) {
            localAndOutboundAuthConfig.setAuthenticationType("default");
        }
        try {
            if (localAndOutboundAuthConfig.getAuthenticationType() == null) {
                localAndOutboundAuthConfig.setAuthenticationType("default");
            }
            updateAuthTypePrepStmt = connection.prepareStatement("UPDATE SP_APP SET AUTH_TYPE=? WHERE TENANT_ID= ? AND ID = ?");
            updateAuthTypePrepStmt.setString(1, localAndOutboundAuthConfig.getAuthenticationType());
            updateAuthTypePrepStmt.setInt(2, tenantID);
            updateAuthTypePrepStmt.setInt(3, applicationId);
            updateAuthTypePrepStmt.execute();
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement(updateAuthTypePrepStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)updateAuthTypePrepStmt);
        if (authSteps != null && authSteps.length > 0) {
            PreparedStatement storeStepIDPAuthnPrepStmt = null;
            storeStepIDPAuthnPrepStmt = connection.prepareStatement("INSERT INTO SP_FEDERATED_IDP (ID, TENANT_ID, AUTHENTICATOR_ID) VALUES (?,?,?)");
            try {
                if ("local".equalsIgnoreCase(localAndOutboundAuthConfig.getAuthenticationType())) {
                    if (authSteps.length != 1 || authSteps[0] == null || authSteps[0].getLocalAuthenticatorConfigs() == null || authSteps[0].getLocalAuthenticatorConfigs().length != 1 || authSteps[0].getFederatedIdentityProviders() != null && authSteps[0].getFederatedIdentityProviders().length >= 1) {
                        String errorMessage = "Invalid local authentication configuration. For local authentication there can only be only one authentication step and only one local authenticator";
                        throw new IdentityApplicationManagementException(errorMessage);
                    }
                } else if ("federated".equalsIgnoreCase(localAndOutboundAuthConfig.getAuthenticationType())) {
                    if (authSteps.length != 1 || authSteps[0] == null || authSteps[0].getFederatedIdentityProviders() == null || authSteps[0].getFederatedIdentityProviders().length != 1 || authSteps[0].getLocalAuthenticatorConfigs().length > 0) {
                        String errorMessage = "Invalid federated authentication configuration. For federated authentication there can only be only one authentication step and only one federated authenticator";
                        throw new IdentityApplicationManagementException(errorMessage);
                    }
                    IdentityProvider fedIdp = authSteps[0].getFederatedIdentityProviders()[0];
                    if (fedIdp.getDefaultAuthenticatorConfig() == null || fedIdp.getFederatedAuthenticatorConfigs() == null) {
                        IdentityProviderDAO idpDAO = ApplicationMgtSystemConfig.getInstance().getIdentityProviderDAO();
                        String defualtAuthName = idpDAO.getDefaultAuthenticator(fedIdp.getIdentityProviderName());
                        FederatedAuthenticatorConfig defaultAuth = new FederatedAuthenticatorConfig();
                        defaultAuth.setName(defualtAuthName);
                        fedIdp.setDefaultAuthenticatorConfig(defaultAuth);
                        fedIdp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{defaultAuth});
                    }
                }
                for (AuthenticationStep authStep : authSteps) {
                    int stepId = 0;
                    IdentityProvider[] federatedIdps = authStep.getFederatedIdentityProviders();
                    if (!(federatedIdps != null && federatedIdps.length != 0 || authStep.getLocalAuthenticatorConfigs() != null && authStep.getLocalAuthenticatorConfigs().length != 0)) {
                        String errorMesssage = "Invalid authentication configuration.An authentication step should have at least one federated identity provider or a local authenticator";
                        throw new IdentityApplicationManagementException(errorMesssage);
                    }
                    PreparedStatement storeStepPrepStmtz = null;
                    ResultSet result = null;
                    try {
                        String dbProductName = connection.getMetaData().getDatabaseProductName();
                        storeStepPrepStmtz = connection.prepareStatement("INSERT INTO SP_AUTH_STEP (TENANT_ID, STEP_ORDER, APP_ID, IS_SUBJECT_STEP, IS_ATTRIBUTE_STEP) VALUES (?,?,?,?,?)", new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
                        storeStepPrepStmtz.setInt(1, tenantID);
                        storeStepPrepStmtz.setInt(2, authStep.getStepOrder());
                        storeStepPrepStmtz.setInt(3, applicationId);
                        storeStepPrepStmtz.setString(4, authStep.isSubjectStep() ? "1" : "0");
                        storeStepPrepStmtz.setString(5, authStep.isAttributeStep() ? "1" : "0");
                        storeStepPrepStmtz.execute();
                        result = storeStepPrepStmtz.getGeneratedKeys();
                        if (result.next()) {
                            stepId = result.getInt(1);
                        }
                    }
                    catch (Throwable throwable) {
                        IdentityApplicationManagementUtil.closeResultSet(result);
                        IdentityApplicationManagementUtil.closeStatement(storeStepPrepStmtz);
                        throw throwable;
                    }
                    IdentityApplicationManagementUtil.closeResultSet((ResultSet)result);
                    IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeStepPrepStmtz);
                    if (authStep.getLocalAuthenticatorConfigs() != null && authStep.getLocalAuthenticatorConfigs().length > 0) {
                        for (LocalAuthenticatorConfig localAuthenticatorConfig : authStep.getLocalAuthenticatorConfigs()) {
                            int authenticatorId = this.getAuthentictorID(connection, tenantID, "LOCAL", localAuthenticatorConfig.getName());
                            if (authenticatorId < 0) {
                                authenticatorId = this.addAuthenticator(connection, tenantID, "LOCAL", localAuthenticatorConfig.getName(), localAuthenticatorConfig.getDisplayName());
                            }
                            if (authenticatorId > 0) {
                                storeStepIDPAuthnPrepStmt.setInt(1, stepId);
                                storeStepIDPAuthnPrepStmt.setInt(2, tenantID);
                                storeStepIDPAuthnPrepStmt.setInt(3, authenticatorId);
                                storeStepIDPAuthnPrepStmt.addBatch();
                            }
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Updating Local IdP of Application " + applicationId + " Step Order: " + authStep.getStepOrder() + " IdP: " + "wso2carbon-local-idp" + " Authenticator: " + localAuthenticatorConfig.getName()));
                        }
                    }
                    if (federatedIdps == null || federatedIdps.length <= 0) continue;
                    for (LocalAuthenticatorConfig localAuthenticatorConfig : federatedIdps) {
                        String idpName = localAuthenticatorConfig.getIdentityProviderName();
                        if ("wso2carbon-local-idp".equalsIgnoreCase(idpName)) {
                            throw new IdentityApplicationManagementException("The federated IdP name cannot be equal to wso2carbon-local-idp");
                        }
                        FederatedAuthenticatorConfig[] authenticators = localAuthenticatorConfig.getFederatedAuthenticatorConfigs();
                        if (authenticators == null || authenticators.length <= 0) continue;
                        for (FederatedAuthenticatorConfig authenticator : authenticators) {
                            int authenticatorId;
                            if (authenticator == null || (authenticatorId = this.getAuthentictorID(connection, tenantID, idpName, authenticator.getName())) <= 0) continue;
                            storeStepIDPAuthnPrepStmt.setInt(1, stepId);
                            storeStepIDPAuthnPrepStmt.setInt(2, tenantID);
                            storeStepIDPAuthnPrepStmt.setInt(3, authenticatorId);
                            storeStepIDPAuthnPrepStmt.addBatch();
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("Updating Federated IdP of Application " + applicationId + " Step Order: " + authStep.getStepOrder() + " IdP: " + idpName + " Authenticator: " + authenticator));
                        }
                    }
                }
                storeStepIDPAuthnPrepStmt.executeBatch();
            }
            finally {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeStepIDPAuthnPrepStmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClaimConfiguration(int applicationId, ClaimConfig claimConfiguration, int applicationID, Connection connection) throws SQLException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement storeRoleClaimPrepStmt = null;
        PreparedStatement storeSPDialectsPrepStmt = null;
        PreparedStatement storeClaimDialectPrepStmt = null;
        PreparedStatement storeSendLocalSubIdPrepStmt = null;
        if (claimConfiguration == null) {
            return;
        }
        try {
            String roleClaim = claimConfiguration.getRoleClaimURI();
            if (roleClaim != null) {
                storeRoleClaimPrepStmt = connection.prepareStatement("UPDATE SP_APP SET ROLE_CLAIM=? WHERE TENANT_ID= ? AND ID = ?");
                storeRoleClaimPrepStmt.setString(1, roleClaim);
                storeRoleClaimPrepStmt.setInt(2, tenantID);
                storeRoleClaimPrepStmt.setInt(3, applicationId);
                storeRoleClaimPrepStmt.executeUpdate();
            }
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement(storeRoleClaimPrepStmt);
        }
        try {
            Object[] spClaimDialects = claimConfiguration.getSpClaimDialects();
            if (ArrayUtils.isNotEmpty((Object[])spClaimDialects)) {
                storeSPDialectsPrepStmt = connection.prepareStatement("INSERT INTO SP_CLAIM_DIALECT (TENANT_ID, SP_DIALECT, APP_ID) VALUES (?,?,?)");
                for (Object spClaimDialect : spClaimDialects) {
                    if (spClaimDialect == null || ((String)spClaimDialect).isEmpty()) continue;
                    storeSPDialectsPrepStmt.setInt(1, tenantID);
                    storeSPDialectsPrepStmt.setString(2, (String)spClaimDialect);
                    storeSPDialectsPrepStmt.setInt(3, applicationId);
                    storeSPDialectsPrepStmt.addBatch();
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Storing SP Dialect: " + (String)spClaimDialect));
                }
                storeSPDialectsPrepStmt.executeBatch();
            }
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement(storeSPDialectsPrepStmt);
        }
        try {
            storeClaimDialectPrepStmt = connection.prepareStatement("UPDATE SP_APP SET IS_LOCAL_CLAIM_DIALECT=? WHERE TENANT_ID= ? AND ID = ?");
            storeClaimDialectPrepStmt.setString(1, claimConfiguration.isLocalClaimDialect() ? "1" : "0");
            storeClaimDialectPrepStmt.setInt(2, tenantID);
            storeClaimDialectPrepStmt.setInt(3, applicationId);
            storeClaimDialectPrepStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeClaimDialectPrepStmt);
        }
        try {
            storeSendLocalSubIdPrepStmt = connection.prepareStatement("UPDATE SP_APP SET IS_SEND_LOCAL_SUBJECT_ID=? WHERE TENANT_ID= ? AND ID = ?");
            storeSendLocalSubIdPrepStmt.setString(1, claimConfiguration.isAlwaysSendMappedLocalSubjectId() ? "1" : "0");
            storeSendLocalSubIdPrepStmt.setInt(2, tenantID);
            storeSendLocalSubIdPrepStmt.setInt(3, applicationId);
            storeSendLocalSubIdPrepStmt.executeUpdate();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeSendLocalSubIdPrepStmt);
        }
        if (claimConfiguration.getClaimMappings() == null || claimConfiguration.getClaimMappings().length == 0) {
            return;
        }
        List<ClaimMapping> claimMappings = Arrays.asList(claimConfiguration.getClaimMappings());
        if (claimMappings.isEmpty()) {
            this.log.debug((Object)"No claim mapping found, Skipping ..");
            return;
        }
        PreparedStatement storeClaimMapPrepStmt = null;
        try {
            storeClaimMapPrepStmt = connection.prepareStatement("INSERT INTO SP_CLAIM_MAPPING (TENANT_ID, IDP_CLAIM, SP_CLAIM, APP_ID, IS_REQUESTED, IS_MANDATORY, DEFAULT_VALUE) VALUES (?,?,?,?,?,?,?)");
            for (ClaimMapping mapping : claimMappings) {
                if (mapping.getLocalClaim() == null || mapping.getLocalClaim().getClaimUri() == null || mapping.getRemoteClaim().getClaimUri() == null || mapping.getRemoteClaim() == null) continue;
                storeClaimMapPrepStmt.setInt(1, tenantID);
                storeClaimMapPrepStmt.setString(2, mapping.getLocalClaim().getClaimUri());
                storeClaimMapPrepStmt.setString(3, mapping.getRemoteClaim().getClaimUri());
                storeClaimMapPrepStmt.setInt(4, applicationID);
                if (mapping.isRequested()) {
                    storeClaimMapPrepStmt.setString(5, "1");
                } else {
                    storeClaimMapPrepStmt.setString(5, "0");
                }
                if (mapping.isMandatory()) {
                    storeClaimMapPrepStmt.setString(6, "1");
                } else {
                    storeClaimMapPrepStmt.setString(6, "0");
                }
                storeClaimMapPrepStmt.setString(7, mapping.getDefaultValue());
                storeClaimMapPrepStmt.addBatch();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Storing Claim Mapping. Local Claim: " + mapping.getLocalClaim().getClaimUri() + " SPClaim: " + mapping.getRemoteClaim().getClaimUri()));
            }
            storeClaimMapPrepStmt.executeBatch();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeClaimMapPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermissionAndRoleConfiguration(int applicationID, PermissionsAndRoleConfig permissionsAndRoleConfiguration, Connection connection) throws SQLException {
        if (permissionsAndRoleConfiguration == null || permissionsAndRoleConfiguration.getRoleMappings() == null || ArrayUtils.isEmpty((Object[])permissionsAndRoleConfiguration.getRoleMappings())) {
            return;
        }
        RoleMapping[] roleMappings = permissionsAndRoleConfiguration.getRoleMappings();
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement storeRoleMapPrepStmt = null;
        try {
            storeRoleMapPrepStmt = connection.prepareStatement("INSERT INTO SP_ROLE_MAPPING (TENANT_ID, IDP_ROLE, SP_ROLE, APP_ID) VALUES (?,?,?,?)");
            for (RoleMapping roleMapping : roleMappings) {
                storeRoleMapPrepStmt.setInt(1, tenantID);
                storeRoleMapPrepStmt.setString(2, roleMapping.getLocalRole().getLocalRoleName());
                storeRoleMapPrepStmt.setString(3, roleMapping.getRemoteRole());
                storeRoleMapPrepStmt.setInt(4, applicationID);
                storeRoleMapPrepStmt.addBatch();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Storing Claim Mapping. IDPRole: " + roleMapping.getLocalRole() + " SPRole: " + roleMapping.getRemoteRole()));
            }
            storeRoleMapPrepStmt.executeBatch();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeRoleMapPrepStmt);
        }
    }

    @Override
    public ServiceProvider getApplication(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        int applicationId = this.getApplicationIdByName(applicationName, tenantDomain);
        if (this.isApplicationNotFound(applicationId) && "wso2carbon-local-sp".equals(applicationName)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("The application: " + applicationName + " trying to retrieve is not available, which is identified as the Local Service Provider. Therefore, creating the application: " + applicationName));
            }
            ServiceProvider localServiceProvider = new ServiceProvider();
            localServiceProvider.setApplicationName(applicationName);
            localServiceProvider.setDescription("Local Service Provider");
            applicationId = this.createServiceProvider(tenantDomain, localServiceProvider);
        }
        return this.getApplication(applicationId);
    }

    private boolean isApplicationNotFound(int applicationId) {
        return applicationId <= 0;
    }

    private ConsentPurposeConfigs getConsentPurposeConfigs(Connection connection, int applicationId, int tenantId) throws IdentityApplicationManagementException {
        ConsentPurposeConfigs consentPurposeConfigs = new ConsentPurposeConfigs();
        ArrayList<ConsentPurpose> consentPurposes = new ArrayList<ConsentPurpose>();
        try (PreparedStatement ps = connection.prepareStatement("SELECT APP_ID, PURPOSE_ID, DISPLAY_ORDER, TENANT_ID FROM SP_CONSENT_PURPOSE_ASSOC WHERE APP_ID = ? AND TENANT_ID = ?");){
            ps.setInt(1, applicationId);
            ps.setInt(2, tenantId);
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    ConsentPurpose consentPurpose = new ConsentPurpose();
                    consentPurpose.setPurposeId(resultSet.getInt(2));
                    consentPurpose.setDisplayOrder(resultSet.getInt(3));
                    consentPurposes.add(consentPurpose);
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while retrieving consent purpose configurations for application ID: " + applicationId, (Throwable)e);
        }
        consentPurposeConfigs.setConsentPurpose(consentPurposes.toArray(new ConsentPurpose[0]));
        return consentPurposeConfigs;
    }

    private String getCertificateContent(List<ServiceProviderProperty> serviceProviderProperties, Connection connection) throws CertificateRetrievingException {
        String certificateReferenceId = null;
        for (ServiceProviderProperty property : serviceProviderProperties) {
            if (!SP_PROPERTY_NAME_CERTIFICATE.equals(property.getName())) continue;
            certificateReferenceId = property.getValue();
        }
        if (certificateReferenceId != null) {
            ResultSet results;
            PreparedStatement statementForFetchingCertificate;
            block7: {
                String string;
                statementForFetchingCertificate = null;
                results = null;
                try {
                    statementForFetchingCertificate = connection.prepareStatement("SELECT CERTIFICATE_IN_PEM FROM IDN_CERTIFICATE WHERE ID = ?");
                    statementForFetchingCertificate.setInt(1, Integer.parseInt(certificateReferenceId));
                    results = statementForFetchingCertificate.executeQuery();
                    String certificateContent = null;
                    while (results.next()) {
                        certificateContent = this.getBlobValue(results.getBinaryStream("CERTIFICATE_IN_PEM"));
                    }
                    if (certificateContent == null) break block7;
                    string = certificateContent;
                }
                catch (IOException | SQLException e) {
                    try {
                        String errorMessage = "An error occurred while retrieving the certificate for the application.";
                        this.log.error((Object)errorMessage);
                        throw new CertificateRetrievingException(errorMessage, e);
                    }
                    catch (Throwable throwable) {
                        IdentityApplicationManagementUtil.closeResultSet(results);
                        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementForFetchingCertificate);
                        throw throwable;
                    }
                }
                IdentityApplicationManagementUtil.closeResultSet((ResultSet)results);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementForFetchingCertificate);
                return string;
            }
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)results);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementForFetchingCertificate);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProvider getBasicApplicationData(String applicationName, Connection connection, int tenantID) throws SQLException, IdentityApplicationManagementException {
        ServiceProvider serviceProvider;
        ServiceProvider serviceProvider2 = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading Basic Application Data of " + applicationName));
        }
        PreparedStatement loadBasicAppInfoStmt = null;
        ResultSet basicAppDataResultSet = null;
        try {
            loadBasicAppInfoStmt = connection.prepareStatement("SELECT ID, TENANT_ID, APP_NAME, USER_STORE, USERNAME, DESCRIPTION, ROLE_CLAIM, AUTH_TYPE, PROVISIONING_USERSTORE_DOMAIN, IS_LOCAL_CLAIM_DIALECT,IS_SEND_LOCAL_SUBJECT_ID, IS_SEND_AUTH_LIST_OF_IDPS, IS_USE_TENANT_DOMAIN_SUBJECT, IS_USE_USER_DOMAIN_SUBJECT, ENABLE_AUTHORIZATION, SUBJECT_CLAIM_URI, IS_SAAS_APP, UUID, IMAGE_URL, ACCESS_URL, IS_DISCOVERABLE FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID= ?");
            loadBasicAppInfoStmt.setString(1, applicationName);
            loadBasicAppInfoStmt.setInt(2, tenantID);
            basicAppDataResultSet = loadBasicAppInfoStmt.executeQuery();
            if (basicAppDataResultSet.next()) {
                String tenantDomain;
                serviceProvider2 = new ServiceProvider();
                serviceProvider2.setApplicationID(basicAppDataResultSet.getInt(1));
                serviceProvider2.setApplicationResourceId(basicAppDataResultSet.getString("UUID"));
                serviceProvider2.setApplicationName(basicAppDataResultSet.getString(3));
                serviceProvider2.setDescription(basicAppDataResultSet.getString(6));
                serviceProvider2.setImageUrl(basicAppDataResultSet.getString("IMAGE_URL"));
                serviceProvider2.setAccessUrl(basicAppDataResultSet.getString("ACCESS_URL"));
                serviceProvider2.setDiscoverable(this.getBooleanValue(basicAppDataResultSet.getString("IS_DISCOVERABLE")));
                try {
                    tenantDomain = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getDomain(basicAppDataResultSet.getInt(2));
                }
                catch (UserStoreException e) {
                    this.log.error((Object)"Error while reading tenantDomain", (Throwable)e);
                    throw new IdentityApplicationManagementException("Error while reading tenant domain for application " + applicationName);
                }
                User owner = new User();
                owner.setUserName(basicAppDataResultSet.getString(5));
                owner.setTenantDomain(tenantDomain);
                owner.setUserStoreDomain(basicAppDataResultSet.getString(4));
                serviceProvider2.setOwner(owner);
                ClaimConfig claimConfig = new ClaimConfig();
                claimConfig.setRoleClaimURI(basicAppDataResultSet.getString(7));
                claimConfig.setLocalClaimDialect("1".equals(basicAppDataResultSet.getString(10)));
                claimConfig.setAlwaysSendMappedLocalSubjectId("1".equals(basicAppDataResultSet.getString(11)));
                serviceProvider2.setClaimConfig(claimConfig);
                LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = new LocalAndOutboundAuthenticationConfig();
                localAndOutboundAuthenticationConfig.setAlwaysSendBackAuthenticatedListOfIdPs("1".equals(basicAppDataResultSet.getString(14)));
                localAndOutboundAuthenticationConfig.setEnableAuthorization("1".equals(basicAppDataResultSet.getString(15)));
                localAndOutboundAuthenticationConfig.setSubjectClaimUri(basicAppDataResultSet.getString(16));
                serviceProvider2.setLocalAndOutBoundAuthenticationConfig(localAndOutboundAuthenticationConfig);
                serviceProvider2.setSaasApp("1".equals(basicAppDataResultSet.getString(17)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ApplicationID: " + serviceProvider2.getApplicationID() + " ApplicationName: " + serviceProvider2.getApplicationName() + " UserName: " + serviceProvider2.getOwner().getUserName() + " TenantDomain: " + serviceProvider2.getOwner().getTenantDomain()));
                }
            }
            serviceProvider = serviceProvider2;
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeResultSet(basicAppDataResultSet);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadBasicAppInfoStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)basicAppDataResultSet);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadBasicAppInfoStmt);
        return serviceProvider;
    }

    @Override
    public ApplicationBasicInfo[] getPaginatedApplicationBasicInfo(int pageNumber, String filter) throws IdentityApplicationManagementException {
        this.validateRequestedPageNumber(pageNumber);
        int limit = ApplicationMgtUtil.getItemsPerPage();
        int offset = (pageNumber - 1) * limit;
        return this.getApplicationBasicInfo(filter, offset, limit);
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter, int offset, int limit) throws IdentityApplicationManagementException {
        this.validateAttributesForPagination(offset, limit);
        if ("*".equals(filter)) {
            return this.getApplicationBasicInfo(offset, limit);
        }
        this.validateAttributesForPagination(offset, limit);
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        try {
            String sqlQuery;
            String filterResolvedForSQL = this.resolveSQLFilter(filter);
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            if (databaseProductName.contains("MySQL") || databaseProductName.contains("MariaDB") || databaseProductName.contains("H2")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION , UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ? ORDER BY ID DESC LIMIT ?, ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, offset);
                getAppNamesStmt.setInt(4, limit);
            } else if (databaseProductName.contains("Oracle")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID, rownum AS rnum FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP ORDER BY ID DESC) WHERE TENANT_ID = ? AND APP_NAME LIKE ? AND rownum <= ?) WHERE rnum > ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, offset + limit);
                getAppNamesStmt.setInt(4, offset);
            } else if (databaseProductName.contains("Microsoft")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ? ORDER BY ID DESC OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, offset);
                getAppNamesStmt.setInt(4, limit);
            } else if (databaseProductName.contains("PostgreSQL")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ? ORDER BY ID DESC LIMIT ? OFFSET ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, limit);
                getAppNamesStmt.setInt(4, offset);
            } else if (databaseProductName.contains("DB2")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ROW_NUMBER() OVER(ORDER BY ID DESC) AS rn,SP_APP.* FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ?)WHERE rn BETWEEN ? AND ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, offset + 1);
                getAppNamesStmt.setInt(4, offset + limit);
            } else if (databaseProductName.contains("INFORMIX")) {
                sqlQuery = "SELECT SKIP ? FIRST ? ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ? ORDER BY ID DESC";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setString(2, filterResolvedForSQL);
                getAppNamesStmt.setInt(3, offset);
                getAppNamesStmt.setInt(4, limit);
            } else {
                this.log.error((Object)"Error while loading applications from DB: Database driver could not be identified or not supported.");
                throw new IdentityApplicationManagementException("Error while loading applications from DB:Database driver could not be identified or not supported.");
            }
            appNameResultSet = getAppNamesStmt.executeQuery();
            while (appNameResultSet.next()) {
                if ("wso2carbon-local-sp".equals(appNameResultSet.getString(1))) continue;
                appInfo.add(this.buildApplicationBasicInfo(appNameResultSet));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while loading applications from DB: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return appInfo.toArray(new ApplicationBasicInfo[0]);
    }

    @Override
    public ServiceProvider getApplication(int applicationId) throws IdentityApplicationManagementException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            ServiceProvider serviceProvider = this.getBasicApplicationData(applicationId, connection);
            if (serviceProvider == null) {
                ServiceProvider serviceProvider2 = null;
                return serviceProvider2;
            }
            int tenantID = IdentityTenantUtil.getTenantId((String)serviceProvider.getOwner().getTenantDomain());
            List<ServiceProviderProperty> propertyList = this.getServicePropertiesBySpId(connection, applicationId);
            serviceProvider.setJwksUri(this.getJwksUri(propertyList));
            serviceProvider.setTemplateId(this.getTemplateId(propertyList));
            serviceProvider.setInboundAuthenticationConfig(this.getInboundAuthenticationConfig(applicationId, connection, tenantID));
            serviceProvider.setLocalAndOutBoundAuthenticationConfig(this.getLocalAndOutboundAuthenticationConfig(applicationId, connection, tenantID, propertyList));
            serviceProvider.setInboundProvisioningConfig(this.getInboundProvisioningConfiguration(applicationId, connection, tenantID));
            serviceProvider.setOutboundProvisioningConfig(this.getOutboundProvisioningConfiguration(applicationId, connection, tenantID));
            serviceProvider.setClaimConfig(this.getClaimConfiguration(applicationId, connection, tenantID));
            List<RoleMapping> roleMappings = this.getRoleMappingOfApplication(applicationId, connection, tenantID);
            PermissionsAndRoleConfig permissionAndRoleConfig = new PermissionsAndRoleConfig();
            permissionAndRoleConfig.setRoleMappings(roleMappings.toArray(new RoleMapping[0]));
            serviceProvider.setPermissionAndRoleConfig(permissionAndRoleConfig);
            RequestPathAuthenticatorConfig[] requestPathAuthenticators = this.getRequestPathAuthenticators(applicationId, connection, tenantID);
            serviceProvider.setRequestPathAuthenticatorConfigs(requestPathAuthenticators);
            serviceProvider.setSpProperties(propertyList.toArray(new ServiceProviderProperty[0]));
            serviceProvider.setCertificateContent(this.getCertificateContent(propertyList, connection));
            String serviceProviderName = serviceProvider.getApplicationName();
            this.loadApplicationPermissions(serviceProviderName, serviceProvider);
            ServiceProvider serviceProvider3 = serviceProvider;
            return serviceProvider3;
        }
        catch (SQLException | CertificateRetrievingException e) {
            throw new IdentityApplicationManagementException("Failed to get service provider with id: " + applicationId, e);
        }
        finally {
            IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        }
    }

    private String getTemplateId(List<ServiceProviderProperty> propertyList) {
        return propertyList.stream().filter(property -> "templateId".equals(property.getName())).findFirst().map(ServiceProviderProperty::getValue).orElse("");
    }

    private String getJwksUri(List<ServiceProviderProperty> propertyList) {
        return propertyList.stream().filter(property -> "jwksURI".equals(property.getName())).findFirst().map(ServiceProviderProperty::getValue).orElse("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceProvider getBasicApplicationData(int appId, Connection connection) throws SQLException, IdentityApplicationManagementException {
        ServiceProvider serviceProvider;
        ServiceProvider serviceProvider2 = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading Basic Application Data of application ID: " + appId));
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = connection.prepareStatement("SELECT ID, TENANT_ID, APP_NAME, USER_STORE, USERNAME, DESCRIPTION, ROLE_CLAIM, AUTH_TYPE, PROVISIONING_USERSTORE_DOMAIN, IS_LOCAL_CLAIM_DIALECT,IS_SEND_LOCAL_SUBJECT_ID, IS_SEND_AUTH_LIST_OF_IDPS, IS_USE_TENANT_DOMAIN_SUBJECT, IS_USE_USER_DOMAIN_SUBJECT, ENABLE_AUTHORIZATION, SUBJECT_CLAIM_URI, IS_SAAS_APP, UUID, IMAGE_URL, ACCESS_URL, IS_DISCOVERABLE FROM SP_APP WHERE ID = ?");
            prepStmt.setInt(1, appId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                serviceProvider2 = new ServiceProvider();
                serviceProvider2.setApplicationID(rs.getInt("ID"));
                serviceProvider2.setApplicationResourceId(rs.getString("UUID"));
                serviceProvider2.setApplicationName(rs.getString("APP_NAME"));
                serviceProvider2.setDescription(rs.getString("DESCRIPTION"));
                serviceProvider2.setImageUrl(rs.getString("IMAGE_URL"));
                serviceProvider2.setAccessUrl(rs.getString("ACCESS_URL"));
                serviceProvider2.setDiscoverable(this.getBooleanValue(rs.getString("IS_DISCOVERABLE")));
                User owner = new User();
                owner.setUserName(rs.getString("USERNAME"));
                owner.setUserStoreDomain(rs.getString("USER_STORE"));
                owner.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)rs.getInt("TENANT_ID")));
                serviceProvider2.setOwner(owner);
                ClaimConfig claimConfig = new ClaimConfig();
                claimConfig.setRoleClaimURI(rs.getString("ROLE_CLAIM"));
                claimConfig.setLocalClaimDialect(this.getBooleanValue(rs.getString("IS_LOCAL_CLAIM_DIALECT")));
                claimConfig.setAlwaysSendMappedLocalSubjectId(this.getBooleanValue(rs.getString("IS_SEND_LOCAL_SUBJECT_ID")));
                serviceProvider2.setClaimConfig(claimConfig);
                LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = new LocalAndOutboundAuthenticationConfig();
                localAndOutboundAuthenticationConfig.setAlwaysSendBackAuthenticatedListOfIdPs(this.getBooleanValue(rs.getString("IS_SEND_AUTH_LIST_OF_IDPS")));
                localAndOutboundAuthenticationConfig.setEnableAuthorization(this.getBooleanValue(rs.getString("ENABLE_AUTHORIZATION")));
                localAndOutboundAuthenticationConfig.setSubjectClaimUri(rs.getString("SUBJECT_CLAIM_URI"));
                serviceProvider2.setLocalAndOutBoundAuthenticationConfig(localAndOutboundAuthenticationConfig);
                serviceProvider2.setSaasApp(this.getBooleanValue(rs.getString("IS_SAAS_APP")));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ApplicationID: " + serviceProvider2.getApplicationID() + " ApplicationName: " + serviceProvider2.getApplicationName() + " UserName: " + serviceProvider2.getOwner().getUserName() + " TenantDomain: " + serviceProvider2.getOwner().getTenantDomain()));
                }
            }
            serviceProvider = serviceProvider2;
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeResultSet(rs);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)rs);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        return serviceProvider;
    }

    private boolean getBooleanValue(String booleanValueAsString) throws SQLException {
        return "1".equals(booleanValueAsString);
    }

    private String getStringValueForBoolean(boolean booleanValue) throws SQLException {
        return booleanValue ? "1" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAuthenticationType(int applicationid, Connection connection) throws SQLException {
        ResultSet authTypeResultSet;
        PreparedStatement authTypeStmt;
        block3: {
            String string;
            int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            authTypeStmt = null;
            authTypeResultSet = null;
            try {
                authTypeStmt = connection.prepareStatement("SELECT AUTH_TYPE FROM SP_APP WHERE ID = ? AND TENANT_ID = ?");
                authTypeStmt.setInt(1, applicationid);
                authTypeStmt.setInt(2, tenantID);
                authTypeResultSet = authTypeStmt.executeQuery();
                if (!authTypeResultSet.next()) break block3;
                string = authTypeResultSet.getString(1);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(authTypeResultSet);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)authTypeStmt);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)authTypeResultSet);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)authTypeStmt);
            return string;
        }
        String string = "default";
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)authTypeResultSet);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)authTypeStmt);
        return string;
    }

    public ServiceProvider getApplicationData(String clientId, String type, String tenantDomain) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading Application Data of Client " + clientId));
        }
        int tenantID = -123;
        try {
            tenantID = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e1) {
            this.log.error((Object)"Error while reading application", (Throwable)e1);
            throw new IdentityApplicationManagementException("Error while reading application", (Throwable)e1);
        }
        String applicationName = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement storeAppPrepStmt = null;
        ResultSet appNameResult = null;
        try {
            storeAppPrepStmt = connection.prepareStatement("SELECT APP_NAME FROM SP_APP INNER JOIN SP_INBOUND_AUTH ON SP_APP.ID = SP_INBOUND_AUTH.APP_ID WHERE INBOUND_AUTH_KEY = ? AND INBOUND_AUTH_TYPE = ? AND SP_APP.TENANT_ID = ? AND SP_INBOUND_AUTH.TENANT_ID=?");
            storeAppPrepStmt.setString(1, clientId);
            storeAppPrepStmt.setString(2, type);
            storeAppPrepStmt.setInt(3, tenantID);
            appNameResult = storeAppPrepStmt.executeQuery();
            if (appNameResult.next()) {
                applicationName = appNameResult.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while reading application", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(appNameResult);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeAppPrepStmt);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResult);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeAppPrepStmt);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return this.getApplication(applicationName, tenantDomain);
    }

    @Override
    public String getApplicationName(int applicationID) throws IdentityApplicationManagementException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            String string = this.getApplicationName(applicationID, connection);
            return string;
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Failed loading the application with " + applicationID, (Throwable)e);
        }
        finally {
            IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        }
    }

    private String getApplicationName(int applicationID, Connection connection) throws SQLException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantID);
            this.log.debug((Object)("Loading application name for id: " + applicationID + " in tenantDomain: " + tenantDomain));
        }
        String applicationName = null;
        try (PreparedStatement loadBasicAppInfoStmt = connection.prepareStatement("SELECT APP_NAME FROM SP_APP WHERE ID = ? AND TENANT_ID = ?");){
            loadBasicAppInfoStmt.setInt(1, applicationID);
            loadBasicAppInfoStmt.setInt(2, tenantID);
            try (ResultSet appNameResultSet = loadBasicAppInfoStmt.executeQuery();){
                if (appNameResultSet.next()) {
                    applicationName = appNameResultSet.getString(1);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Application name for id: " + applicationID + " is '" + applicationName + "'"));
            }
            String string = applicationName;
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getApplicationIdByName(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            int n = this.getApplicationIDByName(applicationName, tenantId, connection);
            return n;
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error retrieving id for application: " + applicationName + " in tenantDomain: " + tenantDomain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getApplicationIDByName(String applicationName, int tenantID, Connection connection) throws SQLException {
        int applicationId = 0;
        PreparedStatement getAppIDPrepStmt = null;
        ResultSet appidResult = null;
        try {
            getAppIDPrepStmt = connection.prepareStatement("SELECT ID FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID = ?");
            getAppIDPrepStmt.setString(1, applicationName);
            getAppIDPrepStmt.setInt(2, tenantID);
            appidResult = getAppIDPrepStmt.executeQuery();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            if (appidResult.next()) {
                applicationId = appidResult.getInt(1);
            }
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeResultSet(appidResult);
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppIDPrepStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appidResult);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppIDPrepStmt);
        return applicationId;
    }

    private Property getMappedProperty(AbstractInboundAuthenticatorConfig customAuthenticator, String propertyName) {
        Property[] confProps;
        Property property = null;
        if (customAuthenticator != null && (confProps = customAuthenticator.getConfigurationProperties()) != null) {
            for (Property confProp : confProps) {
                if (propertyName == null || !propertyName.equals(confProp.getName())) continue;
                property = confProp;
            }
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InboundAuthenticationConfig getInboundAuthenticationConfig(int applicationId, Connection connection, int tenantID) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Clients of Application " + applicationId));
        }
        HashMap<String, InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigMap = new HashMap<String, InboundAuthenticationRequestConfig>();
        PreparedStatement getClientInfo = null;
        ResultSet resultSet = null;
        try {
            getClientInfo = connection.prepareStatement("SELECT INBOUND_AUTH_KEY, INBOUND_AUTH_TYPE, PROP_NAME, PROP_VALUE,INBOUND_CONFIG_TYPE FROM  SP_INBOUND_AUTH WHERE APP_ID = ? AND TENANT_ID = ?");
            getClientInfo.setInt(1, applicationId);
            getClientInfo.setInt(2, tenantID);
            resultSet = getClientInfo.executeQuery();
            while (resultSet.next()) {
                String authKey = resultSet.getString(1);
                if (authKey == null) {
                    authKey = new String();
                }
                String authType = resultSet.getString(2);
                String string = resultSet.getString(3);
                String propValue = resultSet.getString(4);
                String configType = resultSet.getString(5);
                String mapKey = (String)authType + ":" + authKey;
                InboundAuthenticationRequestConfig inboundAuthRequest = null;
                inboundAuthRequest = (InboundAuthenticationRequestConfig)inboundAuthenticationRequestConfigMap.get(mapKey);
                if (inboundAuthRequest == null) {
                    inboundAuthRequest = new InboundAuthenticationRequestConfig();
                }
                inboundAuthRequest.setInboundAuthKey(authKey);
                inboundAuthRequest.setInboundAuthType(authType);
                inboundAuthRequest.setInboundConfigType(configType);
                boolean isCustomAuthenticator = this.isCustomInboundAuthType(authType);
                AbstractInboundAuthenticatorConfig customAuthenticator = ApplicationManagementServiceComponentHolder.getInboundAuthenticatorConfig((String)authType + ":" + configType);
                if (isCustomAuthenticator && customAuthenticator != null) {
                    inboundAuthRequest.setFriendlyName(customAuthenticator.getFriendlyName());
                }
                if (string != null) {
                    Property mappedProperty;
                    Property prop = new Property();
                    prop.setName(string);
                    prop.setValue(propValue);
                    if (isCustomAuthenticator && customAuthenticator != null && (mappedProperty = this.getMappedProperty(customAuthenticator, string)) != null) {
                        prop.setDisplayName(mappedProperty.getDisplayName());
                    }
                    inboundAuthRequest.setProperties(ApplicationMgtUtil.concatArrays(new Property[]{prop}, inboundAuthRequest.getProperties()));
                }
                inboundAuthenticationRequestConfigMap.put(mapKey, inboundAuthRequest);
            }
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClientInfo);
            IdentityApplicationManagementUtil.closeResultSet(resultSet);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClientInfo);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        HashMap<String, AbstractInboundAuthenticatorConfig> allCustomAuthenticators = new HashMap<String, AbstractInboundAuthenticatorConfig>(ApplicationManagementServiceComponentHolder.getAllInboundAuthenticatorConfig());
        for (Map.Entry entry : inboundAuthenticationRequestConfigMap.entrySet()) {
            InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = (InboundAuthenticationRequestConfig)entry.getValue();
            AbstractInboundAuthenticatorConfig inboundAuthenticatorConfig = (AbstractInboundAuthenticatorConfig)allCustomAuthenticators.remove(inboundAuthenticationRequestConfig.getInboundAuthType() + ":" + inboundAuthenticationRequestConfig.getInboundConfigType());
            if (inboundAuthenticatorConfig == null || inboundAuthenticationRequestConfig == null) continue;
            Property[] sources = inboundAuthenticatorConfig.getConfigurationProperties();
            Property[] destinations = inboundAuthenticationRequestConfig.getProperties();
            HashMap<String, Property> destinationMap = new HashMap<String, Property>();
            for (Property destination : destinations) {
                destinationMap.put(destination.getName(), destination);
            }
            for (Property source : sources) {
                Property property = (Property)destinationMap.get(source.getName());
                if (property == null) {
                    if (this.isCustomInboundAuthType(inboundAuthenticationRequestConfig.getInboundAuthType()) && inboundAuthenticatorConfig.isRelyingPartyKeyConfigured() && StringUtils.equals((String)inboundAuthenticatorConfig.getRelyingPartyKey(), (String)source.getName())) {
                        source.setValue(inboundAuthenticationRequestConfig.getInboundAuthKey());
                    }
                    destinationMap.put(source.getName(), source);
                    continue;
                }
                property.setConfidential(source.isConfidential());
                property.setDefaultValue(source.getDefaultValue());
                property.setAdvanced(source.isAdvanced());
                property.setDescription(source.getDescription());
                property.setDisplayOrder(source.getDisplayOrder());
                property.setRequired(source.isRequired());
                property.setType(source.getType());
            }
            inboundAuthenticationRequestConfig.setProperties(destinationMap.values().toArray(new Property[destinationMap.size()]));
        }
        ArrayList returnList = new ArrayList(inboundAuthenticationRequestConfigMap.values());
        InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
        inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(returnList.toArray(new InboundAuthenticationRequestConfig[returnList.size()]));
        return inboundAuthenticationConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalAndOutboundAuthenticationConfig getLocalAndOutboundAuthenticationConfig(int applicationId, Connection connection, int tenantId, List<ServiceProviderProperty> propertyList) throws SQLException, IdentityApplicationManagementException {
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig;
        PreparedStatement getStepInfoPrepStmt = null;
        ResultSet stepInfoResultSet = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Steps of Application " + applicationId));
        }
        try {
            getStepInfoPrepStmt = connection.prepareStatement("SELECT STEP_ORDER, AUTHENTICATOR_ID, IS_SUBJECT_STEP, IS_ATTRIBUTE_STEP FROM SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID WHERE APP_ID = ?");
            getStepInfoPrepStmt.setInt(1, applicationId);
            stepInfoResultSet = getStepInfoPrepStmt.executeQuery();
            HashMap<String, AuthenticationStep> authSteps = new HashMap<String, AuthenticationStep>();
            HashMap stepFedIdPAuthenticators = new HashMap();
            HashMap stepLocalAuth = new HashMap();
            while (stepInfoResultSet.next()) {
                AuthenticationStep authStep;
                String step = String.valueOf(stepInfoResultSet.getInt(1));
                if (authSteps.containsKey(step)) {
                    authStep = (AuthenticationStep)authSteps.get(step);
                } else {
                    authStep = new AuthenticationStep();
                    authStep.setStepOrder(stepInfoResultSet.getInt(1));
                    stepLocalAuth.put(step, new ArrayList());
                    stepFedIdPAuthenticators.put(step, new HashMap());
                }
                int authenticatorId = stepInfoResultSet.getInt(2);
                Map<String, String> authenticatorInfo = this.getAuthenticatorInfo(connection, tenantId, authenticatorId);
                if (authenticatorInfo != null && authenticatorInfo.get("idpName") != null && "LOCAL".equals(authenticatorInfo.get("idpName"))) {
                    LocalAuthenticatorConfig localAuthenticator = new LocalAuthenticatorConfig();
                    localAuthenticator.setName((String)authenticatorInfo.get("authenticatorName"));
                    localAuthenticator.setDisplayName((String)authenticatorInfo.get("authenticatorDisplayName"));
                    ((List)stepLocalAuth.get(step)).add(localAuthenticator);
                } else {
                    Map stepFedIdps = (Map)stepFedIdPAuthenticators.get(step);
                    if (!stepFedIdps.containsKey(authenticatorInfo.get("idpName"))) {
                        stepFedIdps.put(authenticatorInfo.get("idpName"), new ArrayList());
                    }
                    List idpAuths = (List)stepFedIdps.get(authenticatorInfo.get("idpName"));
                    FederatedAuthenticatorConfig fedAuthenticator = new FederatedAuthenticatorConfig();
                    fedAuthenticator.setName((String)authenticatorInfo.get("authenticatorName"));
                    fedAuthenticator.setDisplayName((String)authenticatorInfo.get("authenticatorDisplayName"));
                    idpAuths.add(fedAuthenticator);
                }
                authStep.setSubjectStep("1".equals(stepInfoResultSet.getString(3)));
                authStep.setAttributeStep("1".equals(stepInfoResultSet.getString(4)));
                authSteps.put(step, authStep);
            }
            LocalAndOutboundAuthenticationConfig localAndOutboundConfiguration = new LocalAndOutboundAuthenticationConfig();
            Object[] authenticationSteps = new AuthenticationStep[authSteps.size()];
            int authStepCount = 0;
            for (Map.Entry entry : authSteps.entrySet()) {
                Map idpList;
                Object[] authStep = (Object[])entry.getValue();
                String stepId = (String)entry.getKey();
                List localAuthenticatorList = (List)stepLocalAuth.get(stepId);
                if (localAuthenticatorList != null && localAuthenticatorList.size() > 0) {
                    authStep.setLocalAuthenticatorConfigs(localAuthenticatorList.toArray(new LocalAuthenticatorConfig[localAuthenticatorList.size()]));
                }
                if ((idpList = (Map)stepFedIdPAuthenticators.get(stepId)) != null && idpList.size() > 0) {
                    IdentityProvider[] fedIdpList = new IdentityProvider[idpList.size()];
                    int idpCount = 0;
                    for (Map.Entry idpEntry : idpList.entrySet()) {
                        String idpName = (String)idpEntry.getKey();
                        List fedAuthenticators = (List)idpEntry.getValue();
                        IdentityProvider idp = new IdentityProvider();
                        idp.setIdentityProviderName(idpName);
                        idp.setFederationHub(this.isFederationHubIdP(idpName, connection, tenantId));
                        idp.setFederatedAuthenticatorConfigs(fedAuthenticators.toArray(new FederatedAuthenticatorConfig[fedAuthenticators.size()]));
                        idp.setDefaultAuthenticatorConfig(idp.getFederatedAuthenticatorConfigs()[0]);
                        fedIdpList[idpCount++] = idp;
                    }
                    authStep.setFederatedIdentityProviders(fedIdpList);
                }
                authenticationSteps[authStepCount++] = authStep;
            }
            Arrays.sort(authenticationSteps, Comparator.comparingInt(AuthenticationStep::getStepOrder));
            int numSteps = authenticationSteps.length;
            if (numSteps > 0 && authenticationSteps[numSteps - 1].getStepOrder() != numSteps) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication steps of Application with id: " + applicationId + "  do not have consecutive numbers. This was possibility due to a IDP force deletion. Fixing the step order."));
                }
                int count = 1;
                for (Object step : authenticationSteps) {
                    step.setStepOrder(count++);
                }
            }
            localAndOutboundConfiguration.setAuthenticationSteps((AuthenticationStep[])authenticationSteps);
            String authType = this.getAuthenticationType(applicationId, connection);
            if ((StringUtils.equalsIgnoreCase((String)authType, (String)"federated") || StringUtils.equalsIgnoreCase((String)authType, (String)"flow")) && ArrayUtils.isEmpty((Object[])authenticationSteps)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication type is '" + authType + "' eventhough the application with id: " + applicationId + " has zero authentication step. This was possibility due to a IDP force deletion.  Defaulting authentication type to " + "default"));
                }
                authType = "default";
            }
            localAndOutboundConfiguration.setAuthenticationType(authType);
            AuthenticationScriptConfig authenticationScriptConfig = this.getScriptConfiguration(applicationId, connection);
            if (authenticationScriptConfig != null) {
                localAndOutboundConfiguration.setAuthenticationScriptConfig(authenticationScriptConfig);
            }
            PreparedStatement localAndOutboundConfigPrepStmt = null;
            ResultSet localAndOutboundConfigResultSet = null;
            try {
                localAndOutboundConfigPrepStmt = connection.prepareStatement("SELECT IS_USE_TENANT_DOMAIN_SUBJECT, IS_USE_USER_DOMAIN_SUBJECT, ENABLE_AUTHORIZATION, IS_SEND_AUTH_LIST_OF_IDPS, SUBJECT_CLAIM_URI FROM SP_APP WHERE TENANT_ID= ? AND ID = ?");
                localAndOutboundConfigPrepStmt.setInt(1, tenantId);
                localAndOutboundConfigPrepStmt.setInt(2, applicationId);
                localAndOutboundConfigResultSet = localAndOutboundConfigPrepStmt.executeQuery();
                if (localAndOutboundConfigResultSet.next()) {
                    localAndOutboundConfiguration.setUseTenantDomainInLocalSubjectIdentifier("1".equals(localAndOutboundConfigResultSet.getString(1)));
                    localAndOutboundConfiguration.setUseUserstoreDomainInLocalSubjectIdentifier("1".equals(localAndOutboundConfigResultSet.getString(2)));
                    localAndOutboundConfiguration.setEnableAuthorization("1".equals(localAndOutboundConfigResultSet.getString(3)));
                    localAndOutboundConfiguration.setAlwaysSendBackAuthenticatedListOfIdPs("1".equals(localAndOutboundConfigResultSet.getString(4)));
                    localAndOutboundConfiguration.setSubjectClaimUri(localAndOutboundConfigResultSet.getString(5));
                    this.readAndSetConfigurationsFromProperties(propertyList, localAndOutboundConfiguration);
                }
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)localAndOutboundConfigPrepStmt);
                IdentityApplicationManagementUtil.closeResultSet(localAndOutboundConfigResultSet);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)localAndOutboundConfigPrepStmt);
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)localAndOutboundConfigResultSet);
            localAndOutboundAuthenticationConfig = localAndOutboundConfiguration;
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getStepInfoPrepStmt);
            IdentityApplicationManagementUtil.closeResultSet(stepInfoResultSet);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getStepInfoPrepStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)stepInfoResultSet);
        return localAndOutboundAuthenticationConfig;
    }

    private void readAndSetConfigurationsFromProperties(List<ServiceProviderProperty> propertyList, LocalAndOutboundAuthenticationConfig localAndOutboundConfig) {
        if (CollectionUtils.isNotEmpty(propertyList)) {
            for (ServiceProviderProperty serviceProviderProperty : propertyList) {
                String name = serviceProviderProperty.getName();
                String value = serviceProviderProperty.getValue();
                if (USE_DOMAIN_IN_ROLES.equals(name)) {
                    localAndOutboundConfig.setUseUserstoreDomainInRoles(value == null || Boolean.parseBoolean(value));
                    continue;
                }
                if ("skipConsent".equals(name)) {
                    localAndOutboundConfig.setSkipConsent(Boolean.parseBoolean(value));
                    continue;
                }
                if (!"skipLogoutConsent".equals(name)) continue;
                localAndOutboundConfig.setSkipLogoutConsent(Boolean.parseBoolean(value));
            }
        }
    }

    private AuthenticationScriptConfig getScriptConfiguration(int applicationId, Connection connection) throws SQLException, IdentityApplicationManagementException {
        block32: {
            try (PreparedStatement localAndOutboundConfigScriptPrepStmt = connection.prepareStatement("SELECT CONTENT, IS_ENABLED FROM SP_AUTH_SCRIPT WHERE APP_ID = ?");){
                localAndOutboundConfigScriptPrepStmt.setInt(1, applicationId);
                try (ResultSet localAndOutboundConfigScriptResultSet = localAndOutboundConfigScriptPrepStmt.executeQuery();){
                    if (!localAndOutboundConfigScriptResultSet.next()) break block32;
                    AuthenticationScriptConfig authenticationScriptConfig = new AuthenticationScriptConfig();
                    try {
                        boolean isEnabled = "1".equals(localAndOutboundConfigScriptResultSet.getString(2));
                        InputStream scriptBinaryStream = localAndOutboundConfigScriptResultSet.getBinaryStream(1);
                        String targetString = "";
                        if (scriptBinaryStream != null) {
                            targetString = IOUtils.toString((InputStream)scriptBinaryStream);
                        }
                        authenticationScriptConfig.setContent(targetString);
                        authenticationScriptConfig.setEnabled(isEnabled);
                    }
                    catch (IOException e) {
                        throw new IdentityApplicationManagementException("Could not read the Script for application : " + applicationId, (Throwable)e);
                    }
                    AuthenticationScriptConfig authenticationScriptConfig2 = authenticationScriptConfig;
                    return authenticationScriptConfig2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFederationHubIdP(String idPName, Connection connection, int tenantId) throws SQLException {
        ResultSet resultSet;
        PreparedStatement get;
        block3: {
            boolean bl;
            get = null;
            resultSet = null;
            try {
                get = connection.prepareStatement("SELECT IS_FEDERATION_HUB FROM IDP WHERE NAME = ? AND TENANT_ID = ?");
                get.setString(1, idPName);
                get.setInt(2, tenantId);
                resultSet = get.executeQuery();
                if (!resultSet.next()) break block3;
                bl = "1".equals(resultSet.getString(1));
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)get);
                IdentityApplicationManagementUtil.closeResultSet(resultSet);
                throw throwable;
            }
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)get);
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
            return bl;
        }
        boolean bl = false;
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)get);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        return bl;
    }

    private ClaimConfig getClaimConfiguration(int applicationId, Connection connection, int tenantID) throws IdentityApplicationManagementException {
        ClaimConfig claimConfig = new ClaimConfig();
        ArrayList<ClaimMapping> claimMappingList = new ArrayList<ClaimMapping>();
        ArrayList<String> spDialectList = new ArrayList<String>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Claim Mappings of Application " + applicationId));
        }
        PreparedStatement get = null;
        ResultSet resultSet = null;
        try {
            get = connection.prepareStatement("SELECT IDP_CLAIM, SP_CLAIM, IS_REQUESTED, IS_MANDATORY, DEFAULT_VALUE FROM SP_CLAIM_MAPPING WHERE APP_ID = ? AND TENANT_ID = ?");
            get.setInt(1, applicationId);
            get.setInt(2, tenantID);
            resultSet = get.executeQuery();
            while (resultSet.next()) {
                ClaimMapping claimMapping = new ClaimMapping();
                Claim localClaim = new Claim();
                Claim remoteClaim = new Claim();
                localClaim.setClaimUri(resultSet.getString(1));
                remoteClaim.setClaimUri(resultSet.getString(2));
                String requested = resultSet.getString(3);
                if ("1".equalsIgnoreCase(requested)) {
                    claimMapping.setRequested(true);
                } else {
                    claimMapping.setRequested(false);
                }
                String mandatory = resultSet.getString(4);
                if ("1".equalsIgnoreCase(mandatory)) {
                    claimMapping.setMandatory(true);
                } else {
                    claimMapping.setMandatory(false);
                }
                if (remoteClaim.getClaimUri() == null || remoteClaim.getClaimUri().trim().length() == 0) {
                    remoteClaim.setClaimUri(localClaim.getClaimUri());
                }
                if (localClaim.getClaimUri() == null || localClaim.getClaimUri().trim().length() == 0) {
                    localClaim.setClaimUri(remoteClaim.getClaimUri());
                }
                claimMapping.setDefaultValue(resultSet.getString(5));
                claimMapping.setLocalClaim(localClaim);
                claimMapping.setRemoteClaim(remoteClaim);
                claimMappingList.add(claimMapping);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Local Claim: " + claimMapping.getLocalClaim().getClaimUri() + " SPClaim: " + claimMapping.getRemoteClaim().getClaimUri()));
            }
            claimConfig.setClaimMappings(claimMappingList.toArray(new ClaimMapping[claimMappingList.size()]));
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while retrieving all application");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)get);
                IdentityApplicationManagementUtil.closeResultSet(resultSet);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)get);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        PreparedStatement loadClaimConfigsPrepStmt = null;
        ResultSet loadClaimConfigsResultSet = null;
        try {
            loadClaimConfigsPrepStmt = connection.prepareStatement("SELECT ROLE_CLAIM, IS_LOCAL_CLAIM_DIALECT, IS_SEND_LOCAL_SUBJECT_ID FROM SP_APP WHERE TENANT_ID= ? AND ID = ?");
            loadClaimConfigsPrepStmt.setInt(1, tenantID);
            loadClaimConfigsPrepStmt.setInt(2, applicationId);
            loadClaimConfigsResultSet = loadClaimConfigsPrepStmt.executeQuery();
            while (loadClaimConfigsResultSet.next()) {
                claimConfig.setRoleClaimURI(loadClaimConfigsResultSet.getString(1));
                claimConfig.setLocalClaimDialect("1".equals(loadClaimConfigsResultSet.getString(2)));
                claimConfig.setAlwaysSendMappedLocalSubjectId("1".equals(loadClaimConfigsResultSet.getString(3)));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while retrieving all application");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadClaimConfigsPrepStmt);
                IdentityApplicationManagementUtil.closeResultSet(loadClaimConfigsResultSet);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadClaimConfigsPrepStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)loadClaimConfigsResultSet);
        PreparedStatement loadSPDialectsPrepStmt = null;
        ResultSet loadSPDialectsResultSet = null;
        try {
            loadSPDialectsPrepStmt = connection.prepareStatement("SELECT SP_DIALECT FROM SP_CLAIM_DIALECT WHERE TENANT_ID= ? AND APP_ID = ?");
            loadSPDialectsPrepStmt.setInt(1, tenantID);
            loadSPDialectsPrepStmt.setInt(2, applicationId);
            loadSPDialectsResultSet = loadSPDialectsPrepStmt.executeQuery();
            while (loadSPDialectsResultSet.next()) {
                String spDialect = loadSPDialectsResultSet.getString(1);
                if (spDialect == null || spDialect.isEmpty()) continue;
                spDialectList.add(spDialect);
            }
            claimConfig.setSpClaimDialects(spDialectList.toArray(new String[spDialectList.size()]));
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while retrieving all application");
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadClaimConfigsPrepStmt);
            IdentityApplicationManagementUtil.closeResultSet((ResultSet)loadClaimConfigsResultSet);
        }
        return claimConfig;
    }

    private RequestPathAuthenticatorConfig[] getRequestPathAuthenticators(int applicationId, Connection connection, int tenantID) throws IdentityApplicationManagementException {
        PreparedStatement loadReqPathAuthenticators = null;
        ResultSet authResultSet = null;
        ArrayList<RequestPathAuthenticatorConfig> authenticators = new ArrayList<RequestPathAuthenticatorConfig>();
        try {
            loadReqPathAuthenticators = connection.prepareStatement("SELECT AUTHENTICATOR_NAME FROM SP_REQ_PATH_AUTHENTICATOR WHERE APP_ID = ? AND TENANT_ID = ?");
            loadReqPathAuthenticators.setInt(1, applicationId);
            loadReqPathAuthenticators.setInt(2, tenantID);
            authResultSet = loadReqPathAuthenticators.executeQuery();
            while (authResultSet.next()) {
                RequestPathAuthenticatorConfig reqAuth = new RequestPathAuthenticatorConfig();
                reqAuth.setName(authResultSet.getString(1));
                authenticators.add(reqAuth);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while retrieving all application");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadReqPathAuthenticators);
                IdentityApplicationManagementUtil.closeResultSet(authResultSet);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)loadReqPathAuthenticators);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)authResultSet);
        return authenticators.toArray(new RequestPathAuthenticatorConfig[authenticators.size()]);
    }

    private void updateRequestPathAuthenticators(int applicationId, RequestPathAuthenticatorConfig[] authenticators, Connection connection) throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement storeReqPathAuthenticators = null;
        try {
            storeReqPathAuthenticators = connection.prepareStatement("INSERT INTO SP_REQ_PATH_AUTHENTICATOR (TENANT_ID, AUTHENTICATOR_NAME, APP_ID) VALUES (?,?,?)");
            if (authenticators != null && authenticators.length > 0) {
                for (RequestPathAuthenticatorConfig auth : authenticators) {
                    storeReqPathAuthenticators.setInt(1, tenantID);
                    storeReqPathAuthenticators.setString(2, auth.getName());
                    storeReqPathAuthenticators.setInt(3, applicationId);
                    storeReqPathAuthenticators.addBatch();
                }
                storeReqPathAuthenticators.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while retrieving all application");
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeReqPathAuthenticators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRequestPathAuthenticators(int applicationID, Connection connection) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting request path authenticators " + applicationID));
        }
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement deleteReqAuthPrepStmt = null;
        try {
            deleteReqAuthPrepStmt = connection.prepareStatement("DELETE FROM SP_REQ_PATH_AUTHENTICATOR WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteReqAuthPrepStmt.setInt(1, applicationID);
            deleteReqAuthPrepStmt.setInt(2, tenantID);
            deleteReqAuthPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteReqAuthPrepStmt);
        }
    }

    private List<RoleMapping> getRoleMappingOfApplication(int applicationId, Connection connection, int tenantID) throws IdentityApplicationManagementException {
        ArrayList<RoleMapping> roleMappingList = new ArrayList<RoleMapping>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Role Mapping of Application " + applicationId));
        }
        PreparedStatement getClientInfo = null;
        ResultSet resultSet = null;
        try {
            getClientInfo = connection.prepareStatement("SELECT IDP_ROLE, SP_ROLE FROM SP_ROLE_MAPPING WHERE APP_ID = ? AND TENANT_ID = ?");
            getClientInfo.setInt(1, applicationId);
            getClientInfo.setInt(2, tenantID);
            resultSet = getClientInfo.executeQuery();
            while (resultSet.next()) {
                RoleMapping roleMapping = new RoleMapping();
                LocalRole localRole = new LocalRole();
                localRole.setLocalRoleName(resultSet.getString(1));
                roleMapping.setLocalRole(localRole);
                roleMapping.setRemoteRole(resultSet.getString(2));
                roleMappingList.add(roleMapping);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Local Role: " + roleMapping.getLocalRole().getLocalRoleName() + " SPRole: " + roleMapping.getRemoteRole()));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while retrieving all application");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClientInfo);
                IdentityApplicationManagementUtil.closeResultSet(resultSet);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClientInfo);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        return roleMappingList;
    }

    @Override
    public int getCountOfAllApplications() throws IdentityApplicationManagementException {
        int count;
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting the count of all applications for the tenantID: " + tenantID));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        try {
            getAppNamesStmt = connection.prepareStatement("SELECT COUNT(*) FROM SP_APP WHERE TENANT_ID = ?");
            getAppNamesStmt.setInt(1, tenantID);
            appNameResultSet = getAppNamesStmt.executeQuery();
            appNameResultSet.next();
            count = Integer.parseInt(appNameResultSet.getString(1));
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while getting the count of all Applications for the tenantID: " + tenantID, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return count;
    }

    @Override
    public ApplicationBasicInfo[] getAllApplicationBasicInfo() throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading all Applications of Tenant " + tenantID));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        try {
            getAppNamesStmt = connection.prepareStatement("SELECT ID, APP_NAME, DESCRIPTION FROM SP_APP WHERE TENANT_ID = ? ORDER BY ID DESC");
            getAppNamesStmt.setInt(1, tenantID);
            appNameResultSet = getAppNamesStmt.executeQuery();
            while (appNameResultSet.next()) {
                ApplicationBasicInfo basicInfo = new ApplicationBasicInfo();
                if ("wso2carbon-local-sp".equals(appNameResultSet.getString(1))) continue;
                basicInfo.setApplicationId(appNameResultSet.getInt("ID"));
                basicInfo.setApplicationName(appNameResultSet.getString("APP_NAME"));
                basicInfo.setDescription(appNameResultSet.getString("DESCRIPTION"));
                appInfo.add(basicInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while Reading all Applications");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return appInfo.toArray(new ApplicationBasicInfo[0]);
    }

    private String resolveSQLFilter(String filter) {
        String sqlfilter = "%";
        if (StringUtils.isNotBlank((String)filter)) {
            sqlfilter = filter.trim().replace("*", "%").replace("?", "_");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Input filter: " + filter + " resolved for SQL filter: " + sqlfilter));
        }
        return sqlfilter;
    }

    @Override
    public int getCountOfApplications(String filter) throws IdentityApplicationManagementException {
        int count;
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting the count of all applications for the tenantID: " + tenantID));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        try {
            String filterResolvedForSQL = this.resolveSQLFilter(filter);
            getAppNamesStmt = connection.prepareStatement("SELECT COUNT(*) FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ?");
            getAppNamesStmt.setInt(1, tenantID);
            getAppNamesStmt.setString(2, filterResolvedForSQL);
            appNameResultSet = getAppNamesStmt.executeQuery();
            appNameResultSet.next();
            count = Integer.parseInt(appNameResultSet.getString(1));
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while Reading all Applications for the tenantID: " + tenantID, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return count;
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter) throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting the all applications for the tenant: " + tenantID + " with filter: " + filter));
        }
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        try {
            String filterResolvedForSQL = this.resolveSQLFilter(filter);
            getAppNamesStmt = connection.prepareStatement("SELECT APP_NAME, DESCRIPTION FROM SP_APP WHERE TENANT_ID = ? AND APP_NAME LIKE ? ORDER BY ID DESC");
            getAppNamesStmt.setInt(1, tenantID);
            getAppNamesStmt.setString(2, filterResolvedForSQL);
            appNameResultSet = getAppNamesStmt.executeQuery();
            while (appNameResultSet.next()) {
                ApplicationBasicInfo basicInfo = new ApplicationBasicInfo();
                if ("wso2carbon-local-sp".equals(appNameResultSet.getString(1))) continue;
                basicInfo.setApplicationName(appNameResultSet.getString(1));
                basicInfo.setDescription(appNameResultSet.getString(2));
                appInfo.add(basicInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while getting applications from DB with filter: " + filter, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return appInfo.toArray(new ApplicationBasicInfo[0]);
    }

    @Override
    public ApplicationBasicInfo[] getAllPaginatedApplicationBasicInfo(int pageNumber) throws IdentityApplicationManagementException {
        this.validateRequestedPageNumber(pageNumber);
        int limit = ApplicationMgtUtil.getItemsPerPage();
        int offset = (pageNumber - 1) * limit;
        return this.getApplicationBasicInfo(offset, limit);
    }

    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(int offset, int limit) throws IdentityApplicationManagementException {
        this.validateAttributesForPagination(offset, limit);
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement getAppNamesStmt = null;
        ResultSet appNameResultSet = null;
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        try {
            String sqlQuery;
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            if (databaseProductName.contains("MySQL") || databaseProductName.contains("MariaDB") || databaseProductName.contains("H2")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? ORDER BY ID DESC LIMIT ?, ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setInt(2, offset);
                getAppNamesStmt.setInt(3, limit);
            } else if (databaseProductName.contains("Oracle")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID, rownum AS rnum FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP ORDER BY ID DESC) WHERE TENANT_ID = ? AND rownum <= ?) WHERE rnum > ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setInt(2, offset + limit);
                getAppNamesStmt.setInt(3, offset);
            } else if (databaseProductName.contains("Microsoft")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? ORDER BY ID DESC OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setInt(2, offset);
                getAppNamesStmt.setInt(3, limit);
            } else if (databaseProductName.contains("PostgreSQL")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? ORDER BY ID DESC LIMIT ? OFFSET ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setInt(2, limit);
                getAppNamesStmt.setInt(3, offset);
            } else if (databaseProductName.contains("DB2")) {
                sqlQuery = "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ROW_NUMBER() OVER(ORDER BY ID DESC) AS rn,SP_APP.* FROM SP_APP WHERE TENANT_ID = ?)WHERE rn BETWEEN ? AND ?";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, tenantID);
                getAppNamesStmt.setInt(2, offset + 1);
                getAppNamesStmt.setInt(3, offset + limit);
            } else if (databaseProductName.contains("INFORMIX")) {
                sqlQuery = "SELECT SKIP ? FIRST ? ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = ? ORDER BY ID DESC";
                getAppNamesStmt = connection.prepareStatement(sqlQuery);
                getAppNamesStmt.setInt(1, offset);
                getAppNamesStmt.setInt(2, limit);
                getAppNamesStmt.setInt(3, tenantID);
            } else {
                this.log.error((Object)"Error while loading applications from DB: Database driver could not be identified or not supported.");
                throw new IdentityApplicationManagementException("Error while loading applications from DB: Database driver could not be identified or not supported.");
            }
            appNameResultSet = getAppNamesStmt.executeQuery();
            while (appNameResultSet.next()) {
                if ("wso2carbon-local-sp".equals(appNameResultSet.getString(2))) continue;
                appInfo.add(this.buildApplicationBasicInfo(appNameResultSet));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while loading applications from DB: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(getAppNamesStmt);
                IdentityApplicationManagementUtil.closeResultSet(appNameResultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getAppNamesStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return appInfo.toArray(new ApplicationBasicInfo[0]);
    }

    @Override
    public void deleteApplication(String appName) throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Application " + appName));
        }
        PreparedStatement deleteClientPrepStmt = null;
        try {
            this.deleteCertificate(connection, appName, tenantID);
            int applicationID = this.getApplicationIDByName(appName, tenantID, connection);
            InboundAuthenticationConfig clients = this.getInboundAuthenticationConfig(applicationID, connection, tenantID);
            for (InboundAuthenticationRequestConfig client : clients.getInboundAuthenticationRequestConfigs()) {
                this.deleteClient(client.getInboundAuthKey(), client.getInboundAuthType());
            }
            deleteClientPrepStmt = connection.prepareStatement("DELETE FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID = ?");
            deleteClientPrepStmt.setString(1, appName);
            deleteClientPrepStmt.setInt(2, tenantID);
            deleteClientPrepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException | IdentityApplicationManagementException | UserStoreException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                String errorMessege = "An error occured while delete the application : " + appName;
                this.log.error((Object)errorMessege, e);
                throw new IdentityApplicationManagementException(errorMessege, e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(deleteClientPrepStmt);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteClientPrepStmt);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
    }

    public void deleteApplication(int applicationID, Connection connection) throws IdentityApplicationManagementException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Application " + applicationID));
        }
        PreparedStatement deleteClientPrepStmt = null;
        try {
            InboundAuthenticationConfig clients = this.getInboundAuthenticationConfig(applicationID, connection, tenantID);
            for (InboundAuthenticationRequestConfig client : clients.getInboundAuthenticationRequestConfigs()) {
                this.deleteClient(client.getInboundAuthKey(), client.getInboundAuthType());
            }
            String applicationName = this.getApplicationName(applicationID, connection);
            ApplicationMgtUtil.deleteAppRole(applicationName);
            deleteClientPrepStmt = connection.prepareStatement("DELETE FROM SP_APP WHERE ID = ? AND TENANT_ID = ?");
            deleteClientPrepStmt.setInt(1, applicationID);
            deleteClientPrepStmt.setInt(2, tenantID);
            deleteClientPrepStmt.execute();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw new IdentityApplicationManagementException("Error deleting application");
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement(deleteClientPrepStmt);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteClientPrepStmt);
    }

    @Override
    public void deleteApplications(int tenantId) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting all applications of the tenant: " + tenantId));
        }
        String auditData = "\"Tenant Id\" : \"" + tenantId + "\"";
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            this.deleteCertificatesByTenantId(connection, tenantId);
            try (PreparedStatement deleteClientPrepStmt = connection.prepareStatement("DELETE FROM SP_APP WHERE TENANT_ID = ?");){
                deleteClientPrepStmt.setInt(1, tenantId);
                deleteClientPrepStmt.execute();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                this.audit("Delete all applications of a tenant", auditData, AUDIT_SUCCESS);
            }
        }
        catch (SQLException e) {
            this.audit("Delete all applications of a tenant", auditData, AUDIT_FAIL);
            String msg = "An error occurred while delete all the applications of the tenant: " + tenantId;
            this.log.error((Object)msg, (Throwable)e);
            throw new IdentityApplicationManagementException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInboundAuthRequestConfiguration(int applicationID, Connection connection) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Clients of the Application " + applicationID));
        }
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement deleteClientPrepStmt = null;
        try {
            deleteClientPrepStmt = connection.prepareStatement("DELETE FROM SP_INBOUND_AUTH WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteClientPrepStmt.setInt(1, applicationID);
            deleteClientPrepStmt.setInt(2, tenantID);
            deleteClientPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteClientPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLocalAndOutboundAuthenticationConfiguration(int applicationId, Connection connection) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Steps of Application " + applicationId));
        }
        PreparedStatement deleteLocalAndOutboundAuthConfigPrepStmt = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            deleteLocalAndOutboundAuthConfigPrepStmt = connection.prepareStatement("DELETE FROM SP_AUTH_STEP WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteLocalAndOutboundAuthConfigPrepStmt.setInt(1, applicationId);
            deleteLocalAndOutboundAuthConfigPrepStmt.setInt(2, tenantId);
            deleteLocalAndOutboundAuthConfigPrepStmt.execute();
            this.deleteAuthenticationScript(applicationId, connection);
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteLocalAndOutboundAuthConfigPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOutboundProvisioningConfiguration(int applicationId, Connection connection) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Steps of Application " + applicationId));
        }
        PreparedStatement deleteOutboundProConfigPrepStmt = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            deleteOutboundProConfigPrepStmt = connection.prepareStatement("DELETE FROM SP_PROVISIONING_CONNECTOR WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteOutboundProConfigPrepStmt.setInt(1, applicationId);
            deleteOutboundProConfigPrepStmt.setInt(2, tenantId);
            deleteOutboundProConfigPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteOutboundProConfigPrepStmt);
        }
    }

    private void deleteClient(String clientIdentifier, String type) throws IdentityApplicationManagementException {
        if ("samlsso".equalsIgnoreCase(type)) {
            new SAMLApplicationDAOImpl().removeServiceProviderConfiguration(clientIdentifier);
        } else if ("oauth2".equalsIgnoreCase(type)) {
            new OAuthApplicationDAOImpl().removeOAuthApplication(clientIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClaimConfiguration(int applicationID, Connection connection) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Application Claim Mapping " + applicationID));
        }
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        PreparedStatement deleteCliamPrepStmt = null;
        PreparedStatement deleteSpDialectPrepStmt = null;
        try {
            deleteCliamPrepStmt = connection.prepareStatement("DELETE FROM SP_CLAIM_MAPPING WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteCliamPrepStmt.setInt(1, applicationID);
            deleteCliamPrepStmt.setInt(2, tenantID);
            deleteCliamPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteCliamPrepStmt);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Application SP Dialects " + applicationID));
        }
        try {
            deleteSpDialectPrepStmt = connection.prepareStatement("DELETE FROM SP_CLAIM_DIALECT WHERE APP_ID = ? AND TENANT_ID= ?");
            deleteSpDialectPrepStmt.setInt(1, applicationID);
            deleteSpDialectPrepStmt.setInt(2, tenantID);
            deleteSpDialectPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteSpDialectPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePermissionAndRoleConfiguration(int applicationID, Connection connection) throws SQLException {
        int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting Role Mapping of Application " + applicationID));
        }
        PreparedStatement deleteRoleMappingPrepStmt = null;
        try {
            deleteRoleMappingPrepStmt = connection.prepareStatement("DELETE FROM SP_ROLE_MAPPING WHERE APP_ID = ? AND TENANT_ID = ?");
            deleteRoleMappingPrepStmt.setInt(1, applicationID);
            deleteRoleMappingPrepStmt.setInt(2, tenantID);
            deleteRoleMappingPrepStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteRoleMappingPrepStmt);
        }
    }

    private void deleteCertificate(Connection connection, String appName, int tenantID) throws UserStoreException, IdentityApplicationManagementException, SQLException {
        ServiceProvider application;
        String certificateReferenceID;
        String tenantDomain = "carbon.super";
        if (tenantID != -1234) {
            Tenant tenant = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenant(tenantID);
            tenantDomain = tenant.getDomain();
        }
        if ((certificateReferenceID = this.getCertificateReferenceID((application = this.getApplication(appName, tenantDomain)).getSpProperties())) != null) {
            this.deleteCertificate(connection, Integer.parseInt(certificateReferenceID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCertificate(Connection connection, int id) throws SQLException {
        PreparedStatement statementToRemoveCertificate = null;
        try {
            statementToRemoveCertificate = connection.prepareStatement("DELETE FROM IDN_CERTIFICATE WHERE ID = ?");
            statementToRemoveCertificate.setInt(1, id);
            statementToRemoveCertificate.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)statementToRemoveCertificate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCertificatesByTenantId(Connection connection, int tenantId) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting all application certificates of tenant: " + tenantId));
        }
        PreparedStatement deleteCertificatesStmt = null;
        try {
            deleteCertificatesStmt = connection.prepareStatement("DELETE FROM IDN_CERTIFICATE WHERE TENANT_ID = ?");
            deleteCertificatesStmt.setInt(1, tenantId);
            deleteCertificatesStmt.execute();
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteCertificatesStmt);
        }
    }

    public void deleteAssignedPermissions(Connection connection, String applicationName, ApplicationPermission[] permissions) throws IdentityApplicationManagementException, SQLException {
        List<ApplicationPermission> loadPermissions = ApplicationMgtUtil.loadPermissions(applicationName);
        ArrayList<Object> removedPermissions = null;
        if (!CollectionUtils.isEmpty(loadPermissions)) {
            if (ArrayUtils.isEmpty((Object[])permissions)) {
                removedPermissions = new ArrayList<ApplicationPermission>(loadPermissions);
            } else {
                removedPermissions = new ArrayList();
                for (ApplicationPermission applicationPermission : loadPermissions) {
                    boolean isStored = false;
                    for (ApplicationPermission applicationPermission2 : permissions) {
                        if (!applicationPermission2.getValue().equals(applicationPermission.getValue())) continue;
                        isStored = true;
                        break;
                    }
                    if (isStored) continue;
                    removedPermissions.add(applicationPermission);
                }
            }
        }
        if (!CollectionUtils.isEmpty(removedPermissions)) {
            for (ApplicationPermission applicationPermission : removedPermissions) {
                String permissionValue = "/" + ApplicationMgtUtil.getApplicationPermissionPath() + "/" + applicationName + "/" + applicationPermission.getValue();
                int permisionId = this.getPermissionId(permissionValue.toLowerCase());
                this.deleteRolePermissionMapping(permisionId);
                this.deletePermission(permisionId);
            }
        }
    }

    @Override
    public String getServiceProviderNameByClientId(String clientId, String clientType, String tenantDomain) throws IdentityApplicationManagementException {
        int tenantID = -1234;
        if (StringUtils.isEmpty((String)clientId)) {
            return null;
        }
        if (tenantDomain != null) {
            try {
                tenantID = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e1) {
                throw new IdentityApplicationManagementException("Error while reading application");
            }
        }
        String applicationName = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement storeAppPrepStmt = null;
        ResultSet appNameResult = null;
        try {
            storeAppPrepStmt = connection.prepareStatement("SELECT APP_NAME FROM SP_APP INNER JOIN SP_INBOUND_AUTH ON SP_APP.ID = SP_INBOUND_AUTH.APP_ID WHERE INBOUND_AUTH_KEY = ? AND INBOUND_AUTH_TYPE = ? AND SP_APP.TENANT_ID = ? AND SP_INBOUND_AUTH.TENANT_ID=?");
            storeAppPrepStmt.setString(1, clientId);
            storeAppPrepStmt.setString(2, clientType);
            storeAppPrepStmt.setInt(3, tenantID);
            storeAppPrepStmt.setInt(4, tenantID);
            appNameResult = storeAppPrepStmt.executeQuery();
            if (appNameResult.next()) {
                applicationName = appNameResult.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while reading application", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeResultSet(appNameResult);
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeAppPrepStmt);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)appNameResult);
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)storeAppPrepStmt);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getClaimMapping(String serviceProviderName, String tenantDomain, boolean localIdpAsKey) throws SQLException, IdentityApplicationManagementException {
        int tenantID = -123;
        if (tenantDomain != null) {
            try {
                tenantID = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e1) {
                throw new IdentityApplicationManagementException("Error while reading application");
            }
        }
        HashMap<String, String> claimMapping = new HashMap<String, String>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Claim Mappings of Application " + serviceProviderName));
        }
        PreparedStatement getClaimPreStmt = null;
        ResultSet resultSet = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            getClaimPreStmt = connection.prepareStatement("SELECT IDP_CLAIM, SP_CLAIM, IS_REQUESTED, IS_MANDATORY, DEFAULT_VALUE FROM SP_CLAIM_MAPPING WHERE APP_ID = (SELECT ID FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID = ?)");
            getClaimPreStmt.setString(1, serviceProviderName);
            getClaimPreStmt.setInt(2, tenantID);
            resultSet = getClaimPreStmt.executeQuery();
            while (resultSet.next()) {
                if (localIdpAsKey) {
                    claimMapping.put(resultSet.getString(1), resultSet.getString(2));
                    continue;
                }
                claimMapping.put(resultSet.getString(2), resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClaimPreStmt);
            IdentityApplicationManagementUtil.closeResultSet(resultSet);
            IdentityApplicationManagementUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClaimPreStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return claimMapping;
    }

    @Override
    public Map<String, String> getServiceProviderToLocalIdPClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            return this.getClaimMapping(serviceProviderName, tenantDomain, false);
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while retrieving claim mapping", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getLocalIdPToServiceProviderClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            return this.getClaimMapping(serviceProviderName, tenantDomain, true);
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Error while retrieving claim mapping", (Throwable)e);
        }
    }

    @Override
    public List<String> getAllRequestedClaimsByServiceProvider(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        int tenantID = -123;
        if (tenantDomain != null) {
            try {
                tenantID = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e1) {
                throw new IdentityApplicationManagementException("Error while reading application");
            }
        }
        ArrayList<String> reqClaimUris = new ArrayList<String>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Claim Mappings of Application " + serviceProviderName));
        }
        PreparedStatement getClaimPreStmt = null;
        ResultSet resultSet = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            getClaimPreStmt = connection.prepareStatement("SELECT IDP_CLAIM, SP_CLAIM, IS_REQUESTED, IS_MANDATORY, DEFAULT_VALUE FROM SP_CLAIM_MAPPING WHERE APP_ID = (SELECT ID FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID = ?)");
            getClaimPreStmt.setString(1, serviceProviderName);
            getClaimPreStmt.setInt(2, tenantID);
            resultSet = getClaimPreStmt.executeQuery();
            while (resultSet.next()) {
                if (!"1".equalsIgnoreCase(resultSet.getString(3))) continue;
                reqClaimUris.add(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityApplicationManagementException("Error while retrieving requested claims", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClaimPreStmt);
                IdentityApplicationManagementUtil.closeResultSet(resultSet);
                IdentityApplicationManagementUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)getClaimPreStmt);
        IdentityApplicationManagementUtil.closeResultSet((ResultSet)resultSet);
        IdentityApplicationManagementUtil.closeConnection((Connection)connection);
        return reqClaimUris;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isApplicationExists(String serviceProviderName, String tenantName) throws IdentityApplicationManagementException {
        int tenantID = -1234;
        if (tenantName != null) {
            try {
                tenantID = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantName);
            }
            catch (UserStoreException e1) {
                this.log.error((Object)"Error in reading application", (Throwable)e1);
                throw new IdentityApplicationManagementException("Error while reading application", (Throwable)e1);
            }
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement checkAppExistence = connection.prepareStatement("SELECT ID, TENANT_ID, APP_NAME, USER_STORE, USERNAME, DESCRIPTION, ROLE_CLAIM, AUTH_TYPE, PROVISIONING_USERSTORE_DOMAIN, IS_LOCAL_CLAIM_DIALECT,IS_SEND_LOCAL_SUBJECT_ID, IS_SEND_AUTH_LIST_OF_IDPS, IS_USE_TENANT_DOMAIN_SUBJECT, IS_USE_USER_DOMAIN_SUBJECT, ENABLE_AUTHORIZATION, SUBJECT_CLAIM_URI, IS_SAAS_APP, UUID, IMAGE_URL, ACCESS_URL, IS_DISCOVERABLE FROM SP_APP WHERE APP_NAME = ? AND TENANT_ID= ?");){
            checkAppExistence.setString(1, serviceProviderName);
            checkAppExistence.setInt(2, tenantID);
            try (ResultSet resultSet = checkAppExistence.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementException("Failed to check whether the service provider exists with" + serviceProviderName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAuthentictorID(Connection conn, int tenantId, String idpName, String authenticatorName) throws SQLException {
        if (idpName == null || idpName.isEmpty()) {
            return -1;
        }
        int authId = -1;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "SELECT A.ID FROM IDP_AUTHENTICATOR A JOIN IDP B ON A.IDP_ID= B.ID WHERE A.NAME =? AND B.NAME=? AND ((A.TENANT_ID =? AND B.TENANT_ID =?) OR (B.TENANT_ID=? AND B.NAME LIKE 'SHARED_%'))";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setString(1, authenticatorName);
            prepStmt.setString(2, idpName);
            prepStmt.setInt(3, tenantId);
            prepStmt.setInt(4, tenantId);
            prepStmt.setInt(5, -1234);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                authId = rs.getInt(1);
            }
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
        return authId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAuthenticatorInfo(Connection conn, int tenantId, int authenticatorId) throws SQLException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "SELECT A.NAME, B.NAME, B.DISPLAY_NAME FROM IDP A JOIN IDP_AUTHENTICATOR B ON A.ID = B.IDP_ID WHERE B.ID =? AND ((A.TENANT_ID =? AND B.TENANT_ID =?) OR  (A.TENANT_ID=? AND A.NAME LIKE 'SHARED_%' AND B.TENANT_ID=?))";
        HashMap<String, String> returnData = new HashMap<String, String>();
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setInt(1, authenticatorId);
            prepStmt.setInt(2, tenantId);
            prepStmt.setInt(3, tenantId);
            prepStmt.setInt(4, -1234);
            prepStmt.setInt(5, -1234);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                returnData.put("idpName", rs.getString(1));
                returnData.put("authenticatorName", rs.getString(2));
                returnData.put("authenticatorDisplayName", rs.getString(3));
            }
        }
        finally {
            IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAuthenticator(Connection conn, int tenantId, String idpName, String authenticatorName, String authenticatorDispalyName) throws SQLException {
        int authenticatorId = -1;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "INSERT INTO IDP_AUTHENTICATOR (TENANT_ID, IDP_ID, NAME,IS_ENABLED, DISPLAY_NAME) VALUES (?, (SELECT ID FROM IDP WHERE IDP.NAME=? AND IDP.TENANT_ID =?), ?, ?, ?)";
        try {
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            prepStmt = conn.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, idpName);
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, authenticatorName);
            prepStmt.setString(5, "1");
            prepStmt.setString(6, authenticatorDispalyName);
            prepStmt.execute();
            rs = prepStmt.getGeneratedKeys();
            if (rs.next()) {
                authenticatorId = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)prepStmt);
        return authenticatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readApplicationPermissions(String applicationName) throws SQLException {
        PreparedStatement readPermissionsPrepStmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        HashMap<String, String> permissions = new HashMap<String, String>();
        try {
            connection = IdentityDatabaseUtil.getUserDBConnection();
            readPermissionsPrepStmt = connection.prepareStatement("SELECT UM_ID, UM_RESOURCE_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID LIKE ?");
            readPermissionsPrepStmt.setString(1, "%" + ApplicationMgtUtil.getApplicationPermissionPath() + "%");
            resultSet = readPermissionsPrepStmt.executeQuery();
            while (resultSet.next()) {
                String umId = resultSet.getString(1);
                String permission = resultSet.getString(2);
                if (!permission.contains(ApplicationMgtUtil.getApplicationPermissionPath() + "/" + applicationName.toLowerCase())) continue;
                permissions.put(umId, permission);
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeResultSet(resultSet);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)readPermissionsPrepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)resultSet);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)readPermissionsPrepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermissionPath(String id, String newPermission) throws SQLException {
        PreparedStatement updatePermissionPrepStmt = null;
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getUserDBConnection();
            updatePermissionPrepStmt = connection.prepareStatement("UPDATE UM_PERMISSION SET UM_RESOURCE_ID=? WHERE UM_ID=?");
            updatePermissionPrepStmt.setString(1, newPermission);
            updatePermissionPrepStmt.setString(2, id);
            updatePermissionPrepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(updatePermissionPrepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)updatePermissionPrepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPermissionId(String permission) throws SQLException {
        PreparedStatement loadPermissionsPrepStmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        int id = -1;
        try {
            connection = IdentityDatabaseUtil.getUserDBConnection();
            loadPermissionsPrepStmt = connection.prepareStatement("SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ?");
            loadPermissionsPrepStmt.setString(1, permission.toLowerCase());
            resultSet = loadPermissionsPrepStmt.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getInt(1);
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeResultSet(resultSet);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)loadPermissionsPrepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)resultSet);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)loadPermissionsPrepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRolePermissionMapping(int id) throws SQLException {
        PreparedStatement deleteRolePermissionPrepStmt = null;
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getUserDBConnection();
            deleteRolePermissionPrepStmt = connection.prepareStatement("DELETE FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID = ?");
            deleteRolePermissionPrepStmt.setInt(1, id);
            deleteRolePermissionPrepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement(deleteRolePermissionPrepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deleteRolePermissionPrepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePermission(int entryId) throws SQLException {
        PreparedStatement deletePermissionPrepStmt = null;
        Connection connection = null;
        try {
            connection = IdentityDatabaseUtil.getUserDBConnection();
            deletePermissionPrepStmt = connection.prepareStatement("DELETE FROM UM_PERMISSION WHERE UM_ID = ?");
            deletePermissionPrepStmt.setInt(1, entryId);
            deletePermissionPrepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityApplicationManagementUtil.closeStatement(deletePermissionPrepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            throw throwable;
        }
        IdentityApplicationManagementUtil.closeStatement((PreparedStatement)deletePermissionPrepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    private void updateAuthenticationScriptConfiguration(int applicationId, LocalAndOutboundAuthenticationConfig localAndOutboundAuthConfig, Connection connection, int tenantID) throws SQLException {
        if (localAndOutboundAuthConfig.getAuthenticationScriptConfig() != null) {
            AuthenticationScriptConfig authenticationScriptConfig = localAndOutboundAuthConfig.getAuthenticationScriptConfig();
            try (PreparedStatement storeAuthScriptPrepStmt = connection.prepareStatement("INSERT INTO SP_AUTH_SCRIPT (TENANT_ID, APP_ID, TYPE,  CONTENT, IS_ENABLED) VALUES (?,?,?,?,?)");){
                storeAuthScriptPrepStmt.setInt(1, tenantID);
                storeAuthScriptPrepStmt.setInt(2, applicationId);
                storeAuthScriptPrepStmt.setString(3, authenticationScriptConfig.getLanguage());
                this.setBlobValue(authenticationScriptConfig.getContent(), storeAuthScriptPrepStmt, 4);
                storeAuthScriptPrepStmt.setString(5, authenticationScriptConfig.isEnabled() ? "1" : "0");
                storeAuthScriptPrepStmt.execute();
            }
            catch (IOException ex) {
                this.log.error((Object)"Error occurred while updating authentication script configuration.", (Throwable)ex);
            }
        }
    }

    private void deleteAuthenticationScript(int applicationId, Connection connection) throws SQLException {
        PreparedStatement deleteLocalAndOutboundAuthScriptConfigPrepStmt = connection.prepareStatement("DELETE FROM SP_AUTH_SCRIPT WHERE APP_ID = ?");
        deleteLocalAndOutboundAuthScriptConfigPrepStmt.setInt(1, applicationId);
        deleteLocalAndOutboundAuthScriptConfigPrepStmt.execute();
    }

    private void setBlobValue(String value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBlobValue(InputStream is) throws IOException {
        if (is != null) {
            BufferedReader br = null;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Error in retrieving the Blob value", (Throwable)e);
                    }
                }
            }
            return sb.toString();
        }
        return null;
    }

    private void updateConfigurationsAsServiceProperties(ServiceProvider sp) {
        if (sp.getSpProperties() == null) {
            sp.setSpProperties(new ServiceProviderProperty[0]);
        }
        Map spPropertyMap = Arrays.stream(sp.getSpProperties()).collect(Collectors.toMap(ServiceProviderProperty::getName, Function.identity()));
        if (sp.getLocalAndOutBoundAuthenticationConfig() != null) {
            ServiceProviderProperty userUserStoreDomainInRoles = this.buildUserStoreDomainInRolesProperty(sp);
            spPropertyMap.put(userUserStoreDomainInRoles.getName(), userUserStoreDomainInRoles);
            ServiceProviderProperty skipConsentProperty = this.buildSkipConsentProperty(sp);
            spPropertyMap.put(skipConsentProperty.getName(), skipConsentProperty);
            ServiceProviderProperty skipLogoutConsentProperty = this.buildSkipLogoutConsentProperty(sp);
            spPropertyMap.put(skipLogoutConsentProperty.getName(), skipLogoutConsentProperty);
        }
        ServiceProviderProperty jwksUri = this.buildJwksProperty(sp);
        spPropertyMap.put(jwksUri.getName(), jwksUri);
        ServiceProviderProperty templateIdProperty = this.buildTemplateIdProperty(sp);
        spPropertyMap.put(templateIdProperty.getName(), templateIdProperty);
        sp.setSpProperties(spPropertyMap.values().toArray(new ServiceProviderProperty[0]));
    }

    private ServiceProviderProperty buildTemplateIdProperty(ServiceProvider sp) {
        ServiceProviderProperty templateIdProperty = new ServiceProviderProperty();
        templateIdProperty.setName("templateId");
        templateIdProperty.setDisplayName("Template Id");
        templateIdProperty.setValue(StringUtils.isNotBlank((String)sp.getTemplateId()) ? sp.getTemplateId() : "");
        return templateIdProperty;
    }

    private ServiceProviderProperty buildJwksProperty(ServiceProvider sp) {
        ServiceProviderProperty jwksUri = new ServiceProviderProperty();
        jwksUri.setName("jwksURI");
        jwksUri.setDisplayName("jwksURI");
        jwksUri.setValue(StringUtils.isNotBlank((String)sp.getJwksUri()) ? sp.getJwksUri() : "");
        return jwksUri;
    }

    private ServiceProviderProperty buildSkipConsentProperty(ServiceProvider sp) {
        ServiceProviderProperty skipConsentProperty = new ServiceProviderProperty();
        skipConsentProperty.setName("skipConsent");
        skipConsentProperty.setDisplayName("Skip Consent");
        skipConsentProperty.setValue(String.valueOf(sp.getLocalAndOutBoundAuthenticationConfig().isSkipConsent()));
        return skipConsentProperty;
    }

    private ServiceProviderProperty buildSkipLogoutConsentProperty(ServiceProvider sp) {
        ServiceProviderProperty skipLogoutConsentProperty = new ServiceProviderProperty();
        skipLogoutConsentProperty.setName("skipLogoutConsent");
        skipLogoutConsentProperty.setDisplayName("Skip Logout Consent");
        skipLogoutConsentProperty.setValue(String.valueOf(sp.getLocalAndOutBoundAuthenticationConfig().isSkipLogoutConsent()));
        return skipLogoutConsentProperty;
    }

    private ServiceProviderProperty buildUserStoreDomainInRolesProperty(ServiceProvider sp) {
        ServiceProviderProperty property = new ServiceProviderProperty();
        property.setName(USE_DOMAIN_IN_ROLES);
        property.setDisplayName(USE_DOMAIN_IN_ROLE_DISPLAY_NAME);
        property.setValue(String.valueOf(sp.getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInRoles()));
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadApplicationPermissions(String serviceProviderName, ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(serviceProvider.getOwner().getTenantDomain());
            List<ApplicationPermission> permissionList = ApplicationMgtUtil.loadPermissions(serviceProviderName);
            if (permissionList != null) {
                PermissionsAndRoleConfig permissionAndRoleConfig = serviceProvider.getPermissionAndRoleConfig() == null ? new PermissionsAndRoleConfig() : serviceProvider.getPermissionAndRoleConfig();
                permissionAndRoleConfig.setPermissions(permissionList.toArray(new ApplicationPermission[0]));
                serviceProvider.setPermissionAndRoleConfig(permissionAndRoleConfig);
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    private void validateAttributesForPagination(int offset, int limit) throws IdentityApplicationManagementException {
        if (offset < 0) {
            throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.INVALID_OFFSET.getCode(), "Invalid offset requested. Offset value should be zero or greater than zero.");
        }
        if (limit <= 0) {
            throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.INVALID_LIMIT.getCode(), "Invalid limit requested. Limit value should be greater than zero.");
        }
    }

    private void validateRequestedPageNumber(int pageNumber) throws IdentityApplicationManagementException {
        if (pageNumber < 1) {
            throw new IdentityApplicationManagementException("Invalid page number requested. The page number should be a value greater than 0.");
        }
    }

    private void validateForUnImplementedSortingAttributes(String sortOrder, String sortBy) throws IdentityApplicationManagementServerException {
        if (StringUtils.isNotBlank((String)sortBy) || StringUtils.isNotBlank((String)sortOrder)) {
            throw new IdentityApplicationManagementServerException(IdentityApplicationConstants.Error.SORTING_NOT_IMPLEMENTED.getCode(), "Sorting not supported.");
        }
    }

    @Override
    public ApplicationBasicInfo getApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting application basic information for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain));
        }
        ApplicationBasicInfo applicationBasicInfo = null;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, IS_DISCOVERABLE, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND UUID = :UUID;");){
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            statement.setString("UUID", resourceId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    applicationBasicInfo = this.buildApplicationBasicInfo(resultSet);
                }
            }
        }
        catch (SQLException e) {
            String message = "Error while getting application basic information for resourceId: %s in tenantDomain: %s";
            throw new IdentityApplicationManagementException(String.format(message, resourceId, tenantDomain), (Throwable)e);
        }
        return applicationBasicInfo;
    }

    @Override
    public String addApplication(ServiceProvider application, String tenantDomain) throws IdentityApplicationManagementException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        try {
            ApplicationCreateResult result = this.persistBasicApplicationInformation(connection, application, tenantDomain);
            int applicationId = result.getApplicationId();
            String resourceId = result.getApplicationResourceId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Application with name: " + application.getApplicationName() + " in tenantDomain: " + tenantDomain + " has been created with appId: " + applicationId + " and resourceId: " + resourceId));
            }
            application.setApplicationID(applicationId);
            application.setApplicationResourceId(resourceId);
            this.addApplicationConfigurations(connection, application, tenantDomain);
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
            String string = resourceId;
            return string;
        }
        catch (SQLException | UserStoreException e) {
            this.log.error((Object)("Error while creating the application with name: " + application.getApplicationName() + " in tenantDomain: " + tenantDomain + ". Rolling back created application information."));
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            if (this.isApplicationConflict((Exception)e)) {
                throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode(), "Application already exists with name: " + application.getApplicationName() + " in tenantDomain: " + tenantDomain);
            }
            throw new IdentityApplicationManagementException("Error while creating an application: " + application.getApplicationName() + " in tenantDomain: " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    public void updateApplicationByResourceId(String resourceId, String tenantDomain, ServiceProvider updatedApp) throws IdentityApplicationManagementException {
        try {
            int appIdUsingResourceId = this.getAppIdUsingResourceId(resourceId, tenantDomain);
            updatedApp.setApplicationID(appIdUsingResourceId);
            this.updateApplication(updatedApp, tenantDomain);
        }
        catch (IdentityApplicationManagementException ex) {
            throw new IdentityApplicationManagementServerException("Error while updating application with resourceId: " + resourceId + " in tenantDomain: " + tenantDomain, (Throwable)ex);
        }
    }

    @Override
    public ServiceProvider getApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            int appId = this.getAppIdUsingResourceId(resourceId, tenantDomain);
            ServiceProvider application = this.getApplication(appId);
            if (application == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot find an application for resourceId:" + resourceId + ", tenantDomain:" + tenantDomain));
            }
            return application;
        }
        catch (IdentityApplicationManagementException ex) {
            throw new IdentityApplicationManagementServerException("Error while retrieving application with resourceId: " + resourceId + " in tenantDomain: " + tenantDomain, (Throwable)ex);
        }
    }

    @Override
    public void deleteApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        block31: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deleting Application with resourceId: " + resourceId + " in tenantDomain: " + tenantDomain));
            }
            try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
                ServiceProvider application = this.getApplicationByResourceId(resourceId, tenantDomain);
                if (application != null) {
                    this.deleteApplicationCertificate(connection, application);
                    try (NamedPreparedStatement deleteAppStatement = new NamedPreparedStatement(connection, "DELETE FROM SP_APP WHERE UUID=:UUID; AND TENANT_ID=:TENANT_ID;");){
                        deleteAppStatement.setString("UUID", resourceId);
                        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
                        deleteAppStatement.setInt("TENANT_ID", tenantId);
                        deleteAppStatement.execute();
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        break block31;
                    }
                    catch (SQLException ex) {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        String msg = "Error occurred while deleting application with resourceId: %s in tenantDomain: %s.";
                        throw new IdentityApplicationManagementException(String.format(msg, resourceId, tenantDomain), (Throwable)ex);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    String msg = "Trying to delete a non-existing application with resourceId: %s in tenantDomain: %s.";
                    this.log.debug((Object)String.format(msg, resourceId, tenantDomain));
                }
            }
            catch (SQLException e) {
                String msg = "Error occurred while deleting application with resourceId: %s in tenantDomain: %s.";
                throw new IdentityApplicationManagementException(String.format(msg, resourceId, tenantDomain), (Throwable)e);
            }
        }
    }

    @Override
    public List<ApplicationBasicInfo> getDiscoverableApplicationBasicInfo(int limit, int offset, String filter, String sortOrder, String sortBy, String tenantDomain) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieving application basic information of discoverable applications for limit: " + limit + " offset: " + offset + " filter: " + filter + " sortOrder: " + sortOrder + " sortBy: " + sortBy + " in tenantDomain: " + tenantDomain));
        }
        this.validateForUnImplementedSortingAttributes(sortOrder, sortBy);
        this.validateAttributesForPagination(offset, limit);
        if (StringUtils.isBlank((String)filter) || "*".equals(filter)) {
            return this.getDiscoverableApplicationBasicInfo(limit, offset, tenantDomain);
        }
        String filterResolvedForSQL = this.resolveSQLFilter(filter);
        ArrayList<ApplicationBasicInfo> applicationBasicInfoList = new ArrayList<ApplicationBasicInfo>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String databaseVendorType = connection.getMetaData().getDatabaseProductName();
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, this.getDBVendorSpecificDiscoverableAppRetrievalQueryByAppName(databaseVendorType));){
                statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
                statement.setString("APP_NAME", filterResolvedForSQL);
                statement.setInt("OFFSET", offset);
                statement.setInt("LIMIT", limit);
                statement.setInt("ZERO_BASED_START_INDEX", offset);
                statement.setInt("ONE_BASED_START_INDEX", offset + 1);
                statement.setInt("END_INDEX", offset + limit);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        applicationBasicInfoList.add(this.buildApplicationBasicInfo(resultSet));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting application basic information for discoverable applications in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        return Collections.unmodifiableList(applicationBasicInfoList);
    }

    @Override
    public int getCountOfDiscoverableApplications(String filter, String tenantDomain) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting count of discoverable applications matching filter: " + filter + " in tenantDomain: " + tenantDomain));
        }
        if (StringUtils.isBlank((String)filter) || "*".equals(filter)) {
            return this.getCountOfDiscoverableApplications(tenantDomain);
        }
        int count = 0;
        String filterResolvedForSQL = this.resolveSQLFilter(filter);
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT COUNT(UUID) FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1'");){
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            statement.setString("APP_NAME", filterResolvedForSQL);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting count of discoverable applications matching filter:" + filter + " in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        return count;
    }

    @Override
    public ApplicationBasicInfo getDiscoverableApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting application basic information for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain + " if discoverable."));
        }
        ApplicationBasicInfo applicationBasicInfo = null;
        boolean isDiscoverable = false;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, IS_DISCOVERABLE, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND UUID = :UUID;");){
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            statement.setString("UUID", resourceId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    applicationBasicInfo = this.buildApplicationBasicInfo(resultSet);
                    isDiscoverable = this.getBooleanValue(resultSet.getString("IS_DISCOVERABLE"));
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting discoverable application basic information for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        if (applicationBasicInfo != null && !isDiscoverable) {
            throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.APPLICATION_NOT_DISCOVERABLE.getCode(), "Requested application resource " + resourceId + " is not discoverable.");
        }
        return applicationBasicInfo;
    }

    @Override
    public boolean isApplicationDiscoverable(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        int count = 0;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT COUNT(UUID) FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND UUID = :UUID; AND IS_DISCOVERABLE = '1'");){
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            statement.setString("UUID", resourceId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting discoverable application basic information for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        return count > 0;
    }

    private List<ApplicationBasicInfo> getDiscoverableApplicationBasicInfo(int limit, int offset, String tenantDomain) throws IdentityApplicationManagementException {
        ArrayList<ApplicationBasicInfo> applicationBasicInfoList = new ArrayList<ApplicationBasicInfo>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            String databaseVendorType = connection.getMetaData().getDatabaseProductName();
            try (NamedPreparedStatement statement = new NamedPreparedStatement(connection, this.getDBVendorSpecificDiscoverableAppRetrievalQuery(databaseVendorType));){
                statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
                statement.setInt("OFFSET", offset);
                statement.setInt("LIMIT", limit);
                statement.setInt("ZERO_BASED_START_INDEX", offset);
                statement.setInt("ONE_BASED_START_INDEX", offset + 1);
                statement.setInt("END_INDEX", offset + limit);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        applicationBasicInfoList.add(this.buildApplicationBasicInfo(resultSet));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting application basic information for discoverable applications in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        return Collections.unmodifiableList(applicationBasicInfoList);
    }

    private int getCountOfDiscoverableApplications(String tenantDomain) throws IdentityApplicationManagementException {
        int count;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT COUNT(UUID) FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1'");){
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            try (ResultSet resultSet = statement.executeQuery();){
                resultSet.next();
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new IdentityApplicationManagementServerException("Error while getting count of discoverable applications in tenantDomain: " + tenantDomain, (Throwable)e);
        }
        return count;
    }

    private String getDBVendorSpecificDiscoverableAppRetrievalQueryByAppName(String dbVendorType) throws IdentityApplicationManagementException {
        if ("MySQL".equals(dbVendorType) || "MariaDB".equals(dbVendorType) || "H2".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION , UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC LIMIT :OFFSET;, :LIMIT;";
        }
        if ("Oracle".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID, rownum AS rnum FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP ORDER BY ID DESC) WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND rownum <= :END_INDEX; AND IS_DISCOVERABLE = '1') WHERE rnum > :ZERO_BASED_START_INDEX;";
        }
        if ("Microsoft SQL Server".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC OFFSET :OFFSET; ROWS FETCH NEXT :LIMIT; ROWS ONLY";
        }
        if ("PostgreSQL".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC LIMIT :LIMIT; OFFSET :OFFSET;";
        }
        if (dbVendorType != null && dbVendorType.contains("DB2")) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ROW_NUMBER() OVER(ORDER BY ID DESC) AS rn,SP_APP.* FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1)WHERE rn BETWEEN :ONE_BASED_START_INDEX; AND :END_INDEX;";
        }
        if ("INFORMIX".equals(dbVendorType)) {
            return "SELECT SKIP :OFFSET; FIRST :LIMIT; ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND APP_NAME LIKE :APP_NAME; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC";
        }
        throw new IdentityApplicationManagementException("Error while loading discoverable applications from DB. Database driver for " + dbVendorType + "could not be identified or not supported.");
    }

    private String getDBVendorSpecificDiscoverableAppRetrievalQuery(String dbVendorType) throws IdentityApplicationManagementException {
        if ("MySQL".equals(dbVendorType) || "MariaDB".equals(dbVendorType) || "H2".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC LIMIT :OFFSET;, :LIMIT;";
        }
        if ("Oracle".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID, rownum AS rnum FROM (SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID, IS_DISCOVERABLE FROM SP_APP ORDER BY ID DESC) WHERE TENANT_ID = :TENANT_ID; AND rownum <= :END_INDEX; AND IS_DISCOVERABLE = '1') WHERE rnum > :ZERO_BASED_START_INDEX;";
        }
        if ("Microsoft SQL Server".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC OFFSET :OFFSET; ROWS FETCH NEXT :LIMIT; ROWS ONLY";
        }
        if ("PostgreSQL".equals(dbVendorType)) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC LIMIT :LIMIT; OFFSET :OFFSET;";
        }
        if (dbVendorType != null && dbVendorType.contains("DB2")) {
            return "SELECT ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM (SELECT ROW_NUMBER() OVER(ORDER BY ID DESC) AS rn,SP_APP.* FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1') WHERE rn BETWEEN :ONE_BASED_START_INDEX; AND :END_INDEX;";
        }
        if ("INFORMIX".equals(dbVendorType)) {
            return "SELECT SKIP :OFFSET; FIRST :LIMIT; ID, APP_NAME, DESCRIPTION, UUID, IMAGE_URL, ACCESS_URL, USERNAME, USER_STORE, TENANT_ID FROM SP_APP WHERE TENANT_ID = :TENANT_ID; AND IS_DISCOVERABLE = '1' ORDER BY ID DESC";
        }
        throw new IdentityApplicationManagementException("Error while loading discoverable applications from DB. Database driver for " + dbVendorType + "could not be identified or not supported.");
    }

    private ApplicationBasicInfo buildApplicationBasicInfo(ResultSet appNameResultSet) throws SQLException {
        ApplicationBasicInfo basicInfo = new ApplicationBasicInfo();
        basicInfo.setApplicationId(appNameResultSet.getInt("ID"));
        basicInfo.setApplicationName(appNameResultSet.getString("APP_NAME"));
        basicInfo.setDescription(appNameResultSet.getString("DESCRIPTION"));
        basicInfo.setApplicationResourceId(appNameResultSet.getString("UUID"));
        basicInfo.setImageUrl(appNameResultSet.getString("IMAGE_URL"));
        basicInfo.setAccessUrl(appNameResultSet.getString("ACCESS_URL"));
        String username = appNameResultSet.getString("USERNAME");
        String userStoreDomain = appNameResultSet.getString("USER_STORE");
        int tenantId = appNameResultSet.getInt("TENANT_ID");
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)userStoreDomain) && tenantId != -1) {
            User appOwner = new User();
            appOwner.setUserStoreDomain(userStoreDomain);
            appOwner.setUserName(username);
            appOwner.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)tenantId));
            basicInfo.setAppOwner(appOwner);
        }
        return basicInfo;
    }

    private int getAppIdUsingResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        int applicationId = 0;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             NamedPreparedStatement statement = new NamedPreparedStatement(connection, "SELECT ID FROM SP_APP WHERE UUID = :UUID; AND TENANT_ID = :TENANT_ID;");){
            statement.setString("UUID", resourceId);
            statement.setInt("TENANT_ID", IdentityTenantUtil.getTenantId((String)tenantDomain));
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    applicationId = resultSet.getInt("ID");
                }
            }
        }
        catch (SQLException e) {
            String msg = "Error while retrieving the application id for resourceId: %s in tenantDomain:  %s";
            throw new IdentityApplicationManagementException(String.format(msg, resourceId, tenantDomain), (Throwable)e);
        }
        return applicationId;
    }

    /*
     * Exception decompiling
     */
    private String getResourceIdUsingAppId(int appId, String tenantDomain) throws IdentityApplicationManagementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteApplicationCertificate(Connection connection, ServiceProvider application) throws SQLException {
        String certificateReferenceID = this.getCertificateReferenceID(application.getSpProperties());
        if (certificateReferenceID != null) {
            this.deleteCertificate(connection, Integer.parseInt(certificateReferenceID));
        }
    }

    private String generateApplicationResourceId(ServiceProvider serviceProvider) {
        return UUID.randomUUID().toString();
    }

    private boolean isApplicationAlreadyExistsError(IdentityApplicationManagementException ex) {
        return ex instanceof IdentityApplicationRegistrationFailureException && IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode().contains(ex.getErrorCode());
    }

    private int createServiceProvider(String tenantDomain, ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        int applicationId;
        try {
            applicationId = this.createApplication(serviceProvider, tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            if (!this.isApplicationAlreadyExistsError(e)) {
                throw new IdentityApplicationManagementException("Failed to retrieve application: " + serviceProvider.getApplicationName() + " in tenantDomain: " + tenantDomain, (Throwable)e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("The service provider: " + serviceProvider.getApplicationName() + ", tried to create, is already exists. Therefore, this duplication attempt error is ignored and existing application id is used"), (Throwable)e);
            }
            applicationId = this.getApplicationIdByName(serviceProvider.getApplicationName(), tenantDomain);
        }
        return applicationId;
    }

    private void audit(String action, String data, String result) {
        String loggedInUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUser)) {
            loggedInUser = "wso2.system.user";
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        loggedInUser = UserCoreUtil.addTenantDomainToEntry((String)loggedInUser, (String)tenantDomain);
        AUDIT_LOG.info((Object)String.format(AUDIT_MESSAGE, loggedInUser, action, data, result));
    }

    private static class ApplicationCreateResult {
        private String applicationResourceId;
        private int applicationId;

        ApplicationCreateResult(String applicationResourceId, int applicationId) {
            this.applicationResourceId = applicationResourceId;
            this.applicationId = applicationId;
        }

        String getApplicationResourceId() {
            return this.applicationResourceId;
        }

        int getApplicationId() {
            return this.applicationId;
        }
    }
}

