/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementValidationException;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationConstants;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.dao.impl.ApplicationDAOImpl;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementServiceImpl;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;

public class ApplicationMgtValidator {
    private static Log log = LogFactory.getLog(ApplicationMgtValidator.class);
    private static final String AUTHENTICATOR_NOT_AVAILABLE = "Authenticator %s is not available in the server.";
    private static final String AUTHENTICATOR_NOT_CONFIGURED = "Authenticator %s is not configured for %s identity Provider.";
    private static final String PROVISIONING_CONNECTOR_NOT_CONFIGURED = "No Provisioning connector configured for %s.";
    private static final String FEDERATED_IDP_NOT_AVAILABLE = "Federated Identity Provider %s is not available in the server.";
    private static final String CLAIM_DIALECT_NOT_AVAILABLE = "Claim Dialect %s is not available in the server for tenantDomain:%s.";
    private static final String CLAIM_NOT_AVAILABLE = "Local claim %s is not available in the server for tenantDomain:%s.";
    private static final String SP_CLAIM_NOT_AVAILABLE = "Application Claim URI '%s' is not defined for application:%s.";
    private static final String ROLE_NOT_AVAILABLE = "Local Role %s is not available in the server.";
    public static final String IS_HANDLER = "IS_HANDLER";

    public void validateSPConfigurations(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        this.validateDiscoverabilityConfigs(validationErrors, serviceProvider);
        this.validateInboundAuthenticationConfig(serviceProvider.getInboundAuthenticationConfig(), tenantDomain, serviceProvider.getApplicationID());
        this.validateLocalAndOutBoundAuthenticationConfig(validationErrors, serviceProvider.getLocalAndOutBoundAuthenticationConfig(), tenantDomain);
        this.validateRequestPathAuthenticationConfig(validationErrors, serviceProvider.getRequestPathAuthenticatorConfigs(), tenantDomain);
        this.validateOutBoundProvisioning(validationErrors, serviceProvider.getOutboundProvisioningConfig(), tenantDomain);
        this.validateClaimsConfigs(validationErrors, serviceProvider.getClaimConfig(), serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null ? serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSubjectClaimUri() : null, tenantDomain, serviceProvider.getApplicationName());
        this.validateRoleConfigs(validationErrors, serviceProvider.getPermissionAndRoleConfig(), tenantDomain);
        if (!validationErrors.isEmpty()) {
            String code = IdentityApplicationConstants.Error.INVALID_REQUEST.getCode();
            throw new IdentityApplicationManagementValidationException(code, validationErrors.toArray(new String[0]));
        }
    }

    private void validateDiscoverabilityConfigs(List<String> validationErrors, ServiceProvider serviceProvider) {
        String validationErrorFormat = "A valid %s needs to be defined if an application is marked as discoverable.";
        if (serviceProvider.isDiscoverable() && StringUtils.isBlank((String)serviceProvider.getAccessUrl())) {
            validationErrors.add(String.format(validationErrorFormat, "accessURL"));
        }
    }

    private void validateInboundAuthenticationConfig(InboundAuthenticationConfig inboundAuthenticationConfig, String tenantDomain, int appId) throws IdentityApplicationManagementException {
        if (inboundAuthenticationConfig == null) {
            return;
        }
        Object[] inboundAuthRequestConfigs = inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs();
        if (ArrayUtils.isNotEmpty((Object[])inboundAuthRequestConfigs)) {
            for (Object inboundAuthRequestConfig : inboundAuthRequestConfigs) {
                this.validateInboundAuthKey((InboundAuthenticationRequestConfig)inboundAuthRequestConfig, appId, tenantDomain);
            }
        }
    }

    private void validateInboundAuthKey(InboundAuthenticationRequestConfig inboundConfig, int appId, String tenantDomain) throws IdentityApplicationManagementException {
        if (inboundConfig == null) {
            return;
        }
        ApplicationDAOImpl applicationDAO = new ApplicationDAOImpl();
        String existingAppName = applicationDAO.getServiceProviderNameByClientId(inboundConfig.getInboundAuthKey(), inboundConfig.getInboundAuthType(), CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        if (StringUtils.isBlank((String)existingAppName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find application name for the inbound auth key: " + inboundConfig.getInboundAuthKey() + " of inbound auth type: " + inboundConfig.getInboundAuthType()));
            }
            return;
        }
        ServiceProvider existingApp = applicationDAO.getApplication(existingAppName, tenantDomain);
        if (existingApp != null && existingApp.getApplicationID() != appId) {
            String msg = "Inbound key: '" + inboundConfig.getInboundAuthKey() + "' of inbound auth type: '" + inboundConfig.getInboundAuthType() + "' is already configured for the application :'" + existingApp.getApplicationName() + "'";
            throw this.buildClientException(IdentityApplicationConstants.Error.INBOUND_KEY_ALREADY_EXISTS, msg);
        }
    }

    private IdentityApplicationManagementClientException buildClientException(IdentityApplicationConstants.Error errorMessage, String message) {
        return new IdentityApplicationManagementClientException(errorMessage.getCode(), message);
    }

    private void validateLocalAndOutBoundAuthenticationConfig(List<String> validationMsg, LocalAndOutboundAuthenticationConfig localAndOutBoundAuthenticationConfig, String tenantDomain) throws IdentityApplicationManagementException {
        if (localAndOutBoundAuthenticationConfig == null) {
            return;
        }
        AuthenticationStep[] authenticationSteps = localAndOutBoundAuthenticationConfig.getAuthenticationSteps();
        if (authenticationSteps == null || authenticationSteps.length == 0) {
            return;
        }
        ApplicationManagementService applicationMgtService = ApplicationManagementService.getInstance();
        Map<String, Property[]> allLocalAuthenticators = Arrays.stream(applicationMgtService.getAllLocalAuthenticators(tenantDomain)).collect(Collectors.toMap(LocalAuthenticatorConfig::getName, LocalAuthenticatorConfig::getProperties));
        AtomicBoolean isAuthenticatorIncluded = new AtomicBoolean(false);
        for (AuthenticationStep authenticationStep : authenticationSteps) {
            for (IdentityProvider identityProvider : authenticationStep.getFederatedIdentityProviders()) {
                this.validateFederatedIdp(identityProvider, isAuthenticatorIncluded, validationMsg, tenantDomain);
            }
            for (IdentityProvider identityProvider : authenticationStep.getLocalAuthenticatorConfigs()) {
                if (!allLocalAuthenticators.containsKey(identityProvider.getName())) {
                    validationMsg.add(String.format(AUTHENTICATOR_NOT_AVAILABLE, identityProvider.getName()));
                    continue;
                }
                if (isAuthenticatorIncluded.get()) continue;
                Property[] properties = allLocalAuthenticators.get(identityProvider.getName());
                if (properties.length == 0) {
                    isAuthenticatorIncluded.set(true);
                    continue;
                }
                for (Property property : properties) {
                    if (IS_HANDLER.equals(property.getName()) && Boolean.parseBoolean(property.getValue())) continue;
                    isAuthenticatorIncluded.set(true);
                }
            }
        }
        if (!isAuthenticatorIncluded.get()) {
            validationMsg.add("No authenticator have been registered in the authentication flow.");
        }
    }

    private void validateRequestPathAuthenticationConfig(List<String> validationMsg, RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigs, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationManagementService applicationMgtService = ApplicationManagementService.getInstance();
        Map<String, Property[]> allRequestPathAuthenticators = Arrays.stream(applicationMgtService.getAllRequestPathAuthenticators(tenantDomain)).collect(Collectors.toMap(LocalAuthenticatorConfig::getName, LocalAuthenticatorConfig::getProperties));
        if (requestPathAuthenticatorConfigs != null) {
            for (RequestPathAuthenticatorConfig config : requestPathAuthenticatorConfigs) {
                if (allRequestPathAuthenticators.containsKey(config.getName())) continue;
                validationMsg.add(String.format(AUTHENTICATOR_NOT_AVAILABLE, config.getName()));
            }
        }
    }

    private void validateFederatedIdp(IdentityProvider idp, AtomicBoolean isAuthenticatorIncluded, List<String> validationMsg, String tenantDomain) {
        try {
            IdentityProvider savedIdp = IdentityProviderManager.getInstance().getIdPByName(idp.getIdentityProviderName(), tenantDomain, false);
            if (savedIdp.getId() == null) {
                validationMsg.add(String.format(FEDERATED_IDP_NOT_AVAILABLE, idp.getIdentityProviderName()));
            } else if (savedIdp.getFederatedAuthenticatorConfigs() != null) {
                isAuthenticatorIncluded.set(true);
                List savedIdpAuthenticators = Arrays.stream(savedIdp.getFederatedAuthenticatorConfigs()).map(FederatedAuthenticatorConfig::getName).collect(Collectors.toList());
                for (FederatedAuthenticatorConfig federatedAuth : idp.getFederatedAuthenticatorConfigs()) {
                    if (savedIdpAuthenticators.contains(federatedAuth.getName())) continue;
                    validationMsg.add(String.format(AUTHENTICATOR_NOT_CONFIGURED, federatedAuth.getName(), idp.getIdentityProviderName()));
                }
            } else {
                for (FederatedAuthenticatorConfig federatedAuth : idp.getFederatedAuthenticatorConfigs()) {
                    validationMsg.add(String.format(AUTHENTICATOR_NOT_CONFIGURED, federatedAuth.getName(), idp.getIdentityProviderName()));
                }
            }
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format(FEDERATED_IDP_NOT_AVAILABLE, idp.getIdentityProviderName());
            log.error((Object)errorMsg, (Throwable)e);
            validationMsg.add(errorMsg);
        }
    }

    private void validateOutBoundProvisioning(List<String> validationMsg, OutboundProvisioningConfig outboundProvisioningConfig, String tenantDomain) {
        if (outboundProvisioningConfig == null || outboundProvisioningConfig.getProvisioningIdentityProviders() == null) {
            return;
        }
        for (IdentityProvider idp : outboundProvisioningConfig.getProvisioningIdentityProviders()) {
            try {
                IdentityProvider savedIdp = IdentityProviderManager.getInstance().getIdPByName(idp.getIdentityProviderName(), tenantDomain, false);
                if (savedIdp == null) {
                    validationMsg.add(String.format(FEDERATED_IDP_NOT_AVAILABLE, idp.getIdentityProviderName()));
                    continue;
                }
                if (savedIdp.getDefaultProvisioningConnectorConfig() != null || savedIdp.getProvisioningConnectorConfigs() != null) continue;
                validationMsg.add(String.format(PROVISIONING_CONNECTOR_NOT_CONFIGURED, idp.getIdentityProviderName()));
            }
            catch (IdentityProviderManagementException e) {
                validationMsg.add(String.format(FEDERATED_IDP_NOT_AVAILABLE, idp.getIdentityProviderName()));
            }
        }
    }

    private void validateClaimsConfigs(List<String> validationMsg, ClaimConfig claimConfig, String subjectClaimUri, String tenantDomain, String serviceProviderName) throws IdentityApplicationManagementException {
        String[] spClaimDialects;
        if (claimConfig == null) {
            return;
        }
        ApplicationManagementService applicationMgtService = ApplicationManagementService.getInstance();
        String[] allLocalClaimUris = applicationMgtService.getAllLocalClaimUris(tenantDomain);
        ArrayList<String> remoteClaimUris = new ArrayList<String>();
        ClaimMapping[] claimMappings = claimConfig.getClaimMappings();
        if (claimMappings != null) {
            for (ClaimMapping claimMapping : claimMappings) {
                String claimUri = claimMapping.getLocalClaim().getClaimUri();
                remoteClaimUris.add(claimMapping.getRemoteClaim().getClaimUri());
                if (Arrays.asList(allLocalClaimUris).contains(claimUri)) continue;
                validationMsg.add(String.format(CLAIM_NOT_AVAILABLE, claimUri, tenantDomain));
            }
        }
        String roleClaimUri = claimConfig.getRoleClaimURI();
        String userClaimUri = claimConfig.getUserClaimURI();
        if (claimConfig.isLocalClaimDialect()) {
            if (StringUtils.isNotBlank((String)roleClaimUri) && !Arrays.asList(allLocalClaimUris).contains(roleClaimUri)) {
                validationMsg.add(String.format(CLAIM_NOT_AVAILABLE, roleClaimUri, tenantDomain));
            }
            if (StringUtils.isNotBlank((String)userClaimUri) && !Arrays.asList(allLocalClaimUris).contains(userClaimUri)) {
                validationMsg.add(String.format(CLAIM_NOT_AVAILABLE, userClaimUri, tenantDomain));
            }
            if (StringUtils.isNotBlank((String)subjectClaimUri) && !Arrays.asList(allLocalClaimUris).contains(subjectClaimUri)) {
                validationMsg.add(String.format(CLAIM_NOT_AVAILABLE, subjectClaimUri, tenantDomain));
            }
        } else {
            if (StringUtils.isNotBlank((String)roleClaimUri) && !remoteClaimUris.contains(roleClaimUri)) {
                validationMsg.add(String.format(SP_CLAIM_NOT_AVAILABLE, roleClaimUri, serviceProviderName));
            }
            if (StringUtils.isNotBlank((String)userClaimUri) && !remoteClaimUris.contains(userClaimUri)) {
                validationMsg.add(String.format(SP_CLAIM_NOT_AVAILABLE, userClaimUri, serviceProviderName));
            }
            if (StringUtils.isNotBlank((String)subjectClaimUri) && !remoteClaimUris.contains(subjectClaimUri)) {
                validationMsg.add(String.format(SP_CLAIM_NOT_AVAILABLE, subjectClaimUri, serviceProviderName));
            }
        }
        if ((spClaimDialects = claimConfig.getSpClaimDialects()) != null) {
            try {
                ClaimMetadataManagementServiceImpl claimAdminService = new ClaimMetadataManagementServiceImpl();
                List serverClaimMapping = claimAdminService.getClaimDialects(tenantDomain);
                if (serverClaimMapping != null) {
                    List serverDialectURIS = serverClaimMapping.stream().map(ClaimDialect::getClaimDialectURI).collect(Collectors.toList());
                    for (String spClaimDialect : spClaimDialects) {
                        if (serverDialectURIS.contains(spClaimDialect)) continue;
                        validationMsg.add(String.format(CLAIM_DIALECT_NOT_AVAILABLE, spClaimDialect, tenantDomain));
                    }
                }
            }
            catch (ClaimMetadataException e) {
                validationMsg.add(String.format("Error in getting claim dialect for %s. ", tenantDomain));
            }
        }
    }

    private void validateRoleConfigs(List<String> validationMsg, PermissionsAndRoleConfig permissionsAndRoleConfig, String tenantDomain) {
        if (permissionsAndRoleConfig == null || permissionsAndRoleConfig.getRoleMappings() == null) {
            return;
        }
        try {
            UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            for (RoleMapping roleMapping : permissionsAndRoleConfig.getRoleMappings()) {
                if (userStoreManager.isExistingRole(roleMapping.getLocalRole().getLocalRoleName())) continue;
                validationMsg.add(String.format(ROLE_NOT_AVAILABLE, roleMapping.getLocalRole().getLocalRoleName()));
                break;
            }
        }
        catch (UserStoreException e) {
            validationMsg.add(String.format("Error when checking the existence of local roles in %s.", tenantDomain));
        }
    }
}

