/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ApplicationPermission;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.SpFileStream;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponentHolder;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ApplicationMgtUtil {
    public static final String APPLICATION_ROOT_PERMISSION = "applications";
    public static final String PATH_CONSTANT = "/";
    public static final String APP_NAME_VALIDATING_REGEX = "^[a-zA-Z0-9._-]+(?: [a-zA-Z0-9._-]+)*$";
    private static final String SERVICE_PROVIDERS_NAME_REGEX = "ServiceProviders.SPNameRegex";
    private static Log log = LogFactory.getLog(ApplicationMgtUtil.class);

    private ApplicationMgtUtil() {
    }

    public static Permission[] buildPermissions(String applicationName, String[] permissions) {
        Permission[] permissionSet = null;
        if (permissions != null) {
            permissionSet = new Permission[permissions.length];
            int i = 0;
            for (String permissionString : permissions) {
                permissionSet[i] = new Permission(applicationName + "\\" + permissionString, "ui.execute");
            }
        }
        return permissionSet;
    }

    public static boolean isUserAuthorized(String applicationName, String username, int applicationID) throws IdentityApplicationManagementException {
        if (!ApplicationMgtUtil.isUserAuthorized(applicationName, username)) {
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            String storedApplicationName = appDAO.getApplicationName(applicationID);
            return ApplicationMgtUtil.isUserAuthorized(storedApplicationName, username);
        }
        return true;
    }

    public static boolean isUserAuthorized(String applicationName, String username) throws IdentityApplicationManagementException {
        String applicationRoleName = ApplicationMgtUtil.getAppRoleName(applicationName);
        try {
            String[] userRoles;
            UserStoreManager userStoreManager;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking whether user has role : " + applicationRoleName + " by retrieving role list of user : " + username));
            }
            if ((userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager()) instanceof AbstractUserStoreManager) {
                return ((AbstractUserStoreManager)userStoreManager).isUserInRole(username, applicationRoleName);
            }
            for (String userRole : userRoles = userStoreManager.getRoleListOfUser(username)) {
                if (!applicationRoleName.equals(userRole)) continue;
                return true;
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while checking authorization for user: " + username + " for application: " + applicationName, (Throwable)e);
        }
        return false;
    }

    public static void createAppRole(String applicationName, String username) throws IdentityApplicationManagementException {
        String roleName = ApplicationMgtUtil.getAppRoleName(applicationName);
        Object[] usernames = new String[]{username};
        UserStoreManager userStoreManager = null;
        try {
            userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating application role : " + roleName + " and assign the user : " + Arrays.toString(usernames) + " to that role"));
            }
            userStoreManager.addRole(roleName, (String[])usernames, null);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            ApplicationMgtUtil.assignRoleToUser(username, roleName, userStoreManager, e);
        }
    }

    private static void assignRoleToUser(String username, String roleName, UserStoreManager userStoreManager, org.wso2.carbon.user.api.UserStoreException e) throws IdentityApplicationManagementException {
        String errorMsgString = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getMessage(), roleName);
        String errMsg = e.getMessage();
        if (errMsg != null && (errMsg.contains(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode()) || errorMsgString.contains(errMsg))) {
            String[] newRoles = new String[]{roleName};
            if (log.isDebugEnabled()) {
                log.debug((Object)("Application role is already created. Skip creating: " + roleName + " and assigning the user: " + username));
            }
            try {
                userStoreManager.updateRoleListOfUser(username, null, newRoles);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e1) {
                String msg = "Error while updating application role: " + roleName + " with user " + username;
                try {
                    if (ApplicationMgtUtil.isRoleAlreadyApplied(username, roleName, userStoreManager)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("The role: " + roleName + ", is already assigned to the user: " + username + ". Skip assigning"));
                        }
                        return;
                    }
                }
                catch (org.wso2.carbon.user.api.UserStoreException ex) {
                    msg = "Error while getting existing application roles of the user " + username;
                    throw new IdentityApplicationManagementException(msg, (Throwable)ex);
                }
                throw new IdentityApplicationManagementException(msg, (Throwable)e1);
            }
        }
        throw new IdentityApplicationManagementException("Error while creating application role: " + roleName + " with user " + username, (Throwable)e);
    }

    private static boolean isRoleAlreadyApplied(String username, String roleName, UserStoreManager userStoreManager) throws org.wso2.carbon.user.api.UserStoreException {
        boolean isRoleAlreadyApplied = false;
        String[] roleListOfUser = userStoreManager.getRoleListOfUser(username);
        if (roleListOfUser != null) {
            isRoleAlreadyApplied = Arrays.asList(roleListOfUser).contains(roleName);
        }
        return isRoleAlreadyApplied;
    }

    private static String getAppRoleName(String applicationName) {
        return "Application" + UserCoreConstants.DOMAIN_SEPARATOR + applicationName;
    }

    public static void deleteAppRole(String applicationName) throws IdentityApplicationManagementException {
        String roleName = ApplicationMgtUtil.getAppRoleName(applicationName);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting application role : " + roleName));
            }
            CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().deleteRole(roleName);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while creating application", (Throwable)e);
        }
    }

    public static void renameRole(String oldName, String newName) throws org.wso2.carbon.user.api.UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming application role : " + UserCoreUtil.addInternalDomainName((String)oldName) + " to new role : " + UserCoreUtil.addInternalDomainName((String)newName)));
        }
        CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().updateRoleName(UserCoreUtil.addInternalDomainName((String)oldName), UserCoreUtil.addInternalDomainName((String)newName));
    }

    public static void renameAppPermissionPathNode(String oldName, String newName) throws IdentityApplicationManagementException {
        List<ApplicationPermission> loadPermissions = ApplicationMgtUtil.loadPermissions(oldName);
        String newApplicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + PATH_CONSTANT + oldName;
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        try {
            for (ApplicationPermission applicationPermission : loadPermissions) {
                tenantGovReg.delete(newApplicationNode + PATH_CONSTANT + applicationPermission.getValue());
            }
            tenantGovReg.delete(newApplicationNode);
            Collection permissionNode = tenantGovReg.newCollection();
            permissionNode.setProperty("name", newName);
            String applicationNode = newApplicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + PATH_CONSTANT + newName;
            tenantGovReg.put(newApplicationNode, (Resource)permissionNode);
            ApplicationMgtUtil.addPermission(applicationNode, loadPermissions.toArray(new ApplicationPermission[loadPermissions.size()]), tenantGovReg);
        }
        catch (RegistryException e) {
            throw new IdentityApplicationManagementException("Error while renaming permission node " + oldName + "to " + newName, (Throwable)e);
        }
    }

    public static void storePermissions(String applicationName, String username, PermissionsAndRoleConfig permissionsConfig) throws IdentityApplicationManagementException {
        int tenantId = -1;
        try {
            tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            IdentityTenantUtil.initializeRegistry((int)tenantId);
        }
        catch (IdentityException e) {
            throw new IdentityApplicationManagementException("Error loading tenant registry for tenant domain: " + IdentityTenantUtil.getTenantDomain((int)tenantId), (Throwable)e);
        }
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        String permissionResourcePath = ApplicationMgtUtil.getApplicationPermissionPath();
        try {
            if (!tenantGovReg.resourceExists(permissionResourcePath)) {
                boolean loggedInUserChanged = false;
                org.wso2.carbon.user.core.UserRealm realm = (org.wso2.carbon.user.core.UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
                if (!realm.getAuthorizationManager().isUserAuthorized(username, permissionResourcePath, "ui.execute")) {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(realm.getRealmConfiguration().getAdminUserName());
                    tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
                    loggedInUserChanged = true;
                }
                Collection appRootNode = tenantGovReg.newCollection();
                appRootNode.setProperty("name", "Applications");
                tenantGovReg.put(permissionResourcePath, (Resource)appRootNode);
                if (loggedInUserChanged) {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(username);
                }
            }
            if (permissionsConfig != null) {
                ApplicationPermission[] permissions = permissionsConfig.getPermissions();
                if (permissions == null || permissions.length < 1) {
                    return;
                }
                String appNode = permissionResourcePath + PATH_CONSTANT + applicationName;
                Collection appNodeColl = tenantGovReg.newCollection();
                tenantGovReg.put(appNode, (Resource)appNodeColl);
                for (ApplicationPermission permission : permissions) {
                    String permissinPath = appNode + PATH_CONSTANT + permission;
                    Resource permissionNode = tenantGovReg.newResource();
                    permissionNode.setProperty("name", permission.getValue());
                    tenantGovReg.put(permissinPath, permissionNode);
                }
            }
        }
        catch (Exception e) {
            throw new IdentityApplicationManagementException("Error while storing permissions for application " + applicationName, (Throwable)e);
        }
    }

    public static void updatePermissions(String applicationName, ApplicationPermission[] permissions) throws IdentityApplicationManagementException {
        String applicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + PATH_CONSTANT + applicationName;
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        try {
            Collection appNodeCollec;
            String[] childern;
            boolean exist = tenantGovReg.resourceExists(applicationNode);
            if (!exist) {
                Collection appRootNode = tenantGovReg.newCollection();
                appRootNode.setProperty("name", applicationName);
                tenantGovReg.put(applicationNode, (Resource)appRootNode);
            }
            if ((childern = (appNodeCollec = (Collection)tenantGovReg.get(applicationNode)).getChildren()) != null && childern.length > 0 && (permissions == null || permissions.length == 0)) {
                tenantGovReg.delete(applicationNode);
            }
            if (ArrayUtils.isEmpty((Object[])permissions)) {
                return;
            }
            if (childern == null || appNodeCollec.getChildCount() < 1) {
                ApplicationMgtUtil.addPermission(applicationNode, permissions, tenantGovReg);
            } else {
                List<ApplicationPermission> loadPermissions = ApplicationMgtUtil.loadPermissions(applicationName);
                for (ApplicationPermission applicationPermission : loadPermissions) {
                    tenantGovReg.delete(applicationNode + PATH_CONSTANT + applicationPermission.getValue());
                }
                ApplicationMgtUtil.addPermission(applicationNode, permissions, tenantGovReg);
            }
        }
        catch (RegistryException e) {
            throw new IdentityApplicationManagementException("Error while storing permissions", (Throwable)e);
        }
    }

    private static void addPermission(String applicationNode, ApplicationPermission[] permissions, Registry tenantGovReg) throws RegistryException {
        for (ApplicationPermission permission : permissions) {
            String permissionValue = permission.getValue();
            if (PATH_CONSTANT.equals(permissionValue.substring(0, 1))) {
                permissionValue = permissionValue.substring(1);
            }
            String[] splitedPermission = permissionValue.split(PATH_CONSTANT);
            String permissinPath = applicationNode + PATH_CONSTANT;
            for (int i = 0; i < splitedPermission.length; ++i) {
                permissinPath = permissinPath + splitedPermission[i] + PATH_CONSTANT;
                Collection permissionNode = tenantGovReg.newCollection();
                permissionNode.setProperty("name", splitedPermission[i]);
                tenantGovReg.put(permissinPath, (Resource)permissionNode);
            }
        }
    }

    public static List<ApplicationPermission> loadPermissions(String applicationName) throws IdentityApplicationManagementException {
        String applicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + PATH_CONSTANT + applicationName;
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        ArrayList<String> paths = new ArrayList<String>();
        try {
            boolean exist = tenantGovReg.resourceExists(applicationNode);
            if (!exist) {
                return Collections.emptyList();
            }
            boolean loggedInUserChanged = false;
            String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
            org.wso2.carbon.user.core.UserRealm realm = (org.wso2.carbon.user.core.UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            if (loggedInUser == null || !realm.getAuthorizationManager().isUserAuthorized(loggedInUser, applicationNode, "ui.execute")) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(realm.getRealmConfiguration().getAdminUserName());
                tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
                loggedInUserChanged = true;
            }
            paths.clear();
            ArrayList<ApplicationPermission> permissions = new ArrayList<ApplicationPermission>();
            ApplicationMgtUtil.permissionPath(tenantGovReg, applicationNode, paths, applicationNode);
            for (String permissionPath : paths) {
                ApplicationPermission permission = new ApplicationPermission();
                permission.setValue(permissionPath);
                permissions.add(permission);
            }
            if (loggedInUserChanged) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(loggedInUser);
            }
            return permissions;
        }
        catch (RegistryException | UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while reading permissions", e);
        }
    }

    private static void permissionPath(Registry tenantGovReg, String permissionPath, List<String> paths, String applicationNode) throws RegistryException {
        Collection appCollection = (Collection)tenantGovReg.get(permissionPath);
        String[] childern = appCollection.getChildren();
        if (childern == null || childern.length == 0) {
            paths.add(permissionPath.replace(applicationNode, "").substring(2));
        }
        if (childern != null && childern.length != 0) {
            for (int i = 0; i < childern.length; ++i) {
                ApplicationMgtUtil.permissionPath(tenantGovReg, childern[i], paths, applicationNode);
            }
        }
    }

    public static void deletePermissions(String applicationName) throws IdentityApplicationManagementException {
        String applicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + PATH_CONSTANT + applicationName;
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        try {
            boolean exist = tenantGovReg.resourceExists(applicationNode);
            if (exist) {
                tenantGovReg.delete(applicationNode);
            }
        }
        catch (RegistryException e) {
            throw new IdentityApplicationManagementException("Error while storing permissions", (Throwable)e);
        }
    }

    public static Property[] concatArrays(Property[] o1, Property[] o2) {
        Property[] ret = new Property[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    public static String getApplicationPermissionPath() {
        return "permission/applications";
    }

    public static boolean isRegexValidated(String applicationName) {
        String spValidatorRegex = ApplicationMgtUtil.getSPValidatorRegex();
        Pattern regexPattern = Pattern.compile(spValidatorRegex);
        return regexPattern.matcher(applicationName).matches();
    }

    public static String getSPValidatorRegex() {
        String spValidatorRegex = IdentityUtil.getProperty((String)SERVICE_PROVIDERS_NAME_REGEX);
        if (StringUtils.isBlank((String)spValidatorRegex)) {
            spValidatorRegex = APP_NAME_VALIDATING_REGEX;
        }
        return spValidatorRegex;
    }

    protected Map<String, String> getPropertyValues(String tenantDomain, String spIssuer, List<String> propertyNames) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = ApplicationMgtSystemConfig.getInstance().getApplicationDAO().getApplication(spIssuer, tenantDomain);
        if (serviceProvider == null) {
            throw new IdentityApplicationManagementException("No service provider exists in the provided tenant, with the given issuer id " + spIssuer);
        }
        HashMap<String, String> propKeyValueMap = new HashMap<String, String>();
        InboundAuthenticationRequestConfig[] inboundAuthReqConfigs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (inboundAuthReqConfigs != null && inboundAuthReqConfigs.length > 0) {
            for (InboundAuthenticationRequestConfig authConfig : inboundAuthReqConfigs) {
                Property[] properties;
                for (Property prop : properties = authConfig.getProperties()) {
                    if (!propertyNames.contains(prop.getName())) continue;
                    propKeyValueMap.put(prop.getName(), prop.getValue());
                }
            }
        }
        return propKeyValueMap;
    }

    public static boolean isValidApplicationOwner(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        block7: {
            try {
                if (serviceProvider.getOwner() != null) {
                    String userName = serviceProvider.getOwner().getUserName();
                    if (StringUtils.isEmpty((String)userName) || "wso2.system.user".equals(userName)) {
                        return false;
                    }
                    String userStoreDomain = serviceProvider.getOwner().getUserStoreDomain();
                    String userNameWithDomain = IdentityUtil.addDomainToName((String)userName, (String)userStoreDomain);
                    UserRealm realm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
                    if (realm == null || StringUtils.isEmpty((String)userNameWithDomain)) {
                        return false;
                    }
                    boolean isUserExist = realm.getUserStoreManager().isExistingUser(userNameWithDomain);
                    if (!isUserExist) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Owner does not exist for application: " + serviceProvider.getApplicationName() + ". Hence making the tenant admin the owner of the application."));
                        }
                        User owner = new User();
                        owner.setUserName(realm.getRealmConfiguration().getAdminUserName());
                        owner.setUserStoreDomain(realm.getRealmConfiguration().getUserStoreProperty("DomainName"));
                        owner.setTenantDomain(CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
                        serviceProvider.setOwner(owner);
                    }
                    break block7;
                }
                return false;
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityApplicationManagementException("User validation failed for owner update in the application: " + serviceProvider.getApplicationName(), (Throwable)e);
            }
        }
        return true;
    }

    public static ServiceProvider getApplicationFromSpFileStream(SpFileStream spFileStream, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ServiceProvider)unmarshaller.unmarshal(spFileStream.getFileStream());
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in reading Service Provider configuration file %s uploaded by tenant: %s", spFileStream.getFileName(), tenantDomain), (Throwable)e);
        }
    }

    public static void startTenantFlow(String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ApplicationMgtUtil.startTenantFlow(tenantDomain);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(userName);
    }

    public static void startTenantFlow(String tenantDomain) throws IdentityApplicationManagementException {
        int tenantId;
        try {
            tenantId = ApplicationManagementServiceComponentHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityApplicationManagementException("Error when setting tenant domain. ", (Throwable)e);
        }
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
    }

    public static void endTenantFlow() {
        PrivilegedCarbonContext.endTenantFlow();
    }

    public static int getItemsPerPage() {
        String itemsPerPagePropertyValue = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        try {
            if (StringUtils.isNotBlank((String)itemsPerPagePropertyValue)) {
                int itemsPerPage = Math.abs(Integer.parseInt(itemsPerPagePropertyValue));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Items per page for pagination is set to : " + itemsPerPage));
                }
                return itemsPerPage;
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Error occurred while parsing the 'ItemsPerPage' property value in carbon.xml. Defaulting to: 10");
        }
        return 10;
    }
}

