/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationTemplateDAO;
import org.wso2.carbon.identity.application.mgt.dao.IdentityProviderDAO;
import org.wso2.carbon.identity.application.mgt.dao.OAuthApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.SAMLApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.impl.ApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.ApplicationTemplateDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.CacheBackedApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.impl.IdentityProviderDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.OAuthApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.SAMLApplicationDAOImpl;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.utils.CarbonUtils;

public class ApplicationMgtSystemConfig {
    private static final Log log = LogFactory.getLog(ApplicationMgtSystemConfig.class);
    private static final String CONFIG_ELEMENT_SP_MGT = "ServiceProvidersManagement";
    private static final String CONFIG_APPLICATION_DAO = "ApplicationDAO";
    private static final String CONFIG_OAUTH_OIDC_DAO = "OAuthOIDCClientDAO";
    private static final String CONFIG_SAML_DAO = "SAMLClientDAO";
    private static final String CONFIG_SYSTEM_IDP_DAO = "SystemIDPDAO";
    private static final String CONFIG_APPLICATION_TEMPLATE_DAO = "ApplicationTemplateDAO";
    private static final String CONFIG_CLAIM_DIALECT = "ClaimDialect";
    private static volatile ApplicationMgtSystemConfig instance = null;
    private String appDAOClassName = null;
    private String oauthDAOClassName = null;
    private String samlDAOClassName = null;
    private String systemIDPDAPClassName = null;
    private String appTemplateDAOClassName = null;
    private String claimDialect = null;

    private ApplicationMgtSystemConfig() {
        this.buildSystemConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationMgtSystemConfig getInstance() {
        CarbonUtils.checkSecurity();
        if (instance != null) return instance;
        Class<ApplicationMgtSystemConfig> clazz = ApplicationMgtSystemConfig.class;
        synchronized (ApplicationMgtSystemConfig.class) {
            if (instance != null) return instance;
            instance = new ApplicationMgtSystemConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void buildSystemConfiguration() {
        OMElement spConfigElem = IdentityConfigParser.getInstance().getConfigElement(CONFIG_ELEMENT_SP_MGT);
        if (spConfigElem == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No ServiceProvidersManagement configuration found. System Starts with default configuration");
            }
        } else {
            OMElement claimDAOConfigElem;
            OMElement appTemplateDAOConfigElem;
            OMElement idpDAOConfigElem;
            OMElement samlDAOConfigElem;
            OMElement oauthOidcDAOConfigElem;
            OMElement appDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_APPLICATION_DAO));
            if (appDAOConfigElem != null) {
                this.appDAOClassName = appDAOConfigElem.getText().trim();
            }
            if ((oauthOidcDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_OAUTH_OIDC_DAO))) != null) {
                this.oauthDAOClassName = oauthOidcDAOConfigElem.getText().trim();
            }
            if ((samlDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_SAML_DAO))) != null) {
                this.samlDAOClassName = samlDAOConfigElem.getText().trim();
            }
            if ((idpDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_SYSTEM_IDP_DAO))) != null) {
                this.systemIDPDAPClassName = idpDAOConfigElem.getText().trim();
            }
            if ((appTemplateDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_APPLICATION_TEMPLATE_DAO))) != null) {
                this.appTemplateDAOClassName = appTemplateDAOConfigElem.getText().trim();
            }
            if ((claimDAOConfigElem = spConfigElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)CONFIG_CLAIM_DIALECT))) != null) {
                this.claimDialect = claimDAOConfigElem.getText().trim();
            }
        }
    }

    public ApplicationDAO getApplicationDAO() {
        ApplicationDAO applicationDAO = null;
        if (this.appDAOClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.appDAOClassName);
                applicationDAO = (ApplicationDAO)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the ApplicationDAO ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the ApplicationDAO ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the ApplicationDAO ", (Throwable)e);
            }
        } else {
            applicationDAO = new ApplicationDAOImpl();
        }
        return new CacheBackedApplicationDAO(applicationDAO);
    }

    public OAuthApplicationDAO getOAuthOIDCClientDAO() {
        OAuthApplicationDAO oauthOidcDAO = null;
        if (this.oauthDAOClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.oauthDAOClassName);
                oauthOidcDAO = (OAuthApplicationDAO)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the OAuthOIDCClientDAO ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the OAuthOIDCClientDAO ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the OAuthOIDCClientDAO ", (Throwable)e);
            }
        } else {
            oauthOidcDAO = new OAuthApplicationDAOImpl();
        }
        return oauthOidcDAO;
    }

    public SAMLApplicationDAO getSAMLClientDAO() {
        SAMLApplicationDAO samlDAO = null;
        if (this.samlDAOClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.samlDAOClassName);
                samlDAO = (SAMLApplicationDAO)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
        } else {
            samlDAO = new SAMLApplicationDAOImpl();
        }
        return samlDAO;
    }

    public IdentityProviderDAO getIdentityProviderDAO() {
        IdentityProviderDAO idpDAO = null;
        if (this.systemIDPDAPClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.systemIDPDAPClassName);
                idpDAO = (IdentityProviderDAO)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the SAMLClientDAO ", (Throwable)e);
            }
        } else {
            idpDAO = new IdentityProviderDAOImpl();
        }
        return idpDAO;
    }

    public ApplicationTemplateDAO getApplicationTemplateDAO() {
        ApplicationTemplateDAO applicationTemplateDAO = null;
        if (this.appTemplateDAOClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.appTemplateDAOClassName);
                applicationTemplateDAO = (ApplicationTemplateDAO)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while instantiating the ApplicationTemplateDAO ", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Error while instantiating the ApplicationTemplateDAO ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Error while instantiating the ApplicationTemplateDAO ", (Throwable)e);
            }
        } else {
            applicationTemplateDAO = new ApplicationTemplateDAOImpl();
        }
        return applicationTemplateDAO;
    }

    public String getClaimDialect() {
        if (this.claimDialect != null) {
            return this.claimDialect;
        }
        return "http://wso2.org/claims";
    }
}

