/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementServerException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementValidationException;
import org.wso2.carbon.identity.application.common.IdentityApplicationRegistrationFailureException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.DefaultAuthenticationSequence;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.ImportResponse;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.SpFileContent;
import org.wso2.carbon.identity.application.common.model.SpTemplate;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.common.model.script.AuthenticationScriptConfig;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationConstants;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtValidator;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCache;
import org.wso2.carbon.identity.application.mgt.cache.IdentityServiceProviderCacheKey;
import org.wso2.carbon.identity.application.mgt.cache.ServiceProviderTemplateCache;
import org.wso2.carbon.identity.application.mgt.cache.ServiceProviderTemplateCacheKey;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationTemplateDAO;
import org.wso2.carbon.identity.application.mgt.dao.IdentityProviderDAO;
import org.wso2.carbon.identity.application.mgt.dao.PaginatableFilterableApplicationDAO;
import org.wso2.carbon.identity.application.mgt.dao.impl.AbstractApplicationDAOImpl;
import org.wso2.carbon.identity.application.mgt.dao.impl.FileBasedApplicationDAO;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtException;
import org.wso2.carbon.identity.application.mgt.defaultsequence.DefaultAuthSeqMgtServiceImpl;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponent;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationMgtListenerServiceComponent;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationResourceManagementListener;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ApplicationManagementServiceImpl
extends ApplicationManagementService {
    private static final Log log = LogFactory.getLog(ApplicationManagementServiceImpl.class);
    private static volatile ApplicationManagementServiceImpl appMgtService;
    private ApplicationMgtValidator applicationMgtValidator = new ApplicationMgtValidator();

    private ApplicationManagementServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationManagementServiceImpl getInstance() {
        if (appMgtService != null) return appMgtService;
        Class<ApplicationManagementServiceImpl> clazz = ApplicationManagementServiceImpl.class;
        synchronized (ApplicationManagementServiceImpl.class) {
            if (appMgtService != null) return appMgtService;
            appMgtService = new ApplicationManagementServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return appMgtService;
        }
    }

    @Override
    public ServiceProvider addApplication(ServiceProvider serviceProvider, String tenantDomain, String username) throws IdentityApplicationManagementException {
        return this.createApplicationWithTemplate(serviceProvider, tenantDomain, username, null);
    }

    @Override
    public ServiceProvider createApplicationWithTemplate(ServiceProvider serviceProvider, String tenantDomain, String username, String templateName) throws IdentityApplicationManagementException {
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreCreateApplication(serviceProvider, tenantDomain, username)) continue;
            throw this.buildServerException("Pre create application operation of listener: " + this.getName(listener) + " failed for application: " + serviceProvider.getApplicationName() + " of tenantDomain: " + tenantDomain);
        }
        this.doPreAddApplicationChecks(serviceProvider, tenantDomain, username);
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        serviceProvider.setOwner(this.getUser(tenantDomain, username));
        int appId = this.doAddApplication(serviceProvider, tenantDomain, username, appDAO::createApplication);
        serviceProvider.setApplicationID(appId);
        SpTemplate spTemplate = this.getApplicationTemplate(templateName, tenantDomain);
        if (spTemplate != null) {
            this.updateSpFromTemplate(serviceProvider, tenantDomain, spTemplate);
            appDAO.updateApplication(serviceProvider, tenantDomain);
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostCreateApplication(serviceProvider, tenantDomain, username)) continue;
            log.error((Object)("Post create application operation of listener:" + this.getName(listener) + " failed for application: " + serviceProvider.getApplicationName() + " of tenantDomain: " + tenantDomain));
            break;
        }
        return serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceProvider getApplicationExcludingFileBasedSPs(String applicationName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider;
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetApplicationExcludingFileBasedSPs(applicationName, tenantDomain)) continue;
            return null;
        }
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            serviceProvider = appDAO.getApplication(applicationName, tenantDomain);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetApplicationExcludingFileBasedSPs(serviceProvider, applicationName, tenantDomain)) continue;
            return null;
        }
        return serviceProvider;
    }

    @Override
    public ApplicationBasicInfo[] getAllApplicationBasicInfo(String tenantDomain, String username) throws IdentityApplicationManagementException {
        return this.getApplicationBasicInfo(tenantDomain, username, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String tenantDomain, String username, String filter) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = null;
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetApplicationBasicInfo(tenantDomain, username, filter)) continue;
            return new ApplicationBasicInfo[0];
        }
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
            appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (!(appDAO instanceof AbstractApplicationDAOImpl)) {
            log.error((Object)"Get application basic info service is not supported.");
            throw new IdentityApplicationManagementException("This service is not supported.");
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetApplicationBasicInfo(appDAO, tenantDomain, username, filter)) continue;
            return new ApplicationBasicInfo[0];
        }
        return ((AbstractApplicationDAOImpl)appDAO).getApplicationBasicInfo(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBasicInfo[] getAllPaginatedApplicationBasicInfo(String tenantDomain, String username, int pageNumber) throws IdentityApplicationManagementException {
        ApplicationBasicInfo[] applicationBasicInfoArray;
        block8: {
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                    Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPreGetPaginatedApplicationBasicInfo(tenantDomain, username, pageNumber)) continue;
                        ApplicationBasicInfo[] applicationBasicInfoArray2 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray2;
                    }
                    applicationBasicInfoArray = ((PaginatableFilterableApplicationDAO)appDAO).getAllPaginatedApplicationBasicInfo(pageNumber);
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPostGetPaginatedApplicationBasicInfo(tenantDomain, username, pageNumber, applicationBasicInfoArray)) continue;
                        ApplicationBasicInfo[] applicationBasicInfoArray3 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray3;
                    }
                    break block8;
                }
                throw new UnsupportedOperationException("Application pagination is not supported. Tenant domain: " + tenantDomain);
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        return applicationBasicInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String tenantDomain, String username, int offset, int limit) throws IdentityApplicationManagementException {
        ApplicationBasicInfo[] applicationBasicInfoArray;
        block10: {
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                    Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPreGetApplicationBasicInfo(tenantDomain, username, offset, limit)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking pre listener: " + listener.getClass().getName()));
                        }
                        ApplicationBasicInfo[] applicationBasicInfoArray2 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray2;
                    }
                    applicationBasicInfoArray = ((PaginatableFilterableApplicationDAO)appDAO).getApplicationBasicInfo(offset, limit);
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPostGetApplicationBasicInfo(tenantDomain, username, offset, limit, applicationBasicInfoArray)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking post listener: " + listener.getClass().getName()));
                        }
                        ApplicationBasicInfo[] applicationBasicInfoArray3 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray3;
                    }
                    break block10;
                }
                throw new UnsupportedOperationException("Application pagination is not supported in " + appDAO.getClass().getName() + " with tenant domain: " + tenantDomain);
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        return applicationBasicInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBasicInfo[] getPaginatedApplicationBasicInfo(String tenantDomain, String username, int pageNumber, String filter) throws IdentityApplicationManagementException {
        ApplicationBasicInfo[] applicationBasicInfoArray;
        block8: {
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                    Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPreGetPaginatedApplicationBasicInfo(tenantDomain, username, pageNumber, filter)) continue;
                        ApplicationBasicInfo[] applicationBasicInfoArray2 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray2;
                    }
                    applicationBasicInfoArray = ((PaginatableFilterableApplicationDAO)appDAO).getPaginatedApplicationBasicInfo(pageNumber, filter);
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPostGetPaginatedApplicationBasicInfo(tenantDomain, username, pageNumber, filter, applicationBasicInfoArray)) continue;
                        ApplicationBasicInfo[] applicationBasicInfoArray3 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray3;
                    }
                    break block8;
                }
                throw new UnsupportedOperationException("Application filtering and pagination not supported. Tenant domain: " + tenantDomain);
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        return applicationBasicInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBasicInfo[] getApplicationBasicInfo(String tenantDomain, String username, String filter, int offset, int limit) throws IdentityApplicationManagementException {
        ApplicationBasicInfo[] applicationBasicInfoArray;
        block10: {
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                    Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPreGetApplicationBasicInfo(tenantDomain, username, filter, offset, limit)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking pre listener: " + listener.getClass().getName()));
                        }
                        ApplicationBasicInfo[] applicationBasicInfoArray2 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray2;
                    }
                    applicationBasicInfoArray = ((PaginatableFilterableApplicationDAO)appDAO).getApplicationBasicInfo(filter, offset, limit);
                    for (ApplicationMgtListener listener : listeners) {
                        if (!listener.isEnable() || !(listener instanceof AbstractApplicationMgtListener) || ((AbstractApplicationMgtListener)listener).doPostGetApplicationBasicInfo(tenantDomain, username, filter, offset, limit, applicationBasicInfoArray)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking post listener: " + listener.getClass().getName()));
                        }
                        ApplicationBasicInfo[] applicationBasicInfoArray3 = new ApplicationBasicInfo[]{};
                        return applicationBasicInfoArray3;
                    }
                    break block10;
                }
                throw new UnsupportedOperationException("Application filtering and pagination not supported in " + appDAO.getClass().getName() + " with tenant domain: " + tenantDomain);
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        return applicationBasicInfoArray;
    }

    @Override
    public int getCountOfAllApplications(String tenantDomain, String username) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                int n = ((PaginatableFilterableApplicationDAO)appDAO).getCountOfAllApplications();
                return n;
            }
            throw new UnsupportedOperationException("Application count is not supported. Tenant domain: " + tenantDomain);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public int getCountOfApplications(String tenantDomain, String username, String filter) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            if (appDAO instanceof PaginatableFilterableApplicationDAO) {
                int n = ((PaginatableFilterableApplicationDAO)appDAO).getCountOfApplications(filter);
                return n;
            }
            throw new UnsupportedOperationException("Application count is not supported. Tenant domain: " + tenantDomain);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public void updateApplication(ServiceProvider serviceProvider, String tenantDomain, String username) throws IdentityApplicationManagementException {
        this.validateApplicationConfigurations(serviceProvider, tenantDomain, username);
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreUpdateApplication(serviceProvider, tenantDomain, username)) continue;
            throw this.buildServerException("Pre Update application failed");
        }
        String applicationName = serviceProvider.getApplicationName();
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            String storedAppName = appDAO.getApplicationName(serviceProvider.getApplicationID());
            if (StringUtils.isBlank((String)storedAppName)) {
                String msg = "Cannot find application with id: " + serviceProvider.getApplicationID() + " in tenantDomain: " + tenantDomain;
                throw this.buildClientException(IdentityApplicationConstants.Error.APPLICATION_NOT_FOUND, msg);
            }
            this.doPreUpdateChecks(storedAppName, serviceProvider, tenantDomain, username);
            appDAO.updateApplication(serviceProvider, tenantDomain);
            if (this.isOwnerUpdatedInRequest(serviceProvider)) {
                this.assignApplicationRole(serviceProvider.getApplicationName(), MultitenantUtils.getTenantAwareUsername((String)serviceProvider.getOwner().toFullQualifiedUsername()));
            }
            this.updateApplicationPermissions(serviceProvider, applicationName, storedAppName);
        }
        catch (Exception e) {
            String error = "Error occurred while updating the application: " + applicationName + ". " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostUpdateApplication(serviceProvider, tenantDomain, username)) continue;
            return;
        }
    }

    @Override
    public void deleteApplication(String applicationName, String tenantDomain, String username) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider;
        Collection<ApplicationMgtListener> listeners;
        block9: {
            listeners = this.getApplicationMgtListeners();
            for (ApplicationMgtListener listener : listeners) {
                if (!listener.isEnable() || listener.doPreDeleteApplication(applicationName, tenantDomain, username)) continue;
                throw this.buildServerException("Pre Delete application operation of listener: " + this.getName(listener) + " failed for application: " + applicationName + " of tenantDomain: " + tenantDomain);
            }
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
                this.doPreDeleteChecks(applicationName, tenantDomain, username);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                serviceProvider = appDAO.getApplication(applicationName, tenantDomain);
                if (serviceProvider != null) {
                    ApplicationMgtUtil.deleteAppRole(applicationName);
                    ApplicationMgtUtil.deletePermissions(applicationName);
                    appDAO.deleteApplication(applicationName);
                    break block9;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Application cannot be found for name: " + applicationName + " in tenantDomain: " + tenantDomain));
                }
                return;
            }
            catch (Exception e) {
                String error = "Error occurred while deleting the application: " + applicationName + ". " + e.getMessage();
                throw this.buildServerException(error, e);
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteApplication(serviceProvider, tenantDomain, username)) continue;
            log.error((Object)("Post Delete application operation of listener: " + this.getName(listener) + " failed for application with name: " + applicationName + " of tenantDomain: " + tenantDomain));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplications(int tenantId) throws IdentityApplicationManagementException {
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
        ApplicationBasicInfo[] applicationBasicInfos = this.getAllApplicationBasicInfo(tenantDomain, CarbonContext.getThreadLocalCarbonContext().getUsername());
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        appDAO.deleteApplications(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing the cache entries of all SP applications of the tenant: " + tenantDomain));
        }
        try {
            ApplicationMgtUtil.startTenantFlow("carbon.super");
            for (ApplicationBasicInfo applicationBasicInfo : applicationBasicInfos) {
                IdentityServiceProviderCache.getInstance().clearCacheEntry((Serializable)((Object)new IdentityServiceProviderCacheKey(applicationBasicInfo.getApplicationName(), tenantDomain)));
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public IdentityProvider getIdentityProvider(String federatedIdPName, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            IdentityProviderDAO idpdao = ApplicationMgtSystemConfig.getInstance().getIdentityProviderDAO();
            IdentityProvider identityProvider = idpdao.getIdentityProvider(federatedIdPName);
            return identityProvider;
        }
        catch (Exception e) {
            String error = "Error occurred while retrieving Identity Provider: " + federatedIdPName + ". " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public IdentityProvider[] getAllIdentityProviders(String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            IdentityProviderDAO idpdao = ApplicationMgtSystemConfig.getInstance().getIdentityProviderDAO();
            List<IdentityProvider> fedIdpList = idpdao.getAllIdentityProviders();
            if (fedIdpList != null) {
                IdentityProvider[] identityProviderArray = fedIdpList.toArray(new IdentityProvider[fedIdpList.size()]);
                return identityProviderArray;
            }
            IdentityProvider[] identityProviderArray = new IdentityProvider[]{};
            return identityProviderArray;
        }
        catch (Exception e) {
            String error = "Error occurred while retrieving all Identity Providers. " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public LocalAuthenticatorConfig[] getAllLocalAuthenticators(String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            IdentityProviderDAO idpdao = ApplicationMgtSystemConfig.getInstance().getIdentityProviderDAO();
            List<LocalAuthenticatorConfig> localAuthenticators = idpdao.getAllLocalAuthenticators();
            if (localAuthenticators != null) {
                LocalAuthenticatorConfig[] localAuthenticatorConfigArray = localAuthenticators.toArray(new LocalAuthenticatorConfig[localAuthenticators.size()]);
                return localAuthenticatorConfigArray;
            }
            LocalAuthenticatorConfig[] localAuthenticatorConfigArray = new LocalAuthenticatorConfig[]{};
            return localAuthenticatorConfigArray;
        }
        catch (Exception e) {
            String error = "Error occurred while retrieving all Local Authenticators. " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public RequestPathAuthenticatorConfig[] getAllRequestPathAuthenticators(String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            IdentityProviderDAO idpdao = ApplicationMgtSystemConfig.getInstance().getIdentityProviderDAO();
            List<RequestPathAuthenticatorConfig> reqPathAuthenticators = idpdao.getAllRequestPathAuthenticators();
            if (reqPathAuthenticators != null) {
                RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigArray = reqPathAuthenticators.toArray(new RequestPathAuthenticatorConfig[reqPathAuthenticators.size()]);
                return requestPathAuthenticatorConfigArray;
            }
            RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigArray = new RequestPathAuthenticatorConfig[]{};
            return requestPathAuthenticatorConfigArray;
        }
        catch (Exception e) {
            String error = "Error occurred while retrieving all Request Path Authenticators. " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public String[] getAllLocalClaimUris(String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            String claimDialect = ApplicationMgtSystemConfig.getInstance().getClaimDialect();
            ClaimMapping[] claimMappings = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getClaimManager().getAllClaimMappings(claimDialect);
            ArrayList<String> claimUris = new ArrayList<String>();
            for (ClaimMapping claimMap : claimMappings) {
                claimUris.add(claimMap.getClaim().getClaimUri());
            }
            Object[] allLocalClaimUris = claimUris.toArray(new String[claimUris.size()]);
            if (ArrayUtils.isNotEmpty((Object[])allLocalClaimUris)) {
                Arrays.sort(allLocalClaimUris);
            }
            Object[] objectArray = allLocalClaimUris;
            return objectArray;
        }
        catch (Exception e) {
            String error = "Error while reading system claims. " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public String getServiceProviderNameByClientIdExcludingFileBasedSPs(String clientId, String type, String tenantDomain) throws IdentityApplicationManagementException {
        String name = null;
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetServiceProviderNameByClientIdExcludingFileBasedSPs(name, clientId, type, tenantDomain)) continue;
            return null;
        }
        try {
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            name = appDAO.getServiceProviderNameByClientId(clientId, type, tenantDomain);
        }
        catch (Exception e) {
            String error = "Error occurred while retrieving the service provider for client id :  " + clientId + ". " + e.getMessage();
            throw new IdentityApplicationManagementException(error, (Throwable)e);
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetServiceProviderNameByClientIdExcludingFileBasedSPs(name, clientId, type, tenantDomain)) continue;
            return null;
        }
        return name;
    }

    @Override
    public Map<String, String> getServiceProviderToLocalIdPClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        Map<String, String> claimMap = appDAO.getServiceProviderToLocalIdPClaimMapping(serviceProviderName, tenantDomain);
        if (claimMap == null || claimMap.isEmpty() && ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName)) {
            return new FileBasedApplicationDAO().getServiceProviderToLocalIdPClaimMapping(serviceProviderName, tenantDomain);
        }
        return claimMap;
    }

    @Override
    public Map<String, String> getLocalIdPToServiceProviderClaimMapping(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        Map<String, String> claimMap = appDAO.getLocalIdPToServiceProviderClaimMapping(serviceProviderName, tenantDomain);
        if (claimMap == null || claimMap.isEmpty() && ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName)) {
            return new FileBasedApplicationDAO().getLocalIdPToServiceProviderClaimMapping(serviceProviderName, tenantDomain);
        }
        return claimMap;
    }

    @Override
    public List<String> getAllRequestedClaimsByServiceProvider(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        List<String> reqClaims = appDAO.getAllRequestedClaimsByServiceProvider(serviceProviderName, tenantDomain);
        if (reqClaims == null || reqClaims.isEmpty() && ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName)) {
            return new FileBasedApplicationDAO().getAllRequestedClaimsByServiceProvider(serviceProviderName, tenantDomain);
        }
        return reqClaims;
    }

    @Override
    public String getServiceProviderNameByClientId(String clientId, String clientType, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO;
        String name = null;
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetServiceProviderNameByClientId(clientId, clientType, tenantDomain)) continue;
            return null;
        }
        if (StringUtils.isNotEmpty((String)clientId) && (name = (appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO()).getServiceProviderNameByClientId(clientId, clientType, tenantDomain)) == null) {
            name = new FileBasedApplicationDAO().getServiceProviderNameByClientId(clientId, clientType, tenantDomain);
        }
        if (name == null) {
            ServiceProvider defaultSP = ApplicationManagementServiceComponent.getFileBasedSPs().get("default");
            name = defaultSP.getApplicationName();
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetServiceProviderNameByClientId(name, clientId, clientType, tenantDomain)) continue;
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceProvider getServiceProvider(String serviceProviderName, String tenantDomain) throws IdentityApplicationManagementException {
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetServiceProvider(serviceProviderName, tenantDomain)) continue;
            return null;
        }
        ServiceProvider serviceProvider = null;
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            serviceProvider = appDAO.getApplication(serviceProviderName, tenantDomain);
            if (serviceProvider == null && ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName)) {
                serviceProvider = ApplicationManagementServiceComponent.getFileBasedSPs().get(serviceProviderName);
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetServiceProvider(serviceProvider, serviceProviderName, tenantDomain)) continue;
            return null;
        }
        return serviceProvider;
    }

    @Override
    public ServiceProvider getServiceProvider(int appId) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        ServiceProvider serviceProvider = appDAO.getApplication(appId);
        String serviceProviderName = serviceProvider.getApplicationName();
        String tenantDomain = serviceProvider.getOwner().getTenantDomain();
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetServiceProvider(serviceProvider, serviceProviderName, tenantDomain)) continue;
            return null;
        }
        return serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceProvider getServiceProviderByClientId(String clientId, String clientType, String tenantDomain) throws IdentityApplicationManagementException {
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreGetServiceProviderByClientId(clientId, clientType, tenantDomain)) continue;
            return null;
        }
        if (clientId != null && clientId.contains("@")) {
            clientId = clientId.split("@")[0];
        }
        ServiceProvider serviceProvider = null;
        String serviceProviderName = this.getServiceProviderNameByClientId(clientId, clientType, tenantDomain);
        try {
            AuthenticationStep[] authenticationSteps;
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            serviceProvider = appDAO.getApplication(serviceProviderName, tenantDomain);
            if (serviceProvider != null && ((authenticationSteps = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()) == null || authenticationSteps.length == 0)) {
                ServiceProvider defaultSP = ApplicationManagementServiceComponent.getFileBasedSPs().get("default");
                authenticationSteps = defaultSP.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps();
                AuthenticationScriptConfig scriptConfig = defaultSP.getLocalAndOutBoundAuthenticationConfig().getAuthenticationScriptConfig();
                serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(authenticationSteps);
                if (scriptConfig != null) {
                    serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(scriptConfig);
                    serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationType("flow");
                }
            }
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        if (serviceProvider == null && serviceProviderName != null && ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(serviceProviderName)) {
            serviceProvider = ApplicationManagementServiceComponent.getFileBasedSPs().get(serviceProviderName);
        }
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostGetServiceProviderByClientId(serviceProvider, clientId, clientType, tenantDomain)) continue;
            return null;
        }
        return serviceProvider;
    }

    @Override
    public ImportResponse importSPApplication(SpFileContent spFileContent, String tenantDomain, String username, boolean isUpdate) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing service provider from file " + spFileContent.getFileName()));
        }
        ServiceProvider serviceProvider = this.unmarshalSP(spFileContent, tenantDomain);
        ImportResponse importResponse = this.importSPApplication(serviceProvider, tenantDomain, username, isUpdate);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Service provider %s@%s created successfully from file %s", serviceProvider.getApplicationName(), tenantDomain, spFileContent.getFileName()));
        }
        return importResponse;
    }

    @Override
    public ImportResponse importSPApplication(ServiceProvider serviceProvider, String tenantDomain, String username, boolean isUpdate) throws IdentityApplicationManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing service provider from object " + serviceProvider.getApplicationName()));
        }
        ImportResponse importResponse = this.importApplication(serviceProvider, tenantDomain, username, isUpdate);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Service provider %s@%s created successfully from object", serviceProvider.getApplicationName(), tenantDomain));
        }
        return importResponse;
    }

    private ImportResponse importApplication(ServiceProvider serviceProvider, String tenantDomain, String username, boolean isUpdate) throws IdentityApplicationManagementException {
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        ServiceProvider savedSP = null;
        String appName = serviceProvider.getApplicationName();
        try {
            if (isUpdate && (savedSP = this.getApplicationExcludingFileBasedSPs(appName, tenantDomain)) == null) {
                String errorMsg = String.format("Service provider %s@%s is not found", appName, tenantDomain);
                throw new IdentityApplicationManagementClientException(IdentityApplicationConstants.Error.APPLICATION_NOT_FOUND.getCode(), errorMsg);
            }
            if (!isUpdate) {
                ServiceProvider basicApplication = new ServiceProvider();
                basicApplication.setApplicationName(serviceProvider.getApplicationName());
                basicApplication.setDescription(serviceProvider.getDescription());
                String resourceId = this.createApplication(basicApplication, tenantDomain, username);
                savedSP = this.getApplicationByResourceId(resourceId, tenantDomain);
            }
            serviceProvider.setApplicationResourceId(savedSP.getApplicationResourceId());
            serviceProvider.setApplicationID(savedSP.getApplicationID());
            serviceProvider.setOwner(this.getUser(tenantDomain, username));
            for (ApplicationMgtListener listener : listeners) {
                if (!listener.isEnable()) continue;
                listener.onPreCreateInbound(serviceProvider, isUpdate);
            }
            this.updateApplication(serviceProvider, tenantDomain, username);
            for (ApplicationMgtListener listener : listeners) {
                if (!listener.isEnable()) continue;
                listener.doImportServiceProvider(serviceProvider);
            }
            ImportResponse importResponse = new ImportResponse();
            if (isUpdate) {
                importResponse.setResponseCode(200);
            } else {
                importResponse.setResponseCode(201);
            }
            importResponse.setApplicationName(appName);
            importResponse.setApplicationResourceId(serviceProvider.getApplicationResourceId());
            importResponse.setErrors(new String[0]);
            return importResponse;
        }
        catch (IdentityApplicationManagementClientException e) {
            this.deleteCreatedSP(savedSP, tenantDomain, username, isUpdate);
            return this.buildImportErrorResponse(e);
        }
        catch (IdentityApplicationManagementException e) {
            this.deleteCreatedSP(savedSP, tenantDomain, username, isUpdate);
            String errorMsg = String.format("Error in importing provided service provider %s@%s from file ", appName, tenantDomain);
            throw new IdentityApplicationManagementException(errorMsg, (Throwable)e);
        }
    }

    private ImportResponse buildImportErrorResponse(IdentityApplicationManagementClientException e) {
        ImportResponse importResponse = new ImportResponse();
        importResponse.setResponseCode(400);
        importResponse.setApplicationName(null);
        String errorCode = e.getErrorCode() != null ? e.getErrorCode() : IdentityApplicationConstants.Error.INVALID_REQUEST.getCode();
        importResponse.setErrorCode(errorCode);
        if (e instanceof IdentityApplicationManagementValidationException) {
            importResponse.setErrors(((IdentityApplicationManagementValidationException)e).getValidationMsg());
        } else {
            String message = e.getMessage();
            if (StringUtils.isNotBlank((String)message)) {
                importResponse.setErrors(new String[]{e.getMessage()});
            }
        }
        return importResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportSPApplicationFromAppID(String applicationId, boolean exportSecrets, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationBasicInfo application = this.getApplicationBasicInfoByResourceId(applicationId, tenantDomain);
        if (application == null) {
            throw this.buildClientException(IdentityApplicationConstants.Error.APPLICATION_NOT_FOUND, "Application could not be found for the provided resourceId: " + applicationId);
        }
        String appName = application.getApplicationName();
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            String string = this.exportSPApplication(appName, exportSecrets, tenantDomain);
            return string;
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    @Override
    public String exportSPApplication(String applicationName, boolean exportSecrets, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = this.getApplicationExcludingFileBasedSPs(applicationName, tenantDomain);
        Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
        for (ApplicationMgtListener listener : listeners) {
            if (!listener.isEnable()) continue;
            listener.doExportServiceProvider(serviceProvider, exportSecrets);
        }
        return this.marshalSP(serviceProvider, tenantDomain);
    }

    @Override
    public void createApplicationTemplate(SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            ServiceProvider serviceProvider = this.unmarshalSPTemplate(spTemplate.getContent());
            this.validateSPTemplateExists(spTemplate, tenantDomain);
            this.validateUnsupportedTemplateConfigs(serviceProvider);
            this.applicationMgtValidator.validateSPConfigurations(serviceProvider, tenantDomain, CarbonContext.getThreadLocalCarbonContext().getUsername());
            Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
            for (ApplicationMgtListener listener : listeners) {
                if (!listener.isEnable()) continue;
                listener.doPreCreateApplicationTemplate(serviceProvider, tenantDomain);
            }
            this.doAddApplicationTemplate(spTemplate, tenantDomain);
        }
        catch (IdentityApplicationManagementValidationException e) {
            log.error((Object)("Validation error when creating the application template: " + spTemplate.getName() + " in:" + tenantDomain));
            this.logValidationErrorMessages(e);
            throw new IdentityApplicationManagementClientException(e.getValidationMsg());
        }
        catch (IdentityApplicationManagementException e) {
            String errorMsg = String.format("Error when creating the application template: %s in tenant: %s", spTemplate.getName(), tenantDomain);
            throw new IdentityApplicationManagementException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public void createApplicationTemplateFromSP(ServiceProvider serviceProvider, SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        if (serviceProvider != null) {
            try {
                this.validateSPTemplateExists(spTemplate, tenantDomain);
                ServiceProvider updatedSP = this.removeUnsupportedTemplateConfigs(serviceProvider);
                this.applicationMgtValidator.validateSPConfigurations(updatedSP, tenantDomain, CarbonContext.getThreadLocalCarbonContext().getUsername());
                Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
                for (ApplicationMgtListener listener : listeners) {
                    if (!listener.isEnable()) continue;
                    listener.doPreCreateApplicationTemplate(serviceProvider, tenantDomain);
                }
                String serviceProviderTemplateXml = this.marshalSPTemplate(updatedSP, tenantDomain);
                spTemplate.setContent(serviceProviderTemplateXml);
                this.doAddApplicationTemplate(spTemplate, tenantDomain);
            }
            catch (IdentityApplicationManagementValidationException e) {
                log.error((Object)("Validation error when creating the application template:" + spTemplate.getName() + "from service provider: " + serviceProvider.getApplicationName() + " in:" + tenantDomain));
                this.logValidationErrorMessages(e);
                throw new IdentityApplicationManagementClientException(e.getValidationMsg());
            }
            catch (IdentityApplicationManagementException e) {
                String errorMsg = String.format("Error when creating the application template: %s from service provider: %s in: ", spTemplate.getName(), serviceProvider.getApplicationName(), tenantDomain);
                throw new IdentityApplicationManagementException(errorMsg, (Throwable)e);
            }
        } else {
            this.createApplicationTemplate(spTemplate, tenantDomain);
        }
    }

    @Override
    public SpTemplate getApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        SpTemplate spTemplate;
        String retrievedTemplateName = templateName;
        if (StringUtils.isBlank((String)retrievedTemplateName)) {
            retrievedTemplateName = "default";
        }
        if ((spTemplate = this.doGetApplicationTemplate(retrievedTemplateName, tenantDomain)) == null) {
            if (StringUtils.isBlank((String)templateName)) {
                return null;
            }
            throw new IdentityApplicationManagementClientException(new String[]{String.format("Template with name: %s is not registered for tenant: %s.", templateName, tenantDomain)});
        }
        return spTemplate;
    }

    @Override
    public void deleteApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        this.doDeleteApplicationTemplate(templateName, tenantDomain);
    }

    @Override
    public void updateApplicationTemplate(String oldTemplateName, SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            this.validateSPTemplateExists(oldTemplateName, spTemplate, tenantDomain);
            ServiceProvider serviceProvider = this.unmarshalSPTemplate(spTemplate.getContent());
            this.validateUnsupportedTemplateConfigs(serviceProvider);
            this.applicationMgtValidator.validateSPConfigurations(serviceProvider, tenantDomain, CarbonContext.getThreadLocalCarbonContext().getUsername());
            Collection<ApplicationMgtListener> listeners = this.getApplicationMgtListeners();
            for (ApplicationMgtListener listener : listeners) {
                if (!listener.isEnable()) continue;
                listener.doPreUpdateApplicationTemplate(serviceProvider, tenantDomain);
            }
            this.doUpdateApplicationTemplate(oldTemplateName, spTemplate, tenantDomain);
        }
        catch (IdentityApplicationManagementValidationException e) {
            log.error((Object)("Validation error when updating the application template: " + oldTemplateName + " in:" + tenantDomain));
            this.logValidationErrorMessages(e);
            throw new IdentityApplicationManagementClientException(e.getValidationMsg());
        }
        catch (IdentityApplicationManagementException e) {
            String errorMsg = String.format("Error in updating the application template: %s in tenant: %s", oldTemplateName, tenantDomain);
            throw new IdentityApplicationManagementException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public boolean isExistingApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        return this.doCheckApplicationTemplateExistence(templateName, tenantDomain);
    }

    @Override
    public List<SpTemplate> getAllApplicationTemplateInfo(String tenantDomain) throws IdentityApplicationManagementException {
        return this.doGetAllApplicationTemplateInfo(tenantDomain);
    }

    private void doAddApplicationTemplate(SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
        applicationTemplateDAO.createApplicationTemplate(spTemplate, tenantDomain);
        ServiceProviderTemplateCacheKey templateCacheKey = new ServiceProviderTemplateCacheKey(spTemplate.getName(), tenantDomain);
        ServiceProviderTemplateCache.getInstance().addToCache(templateCacheKey, (Serializable)spTemplate);
    }

    private SpTemplate doGetApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProviderTemplateCacheKey templateCacheKey = new ServiceProviderTemplateCacheKey(templateName, tenantDomain);
        SpTemplate spTemplate = this.getSpTemplateFromCache(templateCacheKey);
        if (spTemplate == null) {
            spTemplate = this.getSpTemplateFromDB(templateName, tenantDomain, templateCacheKey);
        }
        return spTemplate;
    }

    private void doDeleteApplicationTemplate(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
        applicationTemplateDAO.deleteApplicationTemplate(templateName, tenantDomain);
        ServiceProviderTemplateCacheKey templateCacheKey = new ServiceProviderTemplateCacheKey(templateName, tenantDomain);
        ServiceProviderTemplateCache.getInstance().clearCacheEntry(templateCacheKey);
    }

    private void doUpdateApplicationTemplate(String templateName, SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProviderTemplateCacheKey templateCacheKey;
        ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
        applicationTemplateDAO.updateApplicationTemplate(templateName, spTemplate, tenantDomain);
        if (!templateName.equals(spTemplate.getName())) {
            templateCacheKey = new ServiceProviderTemplateCacheKey(templateName, tenantDomain);
            ServiceProviderTemplateCache.getInstance().clearCacheEntry(templateCacheKey);
        }
        templateCacheKey = new ServiceProviderTemplateCacheKey(spTemplate.getName(), tenantDomain);
        ServiceProviderTemplateCache.getInstance().addToCache(templateCacheKey, (Serializable)spTemplate);
    }

    private boolean doCheckApplicationTemplateExistence(String templateName, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProviderTemplateCacheKey templateCacheKey = new ServiceProviderTemplateCacheKey(templateName, tenantDomain);
        SpTemplate spTemplate = this.getSpTemplateFromCache(templateCacheKey);
        if (spTemplate == null) {
            ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
            return applicationTemplateDAO.isExistingTemplate(templateName, tenantDomain);
        }
        return true;
    }

    private List<SpTemplate> doGetAllApplicationTemplateInfo(String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
        return applicationTemplateDAO.getAllApplicationTemplateInfo(tenantDomain);
    }

    private void validateUnsupportedTemplateConfigs(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        ArrayList<String> validationMsg = new ArrayList<String>();
        if (serviceProvider.getInboundAuthenticationConfig() != null) {
            validationMsg.add("Inbound configurations are not supported.");
        }
        if (serviceProvider.getApplicationID() != 0) {
            validationMsg.add("Application ID is not supported.");
        }
        if (serviceProvider.getApplicationName() != null) {
            validationMsg.add("Application name is not supported.");
        }
        if (serviceProvider.getDescription() != null) {
            validationMsg.add("Application description is not supported.");
        }
        if (serviceProvider.getCertificateContent() != null) {
            validationMsg.add("Application certificate is not supported.");
        }
        if (!validationMsg.isEmpty()) {
            throw new IdentityApplicationManagementValidationException(validationMsg.toArray(new String[0]));
        }
    }

    private void validateSPTemplateExists(SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        ArrayList<String> validationMsg = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)spTemplate.getName()) && this.isExistingApplicationTemplate(spTemplate.getName(), tenantDomain)) {
            validationMsg.add(String.format("Template with name: %s is already configured for tenant: %s.", spTemplate.getName(), tenantDomain));
            throw new IdentityApplicationManagementValidationException(validationMsg.toArray(new String[0]));
        }
    }

    private void validateSPTemplateExists(String oldTemplateName, SpTemplate spTemplate, String tenantDomain) throws IdentityApplicationManagementException {
        if (!oldTemplateName.equals(spTemplate.getName())) {
            this.validateSPTemplateExists(spTemplate, tenantDomain);
        }
    }

    private SpTemplate getSpTemplateFromDB(String templateName, String tenantDomain, ServiceProviderTemplateCacheKey templateCacheKey) throws IdentityApplicationManagementException {
        ApplicationTemplateDAO applicationTemplateDAO = ApplicationMgtSystemConfig.getInstance().getApplicationTemplateDAO();
        SpTemplate spTemplate = applicationTemplateDAO.getApplicationTemplate(templateName, tenantDomain);
        if (spTemplate != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Template with name: %s is taken from database for tenant: %s ", templateName, tenantDomain));
            }
            ServiceProviderTemplateCache.getInstance().addToCache(templateCacheKey, (Serializable)spTemplate);
            return spTemplate;
        }
        return null;
    }

    private SpTemplate getSpTemplateFromCache(ServiceProviderTemplateCacheKey templateCacheKey) {
        SpTemplate spTemplate = (SpTemplate)ServiceProviderTemplateCache.getInstance().getValueFromCache(templateCacheKey);
        if (spTemplate != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Template with name: %s is taken from cache of tenant: %s ", templateCacheKey.getTemplateName(), templateCacheKey.getTenantDomain()));
            }
            return spTemplate;
        }
        return null;
    }

    private ServiceProvider unmarshalSPTemplate(String spTemplateXml) throws IdentityApplicationManagementValidationException {
        if (StringUtils.isEmpty((String)spTemplateXml)) {
            throw new IdentityApplicationManagementValidationException(new String[]{"Empty SP template configuration is provided."});
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setXIncludeAware(false);
            try {
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException | SAXException e) {
                log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.");
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            UnmarshallerHandler unmarshallerHandler = jc.createUnmarshaller().getUnmarshallerHandler();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler((ContentHandler)unmarshallerHandler);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(spTemplateXml.getBytes(StandardCharsets.UTF_8));
            InputSource inputSource = new InputSource(inputStream);
            xr.parse(inputSource);
            inputStream.close();
            return (ServiceProvider)unmarshallerHandler.getResult();
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            String msg = "Error in reading Service Provider template configuration.";
            log.error((Object)msg, e);
            throw new IdentityApplicationManagementValidationException(new String[]{msg});
        }
    }

    private String marshalSPTemplate(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            DocumentBuilderFactory docBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            Document document = docBuilderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal((Object)serviceProvider, (Node)document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("cdata-section-elements", "AuthenticationScript inboundConfiguration");
            StringWriter stringBuilder = new StringWriter();
            StreamResult result = new StreamResult(stringBuilder);
            transformer.transform(new DOMSource(document), result);
            return stringBuilder.getBuffer().toString();
        }
        catch (JAXBException | ParserConfigurationException | TransformerException e) {
            throw new IdentityApplicationManagementException(String.format("Error in exporting Service Provider template from SP %s@%s", serviceProvider.getApplicationName(), tenantDomain), e);
        }
    }

    private ServiceProvider removeUnsupportedTemplateConfigs(ServiceProvider serviceProvider) {
        ServiceProvider updatedSp = serviceProvider;
        if (updatedSp != null) {
            updatedSp.setApplicationName(null);
            updatedSp.setDescription(null);
            updatedSp.setApplicationID(0);
            updatedSp.setCertificateContent(null);
            updatedSp.setInboundAuthenticationConfig(null);
        }
        return updatedSp;
    }

    private void updateSpFromTemplate(ServiceProvider serviceProvider, String tenantDomain, SpTemplate spTemplate) throws IdentityApplicationManagementException {
        if (spTemplate != null && spTemplate.getContent() != null) {
            Field[] fieldsSpTemplate;
            ServiceProvider spConfigFromTemplate = this.unmarshalSP(spTemplate.getContent(), tenantDomain);
            for (Field field : fieldsSpTemplate = spConfigFromTemplate.getClass().getDeclaredFields()) {
                try {
                    Field fieldSpTemplate = spConfigFromTemplate.getClass().getDeclaredField(field.getName());
                    fieldSpTemplate.setAccessible(true);
                    Object value = fieldSpTemplate.get(spConfigFromTemplate);
                    if (value == null || fieldSpTemplate.getAnnotation(XmlElement.class) == null) continue;
                    Field fieldActualSp = serviceProvider.getClass().getDeclaredField(field.getName());
                    fieldActualSp.setAccessible(true);
                    fieldActualSp.set(serviceProvider, value);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IdentityApplicationManagementException("Error when updating SP template configurationsinto the actual service provider");
                }
            }
        }
    }

    private ServiceProvider unmarshalSP(String spTemplateXml, String tenantDomain) throws IdentityApplicationManagementException {
        if (StringUtils.isEmpty((String)spTemplateXml)) {
            throw new IdentityApplicationManagementException("Empty SP template configuration is provided to unmarshal");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ServiceProvider)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(spTemplateXml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException("Error in reading Service Provider template configuration ", (Throwable)e);
        }
    }

    private void deleteApplicationPermission(String applicationName) {
        try {
            ApplicationMgtUtil.deletePermissions(applicationName);
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)("Failed to delete the permissions for: " + applicationName), (Throwable)e);
        }
    }

    private void deleteApplicationRole(String applicationName) {
        try {
            ApplicationMgtUtil.deleteAppRole(applicationName);
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)("Failed to delete the application role for: " + applicationName), (Throwable)e);
        }
    }

    private void doPreAddApplicationChecks(ServiceProvider serviceProvider, String tenantDomain, String username) throws IdentityApplicationManagementException {
        String appName = serviceProvider.getApplicationName();
        if (StringUtils.isBlank((String)appName)) {
            throw this.buildClientException(IdentityApplicationConstants.Error.INVALID_REQUEST, "Application name cannot be empty.");
        }
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        if (appDAO.isApplicationExists(appName, tenantDomain)) {
            String msg = "An application with name: '" + appName + "' already exists in tenantDomain: " + tenantDomain;
            throw new IdentityApplicationRegistrationFailureException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode(), msg);
        }
        if (ApplicationManagementServiceComponent.getFileBasedSPs().containsKey(appName)) {
            String msg = "Application with name: '" + appName + "' already loaded from the file system.";
            throw this.buildClientException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS, msg);
        }
        if (!ApplicationMgtUtil.isRegexValidated(appName)) {
            String message = "The Application name: '" + appName + "' is not valid! It is not adhering to the regex: " + ApplicationMgtUtil.getSPValidatorRegex();
            throw this.buildClientException(IdentityApplicationConstants.Error.INVALID_REQUEST, message);
        }
        this.validateApplicationConfigurations(serviceProvider, tenantDomain, username);
    }

    private <T> T doAddApplication(ServiceProvider serviceProvider, String tenantDomain, String username, ApplicationPersistFunction<ServiceProvider, T> applicationPersistFunction) throws IdentityApplicationManagementException {
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain, username);
            String applicationName = serviceProvider.getApplicationName();
            ApplicationMgtUtil.createAppRole(applicationName, username);
            try {
                PermissionsAndRoleConfig permissionAndRoleConfig = serviceProvider.getPermissionAndRoleConfig();
                ApplicationMgtUtil.storePermissions(applicationName, username, permissionAndRoleConfig);
            }
            catch (IdentityApplicationManagementException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating application: " + applicationName + " in tenantDomain: " + tenantDomain + " failed. Rolling back by cleaning up partially created data."));
                }
                this.deleteApplicationRole(applicationName);
                throw ex;
            }
            try {
                T ex = applicationPersistFunction.persistApplication(serviceProvider, tenantDomain);
            }
            catch (IdentityApplicationManagementException ex) {
                if (this.isRollbackRequired(ex)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating application: " + applicationName + " in tenantDomain: " + tenantDomain + " failed. Rolling back by cleaning up partially created data."));
                    }
                    this.deleteApplicationRole(applicationName);
                    this.deleteApplicationPermission(applicationName);
                }
                throw ex;
            }
            return ex;
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
    }

    private boolean isRollbackRequired(IdentityApplicationManagementException ex) {
        return !StringUtils.equals((String)ex.getErrorCode(), (String)IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS.getCode());
    }

    private boolean isOwnerUpdatedInRequest(ServiceProvider serviceProvider) {
        return serviceProvider.getOwner() != null && StringUtils.isNotEmpty((String)serviceProvider.getOwner().getUserName()) && !"wso2.system.user".equals(serviceProvider.getOwner().getUserName());
    }

    private void assignApplicationRole(String applicationName, String username) throws IdentityApplicationManagementException {
        String roleName = ApplicationManagementServiceImpl.getAppRoleName(applicationName);
        String[] newRoles = new String[]{roleName};
        try {
            UserRealm realm = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm();
            if (realm != null) {
                if (((AbstractUserStoreManager)realm.getUserStoreManager()).isUserInRole(username, roleName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The user: " + username + " is already having the role: " + roleName));
                    }
                } else {
                    realm.getUserStoreManager().updateRoleListOfUser(username, null, newRoles);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Assigning application role : " + roleName + " to the user : " + username));
                    }
                }
            }
        }
        catch (UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while assigning application role: " + roleName + " to the user: " + username, (Throwable)e);
        }
    }

    private static String getAppRoleName(String applicationName) {
        return "Application" + UserCoreConstants.DOMAIN_SEPARATOR + applicationName;
    }

    private ServiceProvider unmarshalSP(SpFileContent spFileContent, String tenantDomain) throws IdentityApplicationManagementException {
        if (StringUtils.isEmpty((String)spFileContent.getContent())) {
            throw new IdentityApplicationManagementException(String.format("Empty Service Provider configuration file %s uploaded by tenant: %s", spFileContent.getFileName(), tenantDomain));
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ServiceProvider)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(spFileContent.getContent().getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IdentityApplicationManagementException(String.format("Error in reading Service Provider configuration file %s uploaded by tenant: %s", spFileContent.getFileName(), tenantDomain), (Throwable)e);
        }
    }

    private String marshalSP(ServiceProvider serviceProvider, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceProvider.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            DocumentBuilderFactory docBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            Document document = docBuilderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal((Object)serviceProvider, (Node)document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("cdata-section-elements", "AuthenticationScript inboundConfiguration");
            StringWriter stringBuilder = new StringWriter();
            StreamResult result = new StreamResult(stringBuilder);
            transformer.transform(new DOMSource(document), result);
            return stringBuilder.getBuffer().toString();
        }
        catch (JAXBException | ParserConfigurationException | TransformerException e) {
            throw new IdentityApplicationManagementException(String.format("Error in exporting Service Provider %s@%s", serviceProvider.getApplicationName(), tenantDomain), e);
        }
    }

    private User getUser(String tenantDomain, String username) {
        User user = new User();
        user.setUserName(UserCoreUtil.removeDomainFromName((String)username));
        user.setUserStoreDomain(UserCoreUtil.extractDomainFromName((String)username));
        user.setTenantDomain(tenantDomain);
        return user;
    }

    private void deleteCreatedSP(ServiceProvider savedSP, String tenantDomain, String username, boolean isUpdate) throws IdentityApplicationManagementException {
        if (savedSP != null && !isUpdate) {
            try {
                log.warn((Object)String.format("Remove newly imported %s@%s application as error occurred ", savedSP.getApplicationName(), tenantDomain));
                this.deleteApplication(savedSP.getApplicationName(), tenantDomain, username);
            }
            catch (IdentityApplicationManagementException e) {
                String errorMsg = String.format("Error occurred when removing newly imported service provider %s@%s", savedSP.getApplicationName(), tenantDomain);
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityApplicationManagementException(errorMsg, (Throwable)e);
            }
        }
    }

    private void setDefaultAuthenticationSeq(String sequenceName, String tenantDomain, ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        DefaultAuthenticationSequence sequence;
        DefaultAuthSeqMgtServiceImpl seqMgtService = DefaultAuthSeqMgtServiceImpl.getInstance();
        try {
            sequence = seqMgtService.getDefaultAuthenticationSeq(sequenceName, tenantDomain);
        }
        catch (DefaultAuthSeqMgtException e) {
            throw new IdentityApplicationManagementException("Error when retrieving default authentication sequence in tenant: " + tenantDomain, (Throwable)e);
        }
        if (sequence != null && sequence.getContent() != null) {
            serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(sequence.getContent().getAuthenticationSteps());
            serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(sequence.getContent().getAuthenticationScriptConfig());
        } else {
            ServiceProvider defaultSP = ApplicationManagementServiceComponent.getFileBasedSPs().get("default");
            serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(defaultSP.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps());
            serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(defaultSP.getLocalAndOutBoundAuthenticationConfig().getAuthenticationScriptConfig());
        }
    }

    @Override
    public ApplicationBasicInfo getApplicationBasicInfoByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        Collection<ApplicationResourceManagementListener> listeners = ApplicationMgtListenerServiceComponent.getApplicationResourceMgtListeners();
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPreGetApplicationBasicInfoByResourceId(resourceId, tenantDomain)) continue;
            throw this.buildServerException("Error executing doPreGetApplicationBasicInfoByResourceId operation of listener: " + this.getName(listener) + " for application resourceId: " + resourceId);
        }
        ApplicationBasicInfo basicAppInfo = this.getApplicationBasicInfo(resourceId, tenantDomain);
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPostGetApplicationBasicInfoByResourceId(basicAppInfo, resourceId, tenantDomain)) continue;
            throw this.buildServerException("Error executing doPostGetApplicationBasicInfoByResourceId operation of listener: " + this.getName(listener) + " for application resourceId: " + resourceId);
        }
        return basicAppInfo;
    }

    private ApplicationBasicInfo getApplicationBasicInfo(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        return appDAO.getApplicationBasicInfoByResourceId(resourceId, tenantDomain);
    }

    @Override
    public String createApplication(ServiceProvider application, String tenantDomain, String username) throws IdentityApplicationManagementException {
        Collection<ApplicationResourceManagementListener> listeners = ApplicationMgtListenerServiceComponent.getApplicationResourceMgtListeners();
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPreCreateApplication(application, tenantDomain, username)) continue;
            throw this.buildServerException("Pre create application operation of listener: " + this.getName(listener) + " failed for application: " + application.getApplicationName() + " of tenantDomain: " + tenantDomain);
        }
        this.doPreAddApplicationChecks(application, tenantDomain, username);
        ApplicationDAO applicationDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        String resourceId = this.doAddApplication(application, tenantDomain, username, applicationDAO::addApplication);
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPostCreateApplication(resourceId, application, tenantDomain, username)) continue;
            log.error((Object)("Post create application operation of listener:" + this.getName(listener) + " failed for application: " + application.getApplicationName() + " of tenantDomain: " + tenantDomain));
            break;
        }
        return resourceId;
    }

    private <T> String getName(T listener) {
        return listener.getClass().getName();
    }

    @Override
    public ServiceProvider getApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        Collection<ApplicationResourceManagementListener> listeners = ApplicationMgtListenerServiceComponent.getApplicationResourceMgtListeners();
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPreGetApplicationByResourceId(resourceId, tenantDomain)) continue;
            throw this.buildServerException("Pre Get application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId);
        }
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        ServiceProvider application = appDAO.getApplicationByResourceId(resourceId, tenantDomain);
        if (application == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find an application for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain));
            }
            return null;
        }
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPostGetApplicationByResourceId(application, resourceId, tenantDomain)) continue;
            log.error((Object)("Post Get application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId));
            break;
        }
        return application;
    }

    @Override
    public void updateApplicationByResourceId(String resourceId, ServiceProvider updatedApp, String tenantDomain, String username) throws IdentityApplicationManagementException {
        this.validateApplicationConfigurations(updatedApp, tenantDomain, username);
        updatedApp.setApplicationResourceId(resourceId);
        Collection<ApplicationResourceManagementListener> listeners = ApplicationMgtListenerServiceComponent.getApplicationResourceMgtListeners();
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPreUpdateApplicationByResourceId(updatedApp, resourceId, tenantDomain, username)) continue;
            throw this.buildServerException("Pre Update application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId);
        }
        try {
            ApplicationMgtUtil.startTenantFlow(tenantDomain);
            ApplicationBasicInfo storedAppInfo = this.getApplicationBasicInfo(resourceId, tenantDomain);
            if (storedAppInfo == null) {
                String msg = "Cannot find an application for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain;
                throw this.buildClientException(IdentityApplicationConstants.Error.APPLICATION_NOT_FOUND, msg);
            }
            String updatedAppName = updatedApp.getApplicationName();
            String storedAppName = storedAppInfo.getApplicationName();
            this.doPreUpdateChecks(storedAppName, updatedApp, tenantDomain, username);
            ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
            appDAO.updateApplicationByResourceId(resourceId, tenantDomain, updatedApp);
            if (this.isOwnerUpdateRequest(storedAppInfo.getAppOwner(), updatedApp.getOwner())) {
                this.assignApplicationRole(updatedApp.getApplicationName(), updatedApp.getOwner().getUserName());
            }
            this.updateApplicationPermissions(updatedApp, updatedAppName, storedAppName);
        }
        catch (RegistryException e) {
            String message = "Error while updating application with resourceId: " + resourceId + " in tenantDomain: " + tenantDomain;
            throw this.buildServerException(message, e);
        }
        finally {
            ApplicationMgtUtil.endTenantFlow();
        }
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPostUpdateApplicationByResourceId(updatedApp, resourceId, tenantDomain, username)) continue;
            log.error((Object)("Post Update application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId));
            return;
        }
    }

    @Override
    public Set<String> getSystemApplications() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement systemApplicationsConfig = configParser.getConfigElement("SystemApplications");
        if (systemApplicationsConfig == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"'SystemApplications' config not found.");
            }
            return Collections.emptySet();
        }
        Iterator applicationIdentifierIterator = systemApplicationsConfig.getChildrenWithLocalName("ApplicationName");
        if (applicationIdentifierIterator == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"'ApplicationName' config not found.");
            }
            return Collections.emptySet();
        }
        HashSet<String> systemApplications = new HashSet<String>();
        while (applicationIdentifierIterator.hasNext()) {
            OMElement applicationIdentifierConfig = (OMElement)applicationIdentifierIterator.next();
            String applicationName = applicationIdentifierConfig.getText();
            if (!StringUtils.isNotBlank((String)applicationName)) continue;
            systemApplications.add(applicationName.trim());
        }
        return systemApplications;
    }

    private void doPreUpdateChecks(String storedAppName, ServiceProvider updatedApp, String tenantDomain, String username) throws IdentityApplicationManagementException {
        String updatedAppName = updatedApp.getApplicationName();
        this.validateAuthorization(updatedAppName, storedAppName, username, tenantDomain);
        this.validateAppName(storedAppName, updatedApp, tenantDomain);
        this.validateApplicationCertificate(updatedApp, tenantDomain);
    }

    private void updateApplicationPermissions(ServiceProvider updatedApp, String updatedAppName, String storedAppName) throws RegistryException, IdentityApplicationManagementException {
        String applicationNode = ApplicationMgtUtil.getApplicationPermissionPath() + "/" + storedAppName;
        Registry tenantGovReg = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE);
        boolean exist = tenantGovReg.resourceExists(applicationNode);
        if (exist && !StringUtils.equals((String)storedAppName, (String)updatedAppName)) {
            ApplicationMgtUtil.renameAppPermissionPathNode(storedAppName, updatedAppName);
        }
        if (updatedApp.getPermissionAndRoleConfig() != null && ArrayUtils.isNotEmpty((Object[])updatedApp.getPermissionAndRoleConfig().getPermissions())) {
            ApplicationMgtUtil.updatePermissions(updatedAppName, updatedApp.getPermissionAndRoleConfig().getPermissions());
        }
    }

    private void validateApplicationCertificate(ServiceProvider updatedApp, String tenantDomain) throws IdentityApplicationManagementException {
        if (!IdentityUtil.isValidPEMCertificate((String)updatedApp.getCertificateContent())) {
            String error = "Provided application certificate for application with name: %s in tenantDomain: %s is malformed.";
            throw this.buildClientException(IdentityApplicationConstants.Error.INVALID_REQUEST, String.format(error, updatedApp.getApplicationName(), tenantDomain));
        }
    }

    private void validateApplicationConfigurations(ServiceProvider application, String tenantDomain, String username) throws IdentityApplicationManagementException {
        try {
            this.applicationMgtValidator.validateSPConfigurations(application, tenantDomain, username);
        }
        catch (IdentityApplicationManagementValidationException e) {
            String message = "Invalid application configuration for application: '" + application.getApplicationName() + "' of tenantDomain: " + tenantDomain + ".";
            String errorCode = IdentityApplicationConstants.Error.INVALID_REQUEST.getCode();
            throw new IdentityApplicationManagementValidationException(errorCode, message, e.getValidationMsg());
        }
    }

    private void validateAuthorization(String updatedAppName, String storedAppName, String username, String tenantDomain) throws IdentityApplicationManagementException {
        if (!"wso2carbon-local-sp".equals(storedAppName) && !ApplicationMgtUtil.isUserAuthorized(storedAppName, username)) {
            String message = "Illegal Access! User: " + username + " does not have access to update the application: '" + updatedAppName + "' in tenantDomain: " + tenantDomain;
            throw this.buildClientException(IdentityApplicationConstants.Error.OPERATION_FORBIDDEN, message);
        }
    }

    private boolean isOwnerUpdateRequest(User storedAppOwner, User updatedAppOwner) {
        if (updatedAppOwner != null) {
            boolean isValidAppOwnerInUpdateRequest = StringUtils.isNotEmpty((String)updatedAppOwner.getUserName()) && !"wso2.system.user".equals(updatedAppOwner.getUserName());
            boolean isOwnerChanged = !storedAppOwner.equals((Object)updatedAppOwner);
            return isValidAppOwnerInUpdateRequest && isOwnerChanged;
        }
        return false;
    }

    private void validateAppName(String currentAppName, ServiceProvider updatedApp, String tenantDomain) throws IdentityApplicationManagementException {
        String updatedAppName = updatedApp.getApplicationName();
        if (StringUtils.isBlank((String)updatedAppName)) {
            throw this.buildClientException(IdentityApplicationConstants.Error.INVALID_REQUEST, "Application name cannot be empty.");
        }
        if (!ApplicationMgtUtil.isRegexValidated(updatedAppName)) {
            String message = "The Application name '" + updatedAppName + "' is not valid. Application name does not adhere to the regex " + ApplicationMgtUtil.getSPValidatorRegex();
            throw this.buildClientException(IdentityApplicationConstants.Error.INVALID_REQUEST, message);
        }
        if (this.isAppRenamed(currentAppName, updatedAppName) && "wso2carbon-local-sp".equalsIgnoreCase(updatedAppName)) {
            String msg = "Cannot update an application's name to tenant resident service provider's name '%s'";
            throw this.buildClientException(IdentityApplicationConstants.Error.OPERATION_FORBIDDEN, String.format(msg, "wso2carbon-local-sp"));
        }
        if (this.isAppRenamed(currentAppName, updatedAppName) && this.isAnotherAppExistsWithUpdatedName(updatedApp, tenantDomain)) {
            String msg = "Updated application name '%s' already exists.";
            throw this.buildClientException(IdentityApplicationConstants.Error.APPLICATION_ALREADY_EXISTS, String.format(msg, updatedAppName));
        }
    }

    private boolean isAnotherAppExistsWithUpdatedName(ServiceProvider updatedApp, String tenantDomain) throws IdentityApplicationManagementException {
        ServiceProvider appWithUpdatedName = this.getServiceProvider(updatedApp.getApplicationName(), tenantDomain);
        return appWithUpdatedName != null && appWithUpdatedName.getApplicationID() != updatedApp.getApplicationID();
    }

    private boolean isAppRenamed(String currentAppName, String updatedAppName) {
        return !StringUtils.equals((String)currentAppName, (String)updatedAppName);
    }

    private void logValidationErrorMessages(IdentityApplicationManagementValidationException e) {
        if (e.getValidationMsg() != null) {
            log.error((Object)StringUtils.join((Object[])e.getValidationMsg(), (String)"\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplicationByResourceId(String resourceId, String tenantDomain, String username) throws IdentityApplicationManagementException {
        ServiceProvider application;
        Collection<ApplicationResourceManagementListener> listeners;
        block7: {
            listeners = ApplicationMgtListenerServiceComponent.getApplicationResourceMgtListeners();
            for (ApplicationResourceManagementListener listener : listeners) {
                if (!listener.isEnabled() || listener.doPreDeleteApplicationByResourceId(resourceId, tenantDomain, username)) continue;
                throw this.buildServerException("Pre Delete application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId);
            }
            try {
                ApplicationMgtUtil.startTenantFlow(tenantDomain);
                ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
                application = appDAO.getApplicationByResourceId(resourceId, tenantDomain);
                if (application != null) {
                    String applicationName = application.getApplicationName();
                    this.doPreDeleteChecks(applicationName, tenantDomain, username);
                    ApplicationMgtUtil.deleteAppRole(applicationName);
                    ApplicationMgtUtil.deletePermissions(applicationName);
                    appDAO.deleteApplicationByResourceId(resourceId, tenantDomain);
                    break block7;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Application cannot be found for resourceId: " + resourceId + " in tenantDomain: " + tenantDomain));
                }
                return;
            }
            finally {
                ApplicationMgtUtil.endTenantFlow();
            }
        }
        for (ApplicationResourceManagementListener listener : listeners) {
            if (!listener.isEnabled() || listener.doPostDeleteApplicationByResourceId(application, resourceId, tenantDomain, username)) continue;
            log.error((Object)("Post Delete application operation of listener: " + this.getName(listener) + " failed for application with resourceId: " + resourceId));
            return;
        }
    }

    private void doPreDeleteChecks(String applicationName, String tenantDomain, String username) throws IdentityApplicationManagementException {
        if (!ApplicationMgtUtil.isUserAuthorized(applicationName, username)) {
            String message = "Illegal Access! User " + username + " does not have access to delete the application: '" + applicationName + "' of tenantDomain: " + tenantDomain;
            log.warn((Object)message);
            throw this.buildClientException(IdentityApplicationConstants.Error.OPERATION_FORBIDDEN, message);
        }
        if (StringUtils.equals((String)applicationName, (String)"wso2carbon-local-sp")) {
            String msg = "Cannot delete tenant resident service provider: wso2carbon-local-sp";
            throw this.buildClientException(IdentityApplicationConstants.Error.OPERATION_FORBIDDEN, msg);
        }
    }

    private IdentityApplicationManagementClientException buildClientException(IdentityApplicationConstants.Error errorMessage, String message) {
        return new IdentityApplicationManagementClientException(errorMessage.getCode(), message);
    }

    private IdentityApplicationManagementServerException buildServerException(String message, Throwable ex) {
        return new IdentityApplicationManagementServerException(IdentityApplicationConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), message, ex);
    }

    private IdentityApplicationManagementServerException buildServerException(String message) {
        return new IdentityApplicationManagementServerException(IdentityApplicationConstants.Error.UNEXPECTED_SERVER_ERROR.getCode(), message);
    }

    private Collection<ApplicationMgtListener> getApplicationMgtListeners() {
        return ApplicationMgtListenerServiceComponent.getApplicationMgtListeners();
    }

    @FunctionalInterface
    private static interface ApplicationPersistFunction<S extends ServiceProvider, T> {
        public T persistApplication(S var1, String var2) throws IdentityApplicationManagementException;
    }
}

