/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.ImportResponse;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.SpFileContent;
import org.wso2.carbon.identity.application.common.model.SpTemplate;
import org.wso2.carbon.identity.application.mgt.AbstractInboundAuthenticatorConfig;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.application.mgt.internal.ApplicationManagementServiceComponentHolder;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;

public class ApplicationManagementAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(ApplicationManagementAdminService.class);
    private ApplicationManagementService applicationMgtService;
    private List<InboundAuthenticationRequestConfig> customInboundAuthenticatorConfigs;

    public void createApplication(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        try {
            this.createApplicationWithTemplate(serviceProvider, null);
        }
        catch (IdentityApplicationManagementException ex) {
            String message = "Error while creating application: " + serviceProvider.getApplicationName() + " for tenant: " + this.getTenantDomain();
            throw this.handleException(message, ex);
        }
    }

    private IdentityApplicationManagementException handleException(String msg, IdentityApplicationManagementException ex) {
        if (ex instanceof IdentityApplicationManagementClientException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)ex);
            }
        } else {
            log.error((Object)msg, (Throwable)ex);
        }
        return ex;
    }

    public ServiceProvider createApplicationWithTemplate(ServiceProvider serviceProvider, String templateName) throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.createApplicationWithTemplate(serviceProvider, this.getTenantDomain(), this.getUsername(), templateName);
        }
        catch (IdentityApplicationManagementException ex) {
            String message = "Error while creating application: " + serviceProvider.getApplicationName() + " for tenant: " + this.getTenantDomain();
            throw this.handleException(message, ex);
        }
    }

    public ServiceProvider getApplication(String applicationName) throws IdentityApplicationManagementException {
        try {
            if (!"wso2carbon-local-sp".equals(applicationName) && !ApplicationMgtUtil.isUserAuthorized(applicationName, this.getUsername())) {
                log.warn((Object)("Illegal Access! User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " does not have access to the application " + applicationName));
                throw new IdentityApplicationManagementException("User not authorized");
            }
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getApplicationExcludingFileBasedSPs(applicationName, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException ex) {
            String msg = "Error while retrieving application: " + applicationName + " for tenant: " + this.getTenantDomain();
            throw this.handleException(msg, ex);
        }
    }

    public ApplicationBasicInfo[] getAllApplicationBasicInfo() throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            ApplicationBasicInfo[] applicationBasicInfos = this.applicationMgtService.getAllApplicationBasicInfo(this.getTenantDomain(), this.getUsername());
            ArrayList<ApplicationBasicInfo> appInfo = this.getAuthorizedApplicationBasicInfo(applicationBasicInfos, this.getUsername());
            return appInfo.toArray(new ApplicationBasicInfo[appInfo.size()]);
        }
        catch (IdentityApplicationManagementException ex) {
            String message = "Error while retrieving all application basic info for tenant: " + this.getTenantDomain();
            throw this.handleException(message, ex);
        }
    }

    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter) throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            ApplicationBasicInfo[] applicationBasicInfos = this.applicationMgtService.getApplicationBasicInfo(this.getTenantDomain(), this.getUsername(), filter);
            ArrayList<ApplicationBasicInfo> appInfo = this.getAuthorizedApplicationBasicInfo(applicationBasicInfos, this.getUsername());
            return appInfo.toArray(new ApplicationBasicInfo[appInfo.size()]);
        }
        catch (IdentityApplicationManagementException ex) {
            String message = "Error while retrieving all application basic info for tenant: " + this.getTenantDomain() + " with filter: " + filter;
            throw this.handleException(message, ex);
        }
    }

    public ApplicationBasicInfo[] getAllPaginatedApplicationBasicInfo(int pageNumber) throws IdentityApplicationManagementException {
        return this.getPaginatedApplicationBasicInfo(pageNumber, "*");
    }

    public ApplicationBasicInfo[] getPaginatedApplicationBasicInfo(int pageNumber, String filter) throws IdentityApplicationManagementException {
        this.validateRequestedPageNumber(pageNumber);
        String authorizedUserTenantDomain = this.getTenantDomain();
        String authorizedUser = this.getUsername();
        int totalFilteredUserAuthorizedAppCount = this.getCountOfApplications(filter);
        if (totalFilteredUserAuthorizedAppCount == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The user: " + authorizedUser + " in tenant domain: " + authorizedUserTenantDomain + ", doesn't have any authorized applications that matches the given filter: " + filter));
            }
            return new ApplicationBasicInfo[0];
        }
        int itemsPerPage = ApplicationMgtUtil.getItemsPerPage();
        if (this.isMaxPageNumberToRequestExceeded(authorizedUser, pageNumber, totalFilteredUserAuthorizedAppCount, itemsPerPage)) {
            return new ApplicationBasicInfo[0];
        }
        int offset = 0;
        int expectedNumberOfResults = itemsPerPage * pageNumber;
        int totalFilteredSystemAppCount = ApplicationManagementService.getInstance().getCountOfApplications(this.getTenantDomain(), this.getUsername(), filter);
        int chunkSize = this.getFetchChunkSizeForPagination();
        List<ApplicationBasicInfo> expectedFilteredAuthorizedAppInfoList = new ArrayList<ApplicationBasicInfo>();
        expectedFilteredAuthorizedAppInfoList = this.getFilteredAuthorizedAppBasicInfo(expectedFilteredAuthorizedAppInfoList, authorizedUserTenantDomain, authorizedUser, filter, offset, chunkSize, expectedNumberOfResults, totalFilteredSystemAppCount);
        int startIndexOfRequestedPage = itemsPerPage * (pageNumber - 1);
        int endIndexOfRequestedPage = expectedFilteredAuthorizedAppInfoList.size();
        return expectedFilteredAuthorizedAppInfoList.subList(startIndexOfRequestedPage, endIndexOfRequestedPage).toArray(new ApplicationBasicInfo[0]);
    }

    private List<ApplicationBasicInfo> getFilteredAuthorizedAppBasicInfo(List<ApplicationBasicInfo> expectedFilteredAuthorizedAppInfoList, String authorizedUserTenantDomain, String authorizedUser, String filter, int offset, int chunkSize, int expectedAuthorizedAppInfoCount, int totalFilteredSystemAppCount) throws IdentityApplicationManagementException {
        ApplicationBasicInfo[] applicationBasicInfos;
        if (expectedAuthorizedAppInfoCount > chunkSize) {
            applicationBasicInfos = ApplicationManagementService.getInstance().getApplicationBasicInfo(authorizedUserTenantDomain, authorizedUser, filter, offset, chunkSize);
            offset += chunkSize;
        } else {
            applicationBasicInfos = ApplicationManagementService.getInstance().getApplicationBasicInfo(authorizedUserTenantDomain, authorizedUser, filter, offset, expectedAuthorizedAppInfoCount);
            offset += expectedAuthorizedAppInfoCount;
        }
        ArrayList<ApplicationBasicInfo> authorizedAppBasicInfo = this.getAuthorizedApplicationBasicInfo(applicationBasicInfos, authorizedUser);
        if (authorizedAppBasicInfo.size() == expectedAuthorizedAppInfoCount) {
            expectedFilteredAuthorizedAppInfoList.addAll(authorizedAppBasicInfo);
            return expectedFilteredAuthorizedAppInfoList;
        }
        if (authorizedAppBasicInfo.size() > expectedAuthorizedAppInfoCount) {
            expectedFilteredAuthorizedAppInfoList.addAll(authorizedAppBasicInfo.subList(0, expectedAuthorizedAppInfoCount));
            return expectedFilteredAuthorizedAppInfoList;
        }
        expectedFilteredAuthorizedAppInfoList.addAll(authorizedAppBasicInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("No. of authorized app information found for user " + authorizedUser + " in tenant domain " + authorizedUserTenantDomain + ": " + expectedFilteredAuthorizedAppInfoList.size()));
        }
        if (offset >= totalFilteredSystemAppCount) {
            return expectedFilteredAuthorizedAppInfoList;
        }
        expectedAuthorizedAppInfoCount -= authorizedAppBasicInfo.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("No. of remaining authorized app information needed to be fetched from the DB for user " + authorizedUser + " in tenant domain " + authorizedUserTenantDomain + ": " + expectedAuthorizedAppInfoCount));
        }
        return this.getFilteredAuthorizedAppBasicInfo(expectedFilteredAuthorizedAppInfoList, authorizedUserTenantDomain, authorizedUser, filter, offset, chunkSize, expectedAuthorizedAppInfoCount, totalFilteredSystemAppCount);
    }

    public int getCountOfAllApplications() throws IdentityApplicationManagementException {
        List<String> applicationRoles = this.getApplicationRolesOfUser(this.getUsername());
        return applicationRoles.size();
    }

    public int getCountOfApplications(String filter) throws IdentityApplicationManagementException {
        String sanitizedFilter = this.getSanitizedFilter(filter);
        Pattern pattern = Pattern.compile(sanitizedFilter, 2);
        List<String> applicationRoles = this.getApplicationRolesOfUser(this.getUsername());
        ArrayList<String> filteredApplicationRoles = new ArrayList<String>();
        for (String applicationRole : applicationRoles) {
            Matcher matcher = pattern.matcher(applicationRole);
            if (!matcher.matches()) continue;
            filteredApplicationRoles.add(applicationRole);
        }
        return filteredApplicationRoles.size();
    }

    public void updateApplication(ServiceProvider serviceProvider) throws IdentityApplicationManagementException {
        try {
            if (!"wso2carbon-local-sp".equals(serviceProvider.getApplicationName()) && !ApplicationMgtUtil.isUserAuthorized(serviceProvider.getApplicationName(), this.getUsername(), serviceProvider.getApplicationID())) {
                log.warn((Object)("Illegal Access! User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " does not have access to the application " + serviceProvider.getApplicationName()));
                throw new IdentityApplicationManagementException("User not authorized");
            }
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.updateApplication(serviceProvider, this.getTenantDomain(), this.getUsername());
        }
        catch (IdentityApplicationManagementException ex) {
            String msg = "Error while updating application: " + serviceProvider.getApplicationName() + " for tenant: " + this.getTenantDomain();
            throw this.handleException(msg, ex);
        }
    }

    public void deleteApplication(String applicationName) throws IdentityApplicationManagementException {
        try {
            if (!ApplicationMgtUtil.isUserAuthorized(applicationName, this.getUsername())) {
                log.warn((Object)("Illegal Access! User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " does not have access to the application " + applicationName));
                throw new IdentityApplicationManagementException("User not authorized");
            }
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.deleteApplication(applicationName, this.getTenantDomain(), this.getUsername());
        }
        catch (IdentityApplicationManagementException ex) {
            String msg = "Error while deleting application: " + applicationName + " for tenant: " + this.getTenantDomain();
            throw this.handleException(msg, ex);
        }
    }

    public IdentityProvider getIdentityProvider(String federatedIdPName) throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getIdentityProvider(federatedIdPName, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException idpException) {
            log.error((Object)("Error while retrieving identity provider: " + federatedIdPName + " for tenant: " + this.getTenantDomain()), (Throwable)idpException);
            throw idpException;
        }
    }

    public IdentityProvider[] getAllIdentityProviders() throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getAllIdentityProviders(this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException idpException) {
            log.error((Object)("Error while retrieving all identity providers for tenant: " + this.getTenantDomain()), (Throwable)idpException);
            throw idpException;
        }
    }

    public LocalAuthenticatorConfig[] getAllLocalAuthenticators() throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getAllLocalAuthenticators(this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException idpException) {
            log.error((Object)("Error while retrieving all local authenticators for tenant: " + this.getTenantDomain()), (Throwable)idpException);
            throw idpException;
        }
    }

    public RequestPathAuthenticatorConfig[] getAllRequestPathAuthenticators() throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getAllRequestPathAuthenticators(this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException idpException) {
            log.error((Object)("Error while retrieving all request path authenticators for tenant: " + this.getTenantDomain()), (Throwable)idpException);
            throw idpException;
        }
    }

    public String[] getAllLocalClaimUris() throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getAllLocalClaimUris(this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException idpException) {
            log.error((Object)("Error while retrieving all local claim URIs for tenant: " + this.getTenantDomain()), (Throwable)idpException);
            throw idpException;
        }
    }

    public String getAuthenticationTemplatesJSON() {
        return this.applicationMgtService.getAuthenticationTemplatesJSON();
    }

    public ImportResponse importApplication(SpFileContent spFileContent) throws IdentityApplicationManagementException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.importSPApplication(spFileContent, this.getTenantDomain(), this.getUsername(), false);
        }
        catch (IdentityApplicationManagementException ex) {
            String message = "Error while importing application for tenant: " + this.getTenantDomain();
            throw this.handleException(message, ex);
        }
    }

    public String exportApplication(String applicationName, boolean exportSecrets) throws IdentityApplicationManagementException {
        try {
            if ("wso2carbon-local-sp".equals(applicationName)) {
                log.warn((Object)"Illegal access! Local service provider can't be exported");
                throw new IdentityApplicationManagementException("Local service provider can't be exported");
            }
            if (!ApplicationMgtUtil.isUserAuthorized(applicationName, this.getUsername())) {
                log.warn((Object)("Illegal Access! User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " does not have export the application " + applicationName));
                throw new IdentityApplicationManagementException("User not authorized");
            }
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.exportSPApplication(applicationName, exportSecrets, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementException ex) {
            String msg = "Error while exporting application: " + applicationName + " for tenant: " + this.getTenantDomain();
            throw this.handleException(msg, ex);
        }
    }

    public void createApplicationTemplate(SpTemplate spTemplate) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.createApplicationTemplate(spTemplate, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while creating application template: %s for tenant: %s.", spTemplate.getName(), this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public void createApplicationTemplateFromSP(ServiceProvider serviceProvider, SpTemplate spTemplate) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.createApplicationTemplateFromSP(serviceProvider, spTemplate, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while creating service provider template for the configured SP: %s for tenant: %s.", serviceProvider.getApplicationName(), this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public SpTemplate getApplicationTemplate(String templateName) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getApplicationTemplate(templateName, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while retrieving application template: %s for tenant: %s.", templateName, this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public void deleteApplicationTemplate(String templateName) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.deleteApplicationTemplate(templateName, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while deleting application template: %s in tenant: %s.", templateName, this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public void updateApplicationTemplate(String templateName, SpTemplate spTemplate) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            this.applicationMgtService.updateApplicationTemplate(templateName, spTemplate, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while updating application template: %s in tenant: %s.", spTemplate.getName(), this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public boolean isExistingApplicationTemplate(String templateName) throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.isExistingApplicationTemplate(templateName, this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while checking existence of application template: %s in tenant: %s.", templateName, this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public List<SpTemplate> getAllApplicationTemplateInfo() throws IdentityApplicationManagementClientException {
        try {
            this.applicationMgtService = ApplicationManagementService.getInstance();
            return this.applicationMgtService.getAllApplicationTemplateInfo(this.getTenantDomain());
        }
        catch (IdentityApplicationManagementClientException e) {
            throw e;
        }
        catch (IdentityApplicationManagementException e) {
            log.error((Object)String.format("Error while getting all the application template basic info for tenant: %s.", this.getTenantDomain()), (Throwable)e);
            throw new IdentityApplicationManagementClientException(new String[]{"Server error occurred."});
        }
    }

    public List<InboundAuthenticationRequestConfig> getCustomInboundAuthenticatorConfigs() {
        if (this.customInboundAuthenticatorConfigs != null) {
            return this.customInboundAuthenticatorConfigs;
        }
        this.generateCustomInboundAuthenticatorConfigs();
        return this.customInboundAuthenticatorConfigs;
    }

    private void generateCustomInboundAuthenticatorConfigs() {
        ArrayList<InboundAuthenticationRequestConfig> customAuthenticatorConfigs = new ArrayList<InboundAuthenticationRequestConfig>();
        Map<String, AbstractInboundAuthenticatorConfig> customInboundAuthenticators = ApplicationManagementServiceComponentHolder.getAllInboundAuthenticatorConfig();
        if (customInboundAuthenticators != null && customInboundAuthenticators.size() > 0) {
            for (Map.Entry<String, AbstractInboundAuthenticatorConfig> entry : customInboundAuthenticators.entrySet()) {
                AbstractInboundAuthenticatorConfig inboundAuthenticatorConfig = entry.getValue();
                InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
                inboundAuthenticationRequestConfig.setInboundAuthType(inboundAuthenticatorConfig.getName());
                inboundAuthenticationRequestConfig.setInboundConfigType(inboundAuthenticatorConfig.getConfigName());
                inboundAuthenticationRequestConfig.setFriendlyName(inboundAuthenticatorConfig.getFriendlyName());
                inboundAuthenticationRequestConfig.setProperties(inboundAuthenticatorConfig.getConfigurationProperties());
                customAuthenticatorConfigs.add(inboundAuthenticationRequestConfig);
            }
        }
        this.customInboundAuthenticatorConfigs = customAuthenticatorConfigs;
    }

    private ArrayList<ApplicationBasicInfo> getAuthorizedApplicationBasicInfo(ApplicationBasicInfo[] applicationBasicInfos, String userName) throws IdentityApplicationManagementException {
        ArrayList<ApplicationBasicInfo> appInfo = new ArrayList<ApplicationBasicInfo>();
        for (ApplicationBasicInfo applicationBasicInfo : applicationBasicInfos) {
            if (!ApplicationMgtUtil.isUserAuthorized(applicationBasicInfo.getApplicationName(), userName)) continue;
            appInfo.add(applicationBasicInfo);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Retrieving basic information of application: " + applicationBasicInfo.getApplicationName() + "username: " + userName));
        }
        return appInfo;
    }

    private int getFetchChunkSizeForPagination() {
        String fetchChunkSizeForPagination = IdentityUtil.getProperty((String)"ServiceProviders.FetchChunkSize");
        try {
            if (StringUtils.isNotBlank((String)fetchChunkSizeForPagination)) {
                int fetchChunkSize = Math.abs(Integer.parseInt(fetchChunkSizeForPagination));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fetch chunk size property is set to : " + fetchChunkSize));
                }
                return fetchChunkSize;
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Error occurred while parsing the 'FetchChunkSize' property value in identity.xml. Defaulting to: 50");
        }
        return 50;
    }

    private List<String> getApplicationRolesOfUser(String username) throws IdentityApplicationManagementException {
        try {
            String[] userRoles = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().getRoleListOfUser(username);
            ArrayList<String> applicationRoles = new ArrayList<String>();
            if (userRoles != null) {
                String applicationRoleDomain = "Application" + UserCoreConstants.DOMAIN_SEPARATOR;
                for (String role : userRoles) {
                    if (!role.startsWith(applicationRoleDomain)) continue;
                    applicationRoles.add(role);
                }
            }
            return applicationRoles;
        }
        catch (UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while retrieving application roles for user: " + username, (Throwable)e);
        }
    }

    private void validateRequestedPageNumber(int pageNumber) throws IdentityApplicationManagementException {
        if (pageNumber < 1) {
            throw new IdentityApplicationManagementException("Invalid page number requested. The page number should be a value greater than 0.");
        }
    }

    private boolean isMaxPageNumberToRequestExceeded(String authorizedUser, int pageNumber, int totalUserAuthorizedAppCount, int itemsPerPage) {
        int numberOfPages = (int)Math.ceil((double)totalUserAuthorizedAppCount / (double)itemsPerPage);
        int startIndexOfRequestedPage = itemsPerPage * (pageNumber - 1) + 1;
        if (totalUserAuthorizedAppCount < startIndexOfRequestedPage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The requested page number exceeds the total number of applications authorized for the user: " + authorizedUser + ". Pages can be requested only upto page " + numberOfPages + "."));
            }
            return true;
        }
        return false;
    }

    private String getSanitizedFilter(String filter) {
        if (StringUtils.isNotBlank((String)filter)) {
            filter = filter.replace("*", ".*");
            filter = "Application" + UserCoreConstants.DOMAIN_SEPARATOR + filter;
        } else {
            filter = ".*";
        }
        return filter;
    }
}

