/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services.utils;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Map;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TagCount;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.search.beans.SearchResultsBean;

public class SearchResultsBeanPopulator {
    public static SearchResultsBean populate(UserRegistry userRegistry, String searchType, String criteria) {
        SearchResultsBean searchResultsBean = new SearchResultsBean();
        try {
            ResourceData[] resourceDataList = searchType.equalsIgnoreCase("Tag") ? SearchResultsBeanPopulator.searchByTags(criteria, userRegistry) : SearchResultsBeanPopulator.searchByContent(criteria, userRegistry);
            Arrays.sort(resourceDataList, new Comparator<ResourceData>(){

                @Override
                public int compare(ResourceData o1, ResourceData o2) {
                    return o1.getResourcePath().toLowerCase().compareTo(o2.getResourcePath().toLowerCase());
                }
            });
            searchResultsBean.setResourceDataList(resourceDataList);
        }
        catch (RegistryException e) {
            String msg = "Failed to generate search results. " + e.getMessage();
            searchResultsBean.setErrorMessage(msg);
            searchResultsBean.setResourceDataList(new ResourceData[0]);
        }
        return searchResultsBean;
    }

    private static ResourceData[] searchByTags(String tag, UserRegistry registry) throws RegistryException {
        ResourceData[] resourceDataList = new ResourceData[]{};
        if (tag != null && tag.length() != 0) {
            TaggedResourcePath[] taggedPaths = registry.getResourcePathsWithTag(tag);
            resourceDataList = new ResourceData[taggedPaths.length];
            for (int i = 0; i < taggedPaths.length; ++i) {
                String resultPath = taggedPaths[i].getResourcePath();
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(resultPath);
                if (resultPath != null) {
                    if (resultPath.equals("/")) {
                        resourceData.setName("/");
                    } else {
                        String[] parts = resultPath.split("/");
                        resourceData.setName(parts[parts.length - 1]);
                    }
                }
                try {
                    Resource child = registry.get(resultPath);
                    String actualPath = child.getProperty("registry.actualpath");
                    if (actualPath != null && registry.resourceExists(actualPath)) {
                        child = registry.get(actualPath);
                    }
                    resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                    resourceData.setAuthorUserName(child.getAuthorUserName());
                    resourceData.setDescription(child.getDescription());
                    resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                    Calendar createdDateTime = Calendar.getInstance();
                    createdDateTime.setTime(child.getCreatedTime());
                    resourceData.setCreatedOn(createdDateTime);
                    Map counts = taggedPaths[i].getTagCounts();
                    Object[] keySet = counts.keySet().toArray();
                    TagCount[] tagCounts = new TagCount[counts.size()];
                    for (int j = 0; j < counts.size(); ++j) {
                        TagCount tagCount = new TagCount();
                        tagCount.setKey((String)keySet[j]);
                        tagCount.setValue(new Long((String)counts.get(keySet[j])));
                        tagCounts[j] = tagCount;
                    }
                    resourceData.setTagCounts(tagCounts);
                    CommonUtil.populateAverageStars((ResourceData)resourceData);
                    child.discard();
                    resourceDataList[i] = resourceData;
                    continue;
                }
                catch (AuthorizationFailedException authorizationFailedException) {
                    // empty catch block
                }
            }
        }
        return resourceDataList;
    }

    private static ResourceData[] searchByContent(String content, UserRegistry registry) throws RegistryException {
        ResourceData[] resourceDataList = new ResourceData[]{};
        if (content != null && content.length() != 0) {
            String[] paths;
            try {
                paths = (String[])registry.searchContent(content).getContent();
            }
            catch (Exception e) {
                return new ResourceData[0];
            }
            resourceDataList = new ResourceData[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(paths[i]);
                if (paths[i] != null) {
                    if (paths[i].equals("/")) {
                        resourceData.setName("/");
                    } else {
                        String[] parts = paths[i].split("/");
                        resourceData.setName(parts[parts.length - 1]);
                    }
                }
                try {
                    Resource child = registry.get(paths[i]);
                    String actualPath = child.getProperty("registry.actualpath");
                    if (actualPath != null && registry.resourceExists(actualPath)) {
                        child = registry.get(actualPath);
                    }
                    resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                    resourceData.setAuthorUserName(child.getAuthorUserName());
                    resourceData.setDescription(child.getDescription());
                    resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                    Calendar createdDateTime = Calendar.getInstance();
                    createdDateTime.setTime(child.getCreatedTime());
                    resourceData.setCreatedOn(createdDateTime);
                    CommonUtil.populateAverageStars((ResourceData)resourceData);
                    child.discard();
                    resourceDataList[i] = resourceData;
                    continue;
                }
                catch (AuthorizationFailedException authorizationFailedException) {
                    // empty catch block
                }
            }
        }
        return resourceDataList;
    }
}

