/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.services.utils.AdvancedResourceQuery;
import org.wso2.carbon.registry.search.services.utils.SearchUtils;

public class AdvancedSearchResultsBeanPopulator {
    public static final Log log = LogFactory.getLog(AdvancedSearchResultsBeanPopulator.class);

    /*
     * WARNING - void declaration
     */
    public static AdvancedSearchResultsBean populate(Registry configSystemRegistry, UserRegistry registry, CustomSearchParameterBean propertyNameValues) {
        AdvancedSearchResultsBean advancedSearchResultsBean = new AdvancedSearchResultsBean();
        try {
            void var13_24;
            String[] childPaths = AdvancedSearchResultsBeanPopulator.getQueryResult(configSystemRegistry, registry, propertyNameValues.getParameterValues());
            String[][] parameterValues = propertyNameValues.getParameterValues();
            String resourcePathPattern = null;
            for (String[] parameterValue : parameterValues) {
                if (!parameterValue[0].equals("resourcePath") || parameterValue[1] == null || parameterValue[1].length() <= 0) continue;
                resourcePathPattern = "^(" + parameterValue[1].replace("%", ".*").replace("$", "\\$") + ")$";
                break;
            }
            boolean onlyAssociation = true;
            String associationType = null;
            String associationDestination = null;
            for (String string : parameterValues) {
                if (!(string[0].equals("content") || string[0].equals("associationType") || string[0].equals("associationDest") || string[0].equals("leftOp") || string[0].equals("rightOp") || string[1] == null || string[1].length() <= 0)) {
                    onlyAssociation = false;
                }
                if (string[0].equals("associationType") && string[1] != null && string[1].length() > 0) {
                    associationType = string[1];
                }
                if (!string[0].equals("associationDest") || string[1] == null || string[1].length() <= 0) continue;
                associationDestination = string[1];
            }
            if (onlyAssociation) {
                for (String string : parameterValues) {
                    if (!string[0].equals("resourcePath")) continue;
                    string[1] = "%";
                    break;
                }
                childPaths = AdvancedSearchResultsBeanPopulator.getQueryResult(configSystemRegistry, registry, parameterValues);
            }
            ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
            String[] stringArray = childPaths;
            int n = stringArray.length;
            boolean bl = false;
            while (var13_24 < n) {
                String childPath = stringArray[var13_24];
                if (resourcePathPattern == null || Pattern.compile(resourcePathPattern).matcher(childPath.substring(childPath.lastIndexOf("/") + 1)).find()) {
                    boolean doContinue = true;
                    boolean doContinueDest = true;
                    if (associationDestination != null) {
                        Association[] destinationAssociations;
                        for (Association association : destinationAssociations = registry.getAllAssociations(childPath)) {
                            if (!association.getDestinationPath().contains(associationDestination)) continue;
                            doContinueDest = false;
                            break;
                        }
                    }
                    if (associationType != null) {
                        Association[] typeAssociations = registry.getAssociations(childPath, associationType);
                        for (Association association : typeAssociations) {
                            if (!association.getSourcePath().equals(childPath)) continue;
                            doContinue = false;
                            break;
                        }
                    }
                    if (!(associationType != null && doContinue || associationDestination != null && doContinueDest)) {
                        try {
                            Resource child = registry.get(childPath);
                            if (!"true".equals(child.getProperty("registry.absent"))) {
                                String actualPath;
                                ResourceData resourceData = new ResourceData();
                                resourceData.setResourcePath(childPath);
                                if (childPath != null) {
                                    if ("/".equals(childPath)) {
                                        resourceData.setName("root");
                                    } else {
                                        String[] parts = childPath.split("/");
                                        resourceData.setName(parts[parts.length - 1]);
                                    }
                                }
                                if ((actualPath = child.getProperty("registry.actualpath")) != null && registry.resourceExists(actualPath)) {
                                    child = registry.get(actualPath);
                                }
                                resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                                resourceData.setAuthorUserName(child.getAuthorUserName());
                                resourceData.setDescription(child.getDescription());
                                resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                                Calendar createdDateTime = Calendar.getInstance();
                                createdDateTime.setTime(child.getCreatedTime());
                                resourceData.setCreatedOn(createdDateTime);
                                CommonUtil.populateAverageStars((ResourceData)resourceData);
                                String user = child.getProperty("registry.user");
                                if (registry.getUserName().equals(user)) {
                                    resourceData.setPutAllowed(true);
                                    resourceData.setDeleteAllowed(true);
                                    resourceData.setGetAllowed(true);
                                } else {
                                    resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                                    resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                                    resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                                }
                                child.discard();
                                resourceDataList.add(resourceData);
                            }
                        }
                        catch (AuthorizationFailedException authorizationFailedException) {
                            // empty catch block
                        }
                    }
                }
                ++var13_24;
            }
            SearchUtils.sortResourceDataList(resourceDataList);
            advancedSearchResultsBean.setResourceDataList(resourceDataList.toArray(new ResourceData[resourceDataList.size()]));
        }
        catch (RegistryException e) {
            String msg = "Failed to get advanced search results. " + e.getMessage();
            advancedSearchResultsBean.setErrorMessage(msg);
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining search results", (Throwable)e);
        }
        return advancedSearchResultsBean;
    }

    private static String[] getQueryResult(Registry configSystemRegistry, UserRegistry registry, String[][] propertyNameValues) throws Exception {
        AdvancedResourceQuery query = new AdvancedResourceQuery();
        HashMap<String, String> customValues = new HashMap<String, String>();
        for (String[] propertyNameValue : propertyNameValues) {
            if (propertyNameValue[0].equals("resourcePath")) {
                query.setResourceName(propertyNameValue[1]);
                continue;
            }
            if (propertyNameValue[0].equals("author")) {
                query.setAuthorName((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("updater")) {
                query.setUpdaterName((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("createdAfter")) {
                query.setCreatedAfter(CommonUtil.computeDate((String)propertyNameValue[1]));
                continue;
            }
            if (((String)propertyNameValue[0]).equals("createdBefore")) {
                query.setCreatedBefore(AdvancedSearchResultsBeanPopulator.addOneDay(CommonUtil.computeDate((String)propertyNameValue[1])));
                continue;
            }
            if (((String)propertyNameValue[0]).equals("updatedAfter")) {
                query.setUpdatedAfter(CommonUtil.computeDate((String)propertyNameValue[1]));
                continue;
            }
            if (((String)propertyNameValue[0]).equals("updatedBefore")) {
                query.setUpdatedBefore(AdvancedSearchResultsBeanPopulator.addOneDay(CommonUtil.computeDate((String)propertyNameValue[1])));
                continue;
            }
            if (((String)propertyNameValue[0]).equals("commentWords")) {
                query.setCommentWords((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("associationType")) {
                query.setAssociationType((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("associationDest")) {
                query.setAssociationDest((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("tags")) {
                query.setTags((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("propertyName")) {
                query.setPropertyName((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("leftPropertyValue")) {
                query.setLeftPropertyValue((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("rightPropertyValue")) {
                query.setRightPropertyValue((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("propertyValue")) {
                query.setRightPropertyValue((String)propertyNameValue[1]);
                query.setRightOp("eq");
                continue;
            }
            if (((String)propertyNameValue[0]).equals("authorNameNegate")) {
                query.setAuthorNameNegate((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("updaterNameNegate")) {
                query.setUpdaterNameNegate((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("createdRangeNegate")) {
                query.setCreatedRangeNegate((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("updatedRangeNegate")) {
                query.setUpdatedRangeNegate((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("leftOp")) {
                query.setLeftOp((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("rightOp")) {
                query.setRightOp((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("content")) {
                query.setContent((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("mediaType")) {
                query.setMediaType((String)propertyNameValue[1]);
                continue;
            }
            if (((String)propertyNameValue[0]).equals("mediaTypeNegate")) {
                query.setMediaTypeNegate((String)propertyNameValue[1]);
                continue;
            }
            customValues.put((String)propertyNameValue[0], (String)propertyNameValue[1]);
        }
        boolean first = true;
        boolean noCustomSearch = true;
        HashSet<String> s = new HashSet<String>();
        for (Map.Entry entry : customValues.entrySet()) {
            if (((String)entry.getValue()).equals("")) continue;
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put((String)entry.getKey(), (String)entry.getValue());
            query.setCustomSearchValues(temp);
            Resource qResults = query.execute(configSystemRegistry, (Registry)registry);
            if (((String[])qResults.getContent()).length > 0) {
                if (first) {
                    s.addAll(Arrays.asList((String[])qResults.getContent()));
                    first = false;
                } else {
                    s.retainAll(Arrays.asList((String[])qResults.getContent()));
                }
            } else {
                s.clear();
                return new String[0];
            }
            noCustomSearch = false;
        }
        if (noCustomSearch) {
            query.setCustomSearchValues(customValues);
            Resource qResults = query.execute(configSystemRegistry, (Registry)registry);
            return (String[])qResults.getContent();
        }
        String[] ret = new String[s.size()];
        ret = s.toArray(ret);
        return ret;
    }

    private static Date addOneDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }
}

