/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;

public class AdvancedResourceQuery {
    private static Log log = LogFactory.getLog(AdvancedResourceQuery.class);
    private String resourceName;
    private String authorName;
    private String updaterName;
    private String commentWords;
    private String associationType;
    private String associationDest;
    private String propertyName;
    private String leftPropertyValue;
    private String rightPropertyValue;
    private String content;
    private Map<String, String> customSearchValues;
    private String mediaType;
    private boolean authorNameNegate;
    private boolean updaterNameNegate;
    private boolean createdRangeNegate;
    private boolean updatedRangeNegate;
    private boolean mediaTypeNegate;
    private String leftOp;
    private String rightOp;
    private boolean propertyRange;
    private Set<String> tags;
    private String queryPath;
    private long createdAfter = Long.MIN_VALUE;
    private long createdBefore = Long.MIN_VALUE;
    private long updatedAfter = Long.MIN_VALUE;
    private long updatedBefore = Long.MIN_VALUE;

    public Resource execute(Registry configSystemRegistry, Registry registry) throws RegistryException {
        String collectionQuery;
        String[] resourcePaths = new String[]{};
        String[] collectionPaths = new String[]{};
        String resourceQuery = this.generateSQLForResources();
        if (resourceQuery != null) {
            resourcePaths = this.executeResourceQuery(registry, resourceQuery);
        }
        if ((collectionQuery = this.generateSQLForCollections()) != null) {
            collectionPaths = this.executeCollectionQuery(registry, collectionQuery);
        }
        HashSet<String> totalPathsArr = new HashSet<String>();
        totalPathsArr.addAll(Arrays.asList(resourcePaths));
        totalPathsArr.addAll(Arrays.asList(collectionPaths));
        String[] totalPaths = totalPathsArr.toArray(new String[totalPathsArr.size()]);
        Collection c = registry.newCollection();
        c.setContent((Object)totalPaths);
        return c;
    }

    private String[] executeResourceQuery(Registry registry, String query) throws RegistryException {
        Collection r;
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            params.add(this.resourceName);
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            params.add("%" + this.authorName + "%");
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            params.add("%" + this.updaterName + "%");
        }
        if (this.createdAfter > Long.MIN_VALUE) {
            params.add(new Timestamp(this.createdAfter));
        }
        if (this.createdBefore > Long.MIN_VALUE) {
            params.add(new Timestamp(this.createdBefore));
        }
        if (this.updatedAfter > Long.MIN_VALUE) {
            params.add(new Timestamp(this.updatedAfter));
        }
        if (this.updatedBefore > Long.MIN_VALUE) {
            params.add(new Timestamp(this.updatedBefore));
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            params.add("%" + this.commentWords + "%");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            params.addAll(this.tags);
        }
        if (this.propertyName != null) {
            params.add(this.propertyName);
        }
        if (this.leftPropertyValue != null) {
            params.add(this.leftPropertyValue);
        }
        if (this.rightPropertyValue != null) {
            params.add(this.rightPropertyValue);
        }
        if (this.mediaType != null) {
            params.add(this.mediaType);
        }
        if (this.customSearchValues.size() > 0) {
            for (String s : this.customSearchValues.keySet()) {
                if (this.customSearchValues.get(s).trim().equals("")) continue;
                params.add(this.customSearchValues.get(s));
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            Object value = params.get(i);
            paramMap.put(Integer.toString(i + 1), value);
        }
        if (query != null && query.length() != 0) {
            paramMap.put("query", query);
            r = registry.executeQuery(null, paramMap);
        } else {
            r = registry.executeQuery(this.queryPath, paramMap);
        }
        return (String[])r.getContent();
    }

    private String[] executeCollectionQuery(Registry registry, String query) throws RegistryException {
        Collection r;
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            params.add("%/" + this.resourceName);
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            params.add("%" + this.authorName + "%");
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            params.add("%" + this.updaterName + "%");
        }
        if (this.createdAfter > Long.MIN_VALUE) {
            params.add(new Timestamp(this.createdAfter));
        }
        if (this.createdBefore > Long.MIN_VALUE) {
            params.add(new Timestamp(this.createdBefore));
        }
        if (this.updatedAfter > Long.MIN_VALUE) {
            params.add(new Timestamp(this.updatedAfter));
        }
        if (this.updatedBefore > Long.MIN_VALUE) {
            params.add(new Timestamp(this.updatedBefore));
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            params.add("%" + this.commentWords + "%");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            params.addAll(this.tags);
        }
        if (this.propertyName != null) {
            params.add(this.propertyName);
        }
        if (this.leftPropertyValue != null) {
            params.add(this.leftPropertyValue);
        }
        if (this.rightPropertyValue != null) {
            params.add(this.rightPropertyValue);
        }
        if (this.mediaType != null) {
            params.add(this.mediaType);
        }
        if (this.customSearchValues.size() > 0) {
            for (String s : this.customSearchValues.keySet()) {
                if (this.customSearchValues.get(s).trim().equals("")) continue;
                params.add(this.customSearchValues.get(s));
            }
        }
        if (this.associationType != null) {
            params.add(this.associationType);
        }
        if (this.associationDest != null) {
            params.add("%/" + this.associationDest.toLowerCase());
            params.add("%/" + this.associationDest.toLowerCase() + "/%");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            Object value = params.get(i);
            paramMap.put(Integer.toString(i + 1), value);
        }
        if (query != null && query.length() != 0) {
            paramMap.put("query", query);
            r = registry.executeQuery(null, paramMap);
        } else {
            r = registry.executeQuery(this.queryPath, paramMap);
        }
        return (String[])r.getContent();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        if ("".equals(resourceName)) {
            resourceName = null;
        }
        if (resourceName != null) {
            resourceName = resourceName.toLowerCase();
        }
        this.resourceName = resourceName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        if ("".equals(authorName)) {
            authorName = null;
        }
        if (authorName != null) {
            authorName = authorName.toLowerCase();
        }
        this.authorName = authorName;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public void setUpdaterName(String updaterName) {
        if ("".equals(updaterName)) {
            updaterName = null;
        }
        if (updaterName != null) {
            updaterName = updaterName.toLowerCase();
        }
        this.updaterName = updaterName;
    }

    public Date getCreatedAfter() {
        return this.createdAfter == Long.MIN_VALUE ? null : new Date(this.createdAfter);
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter == null ? Long.MIN_VALUE : createdAfter.getTime();
    }

    public Date getCreatedBefore() {
        return this.createdBefore == Long.MIN_VALUE ? null : new Date(this.createdBefore);
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore == null ? Long.MIN_VALUE : createdBefore.getTime();
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter == Long.MIN_VALUE ? null : new Date(this.updatedAfter);
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter == null ? Long.MIN_VALUE : updatedAfter.getTime();
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore == Long.MIN_VALUE ? null : new Date(this.updatedBefore);
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore == null ? Long.MIN_VALUE : updatedBefore.getTime();
    }

    public void setTags(String tags) {
        this.tags = this.parseTags(tags);
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = "".equals(propertyName) ? null : propertyName.toLowerCase();
    }

    public void setLeftPropertyValue(String leftPropertyValue) {
        if ("".equals(leftPropertyValue)) {
            leftPropertyValue = null;
        }
        this.leftPropertyValue = leftPropertyValue;
    }

    public void setRightPropertyValue(String rightPropertyValue) {
        if ("".equals(rightPropertyValue)) {
            rightPropertyValue = null;
        }
        this.rightPropertyValue = rightPropertyValue;
    }

    public void setMediaTypeNegate(String mediaNegate) {
        this.mediaTypeNegate = !mediaNegate.equals("");
    }

    public String getCommentWords() {
        return this.commentWords;
    }

    public void setCommentWords(String commentWords) {
        if ("".equals(commentWords)) {
            commentWords = null;
        }
        this.commentWords = commentWords;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(String associationType) {
        if ("".equals(associationType)) {
            associationType = null;
        }
        this.associationType = associationType;
    }

    public String getAssociationDest() {
        return this.associationDest;
    }

    public void setAssociationDest(String associationDest) {
        if ("".equals(associationDest)) {
            associationDest = null;
        }
        this.associationDest = associationDest;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, String> getCustomSearchValues() {
        return this.customSearchValues;
    }

    public void setCustomSearchValues(Map<String, String> customSearchValues) {
        this.customSearchValues = customSearchValues;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        if ("".equals(mediaType)) {
            mediaType = null;
        }
        this.mediaType = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)mediaType);
    }

    public void setAuthorNameNegate(String authNegate) {
        this.authorNameNegate = !authNegate.equals("");
    }

    public void setUpdaterNameNegate(String updNegate) {
        this.updaterNameNegate = !updNegate.equals("");
    }

    public void setCreatedRangeNegate(String createdRange) {
        this.createdRangeNegate = !createdRange.equals("");
    }

    public void setUpdatedRangeNegate(String updatedRange) {
        this.updatedRangeNegate = !updatedRange.equals("");
    }

    public void setLeftOp(String leftOp) {
        if (this.leftPropertyValue != null) {
            if (leftOp.equals("gt")) {
                this.leftOp = ">";
            } else if (leftOp.equals("ge")) {
                this.leftOp = ">=";
            }
        }
    }

    public void setRightOp(String rightOp) {
        if (this.rightPropertyValue != null) {
            if (rightOp.equals("lt")) {
                this.rightOp = "<";
            } else if (rightOp.equals("le")) {
                this.rightOp = "<=";
            } else if (rightOp.equals("eq")) {
                this.rightOp = "=";
            }
            if (this.leftPropertyValue != null) {
                this.propertyRange = true;
            }
        }
    }

    private boolean queryExists(Registry configSystemRegistry, String queryPath) throws RegistryException {
        UserRegistry registry = (UserRegistry)configSystemRegistry;
        return registry.resourceExists(queryPath);
    }

    private void defineQueries(Registry configSystemRegistry, String queryPath, String queryContent) throws RegistryException {
        UserRegistry registry = (UserRegistry)configSystemRegistry;
        Resource q1 = registry.newResource();
        q1.setContent((Object)queryContent);
        q1.setMediaType("application/vnd.sql.query");
        q1.addProperty("resultType", "Resource");
        registry.put(queryPath, q1);
    }

    public Set<String> parseTags(String tags) {
        String[] parts;
        HashSet<String> result = new HashSet<String>();
        for (String part1 : parts = tags.split("\\,")) {
            String part = part1.trim();
            if ("".equals(part)) continue;
            result.add(part.toLowerCase());
        }
        return result;
    }

    private String generateSQLForResources() {
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            conditions.add("lower(R.REG_NAME) LIKE ?");
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            if (this.authorNameNegate) {
                conditions.add("lower(R.REG_CREATOR) NOT LIKE ?");
            } else {
                conditions.add("lower(R.REG_CREATOR) LIKE ?");
            }
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            if (this.updaterNameNegate) {
                conditions.add("lower(R.REG_LAST_UPDATOR) NOT LIKE ?");
            } else {
                conditions.add("lower(R.REG_LAST_UPDATOR) LIKE ?");
            }
        }
        if (this.createdAfter > Long.MIN_VALUE) {
            if (this.createdRangeNegate) {
                if (this.createdBefore <= Long.MIN_VALUE) {
                    conditions.add("R.REG_CREATED_TIME < ?");
                }
            } else {
                conditions.add("R.REG_CREATED_TIME > ?");
            }
        }
        if (this.createdBefore > Long.MIN_VALUE) {
            if (this.createdRangeNegate) {
                if (this.createdAfter <= Long.MIN_VALUE) {
                    conditions.add("R.REG_CREATED_TIME > ?");
                } else {
                    conditions.add("R.REG_CREATED_TIME < ? OR R.REG_CREATED_TIME > ?");
                }
            } else {
                conditions.add("R.REG_CREATED_TIME < ?");
            }
        }
        if (this.updatedAfter > Long.MIN_VALUE) {
            if (this.updatedRangeNegate) {
                if (this.updatedBefore <= Long.MIN_VALUE) {
                    conditions.add("R.REG_LAST_UPDATED_TIME < ?");
                }
            } else {
                conditions.add("R.REG_LAST_UPDATED_TIME > ?");
            }
        }
        if (this.updatedBefore > Long.MIN_VALUE) {
            if (this.updatedRangeNegate) {
                if (this.updatedAfter <= Long.MIN_VALUE) {
                    conditions.add("R.REG_LAST_UPDATED_TIME > ?");
                } else {
                    conditions.add("R.REG_LAST_UPDATED_TIME < ? OR R.REG_LAST_UPDATED_TIME > ?");
                }
            } else {
                conditions.add("R.REG_LAST_UPDATED_TIME < ?");
            }
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            tables.add(", REG_COMMENT C");
            tables.add(", REG_RESOURCE_COMMENT RC");
            if (StaticConfiguration.isVersioningComments()) {
                conditions.add("R.REG_VERSION=RC.REG_VERSION AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            } else {
                conditions.add("R.REG_PATH_ID=RC.REG_PATH_ID AND ((R.REG_NAME = RC.REG_RESOURCE_NAME)) AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            }
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            tables.add(", REG_TAG T");
            tables.add(", REG_RESOURCE_TAG RT");
            StringBuilder tagClause = new StringBuilder();
            if (StaticConfiguration.isVersioningTags()) {
                tagClause.append("R.REG_VERSION=RT.REG_VERSION AND RT.REG_TAG_ID=T.REG_ID ");
            } else {
                tagClause.append("R.REG_PATH_ID=RT.REG_PATH_ID AND ((R.REG_NAME = RT.REG_RESOURCE_NAME)) AND RT.REG_TAG_ID=T.REG_ID ");
            }
            Iterator<Object> i = this.tags.iterator();
            int count = 0;
            while (i.hasNext()) {
                if (++count == 1) {
                    tagClause.append(" AND (lower(T.REG_TAG_NAME) LIKE ?");
                } else {
                    tagClause.append(" OR lower(T.REG_TAG_NAME) LIKE ?");
                }
                i.next();
            }
            if (this.tags.size() > 0) {
                tagClause.append(")");
            }
            conditions.add(tagClause.toString());
        }
        boolean bool = false;
        if (this.customSearchValues.size() > 0) {
            for (Map.Entry<String, String> e : this.customSearchValues.entrySet()) {
                if (e.getValue().trim().equals("")) continue;
                bool = true;
            }
        }
        if (bool || this.rightPropertyValue != null && this.rightOp.equals("=") || this.propertyName != null) {
            tables.add(", REG_PROPERTY PP");
            tables.add(", REG_RESOURCE_PROPERTY RP");
            if (StaticConfiguration.isVersioningProperties()) {
                conditions.add("R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID");
            } else {
                conditions.add("R.REG_PATH_ID=RP.REG_PATH_ID AND ((R.REG_NAME = RP.REG_RESOURCE_NAME)) AND RP.REG_PROPERTY_ID=PP.REG_ID");
            }
        }
        if (this.propertyName != null) {
            conditions.add(" lower(PP.REG_NAME) LIKE ? ");
            if (this.propertyRange) {
                conditions.add(" PP.REG_VALUE " + this.leftOp + " ? AND PP.REG_VALUE " + this.rightOp + " ? ");
            } else if (this.rightPropertyValue != null) {
                if (this.rightOp.equals("=")) {
                    conditions.add(" PP.REG_VALUE LIKE ? ");
                } else {
                    conditions.add(" PP.REG_VALUE " + this.rightOp + " ? ");
                }
            } else if (this.leftPropertyValue != null) {
                conditions.add(" PP.REG_VALUE " + this.leftOp + " ? ");
            }
        } else if (this.rightPropertyValue != null && this.rightOp.equals("=")) {
            conditions.add(" PP.REG_VALUE LIKE ? ");
        }
        if (this.mediaType != null) {
            if (this.mediaTypeNegate) {
                conditions.add("R.REG_MEDIA_TYPE NOT LIKE ?");
            } else {
                conditions.add("R.REG_MEDIA_TYPE LIKE ?");
            }
        }
        if (this.customSearchValues.size() > 0) {
            StringBuilder propertyClause = new StringBuilder();
            boolean firstTime = true;
            for (Map.Entry<String, String> e : this.customSearchValues.entrySet()) {
                if (e.getValue().trim().equals("")) continue;
                if (firstTime) {
                    propertyClause.append(" lower(PP.REG_NAME) LIKE '").append(e.getKey().toLowerCase()).append("'").append(" AND PP.REG_VALUE LIKE ?");
                    firstTime = false;
                    continue;
                }
                propertyClause.append(" AND lower(PP.REG_NAME) LIKE '").append(e.getKey().toLowerCase()).append("'").append(" AND PP.REG_VALUE LIKE ?");
            }
            if (!propertyClause.toString().equals("")) {
                conditions.add(propertyClause.toString());
            }
        }
        if (conditions.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R");
        for (String table : tables) {
            query.append(table);
        }
        boolean first = true;
        for (String condition : conditions) {
            if (first) {
                query.append(" WHERE ");
                first = false;
            } else {
                query.append(" AND ");
            }
            query.append(condition);
        }
        return query.toString();
    }

    private String generateSQLForCollections() {
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.resourceName != null && this.resourceName.length() != 0) {
            tables.add(", REG_PATH P");
            conditions.add(" lower(P.REG_PATH_VALUE) LIKE ? AND P.REG_PATH_ID=R.REG_PATH_ID");
        }
        if (this.authorName != null && this.authorName.length() != 0) {
            if (this.authorNameNegate) {
                conditions.add("lower(R.REG_CREATOR) NOT LIKE ?");
            } else {
                conditions.add("lower(R.REG_CREATOR) LIKE ?");
            }
        }
        if (this.updaterName != null && this.updaterName.length() != 0) {
            if (this.updaterNameNegate) {
                conditions.add("lower(R.REG_LAST_UPDATOR) NOT LIKE ?");
            } else {
                conditions.add("lower(R.REG_LAST_UPDATOR) LIKE ?");
            }
        }
        if (this.createdAfter > Long.MIN_VALUE) {
            if (this.createdRangeNegate) {
                if (this.createdBefore <= Long.MIN_VALUE) {
                    conditions.add("R.REG_CREATED_TIME < ?");
                }
            } else {
                conditions.add("R.REG_CREATED_TIME > ?");
            }
        }
        if (this.createdBefore > Long.MIN_VALUE) {
            if (this.createdRangeNegate) {
                if (this.createdAfter <= Long.MIN_VALUE) {
                    conditions.add("R.REG_CREATED_TIME > ?");
                } else {
                    conditions.add("R.REG_CREATED_TIME < ? OR R.REG_CREATED_TIME > ?");
                }
            } else {
                conditions.add("R.REG_CREATED_TIME < ?");
            }
        }
        if (this.updatedAfter > Long.MIN_VALUE) {
            if (this.updatedRangeNegate) {
                if (this.updatedBefore <= Long.MIN_VALUE) {
                    conditions.add("R.REG_LAST_UPDATED_TIME < ?");
                }
            } else {
                conditions.add("R.REG_LAST_UPDATED_TIME > ?");
            }
        }
        if (this.updatedBefore > Long.MIN_VALUE) {
            if (this.updatedRangeNegate) {
                if (this.updatedAfter <= Long.MIN_VALUE) {
                    conditions.add("R.REG_LAST_UPDATED_TIME > ?");
                } else {
                    conditions.add("R.REG_LAST_UPDATED_TIME < ? OR R.REG_LAST_UPDATED_TIME > ?");
                }
            } else {
                conditions.add("R.REG_LAST_UPDATED_TIME < ?");
            }
        }
        if (this.commentWords != null && this.commentWords.length() != 0) {
            tables.add(", REG_COMMENT C");
            tables.add(", REG_RESOURCE_COMMENT RC");
            if (StaticConfiguration.isVersioningComments()) {
                conditions.add("R.REG_VERSION=RC.REG_VERSION AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            } else {
                conditions.add("R.REG_PATH_ID=RC.REG_PATH_ID AND R.REG_NAME IS NULL AND RC.REG_RESOURCE_NAME IS NULL AND RC.REG_COMMENT_ID=C.REG_ID AND C.REG_COMMENT_TEXT LIKE ?");
            }
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            tables.add(", REG_TAG T");
            tables.add(", REG_RESOURCE_TAG RT");
            StringBuilder tagClause = new StringBuilder();
            if (StaticConfiguration.isVersioningTags()) {
                tagClause.append("R.REG_VERSION=RT.REG_VERSION AND RT.REG_TAG_ID=T.REG_ID ");
            } else {
                tagClause.append("R.REG_PATH_ID=RT.REG_PATH_ID AND R.REG_NAME IS NULL AND RT.REG_RESOURCE_NAME IS NULL AND RT.REG_TAG_ID=T.REG_ID ");
            }
            Iterator<Object> i = this.tags.iterator();
            int count = 0;
            while (i.hasNext()) {
                if (++count == 1) {
                    tagClause.append(" AND (lower(T.REG_TAG_NAME) LIKE ?");
                } else {
                    tagClause.append(" OR lower(T.REG_TAG_NAME) LIKE ?");
                }
                i.next();
            }
            if (this.tags.size() > 0) {
                tagClause.append(")");
            }
            conditions.add(tagClause.toString());
        }
        boolean bool = false;
        if (this.customSearchValues.size() > 0) {
            for (Map.Entry<String, String> e : this.customSearchValues.entrySet()) {
                if (e.getValue().trim().equals("")) continue;
                bool = true;
            }
        }
        if (bool || this.rightPropertyValue != null && this.rightOp.equals("=") || this.propertyName != null) {
            tables.add(", REG_PROPERTY PP");
            tables.add(", REG_RESOURCE_PROPERTY RP");
            if (StaticConfiguration.isVersioningProperties()) {
                conditions.add("R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID");
            } else {
                conditions.add("R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID");
            }
        }
        if (this.propertyName != null) {
            conditions.add(" lower(PP.REG_NAME) LIKE ? ");
            if (this.propertyRange) {
                conditions.add(" PP.REG_VALUE " + this.leftOp + " ? AND PP.REG_VALUE " + this.rightOp + " ? ");
            } else if (this.leftPropertyValue != null) {
                if (this.leftOp.equals("=")) {
                    conditions.add(" PP.REG_VALUE LIKE ? ");
                } else {
                    conditions.add(" PP.REG_VALUE " + this.leftOp + " ? ");
                }
            } else if (this.rightPropertyValue != null) {
                conditions.add(" PP.REG_VALUE " + this.rightOp + " ? ");
            }
        } else if (this.rightPropertyValue != null && this.rightOp.equals("=")) {
            conditions.add(" PP.REG_VALUE LIKE ? ");
        }
        if (this.mediaType != null) {
            if (this.mediaTypeNegate) {
                conditions.add("R.REG_MEDIA_TYPE NOT LIKE ?");
            } else {
                conditions.add("R.REG_MEDIA_TYPE LIKE ?");
            }
        }
        if (this.customSearchValues.size() > 0) {
            StringBuilder propertyClause = new StringBuilder();
            boolean firstTime = true;
            for (Map.Entry<String, String> e : this.customSearchValues.entrySet()) {
                if (e.getValue().trim().equals("")) continue;
                if (firstTime) {
                    propertyClause.append(" lower(PP.REG_NAME) LIKE '").append(e.getKey().toLowerCase()).append("'").append(" AND PP.REG_VALUE LIKE ?");
                    firstTime = false;
                    continue;
                }
                propertyClause.append(" AND lower(PP.REG_NAME) LIKE '").append(e.getKey().toLowerCase()).append("'").append(" AND PP.REG_VALUE LIKE ?");
            }
            if (!propertyClause.toString().equals("")) {
                conditions.add(propertyClause.toString());
            }
        }
        if (this.associationType != null) {
            tables.add(", REG_ASSOCIATION RA");
            if (this.resourceName == null) {
                tables.add(", REG_PATH P");
            }
            conditions.add(" R.REG_PATH_ID=P.REG_PATH_ID");
            conditions.add(" RA.REG_SOURCEPATH = P.REG_PATH_VALUE");
            conditions.add(" RA.REG_ASSOCIATION_TYPE LIKE ?");
        }
        if (this.associationDest != null) {
            if (this.associationType == null) {
                tables.add(", REG_ASSOCIATION RA");
                if (this.resourceName == null) {
                    tables.add(", REG_PATH P");
                }
            }
            tables.add(", REG_PATH P2");
            conditions.add(" R.REG_PATH_ID=P.REG_PATH_ID");
            conditions.add(" RA.REG_TARGETPATH = P2.REG_PATH_VALUE ");
            conditions.add(" lower(P2.REG_PATH_VALUE) LIKE ?");
            conditions.add(" lower(P2.REG_PATH_VALUE) NOT LIKE ?");
            conditions.add(" RA.REG_SOURCEPATH = P.REG_PATH_VALUE");
        }
        if (conditions.isEmpty()) {
            return null;
        }
        conditions.add("R.REG_NAME IS NULL");
        StringBuilder query = new StringBuilder();
        query.append("SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R");
        for (String table : tables) {
            query.append(table);
        }
        boolean first = true;
        for (String condition : conditions) {
            if (first) {
                query.append(" WHERE ");
                first = false;
            } else {
                query.append(" AND ");
            }
            query.append(condition);
        }
        return query.toString();
    }
}

